<table class="form-table">
	<tbody>
	<tr>
		<th scope="row">
			<h3><?php echo rsvp_pro_get_admin_string( 'general_form_settings_label' ); ?></h3>
		</th>
	</tr>
	<tr class="subEventHide">
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_FRONTEND_WIZARD; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_frontend_one_step_label' ); ?>
			</label>
		</th>
		<td>
			<input type="checkbox" name="<?php echo RSVP_PRO_OPTION_FRONTEND_WIZARD; ?>"
				   id="<?php echo RSVP_PRO_OPTION_FRONTEND_WIZARD; ?>"
				   value="Y" <?php echo ( $frontendWizard == 'Y' ) ? ' checked="checked"' : ''; ?> />
		</td>
	</tr>
	<tr class="subEventHide">
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_ENABLE_AJAX; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_frontend_enable_ajax_label' ); ?>
			</label>
		</th>
		<td>
			<input type="checkbox" name="<?php echo RSVP_PRO_OPTION_ENABLE_AJAX; ?>"
				   id="<?php echo RSVP_PRO_OPTION_ENABLE_AJAX; ?>"
				   value="Y" <?php echo ( $enable_ajax == 'Y' ) ? ' checked="checked"' : ''; ?> />
			<br/>
			<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_frontend_enable_ajax_description' ); ?></span>
		</td>
	</tr>
	<tr class="subEventHide">
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_DONT_USE_HASH; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_remove_scrolling_label' ); ?>
			</label>
		</th>
		<td>
			<input type="checkbox" name="<?php echo RSVP_PRO_OPTION_DONT_USE_HASH; ?>"
				   id="<?php echo RSVP_PRO_OPTION_DONT_USE_HASH; ?>"
				   value="Y" <?php echo ( $dontUseHash == 'Y' ) ? ' checked="checked"' : ''; ?> />
		</td>
	</tr>
	<tr class="subEventHide">
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_FORM_URL; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_rsvp_form_label' ); ?>
			</label>
		</th>
		<td>
			<input type="text" name="<?php echo RSVP_PRO_OPTION_FORM_URL; ?>"
				   id="<?php echo RSVP_PRO_OPTION_FORM_URL; ?>"
				   value="<?php echo esc_attr( $rsvp_form_url ); ?>" class="large-text"/>
			<br/>
			<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_rsvp_form_description' ); ?></span>
		</td>
	</tr>
	<tr class="subEventHide">
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_DISABLE_USER_SEARCH; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_disable_fuzzy_label' ); ?>
			</label>
		</th>
		<td>
			<input type="checkbox" name="<?php echo RSVP_PRO_OPTION_DISABLE_USER_SEARCH; ?>"
				   id="<?php echo RSVP_PRO_OPTION_DISABLE_USER_SEARCH; ?>"
				   value="Y" <?php echo ( $rsvpDisableUserSearch == 'Y' ) ? ' checked="checked"' : ''; ?> />
		</td>
	</tr>
	<tr class="subEventHide">
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_PARTIAL_MATCH_USER_SEARCH; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_partial_match_label' ); ?>
			</label>
		</th>
		<td>
			<input type="checkbox" name="<?php echo RSVP_PRO_OPTION_PARTIAL_MATCH_USER_SEARCH; ?>"
				   id="<?php echo RSVP_PRO_OPTION_PARTIAL_MATCH_USER_SEARCH; ?>"
				   value="Y" <?php echo ( $partialUserSearch == 'Y' ) ? ' checked="checked"' : ''; ?> />
		</td>
	</tr>
	<tr>
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_EVENT_COUNT_LIMIT; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_event_guest_capacity' ); ?>
			</label>
		</th>
		<td>
			<input type="text" name="<?php echo RSVP_PRO_OPTION_EVENT_COUNT_LIMIT; ?>"
				   id="<?php echo RSVP_PRO_OPTION_EVENT_COUNT_LIMIT; ?>" value="<?php echo esc_html( $rsvpLimit ); ?>"/>
			<br>
			<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_event_guest_capacity_description' ); ?></span>
		</td>
	</tr>
	<tr>
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_ENABLE_WAITLIST; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_waitlist_label' ); ?>
			</label>
		</th>
		<td>
			<input type="checkbox" name="<?php echo RSVP_PRO_OPTION_ENABLE_WAITLIST; ?>"
				   id="<?php echo RSVP_PRO_OPTION_ENABLE_WAITLIST; ?>"
				   value="Y" <?php echo ( $rsvpEnableWaitlist == 'Y' ) ? ' checked="checked"' : ''; ?> />
			<br/>
			<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_waitlist_description' ); ?></span>
		</td>
	</tr>
	<tr>
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_WAITLIST_AUTO_CHANGE; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_auto_change_waitlist_label' ); ?>
			</label>
		</th>
		<td>
			<input type="checkbox" name="<?php echo RSVP_PRO_OPTION_WAITLIST_AUTO_CHANGE; ?>"
				   id="<?php echo RSVP_PRO_OPTION_WAITLIST_AUTO_CHANGE; ?>"
				   value="Y" <?php echo ( $autoWaitlistToYes == 'Y' ) ? ' checked="checked"' : ''; ?> />
			<br/>
			<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_auto_change_waitlist_description' ); ?></span>
		</td>
	</tr>
	<tr>
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_WAITLIST_PERM_SWITCH; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_yes_no_longer_label' ); ?>
			</label>
		</th>
		<td>
			<input type="checkbox" name="<?php echo RSVP_PRO_OPTION_WAITLIST_PERM_SWITCH; ?>"
				   id="<?php echo RSVP_PRO_OPTION_WAITLIST_PERM_SWITCH; ?>"
				   value="Y" <?php echo ( $waitlistPermSwitch == 'Y' ) ? ' checked="checked"' : ''; ?> />
			<br/>
			<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_yes_no_longer_description' ); ?></span>
		</td>
	</tr>
	<tr>
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_WAITLIST_YES_UNAVAILABLE; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_yes_unavailable_label' ); ?>
			</label>
		</th>
		<td>
			<input type="checkbox" name="<?php echo RSVP_PRO_OPTION_WAITLIST_YES_UNAVAILABLE; ?>"
				   id="<?php echo RSVP_PRO_OPTION_WAITLIST_YES_UNAVAILABLE; ?>"
				   value="Y" <?php echo ( $waitlistYesUnavailable == 'Y' ) ? ' checked="checked"' : ''; ?> />
			<br/>
			<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_yes_unavailable_description' ); ?></span>
		</td>
	</tr>
	<tr>
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_ENABLE_MAYBE; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_maybe_label' ); ?>
			</label>
		</th>
		<td>
			<input type="checkbox" name="<?php echo RSVP_PRO_OPTION_ENABLE_MAYBE; ?>"
				   id="<?php echo RSVP_PRO_OPTION_ENABLE_MAYBE; ?>"
				   value="Y" <?php echo ( $rsvp_enable_maybe == 'Y' ) ? ' checked="checked"' : ''; ?> />
		</td>
	</tr>
	<tr>
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_PLUS_ONE_ENABLED; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_enable_plus_one_label' ); ?>
			</label>
		</th>
		<td>
			<input type="checkbox" name="<?php echo RSVP_PRO_OPTION_PLUS_ONE_ENABLED; ?>"
				   id="<?php echo RSVP_PRO_OPTION_PLUS_ONE_ENABLED; ?>"
				   value="Y" <?php echo ( $plus_one_enabled == 'Y' ) ? ' checked="checked"' : ''; ?> />
			<br/>
			<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_enable_plus_one_description' ); ?></span>
		</td>
	</tr>
	<tr class="subEventHide">
		<th scope="row">
			<label for="rsvp_num_additional_guests">
				<?php echo rsvp_pro_get_admin_string( 'settings_num_guests_label' ); ?>
			</label>
		</th>
		<td>
			<input type="text" name="rsvp_num_additional_guests" id="rsvp_num_additional_guests"
				   value="<?php echo htmlspecialchars( $numAdditionalGuests ); ?>"/>
			<br>
			<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_num_guests_description' ); ?></span>
		</td>
	</tr>
	<tr class="subEventHide">
		<th scope="row">
			<label for="hide_additional_guests">
				<?php echo rsvp_pro_get_admin_string( 'settings_no_additional_guests_label' ); ?>
			</label>
		</th>
		<td>
			<input type="checkbox" name="hide_additional_guests" id="hide_additional_guests"
				   value="Y" <?php echo ( $hideAdditionalGuests == 'Y' ) ? ' checked="checked"' : ''; ?> />
		</td>
	</tr>
	<tr class="subEventHide">
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_ALWAYS_SHOW_ADDITIONAL; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_always_show_additional_label' ); ?>
			</label>
		</th>
		<td>
			<input type="checkbox" name="<?php echo RSVP_PRO_OPTION_ALWAYS_SHOW_ADDITIONAL; ?>" 
				id="<?php echo RSVP_PRO_OPTION_ALWAYS_SHOW_ADDITIONAL; ?>"
				value="Y" <?php echo ( $always_show_additional == 'Y' ) ? ' checked="checked"' : ''; ?> />
			<br />
			<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_always_show_additional_description' ); ?></span>
		</td>
	</tr>
	<tr class="subEventHide">
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_OPEN_REGISTRATION; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_allow_open_label' ); ?>
			</label>
		</th>
		<td>
			<input type="checkbox" name="<?php echo RSVP_PRO_OPTION_OPEN_REGISTRATION; ?>"
				   id="<?php echo RSVP_PRO_OPTION_OPEN_REGISTRATION; ?>"
				   value="Y" <?php echo ( $rsvpOpenReg == 'Y' ) ? ' checked="checked"' : ''; ?> />
			<br>
			<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_allow_open_description' ); ?></span>
		</td>
	</tr>
	<tr class="subEventHide">
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_HIDE_SEARCH_FORM; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_hide_search_form_label' ); ?>
			</label>
		</th>
		<td>
			<input type="checkbox" name="<?php echo RSVP_PRO_OPTION_HIDE_SEARCH_FORM; ?>"
				   id="<?php echo RSVP_PRO_OPTION_HIDE_SEARCH_FORM; ?>"
				   value="Y" <?php echo ( $hide_search_form == 'Y' ) ? ' checked="checked"' : ''; ?> />
			<br/>
			<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_hide_search_form_description' ); ?></span>
		</td>
	</tr>
	<tr class="subEventHide">
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_SHOW_NEW_ATTENDEE_FORM_FIRST; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_display_new_attendee_form_label' ); ?>
			</label>
		</th>
		<td>
			<input type="checkbox" name="<?php echo RSVP_PRO_OPTION_SHOW_NEW_ATTENDEE_FORM_FIRST; ?>"
				   id="<?php echo RSVP_PRO_OPTION_SHOW_NEW_ATTENDEE_FORM_FIRST; ?>"
				   value="Y" <?php echo ( $show_new_attendee_form_first == 'Y' ) ? ' checked="checked"' : ''; ?> />
			<br>
			<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_display_new_attendee_form_description' ); ?></span>
		</td>
	</tr>
	<tr class="subEventHide">
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_CANT_EDIT; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_cant_edit_label' ); ?>
			</label>
		</th>
		<td>
			<input type="checkbox" name="<?php echo RSVP_PRO_OPTION_CANT_EDIT; ?>"
				   id="<?php echo RSVP_PRO_OPTION_CANT_EDIT; ?>"
				   value="Y" <?php echo ( $rsvpNoEditing == 'Y' ) ? ' checked="checked"' : ''; ?> />
			<br>
			<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_cant_edit_description' ); ?></span>
		</td>
	</tr>
	<tr class="subEventHide">
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_NO_EDIT_PROMPT; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_no_edit_prompt_label' ); ?>
			</label>
		</th>
		<td>
			<input type="checkbox" name="<?php echo RSVP_PRO_OPTION_NO_EDIT_PROMPT; ?>"
				   id="<?php echo RSVP_PRO_OPTION_NO_EDIT_PROMPT; ?>"
				   value="Y" <?php echo ( $rsvp_no_edit_prompt == 'Y' ) ? ' checked="checked"' : ''; ?> />
			<br>
			<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_no_edit_prompt_description' ); ?></span>
		</td>
	</tr>
	<tr class="subEventHide">
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_ONLY_RSVP_ONCE; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_rsvp_once_label' ); ?>
			</label>
		</th>
		<td>
			<input type="checkbox" name="<?php echo RSVP_PRO_OPTION_ONLY_RSVP_ONCE; ?>"
				   id="<?php echo RSVP_PRO_OPTION_ONLY_RSVP_ONCE; ?>"
				   value="Y" <?php echo ( $rsvp_only_once == 'Y' ) ? ' checked="checked"' : ''; ?> />
			<br>
			<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_rsvp_once_description' ); ?></span>
		</td>
	</tr>
	<tr class="subEventHide">
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_PROMPT_TO_ADD_IF_NOT_FOUND; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_open_prompt_label' ); ?>
			</label>
		</th>
		<td>
			<input type="checkbox" name="<?php echo RSVP_PRO_OPTION_PROMPT_TO_ADD_IF_NOT_FOUND; ?>"
				   id="<?php echo RSVP_PRO_OPTION_PROMPT_TO_ADD_IF_NOT_FOUND; ?>"
				   value="Y" <?php echo ( $rsvp_open_prompt_to_add == 'Y' ) ? ' checked="checked"' : ''; ?> />
			<br>
			<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_open_prompt_description' ); ?></span>
		</td>
	</tr>
	<tr class="subEventHide">
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_AUTO_LOGIN_ATTENDEE; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_auto_auth_label' ); ?>
			</label>
		</th>
		<td>
			<input type="checkbox" name="<?php echo RSVP_PRO_OPTION_AUTO_LOGIN_ATTENDEE; ?>"
				   id="<?php echo RSVP_PRO_OPTION_AUTO_LOGIN_ATTENDEE; ?>"
				   value="Y" <?php echo ( $attendeeAutoLogin == 'Y' ) ? ' checked="checked"' : ''; ?> />
			<br>
			<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_auto_auth_description' ); ?></span>
		</td>
	</tr>
	<tr class="subEventHide">
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_AUTO_ENROLL_ROLE; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_auto_enroll_wp_role_label' ); ?>
			</label>
		</th>
		<td>
			<p>
				<span style="margin-left: 40px;"><?php echo rsvp_pro_get_admin_string( 'settings_available_roles' ); ?></span>
				<span style="margin-left: 68px;"><?php echo rsvp_pro_get_admin_string( 'settings_auto_enabled_roles_label' ); ?></span>
			</p>
			<select name="<?php echo RSVP_PRO_OPTION_AUTO_ENROLL_ROLE; ?>[]"
					id="<?php echo RSVP_PRO_OPTION_AUTO_ENROLL_ROLE; ?>" multiple="multiple">
				<?php
				$roles = wp_roles()->get_names();
				foreach ( $roles as $key => $val ) {
					?>
					<option value="<?php echo $key; ?>" <?php echo ( in_array( $key, $roles_auto_enroll ) === true ) ? 'selected="selected"' : ''; ?> >
						<?php echo $val; ?>
					</option>
					<?php
				}
				?>
			</select>
			<br>
			<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_auto_enroll_wp_role_description' ); ?></span>
		</td>
	</tr>
	<tr class="subEventHide">
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_ATTENDEE_LOOKUP_VIA_EMAIL; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_email_lookup_label' ); ?>
			</label>
		</th>
		<td>
			<input type="checkbox" name="<?php echo RSVP_PRO_OPTION_ATTENDEE_LOOKUP_VIA_EMAIL; ?>"
				   id="<?php echo RSVP_PRO_OPTION_ATTENDEE_LOOKUP_VIA_EMAIL; ?>"
				   value="Y" <?php echo ( $useEmailForLookup == 'Y' ) ? ' checked="checked"' : ''; ?> />
			<br>
			<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_email_lookup_description' ); ?></span>
		</td>
	</tr>
	<tr class="subEventHide">
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_LAST_NAME_NOT_REQUIRED; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_do_not_require_last_name_label' ); ?>
			</label>
		</th>
		<td>
			<input type="checkbox" name="<?php echo RSVP_PRO_OPTION_LAST_NAME_NOT_REQUIRED; ?>"
				   id="<?php echo RSVP_PRO_OPTION_LAST_NAME_NOT_REQUIRED; ?>"
				   value="Y" <?php echo ( $lastNameNotRequired == 'Y' ) ? ' checked="checked"' : ''; ?> />
			<br>
			<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_do_not_require_last_name_description' ); ?></span>
		</td>
	</tr>
	<tr>
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_SHOW_CALENDAR_LINK; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_show_cal_link_label' ); ?>
			</label>
		</th>
		<td>
			<input type="checkbox" name="<?php echo RSVP_PRO_OPTION_SHOW_CALENDAR_LINK; ?>"
				   id="<?php echo RSVP_PRO_OPTION_SHOW_CALENDAR_LINK; ?>"
				   value="Y" <?php echo ( $showCalendarLink == 'Y' ) ? ' checked="checked"' : ''; ?> />
			<br>
			<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_show_cal_link_description' ); ?></span>
		</td>
	</tr>
	<tr>
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_THANKYOU_REDIRECT; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_thankyou_redirect_label' ); ?>
			</label>
		</th>
		<td>
			<input type="text" name="<?php echo RSVP_PRO_OPTION_THANKYOU_REDIRECT; ?>"
				   id="<?php echo RSVP_PRO_OPTION_THANKYOU_REDIRECT; ?>"
				   value="<?php esc_attr_e( $thank_you_redirect ); ?>" class="large-text"/>
			<br>
			<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_thankyou_redirect_description' ); ?></span>
		</td>
	</tr>
	<tr>
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_NOT_COMING_REDIRECT; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_notcoming_redirect_label' ); ?>
			</label>
		</th>
		<td>
			<input type="text" name="<?php echo RSVP_PRO_OPTION_NOT_COMING_REDIRECT; ?>"
				   id="<?php echo RSVP_PRO_OPTION_NOT_COMING_REDIRECT; ?>"
				   value="<?php esc_attr_e( $not_coming_redirect ); ?>" class="large-text"/>
			<br>
			<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_notcoming_redirect_description' ); ?></span>
		</td>
	</tr>
	<tr>
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_SHOW_EVENT_INFO_ON_FRONTEND; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_display_event_description_label' ); ?>
			</label>
		</th>
		<td>
			<input type="checkbox" name="<?php echo RSVP_PRO_OPTION_SHOW_EVENT_INFO_ON_FRONTEND; ?>"
				   id="<?php echo RSVP_PRO_OPTION_SHOW_EVENT_INFO_ON_FRONTEND; ?>"
				   value="Y" <?php echo ( $showEventInfo == 'Y' ) ? ' checked="checked"' : ''; ?> />
			<br>
			<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_display_event_description_description' ); ?></span>
		</td>
	</tr>
	<tr>
		<th scope="row">
			<h3><?php echo rsvp_pro_get_admin_string( 'form_fields_settings_label' ); ?></h3>
		</th>
	</tr>
	<tr class="subEventHide">
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_FIRST_LAST_EDITABLE; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_first_last_editable_label' ); ?>
			</label>
		</th>
		<td>
			<input type="checkbox" name="<?php echo RSVP_PRO_OPTION_FIRST_LAST_EDITABLE; ?>"
				   id="<?php echo RSVP_PRO_OPTION_FIRST_LAST_EDITABLE; ?>"
				   value="Y" <?php echo ( $first_last_editable == 'Y' ) ? ' checked="checked"' : ''; ?> />
			<br/>
			<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_first_last_editable_description' ); ?></span>
		</td>
	</tr>
	<tr class="subEventHide">
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_SHOW_SALUTATION; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_show_salutation_label' ); ?>
			</label>
		</th>
		<td>
			<input type="checkbox" name="<?php echo RSVP_PRO_OPTION_SHOW_SALUTATION; ?>"
				   id="<?php echo RSVP_PRO_OPTION_SHOW_SALUTATION; ?>"
				   value="Y" <?php echo ( $showSalutation == 'Y' ) ? ' checked="checked"' : ''; ?> />
		</td>
	</tr>
	<tr class="subEventHide" id="rsvpProOptionSalutationsContainer">
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_SALUTATIONS; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_possible_salutations_label' ); ?>
			</label>
		</th>
		<td>
				<textarea name="<?php echo RSVP_PRO_OPTION_SALUTATIONS; ?>"
						  id="<?php echo RSVP_PRO_OPTION_SALUTATIONS; ?>" rows="3" cols="60">
					<?php echo esc_html( str_replace( '||', "\r\n", $salutations ) ); ?>
				</textarea>
			<br>
			<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_possible_salutations_description' ); ?></span>
		</td>
	</tr>
	<tr class="subEventHide">
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_SHOW_SUFFIX; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_show_suffix_label' ); ?>
			</label>
		</th>
		<td>
			<input type="checkbox" name="<?php echo RSVP_PRO_OPTION_SHOW_SUFFIX; ?>"
				   id="<?php echo RSVP_PRO_OPTION_SHOW_SUFFIX; ?>"
				   value="Y" <?php echo ( $showSuffix == 'Y' ) ? ' checked="checked"' : ''; ?> />
		</td>
	</tr>
	<tr class="subEventHide">
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_SHOW_NORESPONSE_FOR_ASSOCIATED; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_show_no_response_label' ); ?>
			</label>
		</th>
		<td>
			<input type="checkbox" name="<?php echo RSVP_PRO_OPTION_SHOW_NORESPONSE_FOR_ASSOCIATED; ?>"
				   id="<?php echo RSVP_PRO_OPTION_SHOW_NORESPONSE_FOR_ASSOCIATED; ?>"
				   value="Y" <?php echo ( $showNoResponse == 'Y' ) ? ' checked="checked"' : ''; ?> />
		</td>
	</tr>
	<tr class="subEventHide">
		<th scope="row">
			<label for="hide_note">
				<?php echo rsvp_pro_get_admin_string( 'settings_hide_note_label' ); ?>
			</label>
		</th>
		<td>
			<input type="checkbox" name="hide_note" id="hide_note"
				   value="Y" <?php echo ( $hideNote == 'Y' ) ? ' checked="checked"' : ''; ?> />
		</td>
	</tr>
	<tr class="subEventHide">
		<th scope="row">
			<label for="<?php echo RSVP_PRO_HIDE_EMAIL_FIELD; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_hide_email_field_label' ); ?>
			</label>
		</th>
		<td>
			<input type="checkbox" name="<?php echo RSVP_PRO_HIDE_EMAIL_FIELD; ?>"
				   id="<?php echo RSVP_PRO_HIDE_EMAIL_FIELD; ?>"
				   value="Y" <?php echo ( $hideEmailField == 'Y' ) ? ' checked="checked"' : ''; ?> />
		</td>
	</tr>
	<tr class="subEventHide">
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_EMAIL_REQUIRED; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_require_email_label' ); ?>
			</label>
		</th>
		<td>
			<input type="checkbox" name="<?php echo RSVP_PRO_OPTION_EMAIL_REQUIRED; ?>"
				   id="<?php echo RSVP_PRO_OPTION_EMAIL_REQUIRED; ?>"
				   value="Y" <?php echo ( $requireEmail == 'Y' ) ? ' checked="checked"' : ''; ?> />
		</td>
	</tr>
	<tr class="subEventHide">
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_EMAIL_UNIQUE_VALIDATION; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_unique_email_validation_label' ); ?>:
			</label>
		</th>
		<td>
			<input type="checkbox" name="<?php echo RSVP_PRO_OPTION_EMAIL_UNIQUE_VALIDATION; ?>"
				   id="<?php echo RSVP_PRO_OPTION_EMAIL_UNIQUE_VALIDATION; ?>"
				   value="Y" <?php echo ( $unique_email_validation == 'Y' ) ? ' checked="checked"' : ''; ?> />
			<br/>
			<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_unique_email_validation_description' ); ?></span>
		</td>
	</tr>
	<tr class="subEventHide">
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_RSVP_REQUIRED; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_require_rsvp_label' ); ?>
			</label>
		</th>
		<td>
			<input type="checkbox" name="<?php echo RSVP_PRO_OPTION_RSVP_REQUIRED; ?>"
				   id="<?php echo RSVP_PRO_OPTION_RSVP_REQUIRED; ?>"
				   value="Y" <?php echo ( $requireRsvpValues == 'Y' ) ? ' checked="checked"' : ''; ?> />
		</td>
	</tr>
	<tr class="subEventHide">
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_SHOW_GDPR_QUESTION; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_show_gpdr_label' ); ?>
			</label>
		</th>
		<td>
			<input type="checkbox" name="<?php echo RSVP_PRO_OPTION_SHOW_GDPR_QUESTION; ?>"
				   id="<?php echo RSVP_PRO_OPTION_SHOW_GDPR_QUESTION; ?>"
				   value="Y" <?php echo ( $show_gdpr_question == 'Y' ) ? ' checked="checked"' : ''; ?> />
			<br/>
			<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_show_gdpr_description' ); ?>
		</td>
	</tr>
	<tr class="subEventHide">
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_HIDE_WELCOME; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_hide_welcome_text_label' ); ?>
			</label>
		</th>
		<td>
			<input type="checkbox" name="<?php echo RSVP_PRO_OPTION_HIDE_WELCOME; ?>"
				   id="<?php echo RSVP_PRO_OPTION_HIDE_WELCOME; ?>"
				   value="Y" <?php echo ( 'Y' === $hide_welcome_text ) ? ' checked="checked"' : ''; ?> />
			<br/>
			<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_hide_welcome_text_description' ); ?>
		</td>
	</tr>
	<tr class="subEventHide">
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_SHOW_PROFILE_ON_FORM; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_form_show_profile_pic_label' ); ?>
			</label>
		</th>
		<td>
			<input type="checkbox" name="<?php echo RSVP_PRO_OPTION_SHOW_PROFILE_ON_FORM; ?>"
				   id="<?php echo RSVP_PRO_OPTION_SHOW_PROFILE_ON_FORM; ?>"
				   value="Y" <?php echo ( 'Y' === $form_show_profile_pic ) ? ' checked="checked"' : ''; ?> />
			<br/>
			<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_form_show_profile_pic_description' ); ?>
		</td>
	</tr>
	<tr class="subEventHide">
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_HIDE_RSVP_QUESTION; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_hide_main_rsvp_question_label' ); ?>
			</label>
		</th>
		<td>
			<input type="checkbox" name="<?php echo RSVP_PRO_OPTION_HIDE_RSVP_QUESTION; ?>"
				   id="<?php echo RSVP_PRO_OPTION_HIDE_RSVP_QUESTION; ?>"
				   value="Y" <?php echo ( 'Y' === $hide_main_rsvp_question ) ? ' checked="checked"' : ''; ?> />
			<br/>
			<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_hide_main_rsvp_question_description' ); ?>
		</td>
	</tr>
	<tr>
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_RSVP_HIDE; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_hide_rsvp_question_label' ); ?>:</label>
		</th>
		<td>
			<input type="checkbox" name="<?php echo RSVP_PRO_OPTION_RSVP_HIDE; ?>"
				   id="<?php echo RSVP_PRO_OPTION_RSVP_HIDE; ?>"
				   value="Y" <?php echo ( $hide_rsvp === 'Y' ) ? ' checked="checked"' : ''; ?> />
			<br/>
			<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_hide_rsvp_question_description' ); ?></span>
		</td>
	</tr>
	<tr>
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_DEFAULT_RSVP_VALUE; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_default_rsvp_label' ); ?>:</label>
		</th>
		<td>
			<select name="<?php echo RSVP_PRO_OPTION_DEFAULT_RSVP_VALUE; ?>"
					id="<?php echo RSVP_PRO_OPTION_DEFAULT_RSVP_VALUE; ?>" size="1">
				<option value="">--</option>
				<?php
				$statuses = array( 'yes', 'maybe', 'no', 'noresponse', 'waitlist' );
				foreach ( $statuses as $s ) {
					?>
					<option value="<?php echo $s; ?>" <?php echo ( $default_rsvp_value === $s ) ? 'selected="selected"' : ''; ?>>
						<?php esc_attr_e( rsvp_pro_humanize_rsvp_status( $s, $eventID ) ); ?>
					</option>
					<?php
				}
				?>
			</select>
		</td>
	</tr>
	<tr class="subEventHide">
		<th scope="row">
			<h3><?php echo rsvp_pro_get_admin_string( 'passcode_settings_label' ); ?></h3>
		</th>
	</tr>
	<tr class="subEventHide">
		<th scope="row">
			<label for="require_passcode">
				<?php echo rsvp_pro_get_admin_string( 'settings_require_passcode_label' ); ?>
			</label>
		</th>
		<td>
			<input type="checkbox" name="require_passcode" id="require_passcode"
				   value="Y" <?php echo ( $requirePasscode == 'Y' ) ? ' checked="checked"' : ''; ?> />
		</td>
	</tr>
	<tr class="subEventHide">
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_PASSCODE_UNIQUE; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_unique_passcode_label' ); ?>:
			</label>
		</th>
		<td>
			<input type="checkbox" name="<?php echo RSVP_PRO_OPTION_PASSCODE_UNIQUE; ?>"
				   id="<?php echo RSVP_PRO_OPTION_PASSCODE_UNIQUE; ?>"
				   value="Y" <?php echo ( 'Y' === $unique_passcode ) ? ' checked="checked"' : ''; ?> />
			<br/>
			<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_unique_passcode_description' ); ?></span>
		</td>
	</tr>
	<tr class="subEventHide">
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_PASSWORD_LENGTH; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_passcode_length_label' ); ?>
			</label>
		</th>
		<td>
			<input type="number" name="<?php echo RSVP_PRO_OPTION_PASSWORD_LENGTH; ?>"
				   id="<?php echo RSVP_PRO_OPTION_PASSWORD_LENGTH; ?>" value="<?php echo $password_length; ?>" min="1"
				   max="50"/>
			<br>
			<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_passcode_length_description' ); ?></span>
		</td>
	</tr>
	<tr class="subEventHide">
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_PASSCODE_EDITABLE; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_passcode_modification_label' ); ?>
			</label>
		</th>
		<td>
			<input type="checkbox" name="<?php echo RSVP_PRO_OPTION_PASSCODE_EDITABLE; ?>"
				   id="<?php echo RSVP_PRO_OPTION_PASSCODE_EDITABLE; ?>"
				   value="Y" <?php echo ( $passcode_editable === 'Y' ) ? ' checked="checked"' : ''; ?> />
			<br>
		</td>
	</tr>
	<tr class="subEventHide">
		<th scope="row">
			<label for="<?php echo RSVP_PRO_ONLY_PASSCODE; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_just_passcode_label' ); ?>
			</label>
		</th>
		<td>
			<input type="checkbox" name="<?php echo RSVP_PRO_ONLY_PASSCODE; ?>"
				   id="<?php echo RSVP_PRO_ONLY_PASSCODE; ?>"
				   value="Y" <?php echo ( $onlyPasscode == 'Y' ) ? ' checked="checked"' : ''; ?> />
			<br/>
			<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_just_passcode_description' ); ?></span>
		</td>
	</tr>
	<tr class="subEventHide">
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_RSVP_OPEN_NO_PASSCODE; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_no_passcode_open_label' ); ?>
			</label>
		</th>
		<td>
			<input type="checkbox" name="<?php echo RSVP_PRO_OPTION_RSVP_OPEN_NO_PASSCODE; ?>"
				   id="<?php echo RSVP_PRO_OPTION_RSVP_OPEN_NO_PASSCODE; ?>"
				   value="Y" <?php echo ( $noPasscodeOnOpen == 'Y' ) ? ' checked="checked"' : ''; ?> />
			<br>
			<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_no_passcode_open_description' ); ?></span>
		</td>
	</tr>
	<tr class="subEventHide">
		<th scope="row">
			<h3><?php echo rsvp_pro_get_admin_string( 'captcha_settings_label' ); ?></h3>
		</th>
	</tr>
	<tr class="subEventHide">
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_ENABLE_RECAPTCHA; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_enable_recaptcha_label' ); ?>:
			</label>
		</th>
		<td>
			<input type="checkbox" name="<?php echo RSVP_PRO_OPTION_ENABLE_RECAPTCHA; ?>"
				   id="<?php echo RSVP_PRO_OPTION_ENABLE_RECAPTCHA; ?>"
				   value="Y" <?php echo ( 'Y' === $enable_recaptcha ) ? ' checked="checked"' : ''; ?> />
			<br>
			<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_enable_recaptcha_description' ); ?></span>
		</td>
	</tr>
	<tr class="subEventHide">
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_RECAPTCHA_SITE_KEY; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_recaptcha_site_key_label' ); ?>:
			</label>
		</th>
		<td>
			<input type="text" name="<?php echo RSVP_PRO_OPTION_RECAPTCHA_SITE_KEY; ?>"
				   id="<?php echo RSVP_PRO_OPTION_RECAPTCHA_SITE_KEY; ?>"
				   value="<?php esc_attr_e( $recaptcha_site_key ); ?>"/>
			<br>
			<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_recaptcha_site_key_description' ); ?></span>
		</td>
	</tr>
	<tr class="subEventHide">
		<th scope="row">
			<label for="<?php echo RSVP_PRO_OPTION_RECAPTCHA_SECRET_KEY; ?>">
				<?php echo rsvp_pro_get_admin_string( 'settings_recaptcha_secret_key_label' ); ?>:
			</label>
		</th>
		<td>
			<input type="text" name="<?php echo RSVP_PRO_OPTION_RECAPTCHA_SECRET_KEY; ?>"
				   id="<?php echo RSVP_PRO_OPTION_RECAPTCHA_SECRET_KEY; ?>"
				   value="<?php esc_attr_e( $recaptcha_secret_key ); ?>"/>
			<br>
			<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_recaptcha_secret_key_description' ); ?></span>
		</td>
	</tr>
	</tbody>
</table>
