<table class="form-table">
	<tbody>
		<tr>
			<th scope="row">
				<label for="rsvp_eventname">
					<?php echo rsvp_pro_get_frontend_string( 'event_name_label' ); ?>:
				</label>
			</th>
			<td>
				<input type="text" class="large-text" name="eventName" id="rsvp_eventname" value="<?php echo htmlspecialchars( $eventName ); ?>" />
			</td>
		</tr>
		<tr class="subEventHide">
			<th scope="row">
				<label for="open_date">
					<?php echo rsvp_pro_get_admin_string( 'settings_rsvp_open_date_label' ); ?>
				</label>
			</th>
			<td>
				<input type="text" name="open_date" id="open_date" value="<?php echo htmlspecialchars( $opendate ); ?>" placeholder="Date" />
				<input type="text" name="open_date_time" id="open_date_time" value="<?php echo esc_attr( $opendate_time ); ?>" placeholder="Time" />
				<br />
				<span class="description">An example is 5/31/2015 10:30am</span>
			</td>
		</tr>
		<tr class="subEventHide">
			<th scope="row">
				<label for="close_date">
					<?php echo rsvp_pro_get_admin_string( 'settings_rsvp_close_date_label' ); ?>
				</label>
			</th>
			<td>
				<input type="text" name="close_date" id="close_date" value="<?php echo htmlspecialchars( $closedate ); ?>" placeholder="Date" />
				<input type="text" name="close_date_time" id="close_date_time" value="<?php echo esc_attr( $closedate_time ); ?>" placeholder="Time" />
				<br />
				<span class="description">An example is 5/31/2015 10:30am</span>
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for="parentEventID">
					<?php echo rsvp_pro_get_admin_string( 'settings_parent_event_label' ); ?>
				</label>
			</th>
			<td>
				<select name="parentEventID" id="parentEventID" size="1">
					<option value="">--</option>
					<?php
					$sql    = 'SELECT id, eventName FROM ' . PRO_EVENT_TABLE . ' WHERE id <> %d AND (parentEventID IS NULL OR parentEventID = 0)';
					$events = $wpdb->get_results( $wpdb->prepare( $sql, ( isset( $_GET['id'] ) ? $_GET['id'] : 0 ) ) );
					foreach ( $events as $e ) {
						?>
						<option value="<?php echo $e->id; ?>" <?php echo ( $e->id == $parentEventID ) ? 'selected="selected"' : ''; ?>>
							<?php echo esc_html( $e->eventName ); ?>
						</option>
						<?php
					}
					?>
				</select>
				<br />
				<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_parent_event_description' ); ?></span>
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for="<?php echo RSVP_PRO_OPTION_ADMIN_ROLES; ?>">
					<?php echo rsvp_pro_get_admin_string( 'settings_specify_roles_with_access_label' ); ?>
				</label>
			</th>
			<td>
				<p>
					<span style="margin-left: 35px;"><?php echo rsvp_pro_get_admin_string( 'settings_available_roles' ); ?></span>
					<span style="margin-left: 68px;"><?php echo rsvp_pro_get_admin_string( 'settings_roles_have_access_label' ); ?></span>
				</p>
				<select name="adminRoles[]" id="<?php echo RSVP_PRO_OPTION_ADMIN_ROLES; ?>" multiple="multiple" size="5">
				<?php
				$roles = get_editable_roles();
				foreach ( $roles as $role ) {
					if ( strtolower( $role['name'] ) != 'administrator' ) {
						?>
						<option value="<?php echo esc_attr_e( $role['name'] ); ?>" <?php echo ( in_array( $role['name'], $adminRoles ) ) ? 'selected="selected"' : ''; ?>>
							<?php echo esc_html( $role['name'] ); ?>
						</option>
						<?php
					}
				}
				?>
				</select>
				<br />
				<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_specify_roles_access_description' ); ?></span>
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for="event_access">
					<?php echo rsvp_pro_get_admin_string( 'settings_attendee_access_label' ); ?>
				</label>
			</th>
			<td>
				<select name="event_access" id="event_access" size="1">
					<option value="">--</option>
					<option value="<?php echo RSVP_PRO_OPEN_EVENT_ACCESS; ?>" <?php echo ( $eventAccess == RSVP_PRO_OPEN_EVENT_ACCESS ) ? ' selected="selected" ' : ''; ?>>Open</option>
					<option value="<?php echo RSVP_PRO_PRIVATE_EVENT_ACCESS; ?>" <?php echo ( $eventAccess == RSVP_PRO_PRIVATE_EVENT_ACCESS ) ? ' selected="selected"' : ''; ?>>Select</option>
				</select>
				<br>
				<span class="description">Defines access to an event: <br />
				<b>Open</b> - all attendees are allowed to RSVP for the event<br />
				<b>Select</b> - only the select attendees are allowed to RSVP for the event</span>
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for="attendeeAccessSelect">
					<?php echo rsvp_pro_get_admin_string( 'settings_attendee_access_list_label' ); ?>
				</label>
			</th>
			<td>
				<p>
					<span style="margin-left: 18px;"><?php echo rsvp_pro_get_admin_string( 'settings_available_attendees_label' ); ?></span>
					<span style="margin-left: 40px;"><?php echo rsvp_pro_get_admin_string( 'settings_attendees_who_have_access_label' ); ?></span>
				</p>
				<select name="attendeeAccess[]" id="attendeeAccessSelect" multiple="multiple" size="5">
				<?php
				$sql = 'SELECT id, firstName, lastName
                        FROM ' . PRO_ATTENDEES_TABLE . '
                        WHERE rsvpEventID = %d ';
				if ( rsvp_pro_is_shared_attendee_list_enabled() ) {
					$sql .= ' OR rsvpEventID = ' . RSVP_PRO_GLOBAL_ATTENDEE_EVENT_ID;
				}

				$sql .= ' ORDER BY lastName, firstName';

				$attendees = $wpdb->get_results( $wpdb->prepare( $sql, ( $parentEventID > 0 ) ? $parentEventID : $eventID ) );
				foreach ( $attendees as $a ) {
					?>
					<option value="<?php echo $a->id; ?>" <?php echo ( in_array( $a->id, $attendeeAccess ) ) ? 'selected="selected"' : ''; ?>>
						<?php echo esc_html( stripslashes( $a->firstName ) . ' ' . stripslashes( $a->lastName ) ); ?>
					</option>
					<?php
				}
				?>
				</select>
				<p>
					<span style="margin-left: 30px;"><a href="#" class="select-all-multiselect" data-ms-id="attendeeAccessSelect"><?php echo rsvp_pro_get_admin_string( 'select_all_label' ); ?></a></span>
					<span style="margin-left: 110px;"><a href="#" class="deselect-all-multiselect" data-ms-id="attendeeAccessSelect"><?php echo rsvp_pro_get_admin_string( 'deselect_all_label' ); ?></a></span>
				</p>
			</td>
		</tr>
				<tr class="subEventHide">
					<th scope="row">
						<label for="<?php echo RSVP_PRO_OPTION_ALLOW_CHECKINS; ?>">
							<?php echo rsvp_pro_get_admin_string( 'settings_allow_attendee_checkin_label' ); ?>
						</label>
					</th>
					<td>
						<input type="checkbox" name="<?php echo RSVP_PRO_OPTION_ALLOW_CHECKINS; ?>" id="<?php echo RSVP_PRO_OPTION_ALLOW_CHECKINS; ?>" value="Y" <?php echo ( $allow_checkin == 'Y' ) ? 'checked="checked"' : ''; ?> />
						<br />
						<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_allow_attendee_checkin_description' ); ?></span>
					</td>
				</tr>
				<tr>
					<th scope="row" colspan="2">
						<h3><?php echo rsvp_pro_get_admin_string( 'general_event_information_header' ); ?></h3>
					</th>
				</tr>
				<tr>
					<th scope="row">
						<label for="eventStartDate">
							<?php echo rsvp_pro_get_admin_string( 'settings_event_start_date_label' ); ?>
						</label>
					</th>
					<td>
						<input type="text" name="eventStartDate" id="eventStartDate" value="<?php echo esc_attr_e( $eventStartDate ); ?>" />
						<select name="eventStartDateTimezone">
						<?php echo wp_timezone_choice( ( ! empty( $eventStartDateTimezone ) ? $eventStartDateTimezone : rsvp_pro_wp_get_timezone_string() ) ); ?>
						</select>
						<br />
						<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_date_format_example' ); ?></span>
					</td>
				</tr>
				<tr>
					<th scope="row">
						<label for="eventEndDate">
							<?php echo rsvp_pro_get_admin_string( 'settings_event_end_date_label' ); ?>
						</label>
					</th>
					<td>
						<input type="text" name="eventEndDate" id="eventEndDate" value="<?php echo esc_attr_e( $eventEndDate ); ?>" />
						<select name="eventEndDateTimezone">
						<?php echo wp_timezone_choice( ( ! empty( $eventEndDateTimezone ) ? $eventEndDateTimezone : rsvp_pro_wp_get_timezone_string() ) ); ?>
						</select>
						<br />
						<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_date_format_example' ); ?></span>
					</td>
				</tr>
				<tr>
					<th scope="row">
						<label for="eventLocation">
							<?php echo rsvp_pro_get_frontend_string( 'event_location_label' ); ?>
						</label>
					</th>
					<td>
						<input type="text" name="eventLocation" id="eventLocation" value="<?php echo esc_attr_e( $eventLocation ); ?>" />
					</td>
				</tr>
				<tr>
					<th scope="row">
						<label for="eventDescription">
							<?php echo rsvp_pro_get_admin_string( 'settings_event_description_label' ); ?>
						</label>
					</th>
					<td>
						<textarea name="eventDescription" id="eventDescription" rows="5" cols="60"><?php echo esc_html( $eventDescription ); ?></textarea>
					</td>
				</tr>
				<!-- Reoccurring Events Info -->
				<tr class="subEventHide">
					<th scope="row" colspan="2">
						<h3><?php echo rsvp_pro_get_admin_string( 'settings_recurring_event_information_header' ); ?></h3>
						<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_recurring_event_header_description' ); ?></span>
					</th>
				</tr>
				<tr class="subEventHide">
					<th scope="row">
						<label for="<?php echo RSVP_PRO_OPTION_REPEAT_START_DATE; ?>">
							<?php echo rsvp_pro_get_admin_string( 'settings_repeating_start_date_label' ); ?>
						</label>
					</th>
					<td>
						<input type="text" name="<?php echo RSVP_PRO_OPTION_REPEAT_START_DATE; ?>" id="<?php echo RSVP_PRO_OPTION_REPEAT_START_DATE; ?>" value="<?php echo esc_attr_e( $repeatStartDate ); ?>" />
						<br />
						<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_repeating_start_date_description' ); ?></span>
					</td>
				</tr>
				<tr class="subEventHide">
					<th scope="row">
						<label for="<?php echo RSVP_PRO_OPTION_REPEAT_END_DATE; ?>">
							<?php echo rsvp_pro_get_admin_string( 'settings_repeating_end_date_label' ); ?>
						</label>
					</th>
					<td>
						<input type="text" name="<?php echo RSVP_PRO_OPTION_REPEAT_END_DATE; ?>" id="<?php echo RSVP_PRO_OPTION_REPEAT_END_DATE; ?>" value="<?php echo esc_attr_e( $repeatEndDate ); ?>" />
						<br />
						<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_repeating_end_date_description' ); ?></span>
					</td>
				</tr>
				<tr class="subEventHide">
					<th scope="row">
						<label for="<?php echo RSVP_PRO_OPTION_REPEAT_FREQUENCY; ?>">
							<?php echo rsvp_pro_get_admin_string( 'settings_repeating_frequency_label' ); ?>
						</label>
					</th>
					<td>
						<input type="number" name="<?php echo RSVP_PRO_OPTION_REPEAT_FREQUENCY; ?>" id="<?php echo RSVP_PRO_OPTION_REPEAT_FREQUENCY; ?>" value="<?php echo esc_attr_e( $repeatFrequency ); ?>" />
						<br />
						<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_repeating_frequency_description' ); ?></span>
					</td>
				</tr>
				<tr class="subEventHide">
					<th scope="row">
						<label for="<?php echo RSVP_PRO_OPTION_REPEAT_FREQUENCY_TYPE; ?>">
							<?php echo rsvp_pro_get_admin_string( 'settings_repeating_frequency_type' ); ?>
						</label>
					</th>
					<td>
						<select name="<?php echo RSVP_PRO_OPTION_REPEAT_FREQUENCY_TYPE; ?>" id="<?php echo RSVP_PRO_OPTION_REPEAT_FREQUENCY_TYPE; ?>" size="1">
							<option value="">--</option>
							<option value="day" <?php echo ( $repeatFrequencyType == 'day' ) ? 'selected="selected"' : ''; ?>>
								<?php echo rsvp_pro_get_admin_string( 'settings_day_label' ); ?>
							</option>
							<option value="week" <?php echo ( $repeatFrequencyType == 'week' ) ? 'selected="selected"' : ''; ?>>
								<?php echo rsvp_pro_get_admin_string( 'settings_week_label' ); ?>
							</option>
							<option value="month" <?php echo ( $repeatFrequencyType == 'month' ) ? 'selected="selected"' : ''; ?>>
								<?php echo rsvp_pro_get_admin_string( 'settings_month_label' ); ?>
							</option>
							<option value="year" <?php echo ( $repeatFrequencyType == 'year' ) ? 'selected="selected"' : ''; ?>>
								<?php echo rsvp_pro_get_admin_string( 'settings_year_label' ); ?>
							</option>
						</select>
						<br />
						<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_repeating_frequency_type_description' ); ?></span>
					</td>
				</tr>
				<tr class="subEventHide">
					<th scope="row">
						<label for="<?php echo RSVP_PRO_OPTION_REPEAT_LENGTH; ?>">
							<?php echo rsvp_pro_get_admin_string( 'settings_event_length_label' ); ?>
						</label>
					</th>
					<td>
						<input type="number" name="<?php echo RSVP_PRO_OPTION_REPEAT_LENGTH; ?>" id="<?php echo RSVP_PRO_OPTION_REPEAT_LENGTH; ?>" value="<?php echo esc_attr_e( $repeatLength ); ?>" />
						<br />
						<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_event_length_description' ); ?></span>
					</td>
				</tr>
				<tr class="subEventHide">
					<th scope="row">
						<label for="<?php echo RSVP_PRO_OPTION_REPEAT_LENGTH_TYPE; ?>">
							<?php echo rsvp_pro_get_admin_string( 'settings_length_type_label' ); ?>
						</label>
					</th>
					<td>
						<select name="<?php echo RSVP_PRO_OPTION_REPEAT_LENGTH_TYPE; ?>" id="<?php echo RSVP_PRO_OPTION_REPEAT_LENGTH_TYPE; ?>" size="1">
							<option value="">--</option>
							<option value="day" <?php echo ( $repeatLengthType == 'day' ) ? 'selected="selected"' : ''; ?>>
								<?php echo rsvp_pro_get_admin_string( 'settings_day_label' ); ?>
							</option>
							<option value="week" <?php echo ( $repeatLengthType == 'week' ) ? 'selected="selected"' : ''; ?>>
								<?php echo rsvp_pro_get_admin_string( 'settings_week_label' ); ?>
							</option>
							<option value="month" <?php echo ( $repeatLengthType == 'month' ) ? 'selected="selected"' : ''; ?>>
								<?php echo rsvp_pro_get_admin_string( 'settings_month_label' ); ?>
							</option>
							<option value="year" <?php echo ( $repeatLengthType == 'year' ) ? 'selected="selected"' : ''; ?>>
								<?php echo rsvp_pro_get_admin_string( 'settings_year_label' ); ?>
							</option>
						</select>
						<br />
						<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_length_type_description' ); ?></span>
					</td>
				</tr>
				<tr class="subEventHide">
					<th scope="row">
						<label for="<?php echo RSVP_PRO_OPTION_REPEAT_DONT_SAVE_EVENTS; ?>">
							<?php echo rsvp_pro_get_admin_string( 'settings_dont_keep_recurring_history' ); ?>
						</label>
					</th>
					<td>
						<input type="checkbox" name="<?php echo RSVP_PRO_OPTION_REPEAT_DONT_SAVE_EVENTS; ?>" id="<?php echo RSVP_PRO_OPTION_REPEAT_DONT_SAVE_EVENTS; ?>" value="Y" <?php echo ( $repeatDoNotSaveEvent == 'Y' ) ? 'checked="checked"' : ''; ?> />
						<br />
						<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_dont_keep_recurring_history_description' ); ?></span>
					</td>
				</tr>
	</tbody>
</table>
