<?php
/**
 * Returns all of the strings that exist for the admin interface.
 *
 * @return array An array of all strings for the admin interface.
 */
function rsvp_pro_get_admin_strings() {
	$admin_strings = array(
		'invalid_license'                                  => array(
			'name' => 'Invalid license message',
			'text' => __( 'License is invalid, please activate your license in <a href="%s">RSVP Pro -> License</a>', 'rsvp-pro-plugin' ),
		),
		'event_deleted'                                    => array(
			'name' => 'Event deleted message',
			'text' => __( 'Event deleted', 'rsvp-pro-plugin' ),
		),
		'delete_question'                                  => array(
			'name' => 'Event delete confirmation',
			'text' => __( 'Are you sure you want to delete ', 'rsvp-pro-plugin' ),
		),
		'list_events'                                      => array(
			'name' => 'List of Events',
			'text' => __( 'List of Events', 'rsvp-pro-plugin' ),
		),
		'change_log_admin_title'                           => array(
			'name' => 'Attendee change log title',
			'text' => __( 'Attendee Change Log', 'rsvp-pro-plugin' ),
		),
		'add_events'                                       => array(
			'name' => 'Add Events Button',
			'text' => __( 'Add Event', 'rsvp-pro-plugin' ),
		),
		'no_events_message'                                => array(
			'name' => 'No Events Message',
			'text' => __( 'No events have been created yet.', 'rsvp-pro-plugin' ),
		),
		'create_event_message'                             => array(
			'name' => 'Create One Message',
			'text' => __( 'Create one now', 'rsvp-pro-plugin' ),
		),
		'event_id_label'                                   => array(
			'name' => 'Event ID Label',
			'text' => __( 'Event ID', 'rsvp-pro-plugin' ),
		),
		'short_code_label'                                 => array(
			'name' => 'Short Code Label',
			'text' => __( 'Short Code', 'rsvp-pro-plugin' ),
		),
		'attendees_label'                                  => array(
			'name' => 'Attendees Label',
			'text' => __( 'Attendees', 'rsvp-pro-plugin' ),
		),
		'settings_label'                                   => array(
			'name' => 'Settings Label',
			'text' => __( 'Settings', 'rsvp-pro-plugin' ),
		),
		'delete_label'                                     => array(
			'name' => 'Delete Label',
			'text' => __( 'Delete', 'rsvp-pro-plugin' ),
		),
		'export_attendees_label'                           => array(
			'name' => 'Export Attendees Label',
			'text' => __( 'Export Attendees', 'rsvp-pro-plugin' ),
		),
		'export_change_log_label'                          => array(
			'name' => 'Export Change Log Label',
			'text' => __( 'Export Change Log', 'rsvp-pro-plugin' ),
		),
		'export_attendees_w_subevent_label'                => array(
			'name' => 'Export Attendess w/Sub-Event Label',
			'text' => __( 'Export Attendees w/Sub-Event Information', 'rsvp-pro-plugin' ),
		),
		'import_attendees_label'                           => array(
			'name' => 'Import Attendess Label',
			'text' => __( 'Import Attendees', 'rsvp-pro-plugin' ),
		),
		'add_attendees_button'                             => array(
			'name' => 'Add Attendees Button',
			'text' => __( 'Add Attendee', 'rsvp-pro-plugin' ),
		),
		'custom_questions_label'                           => array(
			'name' => 'Custom Questions Label',
			'text' => __( 'Custom Questions', 'rsvp-pro-plugin' ),
		),
		'copy_event_label'                                 => array(
			'name' => 'Copy Event Label',
			'text' => __( 'Copy Event', 'rsvp-pro-plugin' ),
		),
		'import_from_free_label'                           => array(
			'name' => 'Import from RSVP Free Label',
			'text' => __( 'Import attendees and custom questions from Free RSVP', 'rsvp-pro-plugin' ),
		),
		'send_message_label'                               => array(
			'name' => 'Send Message Label',
			'text' => __( 'Send Message', 'rsvp-pro-plugin' ),
		),
		'all_attendees_label'                              => array(
			'name' => 'All Attendees Label',
			'text' => __( 'All Attendees', 'rsvp-pro-plugin' ),
		),
		'reminders_label'                                  => array(
			'name' => 'Reminders Label',
			'text' => __( 'Reminders', 'rsvp-pro-plugin' ),
		),
		'reset_all_label'                                  => array(
			'name' => 'Reset All Attendees Label',
			'text' => __( 'Reset All Attendees', 'rsvp-pro-plugin' ),
		),
		'change_log_label'                                 => array(
			'name' => 'Change Log Label',
			'text' => __( 'Attendee Change Log', 'rsvp-pro-plugin' ),
		),
		'manage_attendees_label'                           => array(
			'name' => 'Manage Attendees Label',
			'text' => __( 'Manage Attendees', 'rsvp-pro-plugin' ),
		),
		'sub_events_label'                                 => array(
			'name' => 'Sub-Events Label',
			'text' => __( 'Sub-Events for <strong>%s</strong>', 'rsvp-pro-plugin' ),
		),
		'note_label'                                       => array(
			'name' => 'Note Label',
			'text' => __( 'Note', 'rsvp-pro-plugin' ),
		),
		'nicknames_label'                                  => array(
			'name' => 'Nicknames Label',
			'text' => __( 'Nicknames', 'rsvp-pro-plugin' ),
		),
		'list_attendees_label'                             => array(
			'name' => 'List of Attendees Label',
			'text' => __( 'List of current attendees', 'rsvp-pro-plugin' ),
		),
		'attendee_count_label'                             => array(
			'name' => 'Attendee Count Label',
			'text' => __( 'Attendee Count', 'rsvp-pro-plugin' ),
		),
		'and'                                              => array(
			'name' => 'And Label',
			'text' => __( 'and', 'rsvp-pro-plugin' ),
		),
		'field_to_search_label'                            => array(
			'name' => 'Field to Search Label',
			'text' => __( 'Field to search', 'rsvp-pro-plugin' ),
		),
		'results_page_label'                               => array(
			'name' => 'Results Per Page Label',
			'text' => __( 'Results per page', 'rsvp-pro-plugin' ),
		),
		'result_25'                                        => array(
			'name' => '25 Results Per Page',
			'text' => __( '25', 'rsvp-pro-plugin' ),
		),
		'result_50'                                        => array(
			'name' => '50 Results Per Page',
			'text' => __( '50', 'rsvp-pro-plugin' ),
		),
		'result_100'                                       => array(
			'name' => '100 Results Per Page',
			'text' => __( '100', 'rsvp-pro-plugin' ),
		),
		'result_all'                                       => array(
			'name' => 'All Results',
			'text' => __( 'All', 'rsvp-pro-plugin' ),
		),
		'bulk_actions_label'                               => array(
			'name' => 'Bulk Actions Label',
			'text' => __( 'Bulk Actions', 'rsvp-pro-plugin' ),
		),
		'apply_label'                                      => array(
			'name' => 'Apply Label',
			'text' => __( 'Apply', 'rsvp-pro-plugin' ),
		),
		'event_list_label'                                 => array(
			'name' => 'Event List Label',
			'text' => __( 'Event List', 'rsvp-pro-plugin' ),
		),
		'attendee_event_list_label'                        => array(
			'name' => 'Attendee Event List Label',
			'text' => __( 'Attendee Event List', 'rsvp-pro-plugin' ),
		),
		'rsvp_date_label'                                  => array(
			'name' => 'RSVP Date Label',
			'text' => __( 'RSVP Date', 'rsvp-pro-plugin' ),
		),
		'attendee_label'                                   => array(
			'name' => 'Attendee Label',
			'text' => __( 'Attendee', 'rsvp-pro-plugin' ),
		),
		'changes_header_label'                             => array(
			'name' => 'Changes header label',
			'text' => __( 'Changes', 'rsvp-pro-plugin' ),
		),
		'change_date_header_label'                         => array(
			'name' => 'Change date header label',
			'text' => __( 'Change Date', 'rsvp-pro-plugin' ),
		),
		'checked_in_label'                                 => array(
			'name' => 'Checked-In Label',
			'text' => __( 'Checked In', 'rsvp-pro-plugin' ),
		),
		'additional_attendee_label'                        => array(
			'name' => 'Additional Attendee Label',
			'text' => __( 'Additional Attendee', 'rsvp-pro-plugin' ),
		),
		'total_imported_label'                             => array(
			'name' => 'Total Records Imported Label',
			'text' => __( 'total records were imported', 'rsvp-pro-plugin' ),
		),
		'continue_to_rsvp_label'                           => array(
			'name' => 'Continue to RSVP label',
			'text' => __( 'Continue to the RSVP', 'rsvp-pro-plugin' ),
		),
		'list_label'                                       => array(
			'name' => 'List Label',
			'text' => __( 'list', 'rsvp-pro-plugin' ),
		),
		'attendee_import_excel_message'                    => array(
			'name' => 'Attendee Import File Message',
			'text' => __(
				'<p>This area allows you to import attendees in for your event. There are two steps with this process. Below you select the file you want to import and choose if you want to delete attendees associated with the event (this will happen on the final step and not when you click next).</p>
			 	<p>Any CSV or Excel file can be used to import attendees. The file must meet the following requirements:</p>
			 	<ol>
			 		<li>A first OR last name column</li>
			 		<li>The first row must be a header row with column names</li>
			 	</ol>
				<p>In the second step you specify which columns go to which attendee fields.</p>',
				'rsvp-pro-plugin'
			),
		),
		'attendee_import_title_step_1'                     => array(
			'name' => 'Attendee Import Step 1 Title',
			'text' => __( 'Import (Step 1 of 2)', 'rsvp-pro-plugin' ),
		),
		'attendee_import_title_step_2'                     => array(
			'name' => 'Attendee Import Step 2 Title',
			'text' => __( 'Import (Step 2 of 2)', 'rsvp-pro-plugin' ),
		),
		'attendee_import_column_selection_message'         => array(
			'name' => 'Attendee Import Column Selection Description',
			'text' => __(
				'<p>We are almost there! This is the final step where you specify which column in your file goes to what attendee field.</p>

				<p>Once you specify the columns just hit &quot;Import Attendees&quot; and your attendees will be loaded for your event.</p>

				<p>Only the first OR last name needs to be selected for the import process to work.</p>',
				'rsvp-pro-plugin'
			),
		),
		'custom_message_label'                             => array(
			'name' => 'Custom Message Label',
			'text' => __( 'Custom Message', 'rsvp-pro-plugin' ),
		),
		'number_guests_allowed_label'                      => array(
			'name' => 'Number of Guests Allowed Label',
			'text' => __( 'Number of guests allowed for attendee', 'rsvp-pro-plugin' ),
		),
		'primary_attendee_label'                           => array(
			'name' => 'Primary Attendee Label',
			'text' => __( 'Primary Attendee', 'rsvp-pro-plugin' ),
		),
		'group_id_label'                                   => array(
			'name' => 'Group ID Label',
			'text' => __( 'GroupID', 'rsvp-pro-plugin' ),
		),
		'private_question_association_label'               => array(
			'name' => 'Select People Custom Question Association Label',
			'text' => __( '&quot;Select People&quot; Custom Question Association', 'rsvp-pro-plugin' ),
		),
		'custom_question_value_label'                      => array(
			'name' => 'Custom Question Value Label',
			'text' => __( 'Custom Question Values', 'rsvp-pro-plugin' ),
		),
		'sub_event_association_label'                      => array(
			'name' => 'Sub-Event Association Label',
			'text' => __( 'Sub-Event Association', 'rsvp-pro-plugin' ),
		),
		'delete_attendees_import_label'                    => array(
			'name' => 'Delete Attendees on Import Label',
			'text' => __( 'Delete existing attendees on import', 'rsvp-pro-plugin' ),
		),
		'emailed_label'                                    => array(
			'name' => 'Emailed Label',
			'text' => __( 'emailed', 'rsvp-pro-plugin' ),
		),
		'send_message_for_label'                           => array(
			'name' => 'Send A Message For Event Label',
			'text' => __( 'Send a message for', 'rsvp-pro-plugin' ),
		),
		'attendees_being_emailed_label'                    => array(
			'name' => 'Attendees Currently Emailing Label',
			'text' => __( 'Attendees currently emailing', 'rsvp-pro-plugin' ),
		),
		'email_not_set_label'                              => array(
			'name' => 'Email Not Set Label',
			'text' => __( 'Email Not Set', 'rsvp-pro-plugin' ),
		),
		'from_email_label'                                 => array(
			'name' => 'From Email Address Label',
			'text' => __( 'From Email Address', 'rsvp-pro-plugin' ),
		),
		'from_email_name_label'                            => array(
			'name' => 'From Name Label',
			'text' => __( 'From Name', 'rsvp-pro-plugin' ),
		),
		'limit_rsvp_status_label'                          => array(
			'name' => 'Limit to RSVP Status Label',
			'text' => __( 'Limit to RSVP Status', 'rsvp-pro-plugin' ),
		),
		'read_receipt_label'                               => array(
			'name' => 'Request Read Receipt Label',
			'text' => __( 'Request a Read Receipt', 'rsvp-pro-plugin' ),
		),
		'from_address_required_label'                      => array(
			'name' => 'From Address Field Must be Filled Out Label',
			'text' => __( 'The &quot;From Address&quot; field must be filled out', 'rsvp-pro-plugin' ),
		),
		'message_subject_label'                            => array(
			'name' => 'Message Subject Label',
			'text' => __( 'Subject', 'rsvp-pro-plugin' ),
		),
		'message_email_label'                              => array(
			'name' => 'Message Label',
			'text' => __( 'Message', 'rsvp-pro-plugin' ),
		),
		'message_attachments_label'                        => array(
			'name' => 'Attachment Label',
			'text' => __( 'Attachments', 'rsvp-pro-plugin' ),
		),
		'available_placeholders_label'                     => array(
			'name' => 'Available Placeholders Label',
			'text' => __( 'Available Attendee Data Placeholders For Subject &amp; Message', 'rsvp-pro-plugin' ),
		),
		'individual_tags_label'                            => array(
			'name' => 'Individual Nested Tags Label',
			'text' => __( 'This tag needs to have an open and close tag, individual tags can be nested inside.', 'rsvp-pro-plugin' ),
		),
		'copy_text'                                        => array(
			'name' => 'Copy Text',
			'text' => __( 'Copy', 'rsvp-pro-plugin' ),
		),
		'event_copy_to_message'                            => array(
			'name' => 'Event Copied Message',
			'text' => __( 'Event copied to', 'rsvp-pro-plugin' ),
		),
		'copy_settings_and_questions_label'                => array(
			'name' => 'Copy All Settings and Custom Questions From Event Label',
			'text' => __( 'Copy all settings and custom questions from ', 'rsvp-pro-plugin' ),
		),
		'to_new_event_label'                               => array(
			'name' => 'To New Event Label',
			'text' => __( 'to a new event?', 'rsvp-pro-plugin' ),
		),
		'copy_attendees_question_label'                    => array(
			'name' => 'Copy Attendees Question Label',
			'text' => __( 'Copy attendees as well?', 'rsvp-pro-plugin' ),
		),
		'reset_attendees_caution_label'                    => array(
			'name' => 'Reset All Attendees Question Label',
			'text' => __( 'Are you sure you want to reset all attendees for event ', 'rsvp-pro-plugin' ),
		),
		'reset_rsvp_status_label'                          => array(
			'name' => 'Reset RSVP Responses Label',
			'text' => __( 'This will set RSVP responses to &quot;No Response&quot; and remove all answers for custom questions.', 'rsvp-pro-plugin' ),
		),
		'reset_label'                                      => array(
			'name' => 'Reset Label',
			'text' => __( 'Reset', 'rsvp-pro-plugin' ),
		),
		'attendee_successfully_saved_message'              => array(
			'name' => 'Attendee Successfully Saved',
			'text' => __( 'has been successfully saved', 'rsvp-pro-plugin' ),
		),
		'continue_attendee_list_label'                     => array(
			'name' => 'Continue To Attendee List Label',
			'text' => __( 'Continue to Attendee List', 'rsvp-pro-plugin' ),
		),
		'edit_label'                                       => array(
			'name' => 'Edit Label',
			'text' => __( 'Edit ', 'rsvp-pro-plugin' ),
		),
		'again_label'                                      => array(
			'name' => 'Again Label',
			'text' => __( 'again', 'rsvp-pro-plugin' ),
		),
		'back_attendee_list_label'                         => array(
			'name' => 'Back to Attendee List Label',
			'text' => __( 'Back to attendee list', 'rsvp-pro-plugin' ),
		),
		'rsvpd_label'                                      => array(
			'name' => 'RSVP\'d On Label',
			'text' => __( 'RSVP\'d on', 'rsvp-pro-plugin' ),
		),
		'alt_first_name_label'                             => array(
			'name' => 'Alternative First Name Label',
			'text' => __( 'Alternative First Names', 'rsvp-pro-plugin' ),
		),
		'primary_attendee_description_message'             => array(
			'name' => 'Primary Attendee Description Message',
			'text' => __( 'Primary attendees will be shown first when associated guests try to RSVP', 'rsvp-pro-plugin' ),
		),
		'non_associated_attendees_label'                   => array(
			'name' => 'Non-Associated Attendees Label',
			'text' => __( 'Non-Associated Attendees', 'rsvp-pro-plugin' ),
		),
		'email_attendee_label'                             => array(
			'name' => 'Email Attendee Label',
			'text' => __( 'Email Attendee', 'rsvp-pro-plugin' ),
		),
		'reset_attendee_label'                             => array(
			'name' => 'Reset Attendee Label',
			'text' => __( 'Reset Attendee Information', 'rsvp-pro-plugin' ),
		),
		'save_sort_order_label'                            => array(
			'name' => 'Save Sort Order Label',
			'text' => __( 'Save Sort Order', 'rsvp-pro-plugin' ),
		),
		'id_label'                                         => array(
			'name' => 'ID Label',
			'text' => __( 'ID', 'rsvp-pro-plugin' ),
		),
		'question_label'                                   => array(
			'name' => 'Question Label',
			'text' => __( 'Question', 'rsvp-pro-plugin' ),
		),
		'custom_question_saved_label'                      => array(
			'name' => 'Custom Question Saved Label',
			'text' => __( 'Custom Question saved', 'rsvp-pro-plugin' ),
		),
		'continue_question_list_label'                     => array(
			'name' => 'Continue to Question List Label',
			'text' => __( 'Continue to Question List', 'rsvp-pro-plugin' ),
		),
		'another_question_label'                           => array(
			'name' => 'Add Another Question Label',
			'text' => __( 'Add another Question', 'rsvp-pro-plugin' ),
		),
		'answer_label'                                     => array(
			'name' => 'Answer Label',
			'text' => __( 'Answer', 'rsvp-pro-plugin' ),
		),
		'default_answer_label'                             => array(
			'name' => 'Default Answer Label',
			'text' => __( 'Default Answer', 'rsvp-pro-plugin' ),
		),
		'save_label'                                       => array(
			'name' => 'Save Label',
			'text' => __( 'Save', 'rsvp-pro-plugin' ),
		),
		'back_custom_question_label'                       => array(
			'name' => 'Back to Custom Question List',
			'text' => __( 'Back to custom question list', 'rsvp-pro-plugin' ),
		),
		'question_grouping_label'                          => array(
			'name' => 'Question Grouping Label',
			'text' => __( 'Question Grouping', 'rsvp-pro-plugin' ),
		),
		'question_asked_everyone_label'                    => array(
			'name' => 'Question Asked to Everyone Label',
			'text' => __( 'Question asked to everyone', 'rsvp-pro-plugin' ),
		),
		'question_asked_per_associated_label'              => array(
			'name' => 'Question Asked Once Per Associated Attendee Label',
			'text' => __( 'Question asked once per associated attendees', 'rsvp-pro-plugin' ),
		),
		'question_type_label'                              => array(
			'name' => 'Question Type Label',
			'text' => __( 'Question Type', 'rsvp-pro-plugin' ),
		),
		'is_required_label'                                => array(
			'name' => 'Is Required? Label',
			'text' => __( 'Is Required?', 'rsvp-pro-plugin' ),
		),
		'required_text_label'                              => array(
			'name' => 'Required Message Label',
			'text' => __( 'Required Message', 'rsvp-pro-plugin' ),
		),
		'only_ask_associated_new_label'                    => array(
			'name' => 'Only Ask Question to Associated and New Attendees',
			'text' => __( 'Only ask question to associated and new guests?', 'rsvp-pro-plugin' ),
		),
		'question_permission_label'                        => array(
			'name' => 'Question Permission Label',
			'text' => __( 'Question Permission Level', 'rsvp-pro-plugin' ),
		),
		'everyone_label'                                   => array(
			'name' => 'Everyone Label',
			'text' => __( 'Everyone', 'rsvp-pro-plugin' ),
		),
		'select_people_label'                              => array(
			'name' => 'Select People Label',
			'text' => __( 'Select People', 'rsvp-pro-plugin' ),
		),
		'attendees_allowed_to_answer_label'                => array(
			'name' => 'Attendees Allowed to Answer Label',
			'text' => __( 'Attendees allowed to answer this question', 'rsvp-pro-plugin' ),
		),
		'show_question_rsvp_status_label'                  => array(
			'name' => 'Only Show Question for RSVP Status Label',
			'text' => __( 'Only Show Question for RSVP Status', 'rsvp-pro-plugin' ),
		),
		'answers_label'                                    => array(
			'name' => 'Answers Label',
			'text' => __( 'Answers', 'rsvp-pro-plugin' ),
		),
		'add_answer_label'                                 => array(
			'name' => 'Add New Answer Label',
			'text' => __( 'Add new Answer', 'rsvp-pro-plugin' ),
		),
		'import_complete_label'                            => array(
			'name' => 'Import Complete Label',
			'text' => __( 'Import complete', 'rsvp-pro-plugin' ),
		),
		'import_label'                                     => array(
			'name' => 'Import Label',
			'text' => __( 'Import!', 'rsvp-pro-plugin' ),
		),
		'rsvp_general_settings_label'                      => array(
			'name' => 'RSVP Pro General Settings Label',
			'text' => __( 'RSVP Pro General Settings', 'rsvp-pro-plugin' ),
		),
		'delete_data_uninstall_label'                      => array(
			'name' => 'Delete Data on Uninstall Label',
			'text' => __( 'Delete all data on uninstall:', 'rsvp-pro-plugin' ),
		),
		'post_type_select_settings_label'                  => array(
			'name' => 'Select Post Type to Auto-Create Event Pages Label',
			'text' => __( 'Select the post type to auto create events &quot;pages&quot; for', 'rsvp-pro-plugin' ),
		),
		'auto_create_post_type_label'                      => array(
			'name' => 'Automatically Create Post-Type Settings Label',
			'text' => __( 'Automatically create post_type entry for main event:', 'rsvp-pro-plugin' ),
		),
		'page_found_or_not_description_label'              => array(
			'name' => 'If Page Found With Shortcode One Won\'t Be Created Label',
			'text' => __( 'If a &quot;page&quot; is found with the rsvp short code than a &quot;page&quot; will not be created.', 'rsvp-pro-plugin' ),
		),
		'add_attendee_list_to_auto_page_label'             => array(
			'name' => 'Add Attendee List to Auto-Created Page Label',
			'text' => __( 'Add attendee list shortcode to automatically created page:', 'rsvp-pro-plugin' ),
		),
		'attendee_list_auto_page_description'              => array(
			'name' => 'Add Attendee List to Auto-Created Description Label',
			'text' => __( 'This will automatically add the public attendee list shortcode to the automatic created page.', 'rsvp-pro-plugin' ),
		),
		'custom_styling_label'                             => array(
			'name' => 'Custom Styling Label',
			'text' => __( 'Custom Styling:', 'rsvp-pro-plugin' ),
		),
		'events_imported_label'                            => array(
			'name' => 'Events Imported Label',
			'text' => __( 'Events imported', 'rsvp-pro-plugin' ),
		),
		'rsvp_pro_import_events_label'                     => array(
			'name' => 'RSVP Pro Import Events Label',
			'text' => __( 'RSVP Pro Import Events', 'rsvp-pro-plugin' ),
		),
		'select_file_import_label'                         => array(
			'name' => 'Select File Import Label',
			'text' => __( 'Select file to import', 'rsvp-pro-plugin' ),
		),
		'import_events_label'                              => array(
			'name' => 'Import Events Label',
			'text' => __( 'Import Events', 'rsvp-pro-plugin' ),
		),
		'export_events_header'                             => array(
			'name' => 'RSVP Pro Export Events Header',
			'text' => __( 'RSVP Pro Export Events', 'rsvp-pro-plugin' ),
		),
		'select_events_exported_label'                     => array(
			'name' => 'Select Events to be Exported Label',
			'text' => __( 'Select the Events To Be Exported', 'rsvp-pro-plugin' ),
		),
		'export_parent_is_label'                           => array(
			'name' => 'Export Parent Event Label',
			'text' => __( ' - Parent Event is ', 'rsvp-pro-plugin' ),
		),
		'export_information_warning_label'                 => array(
			'name' => 'Export Information Warning Label',
			'text' => __( 'Currently only event information and <b>NOT</b> attendee information is exported', 'rsvp-pro-plugin' ),
		),
		'export_events_label'                              => array(
			'name' => 'Export Events Label',
			'text' => __( 'Export Events', 'rsvp-pro-plugin' ),
		),
		'event_management_label'                           => array(
			'name' => 'Event Management Label',
			'text' => __( 'Event Management', 'rsvp-pro-plugin' ),
		),
		'general_settings_label'                           => array(
			'name' => 'General Settings Label',
			'text' => __( 'General settings', 'rsvp-pro-plugin' ),
		),
		'rsvp_pro_plugin_license_label'                    => array(
			'name' => 'RSVP Pro Plugin License Label',
			'text' => __( 'License', 'rsvp-pro-plugin' ),
		),
		'enter_license_key_label'                          => array(
			'name' => 'Enter License Key Label',
			'text' => __( 'Enter your license key', 'rsvp-pro-plugin' ),
		),
		'active_label'                                     => array(
			'name' => 'Active Label',
			'text' => __( 'active', 'rsvp-pro-plugin' ),
		),
		'deactivate_license_label'                         => array(
			'name' => 'Deactivate License Label',
			'text' => __( 'Deactivate License', 'rsvp-pro-plugin' ),
		),
		'activate_license_label'                           => array(
			'name' => 'Activate License Label',
			'text' => __( 'Activate License', 'rsvp-pro-plugin' ),
		),
		'attendee_list_for_label'                          => array(
			'name' => 'Attendee List For Notification Subject Label',
			'text' => __( 'Attendee list for ', 'rsvp-pro-plugin' ),
		),
		'documentation_label'                              => array(
			'name' => 'Documentation Label',
			'text' => __( 'Documentation', 'rsvp-pro-plugin' ),
		),
		'event_added_message'                              => array(
			'name' => 'Event Added Message',
			'text' => __( 'Event added successfully', 'rsvp-pro-plugin' ),
		),
		'event_updated_message'                            => array(
			'name' => 'Event Updated Message',
			'text' => __( 'Event updated successfully', 'rsvp-pro-plugin' ),
		),
		'settings_general_tab_text'                        => array(
			'name' => 'Settings General Tab Label',
			'text' => __( 'General', 'rsvp-pro-plugin' ),
		),
		'settings_frontend_tab_text'                       => array(
			'name' => 'Settings Front-End Tab Label',
			'text' => __( 'Front-End', 'rsvp-pro-plugin' ),
		),
		'settings_frontend_text_tab_text'                  => array(
			'name' => 'Settings Front-End Text Tab Label',
			'text' => __( 'Front-End Text', 'rsvp-pro-plugin' ),
		),
		'settings_public_attendee_tab_text'                => array(
			'name' => 'Settings Public Attendee List Label',
			'text' => __( 'Public Attendee List', 'rsvp-pro-plugin' ),
		),
		'settings_notifications_tab_text'                  => array(
			'name' => 'Settings Notifications Tab Label',
			'text' => __( 'Notifications', 'rsvp-pro-plugin' ),
		),
		'settings_payment_tab_text'                        => array(
			'name' => 'Settings Payment Tab Label',
			'text' => __( 'Payments', 'rsvp-pro-plugin' ),
		),
		'settings_admin_options_tab_text'                  => array(
			'name' => 'Admin Options Tab Label',
			'text' => __( 'Admin Area Options', 'rsvp-pro-plugin' ),
		),
		'update_event_button_label'                        => array(
			'name' => 'Update Event Button Label',
			'text' => __( 'Update Event', 'rsvp-pro-plugin' ),
		),
		'settings_notify_when_rsvp_label'                  => array(
			'name' => 'Notify When Guest RSVPs Label',
			'text' => __( 'Notify When Guest RSVPs:', 'rsvp-pro-plugin' ),
		),
		'settings_admin_notification_email_label'          => array(
			'name' => 'Admin Notification Email Label',
			'text' => __( 'Admin notification email:', 'rsvp-pro-plugin' ),
		),
		'settings_email_guest_when_rsvp_label'             => array(
			'name' => 'Email Guest when RSVP is Complete Label',
			'text' => __( 'Email guests when RSVP is completed:', 'rsvp-pro-plugin' ),
		),
		'settings_guest_eamil_text_label'                  => array(
			'name' => 'Guest Email Header Text Label',
			'text' => __( 'Email Text: <br />Sent to guests in confirmation, at top of email', 'rsvp-pro-plugin' ),
		),
		'settings_email_from_label'                        => array(
			'name' => 'Email Address Notifications From label',
			'text' => __( 'Email address notifications could come from?', 'rsvp-pro-plugin' ),
		),
		'settings_email_from_description'                  => array(
			'name' => 'Email Address Notification From Description',
			'text' => __(
				'Note: depending on your web host they might block emails with this setting turned on.<br />
                   Examples of expected data: test@test.com or &quot;Test Bob&quot; &lt;test@test.com&gt;',
				'rsvp-pro-plugin'
			),
		),
		'settings_cc_associated_label'                     => array(
			'name' => 'CC Associated Label',
			'text' => __( 'CC associated attendees', 'rsvp-pro-plugin' ),
		),
		'settings_email_associated_separately_label'       => array(
			'name' => 'Email Associated Separately Label',
			'text' => __( 'Email associated attendees separately', 'rsvp-pro-plugin' ),
		),
		'settings_include_ics_label'                       => array(
			'name' => 'Include ICS Label',
			'text' => __( 'Include an ICS file as an attachment', 'rsvp-pro-plugin' ),
		),
		'settings_include_ics_description'                 => array(
			'name' => 'Include ICS Description',
			'text' => __( 'An ICS file will only be attached if the &quot;General Event Information&quot; area is filled out.', 'rsvp-pro-plugin' ),
		),
		'settings_email_to_bcc_label'                      => array(
			'name' => 'Email Address to BCC for Attendee RSVPs Label',
			'text' => __( 'Email addresses to BCC when attendee RSVPs', 'rsvp-pro-plugin' ),
		),
		'settings_email_to_bcc_description'                => array(
			'name' => 'Email Address to BCC For Attendee RSVPs Description',
			'text' => __( 'Separate each email address with a semicolon (;)', 'rsvp-pro-plugin' ),
		),
		'settings_email_attendee_subject_label'            => array(
			'name' => 'Email Attendee Subject Label',
			'text' => __( 'Email subject for the attendee email', 'rsvp-pro-plugin' ),
		),
		'settings_email_attendee_subject_description'      => array(
			'name' => 'Email Attendee Subject Description',
			'text' => __( 'Default is: &quot;RSVP Confirmation&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_email_admin_subject_label'               => array(
			'name' => 'Email Admin Subject Label',
			'text' => __( 'Email subject for the admin notification email', 'rsvp-pro-plugin' ),
		),
		'settings_email_admin_subject_description'         => array(
			'name' => 'Email Admin Subject Description',
			'text' => __( 'Default is: &quot;New RSVP Submission&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_available_email_fields_description'      => array(
			'name' => 'Available Email Fields Description',
			'text' => __( 'Fields that can be used in the email body', 'rsvp-pro-plugin' ),
		),
		'settings_email_attendee_body_label'               => array(
			'name' => 'Email Attendee Body Label',
			'text' => __( 'Email body for the attendee email:', 'rsvp-pro-plugin' ),
		),
		'settings_email_attendee_body_description'         => array(
			'name' => 'Email Attendee Body Description',
			'text' => __( 'This will replace the email message that is sent when an attendee RSVPs.', 'rsvp-pro-plugin' ),
		),
		'settings_email_attendee_body_no_label'            => array(
			'name' => 'Email Attendee "No" Body Label',
			'text' => __( 'Email body for attendee email when they RSVP with &quot;No&quot;:', 'rsvp-pro-plugin' ),
		),
		'settings_email_attendee_body_no_description'      => array(
			'name' => 'Email Attendee "No" Body Description',
			'text' => __( 'This will be sent when an attendee RSVPs with a &quot;No&quot;. The same fields can be used as the email body field above.', 'rsvp-pro-plugin' ),
		),
		'settings_email_attendee_body_waitlist_label'      => array(
			'name' => 'Email Attendee "Waitlist" Body Label',
			'text' => __( 'Email body for attendee email when they RSVP with &quot;Waitlist&quot;:', 'rsvp-pro-plugin' ),
		),
		'settings_email_attendee_body_waitlist_description' => array(
			'name' => 'Email Attendee "Waitlist" Body Description',
			'text' => __( 'This will be sent when an attendee RSVPs with a &quot;No&quot;. The same fields can be used as the email body field above.', 'rsvp-pro-plugin' ),
		),
		'settings_send_attendee_list_label'                => array(
			'name' => 'Send Attendee List Label',
			'text' => __( 'Send attendee list once RSVP closes', 'rsvp-pro-plugin' ),
		),
		'settings_send_attendee_list_description'          => array(
			'name' => 'Send Attendee List Description',
			'text' => __( 'Automatically send a list of attendees that are going to the event, once the event passes the RSVP close date.', 'rsvp-pro-plugin' ),
		),
		'settings_send_attendee_list_button'               => array(
			'name' => 'Send Attendee List Button Label',
			'text' => __( 'Manually Send Attendee List Now', 'rsvp-pro-plugin' ),
		),
		'settings_email_attendee_list_to_label'            => array(
			'name' => 'Send Attendee List Email To Label',
			'text' => __( 'Email attendee list to', 'rsvp-pro-plugin' ),
		),
		'settings_email_attendee_list_to_description'      => array(
			'name' => 'Send Attendee List Email To Description',
			'text' => __( 'Each address should be separated by a comma.', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_message_label'             => array(
			'name' => 'Send Attendee List Message Label',
			'text' => __( 'Attendee list message', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_message_description'       => array(
			'name' => 'Send Attendee List Message Description',
			'text' => __( 'The text that goes at the top of the attendee list.', 'rsvp-pro-plugin' ),
		),
		'settings_data_fields_label'                       => array(
			'name' => 'Data Fields Label',
			'text' => __( 'Data fields that can be used below', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_format_label'              => array(
			'name' => 'Attendee List Format Label',
			'text' => __( 'Attendee list row format', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_format_description'        => array(
			'name' => 'Attendee List Format Description',
			'text' => __( 'Email sent to attendees when they are automatically changed from "waitlist" to "yes":', 'rsvp-pro-plugin' ),
		),
		'general_form_settings_label'                      => array(
			'name' => 'General Form Settings Label',
			'text' => __( 'General Form Settings', 'rsvp-pro-plugin' ),
		),
		'settings_frontend_one_step_label'                 => array(
			'name' => 'Frontend Has One Step Per Event Label',
			'text' => __( 'Frontend has one step per event:', 'rsvp-pro-plugin' ),
		),
		'settings_frontend_enable_ajax_label'              => array(
			'name' => 'Enable No Refresh Form Submit Label',
			'text' => __( 'Enable no refresh form submit:', 'rsvp-pro-plugin' ),
		),
		'settings_frontend_enable_ajax_description'        => array(
			'name' => 'Enable No Refresh Form Submit Label',
			'text' => __( 'This requires JavaScript to be enabled on your site.', 'rsvp-pro-plugin' ),
		),
		'settings_remove_scrolling_label'                  => array(
			'name' => 'Remove Scrolling To Top Label',
			'text' => __( 'Remove scrolling to the top of the RSVP form:', 'rsvp-pro-plugin' ),
		),
		'settings_disable_fuzzy_label'                     => array(
			'name' => 'Disable Fuzzy User Search Label',
			'text' => __( 'Disable fuzzy user search:', 'rsvp-pro-plugin' ),
		),
		'settings_event_guest_capacity'                    => array(
			'name' => 'Event Guest Capacity Label',
			'text' => __( 'Event guest capacity:', 'rsvp-pro-plugin' ),
		),
		'settings_event_guest_capacity_description'        => array(
			'name' => 'Event Guest Capacity Description',
			'text' => __( 'By default capacity is unlimited', 'rsvp-pro-plugin' ),
		),
		'settings_waitlist_label'                          => array(
			'name' => 'Enable Waitlist Label',
			'text' => __( 'Enable wait list:', 'rsvp-pro-plugin' ),
		),
		'settings_waitlist_description'                    => array(
			'name' => 'Enable Waitlist Description',
			'text' => __( 'Only applies when there is an event capacity set', 'rsvp-pro-plugin' ),
		),
		'settings_partial_match_label'                     => array(
			'name' => 'Do Partial Match on First and Last Name Label',
			'text' => __( "Do partial match on attendee's first and last name:", 'rsvp-pro-plugin' ),
		),
		'settings_auto_change_waitlist_label'              => array(
			'name' => 'Automatically Change Waitlist to Yes Label',
			'text' => __( 'Automatically change "waitlist" status to "yes" when a spot opens up:', 'rsvp-pro-plugin' ),
		),
		'settings_auto_change_waitlist_description'        => array(
			'name' => 'Automatically Change Waitlist to Yes Description',
			'text' => __( 'Will select attendees based on who has the oldest RSVP date', 'rsvp-pro-plugin' ),
		),
		'settings_yes_no_longer_label'                     => array(
			'name' => 'Once "Waitlist" is Triggered "Yes" Will No Longer be Available Label',
			'text' => __( 'Once "waitlist" is triggered, "yes" will no longer be available:', 'rsvp-pro-plugin' ),
		),
		'settings_yes_no_longer_description'               => array(
			'name' => 'Once "Waitlist" is Triggered "Yes" Will No Longer be Available Description',
			'text' => __( 'With this option once a waitlist situation occurs it will never go back to open registration', 'rsvp-pro-plugin' ),
		),
		'settings_yes_unavailable_label'                   => array(
			'name' => 'Is "Yes" Unavailable Label',
			'text' => __( 'Is the "yes" option unavailable to be selected?:', 'rsvp-pro-plugin' ),
		),
		'settings_yes_unavailable_description'             => array(
			'name' => 'Is "Yes" Unavailable Description',
			'text' => __( 'This will set the flag for if the "yes" option should be available when waitlists are enabled', 'rsvp-pro-plugin' ),
		),
		'settings_maybe_label'                             => array(
			'name' => 'Allow Maybe Label',
			'text' => __( 'Allow for a maybe response:', 'rsvp-pro-plugin' ),
		),
		'settings_num_guests_label'                        => array(
			'name' => 'Number of Additional Guests Label',
			'text' => __( 'Number of Additional Guests:', 'rsvp-pro-plugin' ),
		),
		'settings_num_guests_description'                  => array(
			'name' => 'Number of Additional Guests Description',
			'text' => __( 'Default is 3 guests, it is also possible to set different limits for individual attendees', 'rsvp-pro-plugin' ),
		),
		'settings_no_additional_guests_label'              => array(
			'name' => 'No Additional Guests Label',
			'text' => __( 'No additional guests:', 'rsvp-pro-plugin' ),
		),
		'settings_allow_open_label'                        => array(
			'name' => 'Allow Open Registration Label',
			'text' => __( 'Allow Open Registration:', 'rsvp-pro-plugin' ),
		),
		'settings_allow_open_description'                  => array(
			'name' => 'Allow Open Registration Description',
			'text' => __( 'This will force passcodes for attendees', 'rsvp-pro-plugin' ),
		),
		'settings_cant_edit_label'                         => array(
			'name' => 'Attendees Can\'t Edit Registration Label',
			'text' => __( "Attendees can't edit their RSVP:", 'rsvp-pro-plugin' ),
		),
		'settings_cant_edit_description'                   => array(
			'name' => 'Attendees Can\'t Edit Registration Description',
			'text' => __( 'This only works with open registrations', 'rsvp-pro-plugin' ),
		),
		'settings_no_edit_prompt_label'                    => array(
			'name' => 'No Edit Prompt for Attendees Label',
			'text' => __( 'No Edit Prompt for Attendees:', 'rsvp-pro-plugin' ),
		),
		'settings_no_edit_prompt_description'              => array(
			'name' => 'No Edit Prompt for Attendees Description',
			'text' => __( 'This removes the edit prompt for returning attendees', 'rsvp-pro-plugin' ),
		),
		'settings_rsvp_once_label'                         => array(
			'name' => 'Attendees Can RSVP Once Label',
			'text' => __( 'Attendees can only RSVP once:', 'rsvp-pro-plugin' ),
		),
		'settings_rsvp_once_description'                   => array(
			'name' => 'Attendees Can RSVP Once Description',
			'text' => __( 'This will allow attendees to RSVP only once.', 'rsvp-pro-plugin' ),
		),
		'settings_open_prompt_label'                       => array(
			'name' => 'Open Registrations Prompt to Add Label',
			'text' => __( 'For open registrations prompt to add a user if not found in user search:', 'rsvp-pro-plugin' ),
		),
		'settings_open_prompt_description'                 => array(
			'name' => 'Open Regsitrations Prompt to Add Description',
			'text' => __( 'This will initially hide the open registration button and will display it if a user is not found', 'rsvp-pro-plugin' ),
		),
		'settings_auto_auth_label'                         => array(
			'name' => 'Automatically Authenticate WP-Users Label',
			'text' => __( 'Automatically authenticate logged in WP-Users:', 'rsvp-pro-plugin' ),
		),
		'settings_auto_auth_description'                   => array(
			'name' => 'Automatically Authenticate WP-Users Description',
			'text' => __( 'Checking this option will automatically skip the user lookup form if they are logged in and the user and attendee emails match, if it is an open event they will automatically go to create an attendee if there is no match.', 'rsvp-pro-plugin' ),
		),
		'settings_auto_enroll_wp_role_label'               => array(
			'name' => 'Auto-Enroll WordPress Roles Label',
			'text' => __( 'Auto enroll the following WordPress roles:', 'rsvp-pro-plugin' ),
		),
		'settings_available_roles'                         => array(
			'name' => 'Available Roles Label',
			'text' => __( 'Available roles', 'rsvp-pro-plugin' ),
		),
		'settings_auto_enabled_roles_label'                => array(
			'name' => 'Auto Enroll Enabled Roles Label',
			'text' => __( 'Auto enroll enabled roles', 'rsvp-pro-plugin' ),
		),
		'settings_auto_enroll_wp_role_description'         => array(
			'name' => 'Auto-Enroll WordPress Roles Description',
			'text' => __( 'This will allow for a set attendee list to pull from WordPress roles for attendees, &quot;automatically authenticate logged in WP-Users&quot; must be checked.', 'rsvp-pro-plugin' ),
		),
		'settings_email_lookup_label'                      => array(
			'name' => 'Use Email for Look-up Label',
			'text' => __( 'Use email address instead of first and last name for lookup:', 'rsvp-pro-plugin' ),
		),
		'settings_email_lookup_description'                => array(
			'name' => 'Use Email for Look-up Description',
			'text' => __( 'Checking this option will use the email address instead of the first and last name of the attendee when trying to find the user.', 'rsvp-pro-plugin' ),
		),
		'settings_do_not_require_last_name_label'          => array(
			'name' => 'Do Not Require Last Name for Attendees Label',
			'text' => __( 'Do not require the last name for attendees:', 'rsvp-pro-plugin' ),
		),
		'settings_do_not_require_last_name_description'    => array(
			'name' => 'Do Not Require Last Name for Attendees Description',
			'text' => __( 'Checking this option will allow attendees to look-up themselves with just their first name and also allow people to not enter in their last name if they do not want.', 'rsvp-pro-plugin' ),
		),
		'settings_show_cal_link_label'                     => array(
			'name' => 'Show Calendar Link on Confirmation Page Label',
			'text' => __( 'Show calendar invite link on confirmation page:', 'rsvp-pro-plugin' ),
		),
		'settings_show_cal_link_description'               => array(
			'name' => 'Show Calendar Link on Confirmation Page Description',
			'text' => __( 'Displays a link to download a calendar ICS file on the "Yes" confirmation page.', 'rsvp-pro-plugin' ),
		),
		'settings_display_event_description_label'         => array(
			'name' => 'Display Event Description on Front-End Label',
			'text' => __( 'Display &quot;Event Description&quot; on the front-end:', 'rsvp-pro-plugin' ),
		),
		'settings_display_event_description_description'   => array(
			'name' => 'Display Event Description on Front-End Description',
			'text' => __( 'Displays the event description specified in the &quot;General Event Information&quot; section on the front-page.', 'rsvp-pro-plugin' ),
		),
		'form_fields_settings_label'                       => array(
			'name' => 'Form Field Settings Label',
			'text' => __( 'Form Field Settings', 'rsvp-pro-plugin' ),
		),
		'settings_first_last_editable_label'               => array(
			'name' => 'Allow First and Last Name to be Editable Label',
			'text' => __( 'Allow for the First and Last Name to Editable:', 'rsvp-pro-plugin' ),
		),
		'settings_first_last_editable_description'         => array(
			'name' => 'Allow First and Last Name to be Editable Description',
			'text' => __( 'Makes it so the first and last name can always be edited by attendees when they RSVP', 'rsvp-pro-plugin' ),
		),
		'settings_show_salutation_label'                   => array(
			'name' => 'Show Salutation Label',
			'text' => __( 'Show Salutations:', 'rsvp-pro-plugin' ),
		),
		'settings_possible_salutations_label'              => array(
			'name' => 'Possible Salutations Label',
			'text' => __( 'Possible Salutations:', 'rsvp-pro-plugin' ),
		),
		'settings_possible_salutations_description'        => array(
			'name' => 'Possible Salutations Description',
			'text' => __( 'One salutation per-line', 'rsvp-pro-plugin' ),
		),
		'settings_show_suffix_label'                       => array(
			'name' => 'Show Suffix Label',
			'text' => __( 'Show Suffix:', 'rsvp-pro-plugin' ),
		),
		'settings_show_no_response_label'                  => array(
			'name' => 'Show "No Response" for Associated Attendees Label',
			'text' => __( 'Show &quot;No Response&quot; for Associated Attendees:', 'rsvp-pro-plugin' ),
		),
		'settings_hide_note_label'                         => array(
			'name' => 'Hide Note Field Label',
			'text' => __( 'Hide Note Field:', 'rsvp-pro-plugin' ),
		),
		'settings_hide_email_field_label'                  => array(
			'name' => 'Hide Email Field Label',
			'text' => __( 'Hide email field on rsvp form:', 'rsvp-pro-plugin' ),
		),
		'settings_unique_email_validation_label'           => array(
			'name' => 'Unique Email Validation Label',
			'text' => __( 'Unique email validation on rsvp form', 'rsvp-pro-plugin' ),
		),
		'settings_unique_email_validation_description'     => array(
			'name' => 'Unique Email Validation Description',
			'text' => __( 'This requires a unique email addresses when an attendee RSVPs', 'rsvp-pro-plugin' ),
		),
		'settings_require_email_label'                     => array(
			'name' => 'Require Email Label',
			'text' => __( 'Require email question:', 'rsvp-pro-plugin' ),
		),
		'settings_require_rsvp_label'                      => array(
			'name' => 'Require RSVP Question Label',
			'text' => __( 'Require RSVP question:', 'rsvp-pro-plugin' ),
		),
		'settings_hide_rsvp_question_label'                => array(
			'name' => 'Hide RSVP Question Label',
			'text' => __( 'Hide RSVP question', 'rsvp-pro-plugin' ),
		),
		'settings_hide_rsvp_question_description'          => array(
			'name' => 'Hide RSVP Question Description',
			'text' => __( 'Will default to "No Response" if a default is not specified', 'rsvp-pro-plugin' ),
		),
		'settings_default_rsvp_label'                      => array(
			'name' => 'Default RSVP Response Label',
			'text' => __( 'Default RSVP response', 'rsvp-pro-plugin' ),
		),
		'passcode_settings_label'                          => array(
			'name' => 'Passcode Settings Label',
			'text' => __( 'Passcode Settings', 'rsvp-pro-plugin' ),
		),
		'settings_require_passcode_label'                  => array(
			'name' => 'Require a Passcode to RSVP Label',
			'text' => __( 'Require a Passcode to RSVP:', 'rsvp-pro-plugin' ),
		),
		'settings_passcode_length_label'                   => array(
			'name' => 'Passcode Length Label',
			'text' => __( 'Passcode length:', 'rsvp-pro-plugin' ),
		),
		'settings_passcode_length_description'             => array(
			'name' => 'Passcode Length Description',
			'text' => __( 'Valid values 1 to 50', 'rsvp-pro-plugin' ),
		),
		'settings_passcode_modification_label'             => array(
			'name' => 'Allow Passcode Modification Label',
			'text' => __( 'Allow passcodes to be modified by attendees:', 'rsvp-pro-plugin' ),
		),
		'settings_just_passcode_label'                     => array(
			'name' => 'Just a Passcode to RSVP Label',
			'text' => __( 'Just a Passcode to RSVP:', 'rsvp-pro-plugin' ),
		),
		'settings_just_passcode_description'               => array(
			'name' => 'Just a Passcode to RSVP Description',
			'text' => __( 'Requires that passcodes are unique', 'rsvp-pro-plugin' ),
		),
		'settings_no_passcode_open_label'                  => array(
			'name' => 'No Passcode on Open Registration Label',
			'text' => __( 'No passcode required on open registration:', 'rsvp-pro-plugin' ),
		),
		'settings_no_passcode_open_description'            => array(
			'name' => 'No Passcode on Open Registration Description',
			'text' => __( 'This will override the requirement of having a passcode for open registration', 'rsvp-pro-plugin' ),
		),
		'settings_first_name_label'                        => array(
			'name' => 'First Name Label',
			'text' => __( '&quot;First Name&quot; label:', 'rsvp-pro-plugin' ),
		),
		'settings_last_name_label'                         => array(
			'name' => 'Last Name Label',
			'text' => __( '&quot;Last Name&quot; label:', 'rsvp-pro-plugin' ),
		),
		'settings_yes_text_label'                          => array(
			'name' => 'Yes Text Label',
			'text' => __( '&quot;Yes&quot; text:', 'rsvp-pro-plugin' ),
		),
		'settings_no_text_label'                           => array(
			'name' => 'No Text Label',
			'text' => __( '&quot;No&quot; text:', 'rsvp-pro-plugin' ),
		),
		'settings_mabye_text_label'                        => array(
			'name' => 'Maybe Text Label',
			'text' => __( '&quot;Maybe&quot; text:', 'rsvp-pro-plugin' ),
		),
		'settings_waitlist_friendly_text_label'            => array(
			'name' => 'Waitlist Text Label',
			'text' => __( '&quot;Waitlist&quot; text:', 'rsvp-pro-plugin' ),
		),
		'settings_plus_one_generic_text_label'             => array(
			'name' => 'Yes, Plus One Text Label',
			'text' => __( '&quot;Yes, Plus One&quot; text:', 'rsvp-pro-plugin' ),
		),
		'settings_hi_text_label'                           => array(
			'name' => 'Hi Text Label',
			'text' => __( '&quot;Hi&quot; text:', 'rsvp-pro-plugin' ),
		),
		'settings_no_response_text_label'                  => array(
			'name' => 'No Response Text Label',
			'text' => __( '&quot;No Response&quot; text:', 'rsvp-pro-plugin' ),
		),
		'greetings_page_label'                             => array(
			'name' => 'Greetings Page Header',
			'text' => __( 'Greeting Page', 'rsvp-pro-plugin' ),
		),
		'settings_open_message_label'                      => array(
			'name' => 'Before Open Message Label',
			'text' => __( "Message displayed before the event is open for RSVP'ing", 'rsvp-pro-plugin' ),
		),
		'settings_open_message_description'                => array(
			'name' => 'Before Open Message Description',
			'text' => __( "Default is: &quot;I am sorry but the ability to RSVP for our event won't open till &lt;strong&gt;%s&lt;/strong&gt;&quot;", 'rsvp-pro-plugin' ),
		),
		'settings_closed_message_label'                    => array(
			'name' => 'Closed Message Label',
			'text' => __( "Message displayed once the event is closed for RSVP'ing", 'rsvp-pro-plugin' ),
		),
		'settings_closed_message_description'              => array(
			'name' => 'Closed Message Description',
			'text' => __( 'Default is: &quot;The deadline to RSVP for this event has passed.&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_custom_greeting_label'                   => array(
			'name' => 'Custom Greeting Label',
			'text' => __( 'Custom greeting:', 'rsvp-pro-plugin' ),
		),
		'settings_custom_greeting_description'             => array(
			'name' => 'Custom Greeting Description',
			'text' => __( 'Default is: &quot;Please enter your first and last name to RSVP.&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_modify_attendee_label'                   => array(
			'name' => 'Modify Attendee Label',
			'text' => __( '&quot;Modify Attendee&quot; message:', 'rsvp-pro-plugin' ),
		),
		'settings_modify_attendee_description'             => array(
			'name' => 'Modify Attendee Description',
			'text' => __( 'Default text is: &quot;Need to modify your registration? Start with the below form.&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_passcode_label'                          => array(
			'name' => 'Passcode Label',
			'text' => __( '&quot;Passcode&quot; label:', 'rsvp-pro-plugin' ),
		),
		'settings_new_attendee_button_label'               => array(
			'name' => 'New Attendee Button label',
			'text' => __( '&quot;New Attendee&quot; button:', 'rsvp-pro-plugin' ),
		),
		'settings_new_attendee_button_description'         => array(
			'name' => 'New Attendee Button Description',
			'text' => __( 'Default text is: &quot;New Attendee Registration&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_find_me_button_label'                    => array(
			'name' => 'Find Me Button label',
			'text' => __( '&quot;Find me&quot; button:', 'rsvp-pro-plugin' ),
		),
		'settings_find_me_button_description'              => array(
			'name' => 'Find Me Button Description',
			'text' => __( 'Default text is: &quot;Find me!&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_unable_find_label'                       => array(
			'name' => 'Unable to Find Label',
			'text' => __( 'Unable to find:', 'rsvp-pro-plugin' ),
		),
		'settings_unable_find_description'                 => array(
			'name' => 'Unable to Find Description',
			'text' => __( 'Default text is: &quot;We were unable to find anyone with a name of...&quot;', 'rsvp-pro-plugin' ),
		),
		'edit_confirmation_page_label'                     => array(
			'name' => 'Edit Confirmation Label',
			'text' => __( 'Edit Confirmation Page', 'rsvp-pro-plugin' ),
		),
		'settings_edit_prompt_label'                       => array(
			'name' => 'Edit Prompt Label',
			'text' => __( 'Edit prompt:', 'rsvp-pro-plugin' ),
		),
		'settings_edit_prompt_description'                 => array(
			'name' => 'Edit Prompt Description',
			'text' => __( "Default text is: &quot;Hi %1\$s %2\$s it looks like you have already RSVP'd. Would you like to edit your reservation?&quot;", 'rsvp-pro-plugin' ),
		),
		'settings_rsvp_once_message_header'                => array(
			'name' => 'Only RSVP Once Message Header',
			'text' => __( 'Only RSVP Once Message Screen', 'rsvp-pro-plugin' ),
		),
		'settings_user_already_rsvpd_label'                => array(
			'name' => 'Message Displayed When User Has Already RSVP\'d Label',
			'text' => __( 'Message displayed when a user has already RSVP\'d:', 'rsvp-pro-plugin' ),
		),
		'settings_user_already_rsvpd_description'          => array(
			'name' => 'Message Displayed When User Has Already RSVP\'d Description',
			'text' => __( "Default text is: &quot;You have already RSVP'd for this event. Please contact us if you need to modify your registration.&quot;", 'rsvp-pro-plugin' ),
		),
		'settings_not_found_screen_header'                 => array(
			'name' => 'Not Found Screen Header',
			'text' => __( 'Not found screen', 'rsvp-pro-plugin' ),
		),
		'settings_fuzzy_match_text_label'                  => array(
			'name' => 'Fuzzy Match Results Text Label',
			'text' => __( 'Fuzzy match results text:', 'rsvp-pro-plugin' ),
		),
		'settings_fuzzy_match_text_description'            => array(
			'name' => 'Fuzzy Match Results Text Description',
			'text' => __( 'Default text is: &quot;We could not find an exact match but could any of the below entries be you?&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_multiple_match_text_label'               => array(
			'name' => 'Multiple Match Results Text Label',
			'text' => __( 'Multiple match results text:', 'rsvp-pro-plugin' ),
		),
		'settings_multiple_match_text_description'         => array(
			'name' => 'Multiple Match Results Text Description',
			'text' => __( 'Default text is: &quot;we found multiple people with that name, please select your record&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_multiple_attendee_match_text_label'      => array(
			'name' => 'Multiple Attendee Match Text Label',
			'text' => __( 'Multiple match attendee text:', 'rsvp-pro-plugin' ),
		),
		'settings_multiple_attendee_match_text_description' => array(
			'name' => 'Multiple Attendee Match Text Description',
			'text' => __( 'Default text is: &quot;[Salutation] [FirstName] [LastName] [Suffix] - [Email]&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_open_add_user_prompt_label'              => array(
			'name' => 'Open Registration Add User Prompt Label',
			'text' => __( 'Open registration add user prompt:', 'rsvp-pro-plugin' ),
		),
		'settings_open_add_user_prompt_description'        => array(
			'name' => 'Open Registration Add User Prompt Description',
			'text' => __( 'Default text is: &quot;Maybe you aren\'t on the invitee list yet. Add yourself now.&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_main_rsvp_header'                        => array(
			'name' => 'Main RSVP Page Header',
			'text' => __( 'Main RSVP Page', 'rsvp-pro-plugin' ),
		),
		'settings_custom_welcome_text_label'               => array(
			'name' => 'Custom Welcome Label',
			'text' => __( 'Custom welcome:', 'rsvp-pro-plugin' ),
		),
		'settings_custom_welcome_text_description'         => array(
			'name' => 'Custom Welcome Description',
			'text' => __( 'Default is: &quot;There are a few more questions we need to ask you if you could please fill them out below to finish up the RSVP process.&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_welcome_text_label'                      => array(
			'name' => 'Welcome Label',
			'text' => __( 'Welcome:', 'rsvp-pro-plugin' ),
		),
		'settings_welcome_text_description'                => array(
			'name' => 'Welcome Description',
			'text' => __( 'Default is: &quot;Welcome %1$s %2$s!&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_rsvp_question_label'                     => array(
			'name' => 'RSVP Question Verbiage Label',
			'text' => __( 'RSVP question verbiage:', 'rsvp-pro-plugin' ),
		),
		'settings_rsvp_question_description'               => array(
			'name' => 'RSVP Question Verbiage Description',
			'text' => __( 'Default is: &quot;So, how about it?&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_rsvp_yes_text_label'                     => array(
			'name' => 'RSVP Yes Label',
			'text' => __( 'RSVP yes:', 'rsvp-pro-plugin' ),
		),
		'settings_rsvp_yes_text_description'               => array(
			'name' => 'RSVP Yes Description',
			'text' => __( 'Default is: &quot;Yes, I will attend.&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_rsvp_no_text_label'                      => array(
			'name' => 'RSVP No Label',
			'text' => __( 'RSVP no:', 'rsvp-pro-plugin' ),
		),
		'settings_rsvp_no_text_description'                => array(
			'name' => 'RSVP No Description',
			'text' => __( 'Default is: &quot;No, I will not be able to attend.&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_rsvp_waitlist_text_label'                => array(
			'name' => 'RSVP Waitlist Label',
			'text' => __( 'RSVP waitlist:', 'rsvp-pro-plugin' ),
		),
		'settings_rsvp_waitlist_text_description'          => array(
			'name' => 'RSVP Waitlist Description',
			'text' => __( 'Default is: &quot;The event is full but we can add you to the waitlist.&quot;', 'rsvp-pro-plugin' ),
		),
		'settigns_rsvp_maybe_text_label'                   => array(
			'name' => 'RSVP Maybe Label',
			'text' => __( 'RSVP maybe:', 'rsvp-pro-plugin' ),
		),
		'settings_rsvp_maybe_text_description'             => array(
			'name' => 'RSVP Maybe Description',
			'text' => __( 'Default is: &quot;I might attend.&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_salutation_text_label'                   => array(
			'name' => 'Salutation Label',
			'text' => __( '&quot;Salutation&quot; label:', 'rsvp-pro-plugin' ),
		),
		'settings_salutation_text_description'             => array(
			'name' => 'Salutation Description',
			'text' => __( 'Default is: &quot;Salutation&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_suffix_text_label'                       => array(
			'name' => 'Suffix Label',
			'text' => __( '&quot;Suffix&quot; label:', 'rsvp-pro-plugin' ),
		),
		'settings_suffix_text_description'                 => array(
			'name' => 'Suffix Description',
			'text' => __( 'Default is: &quot;Suffix&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_email_text_label'                        => array(
			'name' => 'Email Label',
			'text' => __( '&quot;Email&quot; label:', 'rsvp-pro-plugin' ),
		),
		'settings_email_text_description'                  => array(
			'name' => 'Email Description',
			'text' => __( 'Default is: &quot;Email address&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_passcode_edit_text_label'                => array(
			'name' => 'Passcode Edit Label',
			'text' => __( '&quot;Passcode Edit&quot; label:', 'rsvp-pro-plugin' ),
		),
		'settings_passcode_edit_text_description'          => array(
			'name' => 'Passcode Edit Description',
			'text' => __( 'Default is: &quot;Attendee Passcode&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_text_under_rsvp_label'                   => array(
			'name' => 'Text Under RSVP Label',
			'text' => __( 'Text Under RSVP', 'rsvp-pro-plugin' ),
		),
		'settings_text_under_rsvp_description'             => array(
			'name' => 'Text Under RSVP Description',
			'text' => __( 'Option to show some text right underneath the RSVP main question.', 'rsvp-pro-plugin' ),
		),
		'settings_note_question_text_label'                => array(
			'name' => 'Note Question Label',
			'text' => __( 'Note question:', 'rsvp-pro-plugin' ),
		),
		'settings_note_question_text_description'          => array(
			'name' => 'Note Question Description',
			'text' => __( "Default is: &quot;If you have any <strong style=\"color:red;\">food allergies</strong>, please indicate what they are in the 'notes' section below.  Or, if you just want to send us a note, please feel free. If you have any questions, please send us an email.&quot;", 'rsvp-pro-plugin' ),
		),
		'settings_rsvp_button_label'                       => array(
			'name' => 'RSVP Button Label',
			'text' => __( '&quot;RSVP&quot; button:', 'rsvp-pro-plugin' ),
		),
		'settings_rsvp_button_description'                 => array(
			'name' => 'RSVP Button Description',
			'text' => __( 'Default text is: &quot;RSVP&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_next_button_label'                       => array(
			'name' => 'Next Button Label',
			'text' => __( '&quot;Next&quot; button:', 'rsvp-pro-plugin' ),
		),
		'settings_next_button_description'                 => array(
			'name' => 'Next Button Description',
			'text' => __( 'Default text is: &quot;Next&quot; (this only applies to when the multiple step option is enabled)', 'rsvp-pro-plugin' ),
		),
		'settings_add_additional_label'                    => array(
			'name' => 'Add Additional Label',
			'text' => __( 'Add additional:', 'rsvp-pro-plugin' ),
		),
		'settings_add_additional_description'              => array(
			'name' => 'Add Additional Description',
			'text' => __( 'Default is: &quot;You currently can invite &lt;span id="numAvailableToAdd"&gt;%d&lt;/span&gt; more people.&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_associated_attendee_greeting_label'      => array(
			'name' => 'Associated Attendee Greeting Label',
			'text' => __( 'Associated attendee greeting:', 'rsvp-pro-plugin' ),
		),
		'settings_associated_attendee_greeting_description' => array(
			'name' => 'Associated Attendee Greeting Description',
			'text' => __( 'Default is: &quot;Will %s be attending?&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_new_attendee_button_text_label'          => array(
			'name' => 'New Attendee Button Label',
			'text' => __( 'New attendee button:', 'rsvp-pro-plugin' ),
		),
		'settings_new_attendee_button_text_description'    => array(
			'name' => 'New Attendee Button Description',
			'text' => __( 'Default is: &quot;Add Additional Guests&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_remove_attendee_button_text_label'       => array(
			'name' => 'Remove Attendee Button Label',
			'text' => __( 'Remove attendee button:', 'rsvp-pro-plugin' ),
		),
		'settings_remove_attendee_button_text_description' => array(
			'name' => 'Remove Attendee Button Description',
			'text' => __( 'Default is: &quot;Remove Guest&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_message_event_capacity_text_label'       => array(
			'name' => 'Message Event Capacity is Reached Label',
			'text' => __( 'Message when event capacity is reached:', 'rsvp-pro-plugin' ),
		),
		'settings_message_event_capacity_text_description' => array(
			'name' => 'Message Event Capacity is Reached Description',
			'text' => __( 'Default is: &quot;The maximum limit of %1$d has been reached for this event.&quot; <br />The %2$d is a placeholder that will autofill the capacity number set on the front-end settings tab.', 'rsvp-pro-plugin' ),
		),
		'settings_waitlist_text_label'                     => array(
			'name' => 'Waitlist Text Label',
			'text' => __( 'Waitlist text:', 'rsvp-pro-plugin' ),
		),
		'settings_waitlist_text_description'               => array(
			'name' => 'Waitlist Text Description',
			'text' => __( 'Default is: &quot;This event has a waitlist available.&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_associated_rsvp_text_label'              => array(
			'name' => 'Associated RSVP Message Label',
			'text' => __( 'Associated RSVP message:', 'rsvp-pro-plugin' ),
		),
		'settings_associated_rsvp_text_description'        => array(
			'name' => 'Associated RSVP Message Description',
			'text' => __( 'Default is: &quot;The following people are associated with you.  At this time you can RSVP for them as well.&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_additional_attendee_greeting_text_label' => array(
			'name' => 'Additional Attendee Greeting Label',
			'text' => __( 'Additional attendee greeting:', 'rsvp-pro-plugin' ),
		),
		'settings_additional_attendee_greeting_text_description' => array(
			'name' => 'Additional Attendee Greeting Description',
			'text' => __( 'Default is: &quot;Will this person be attending?&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_javascript_validation_header'            => array(
			'name' => 'JavaScript Validation Messages',
			'text' => __( 'JavaScript Validation Messages', 'rsvp-pro-plugin' ),
		),
		'settings_first_name_required_label'               => array(
			'name' => 'First Name Required Label',
			'text' => __( 'First name required message:', 'rsvp-pro-plugin' ),
		),
		'settings_first_name_required_description'         => array(
			'name' => 'First Name Required Description',
			'text' => __( 'Default is: &quot;Please enter a first name&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_last_name_required_label'                => array(
			'name' => 'Last Name Required Label',
			'text' => __( 'Last name required message:', 'rsvp-pro-plugin' ),
		),
		'settings_last_name_required_description'          => array(
			'name' => 'Last Name Required Description',
			'text' => __( 'Default is: &quot;Please enter a last name&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_custom_note_required_label'              => array(
			'name' => 'Custom Note Required Label',
			'text' => __( 'Custom note required message:', 'rsvp-pro-plugin' ),
		),
		'settings_custom_note_required_description'        => array(
			'name' => 'Custom Note Required Description',
			'text' => __( 'Default is: &quot;If you are adding additional RSVPs please enter your email address in case we have questions&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_email_required_label'                    => array(
			'name' => 'Email Required Label',
			'text' => __( 'Email required message:', 'rsvp-pro-plugin' ),
		),
		'settings_email_required_description'              => array(
			'name' => 'Email Required Description',
			'text' => __( 'Default is: &quot;Please enter an email address&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_gdpr_required_label'                     => array(
			'name' => 'GDPR Required Label',
			'text' => __( 'GDPR required message:', 'rsvp-pro-plugin' ),
		),
		'settings_gdpr_required_description'               => array(
			'name' => 'GDPR Required Description',
			'text' => __( 'Default is: &quot;This field is required&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_one_step_event_header'                   => array(
			'name' => 'One Step Per-Event Messages',
			'text' => __( 'One Step Per Event', 'rsvp-pro-plugin' ),
		),
		'settings_event_title_text_label'                  => array(
			'name' => 'Event Title Text Label',
			'text' => __( 'Event title text:', 'rsvp-pro-plugin' ),
		),
		'settings_event_title_text_description'            => array(
			'name' => 'Event Title Text Description',
			'text' => __( 'Default is: &quot;RSVP for %s&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_option_text_label'                       => array(
			'name' => 'Option Text Label',
			'text' => __( '&quot;Option&quot; text:', 'rsvp-pro-plugin' ),
		),
		'settings_confirmation_page_header'                => array(
			'name' => 'Confirmtion Page Header',
			'text' => __( 'Confirmation Page', 'rsvp-pro-plugin' ),
		),
		'settings_modify_instructions_text_label'          => array(
			'name' => 'Modify Instructions for New Attendees Label',
			'text' => __( 'Modify instructions for new attendees:', 'rsvp-pro-plugin' ),
		),
		'settings_modify_instructions_text_description'    => array(
			'name' => 'Modify Instructions for New Attendees Description',
			'text' => __( 'Default is: &quot;To modify your RSVP just come back to this page and enter in your first and last name.&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_password_new_attendees_text_label'       => array(
			'name' => 'Password for New Attendees Text Label',
			'text' => __( 'Password for new attendees:', 'rsvp-pro-plugin' ),
		),
		'settings_password_new_attendees_text_description' => array(
			'name' => 'Password for New Attendees Text Description',
			'text' => __( 'Default is: &quot;You will also need to know your password which is <strong>%s</strong>&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_associated_text_new_attendees_label'     => array(
			'name' => 'Associated Text for New Attendees Label',
			'text' => __( 'Associated text for new attendees:', 'rsvp-pro-plugin' ),
		),
		'settings_associated_text_new_attendees_description' => array(
			'name' => 'Associated Text for New Attendees Description',
			'text' => __( 'Default is: &quot;You have also RSVPed for - &quot;', 'rsvp-pro-plugin' ),
		),
		'settings_custom_thankyou_text_label'              => array(
			'name' => 'Custom Thank You Label',
			'text' => __( 'Custom thank you:', 'rsvp-pro-plugin' ),
		),
		'settings_custom_thankyou_text_description'        => array(
			'name' => 'Custom Thank You Description',
			'text' => __( 'Default is: &quot;Thank you for RSVPing&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_thank_you_when_no_label'                 => array(
			'name' => 'Thank You When an Attendee Says "No"',
			'text' => __( 'Thank You when an attendee RSVPs with &quot;no&quot;:', 'rsvp-pro-plugin' ),
		),
		'settings_calendar_link_text_label'                => array(
			'name' => 'Calendar Download Link Text Label',
			'text' => __( 'Calendar download link text:', 'rsvp-pro-plugin' ),
		),
		'settings_calendar_link_text_description'          => array(
			'name' => 'Calendar Download Link Text Description',
			'text' => __( 'Default is: &quot;Add to your calendar&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_google_calendar_link_text_label'         => array(
			'name' => 'Add to Google Calendar Link Text Label',
			'text' => __( 'Add to Google Calendar link text:', 'rsvp-pro-plugin' ),
		),
		'settings_google_calendar_link_text_description'   => array(
			'name' => 'Add to Google Calendar Link Text Description',
			'text' => __( 'Default is: &quot;Add to your Google calendar&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_rsvp_open_date_label'                    => array(
			'name' => 'RSVP Open Date Label',
			'text' => __( 'RSVP Open Date', 'rsvp-pro-plugin' ),
		),
		'settings_rsvp_close_date_label'                   => array(
			'name' => 'RSVP Close Date Label',
			'text' => __( 'RSVP Close Date', 'rsvp-pro-plugin' ),
		),
		'settings_parent_event_label'                      => array(
			'name' => 'Parent Event Label',
			'text' => __( 'Parent Event', 'rsvp-pro-plugin' ),
		),
		'settings_parent_event_description'                => array(
			'name' => 'Parent Event Description',
			'text' => __( 'Setting a parent event will allow you to share attendee lists and RSVP for all the events on one page.', 'rsvp-pro-plugin' ),
		),
		'settings_specify_roles_with_access_label'         => array(
			'name' => 'Specify Roles That Can Access Configuration Label',
			'text' => __( 'Specify roles that can access configuration functionality:', 'rsvp-pro-plugin' ),
		),
		'settings_specify_roles_access_description'        => array(
			'name' => 'Specify Roles That Can Access Configuration Description',
			'text' => __( 'If no one is selected then everyone can access the configuration functionality. Administrators can not be locked out of settings.', 'rsvp-pro-plugin' ),
		),
		'settings_roles_have_access_label'                 => array(
			'name' => 'Roles That Have Access Label',
			'text' => __( 'Roles That Have Access', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_access_label'                   => array(
			'name' => 'Attendee Access to Event Label',
			'text' => __( 'Attendee Access to Event:', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_access_list_label'              => array(
			'name' => 'Attendee Access List Label',
			'text' => __( 'Attendee Access List:', 'rsvp-pro-plugin' ),
		),
		'settings_available_attendees_label'               => array(
			'name' => 'Available Attendees Label',
			'text' => __( 'Available Attendees', 'rsvp-pro-plugin' ),
		),
		'settings_attendees_who_have_access_label'         => array(
			'name' => 'Attendees Who Have Access Label',
			'text' => __( 'Attendees Who Have Access', 'rsvp-pro-plugin' ),
		),
		'settings_allow_attendee_checkin_label'            => array(
			'name' => 'Allow Attendee Check-Ins Label',
			'text' => __( 'Allow Attendee Check-ins:', 'rsvp-pro-plugin' ),
		),
		'settings_allow_attendee_checkin_description'      => array(
			'name' => 'Allow Attendee Check-Ins Description',
			'text' => __( 'This surfaces the ability for admins to check attendees into events, confirming attendance, etc.. for this event', 'rsvp-pro-plugin' ),
		),
		'general_event_information_header'                 => array(
			'name' => 'General Event Information Header',
			'text' => __( 'General Event Information', 'rsvp-pro-plugin' ),
		),
		'settings_event_start_date_label'                  => array(
			'name' => 'Event Start Date Label',
			'text' => __( 'Event Start Date', 'rsvp-pro-plugin' ),
		),
		'settings_date_format_example'                     => array(
			'name' => 'Settings Date Format Example',
			'text' => __( 'yyyy-mm-dd h:m:s AM/PM(i.e. 2017-05-31 10:30:00 AM)', 'rsvp-pro-plugin' ),
		),
		'settings_event_end_date_label'                    => array(
			'name' => 'Event End Date Label',
			'text' => __( 'Event End Date', 'rsvp-pro-plugin' ),
		),
		'settings_event_description_label'                 => array(
			'name' => 'Event Description Label',
			'text' => __( 'Event Description', 'rsvp-pro-plugin' ),
		),
		'settings_recurring_event_information_header'      => array(
			'name' => 'Recurring Event Information Header',
			'text' => __( 'Recurring Event Information', 'rsvp-pro-plugin' ),
		),
		'settings_recurring_event_header_description'      => array(
			'name' => 'Recurring Event Header Description',
			'text' => __( 'Information used for making an event repeat', 'rsvp-pro-plugin' ),
		),
		'settings_repeating_start_date_label'              => array(
			'name' => 'Repeating Start Date Label',
			'text' => __( 'Repeating start date:', 'rsvp-pro-plugin' ),
		),
		'settings_repeating_start_date_description'        => array(
			'name' => 'Repeating Start Date Description',
			'text' => __( 'The date to which the recurring event starts', 'rsvp-pro-plugin' ),
		),
		'settings_repeating_end_date_label'                => array(
			'name' => 'Repeating End Date Label',
			'text' => __( 'Repeating end date', 'rsvp-pro-plugin' ),
		),
		'settings_repeating_end_date_description'          => array(
			'name' => 'Repeating End Date Description',
			'text' => __( 'The date to which the recurring event ends', 'rsvp-pro-plugin' ),
		),
		'settings_repeating_frequency_label'               => array(
			'name' => 'Repeating Frequency Label',
			'text' => __( 'Repeating frequency:', 'rsvp-pro-plugin' ),
		),
		'settings_repeating_frequency_description'         => array(
			'name' => 'Repeating Frequency Description',
			'text' => __( 'How often does it repeat (i.e. 1 week, 2 months), any whole number greater than zero is allowed.', 'rsvp-pro-plugin' ),
		),
		'settings_repeating_frequency_type'                => array(
			'name' => 'Repeating Frequency Type Label',
			'text' => __( 'Repeating frequency type:', 'rsvp-pro-plugin' ),
		),
		'settings_day_label'                               => array(
			'name' => 'Day Label',
			'text' => __( 'Day', 'rsvp-pro-plugin' ),
		),
		'settings_week_label'                              => array(
			'name' => 'Week Label',
			'text' => __( 'Week', 'rsvp-pro-plugin' ),
		),
		'settings_month_label'                             => array(
			'name' => 'Month Label',
			'text' => __( 'Month', 'rsvp-pro-plugin' ),
		),
		'settings_year_label'                              => array(
			'name' => 'Year Label',
			'text' => __( 'Year', 'rsvp-pro-plugin' ),
		),
		'settings_repeating_frequency_type_description'    => array(
			'name' => 'Frequency Type Description',
			'text' => __( 'The frequency at which the event repeats (i.e. every week, a month, etc..)', 'rsvp-pro-plugin' ),
		),
		'settings_event_length_label'                      => array(
			'name' => 'Event Length Label',
			'text' => __( 'Length of each event', 'rsvp-pro-plugin' ),
		),
		'settings_event_length_description'                => array(
			'name' => 'Event Length Description',
			'text' => __( 'How long each instance of the event goes for, any whole number greater than zero is allowed.', 'rsvp-pro-plugin' ),
		),
		'settings_length_type_label'                       => array(
			'name' => 'Length Type Label',
			'text' => __( 'Length type of each event', 'rsvp-pro-plugin' ),
		),
		'settings_length_type_description'                 => array(
			'name' => 'Length Type Description',
			'text' => __( 'The length type of each instance (i.e. day, month, etc...).', 'rsvp-pro-plugin' ),
		),
		'settings_dont_keep_recurring_history'             => array(
			'name' => 'Do Not Keep a History of Repeated Events Label',
			'text' => __( 'Do not keep a history of repeated events', 'rsvp-pro-plugin' ),
		),
		'settings_dont_keep_recurring_history_description' => array(
			'name' => 'Do Not Keep a History of Repeated Events Description',
			'text' => __( 'By default whenever an event repeats we will keep a copy of the previous date of event.', 'rsvp-pro-plugin' ),
		),
		'settings_public_attendee_list_only_status_label'  => array(
			'name' => 'Only Show a Specific RSVP Status on Public Attendee List',
			'text' => __( 'Only show a specific rsvp status on public attendee list:', 'rsvp-pro-plugin' ),
		),
		'settings_allow_status_change_on_attendee_list_label' => array(
			'name' => 'Allow Status Change on Public Attendee List Label',
			'text' => __( 'Allow attendees to modify their status via the list:', 'rsvp-pro-plugin' ),
		),
		'settings_show_search_attendee_list_label'         => array(
			'name' => 'Show Search on Public Attendee List Label',
			'text' => __( 'Show attendee search on the attendee list:', 'rsvp-pro-plugin' ),
		),
		'settings_show_export_button_attendee_list_label'  => array(
			'name' => 'Show Export Button on Public Attendee List Label',
			'text' => __( 'Show export attendee button on the attendee list:', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_search_text_label'         => array(
			'name' => 'Public Attendee List Search Text Label',
			'text' => __( 'Specify search text:', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_search_text_description'   => array(
			'name' => 'Public Attendee List Search Text Description',
			'text' => __( 'Default is "Search Attendee List"', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_allow_checkin_label'       => array(
			'name' => 'Public Attendee List Allow Check-In Label',
			'text' => __( 'Allow attendees to check-in:', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_allow_checkin_description' => array(
			'name' => 'Public Attendee List Allow Check-In Description',
			'text' => __( 'Allows attendees to check-in for the event to show they have attended.', 'rsvp-pro-plugin' ),
		),

		'settings_attendee_list_checkin_text_label'        => array(
			'name' => 'Public Attendee List Check-In Button Text Label',
			'text' => __( 'Specify Check-In Button Text:', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_checkin_text_description'  => array(
			'name' => 'Public Attendee List Check-In Button Text Description',
			'text' => __( 'Default is "Check In"', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_checkin_message_label'     => array(
			'name' => 'Public Attendee List Checked-In Message Label',
			'text' => __( 'Message if User is Checked-In:', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_checkin_message_description' => array(
			'name' => 'Public Attendee List Checked-In Message Description',
			'text' => __( 'Default is "Already checked in"', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_sort_order_label'          => array(
			'name' => 'Public Attendee List Sort Order Label',
			'text' => __( 'Attendee list sort order:', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_sort_order_description'    => array(
			'name' => 'Public Attendee List Sort Order Description',
			'text' => __( 'Default sort order is: First Name', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_show_email_label'          => array(
			'name' => 'Public Attendee List Show Email Label',
			'text' => __( 'Show email address on attendee list', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_show_note_label'           => array(
			'name' => 'Public Attendee List Show Note Label',
			'text' => __( 'Show note on attendee list', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_show_associated_label'     => array(
			'name' => 'Public Attendee List Show Associated Attendees Label',
			'text' => __( 'Show associated attendees on attendee list', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_show_rsvp_count_label'     => array(
			'name' => 'Public Attendee List Show RSVP Count Label',
			'text' => __( 'Show total RSVP yes/no count at the top and bottom of the attendee list', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_hide_rsvp_status_label'    => array(
			'name' => 'Public Attendee List Hide RSVP Status Label',
			'text' => __( 'Hide RSVP status from list:', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_show_custom_questions_label' => array(
			'name' => 'Public Attendee List Show Custom Questions Label',
			'text' => __( 'Show custom questions in list:', 'rsvp-pro-plugin' ),
		),
		'settings_available_custom_questions_label'        => array(
			'name' => 'Available Custom Questions Label',
			'text' => __( 'Available custom questions', 'rsvp-pro-plugin' ),
		),
		'settings_custom_questions_displayed_label'        => array(
			'name' => 'Custom Questions Displayed Label',
			'text' => __( 'Custom questions displayed', 'rsvp-pro-plugin' ),
		),
		'add_rsvp_pro_form_label'                          => array(
			'name' => 'Add RSVP Pro Form Label',
			'text' => __( 'Add RSVP Pro Form', 'rsvp-pro-plugin' ),
		),
		'insert_rsvp_pro_form_label'                       => array(
			'name' => 'Insert RSVP Pro Form Label',
			'text' => __( 'Insert A RSVP Pro Form', 'rsvp-pro-plugin' ),
		),
		'select_information_to_display_label'              => array(
			'name' => 'Select Informtion to Display Label',
			'text' => __( 'Select information you want to display', 'rsvp-pro-plugin' ),
		),
		'rsvp_form_label'                                  => array(
			'name' => 'RSVP Form Label',
			'text' => __( 'RSVP Form', 'rsvp-pro-plugin' ),
		),
		'attendee_list_label'                              => array(
			'name' => 'Attendee List Label',
			'text' => __( 'Attendee List', 'rsvp-pro-plugin' ),
		),
		'event_list_label'                                 => array(
			'name' => 'Event List Label',
			'text' => __( 'Event List', 'rsvp-pro-plugin' ),
		),
		'select_event_label'                               => array(
			'name' => 'Select Event Label',
			'text' => __( 'Select event', 'rsvp-pro-plugin' ),
		),
		'insert_event_label'                               => array(
			'name' => 'Inert Event Label',
			'text' => __( 'Insert Event', 'rsvp-pro-plugin' ),
		),
		'cancel_label'                                     => array(
			'name' => 'Cancel Label',
			'text' => __( 'Cancel', 'rsvp-pro-plugin' ),
		),
		'reminders_for_label'                              => array(
			'name' => 'Reminders For Label',
			'text' => __( 'Reminders for', 'rsvp-pro-plugin' ),
		),
		'add_new_label'                                    => array(
			'name' => 'Add New Label',
			'text' => __( 'Add New', 'rsvp-pro-plugin' ),
		),
		'the_date_label'                                   => array(
			'name' => 'The Date Label',
			'text' => __( 'The date', 'rsvp-pro-plugin' ),
		),
		'used_for_reminder_calculation_label'              => array(
			'name' => 'Will Be Used For Reminders Calculation Label',
			'text' => __( 'will be used to calculate when the reminders are sent out.', 'rsvp-pro-plugin' ),
		),
		'date_retrieved_from_label'                        => array(
			'name' => 'Date Retrieved From Label',
			'text' => __( 'This date was retrieved from the ', 'rsvp-pro-plugin' ),
		),
		'field_label'                                      => array(
			'name' => 'Field Label',
			'text' => __( 'field.', 'rsvp-pro-plugin' ),
		),
		'add_reminder_label'                               => array(
			'name' => 'Add Reminder Label',
			'text' => __( 'Add Reminder', 'rsvp-pro-plugin' ),
		),
		'edit_reminder_label'                              => array(
			'name' => 'Edit Reminder Label',
			'text' => __( 'Edit Reminder', 'rsvp-pro-plugin' ),
		),
		'go_back_label'                                    => array(
			'name' => 'Go Back Label',
			'text' => __( 'Go Back', 'rsvp-pro-plugin' ),
		),
		'reminder_name_label'                              => array(
			'name' => 'Reminder Name Label',
			'text' => __( 'Reminder Name', 'rsvp-pro-plugin' ),
		),
		'reminder_name_description'                        => array(
			'name' => 'Reminder Name Description',
			'text' => __( 'A friendly name for the reminder that is only viewable from the admin area', 'rsvp-pro-plugin' ),
		),
		'reminder_time_label'                              => array(
			'name' => 'Reminder Time Label',
			'text' => __( 'Reminder Time', 'rsvp-pro-plugin' ),
		),
		'send_reminder_label'                              => array(
			'name' => 'Send Reminder Label',
			'text' => __( 'Send reminder', 'rsvp-pro-plugin' ),
		),
		'before_label'                                     => array(
			'name' => 'Before Label',
			'text' => __( 'before', 'rsvp-pro-plugin' ),
		),
		'send_reminder_on_label'                           => array(
			'name' => 'Send Reminder On Label',
			'text' => __( 'Send Reminder On', 'rsvp-pro-plugin' ),
		),
		'reminders_only_rsvp_status_label'                 => array(
			'name' => 'Only Send Reminders to Selected Statuses Label',
			'text' => __( 'Only Send Reminders to Selected Statuses', 'rsvp-pro-plugin' ),
		),
		'possible_statuses_to_send_label'                  => array(
			'name' => 'Possible Statuses to Send Label',
			'text' => __( 'Possible Statuses To Send', 'rsvp-pro-plugin' ),
		),
		'reminders_sent_to_statuses_label'                 => array(
			'name' => 'Reminders Sent to Statuses Label',
			'text' => __( 'Statuses Reminders Will Be Sent To', 'rsvp-pro-plugin' ),
		),
		'reminder_subject_label'                           => array(
			'name' => 'Reminder Subject Label',
			'text' => __( 'Reminder Subject', 'rsvp-pro-plugin' ),
		),
		'reminder_message_label'                           => array(
			'name' => 'Reminder Message Label',
			'text' => __( 'Reminder Message', 'rsvp-pro-plugin' ),
		),
		'save_reminder_label'                              => array(
			'name' => 'Save Reminder Label',
			'text' => __( 'Save Reminder', 'rsvp-pro-plugin' ),
		),
		'reminder_label'                                   => array(
			'name' => 'Reminder Label',
			'text' => __( 'Reminder', 'rsvp-pro-plugin' ),
		),
		'time_qualifier_label'                             => array(
			'name' => 'Time Qualifier Label',
			'text' => __( 'Time Qualifier', 'rsvp-pro-plugin' ),
		),
		'time_period_label'                                => array(
			'name' => 'Time Period Label',
			'text' => __( 'Time Period', 'rsvp-pro-plugin' ),
		),
		'send_reminder_specific_date_label'                => array(
			'name' => 'Send Reminder On Specific Date Label',
			'text' => __( 'Send On Specific Date', 'rsvp-pro-plugin' ),
		),
		'relevant_rsvp_label'                              => array(
			'name' => 'Relevant RSVP Label',
			'text' => __( 'Relevant RSVP', 'rsvp-pro-plugin' ),
		),
		'rsvp_pro_event_responses_label'                   => array(
			'name' => 'RSVP Pro Event Responses Label',
			'text' => __( 'RSVP Pro Event Responses', 'rsvp-pro-plugin' ),
		),
		'settings_hide_search_form_label'                  => array(
			'name' => 'Use A Button to Display Search Form Label',
			'text' => __( 'Use A Button to Display Attendee Search Form', 'rsvp-pro-plugin' ),
		),
		'settings_hide_search_form_description'            => array(
			'name' => 'Use A Button to Display Search Form Description',
			'text' => __( 'This will surface a button for a user to click on before the attendee search form is displayed.', 'rsvp-pro-plugin' ),
		),
		'settings_find_attendees_label'                    => array(
			'name' => '"Find Attendees" Button Label',
			'text' => __( '"Find Attendees" Button', 'rsvp-pro-plugin' ),
		),
		'settings_find_attendees_description'              => array(
			'name' => '"Find Attendees" Button Description',
			'text' => __( 'Default text is: "Find Attendees"', 'rsvp-pro-plugin' ),
		),
		'auto_create_attendee_list_label'                  => array(
			'name' => 'Automatically Create Attendee List Label',
			'text' => __( 'Automatically create post_type entry for main event attendee list', 'rsvp-pro-plugin' ),
		),
		'auto_create_attendee_list_description'            => array(
			'name' => 'Automatically Create Attendee List Description',
			'text' => __( 'If a "page" is found with the attendee list short code than a "page" will not be created.', 'rsvp-pro-plugin' ),
		),
		'attendee_list_text'                               => array(
			'name' => 'Attendee List Text',
			'text' => __( 'Attendee List', 'rsvp-pro-plugin' ),
		),
		'disable_comments_label'                           => array(
			'name' => 'Disable Comments Label',
			'text' => __( 'Disable Comments on Automatically Created Items', 'rsvp-pro-plugin' ),
		),
		'disable_comments_description'                     => array(
			'name' => 'Disable Comments Description',
			'text' => __( 'This will turn off commenting on items automatically created for events', 'rsvp-pro-plugin' ),
		),
		'global_attendee_list'                             => array(
			'name' => 'Global Attendee List Label',
			'text' => __( 'Global Attendee List', 'rsvp-pro-plugin' ),
		),
		'enable_global_attendee_list_label'                => array(
			'name' => 'Enable Global Attendee List Label',
			'text' => __( 'Enable Global Attendee List', 'rsvp-pro-plugin' ),
		),
		'enable_global_attendee_list_description'          => array(
			'name' => 'Global Attendee List Setting Description',
			'text' => __( 'This enables a global attendee list that will be shared with ALL events.', 'rsvp-pro-plugin' ),
		),
		'enable_global_attendee_changelog_label'           => array(
			'name' => 'Enable Attendee Changelog Label',
			'text' => __( 'Enable Attendee Changelogs', 'rsvp-pro-plugin' ),
		),
		'enable_global_attendee_changelog_description'     => array(
			'name' => 'Attendee Changelog Setting Description',
			'text' => __( 'This enables a feature which saves any changes an  attendee makes from the front-end.', 'rsvp-pro-plugin' ),
		),
		'change_heading'                                   => array(
			'name' => 'Changes Table Header Label',
			'text' => __( 'Changes', 'rsvp-pro-plugin' ),
		),
		'change_heading_date'                              => array(
			'name' => 'Changes Date Table Header Label',
			'text' => __( 'Change Date', 'rsvp-pro-plugin' ),
		),
		'changed_to_label'                                 => array(
			'name' => 'Changed To Label',
			'text' => __( 'changed to', 'rsvp-pro-plugin' ),
		),
		'export_select_columns_text'                       => array(
			'name' => 'Select columns text',
			'text' => __( 'Check the below columns that you want in the exported file.', 'rsvp-pro-plugin' ),
		),
		'prefill_url_label'                                => array(
			'name' => 'Pre-fill URL label',
			'text' => __( 'Pre-fill URL', 'rsvp-pro-plugin' ),
		),
		'settings_enable_plus_one_label'                   => array(
			'name' => 'Allow Yes, Plus One Settings Label',
			'text' => __( 'Allow for a &quot;Yes, plus one&quot; response', 'rsvp-pro-plugin' ),
		),
		'settings_enable_plus_one_description'             => array(
			'name' => 'Enable +1 Settings Description',
			'text' => __( 'This surfaces an additional RSVP response for attendees to add a +1 for an additional attendee without any information.', 'rsvp-pro-plugin' ),
		),
		'settings_plus_one_text_label'                     => array(
			'name' => 'Yes, Plus One Settings Label',
			'text' => __( 'RSVP yes, plus one', 'rsvp-pro-plugin' ),
		),
		'settings_plus_one_text_description'               => array(
			'name' => '+1 Text Settings Description',
			'text' => __( 'Default is: &quot;Yes, +1 additional attendee&quot;', 'rsvp-pro-plugin' ),
		),
		'save_message_label'                               => array(
			'name' => 'Save Message Label',
			'text' => __( 'Save Message to Log', 'rsvp-pro-plugin' ),
		),
		'message_log_table_label'                          => array(
			'name' => 'Message Log Table Label',
			'text' => __( 'Message Log', 'rsvp-pro-plugin' ),
		),
		'message_logs_table_label'                         => array(
			'name' => 'Message Logs Table Label',
			'text' => __( 'Message Logs', 'rsvp-pro-plugin' ),
		),
		'message_log_sent_on_label'                        => array(
			'name' => 'Message Log Sent On Label',
			'text' => __( 'Sent On', 'rsvp-pro-plugin' ),
		),
		'message_log_copy_table_label'                     => array(
			'name' => 'Message Log Table Copy Header Label',
			'text' => __( 'Copy Message', 'rsvp-pro-plugin' ),
		),
		'message_log_resend_label'                         => array(
			'name' => 'Resend Message Label',
			'text' => __( 'Resend Message', 'rsvp-pro-plugin' ),
		),
		'message_attendees_emailed_label'                  => array(
			'name' => 'Attendees Emailed in this Message Label',
			'text' => __( 'Attendees Emailed in this Message', 'rsvp-pro-plugin' ),
		),
		'select_all_label'                                 => array(
			'name' => 'Select All Label',
			'text' => __( 'Select All', 'rsvp-pro-plugin' ),
		),
		'deselect_all_label'                               => array(
			'name' => 'Deselect All Label',
			'text' => __( 'Deselect All', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_columns_label'             => array(
			'name' => 'Attendee List Columns Label',
			'text' => __( 'Attendee List Columns', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_columns_description'       => array(
			'name' => 'Attendee List Columns Description',
			'text' => __( 'This allows you to select which columns are displayed for this event\'s attendee list in the admin area.', 'rsvp-pro-plugin' ),
		),
		'attendee_name_column_option'                      => array(
			'name' => 'Attendee Name Column Option Label',
			'text' => __( 'Attendee Name', 'rsvp-pro-plugin' ),
		),
		'rsvp_status_column_option'                        => array(
			'name' => 'RSVP Status Column Option Label',
			'text' => __( 'RSVP Status', 'rsvp-pro-plugin' ),
		),
		'rsvp_date_column_option'                          => array(
			'name' => 'RSVP Date Column Option Label',
			'text' => __( 'RSVP Date', 'rsvp-pro-plugin' ),
		),
		'additional_attendee_column_option'                => array(
			'name' => 'Additional Attendee Column Option Label',
			'text' => __( 'Additional Attendee', 'rsvp-pro-plugin' ),
		),
		'note_column_option'                               => array(
			'name' => 'Note Column Option Label',
			'text' => __( 'Note', 'rsvp-pro-plugin' ),
		),
		'associated_attendees_column_option'               => array(
			'name' => 'Associated Attendees Column Option Label',
			'text' => __( 'Associated Attendees', 'rsvp-pro-plugin' ),
		),
		'email_column_option'                              => array(
			'name' => 'Email Column Option Label',
			'text' => __( 'Email', 'rsvp-pro-plugin' ),
		),
		'checked_in_column_option'                         => array(
			'name' => 'Checked In Column Option Label',
			'text' => __( 'Checked In', 'rsvp-pro-plugin' ),
		),
		'passcode_column_option'                           => array(
			'name' => 'Passcode Column Option Label',
			'text' => __( 'Passcode', 'rsvp-pro-plugin' ),
		),
		'data_eraser_successful'                           => array(
			'name' => 'Data Eraser Success Message',
			'text' => __( 'All RSVP Pro data erased for email submitted', 'rsvp-pro-plugin' ),
		),
		'rsvp_pro_friendly_name'                           => array(
			'name' => 'RSVP Pro Friendly Label',
			'text' => __( 'RSVP Pro Plugin', 'rsvp-pro-plugin' ),
		),
		'settings_thankyou_redirect_label'                 => array(
			'name' => 'Thank You Redirect Label',
			'text' => __( 'Thank you redirect', 'rsvp-pro-plugin' ),
		),
		'settings_thankyou_redirect_description'           => array(
			'name' => 'Thank You Redirect Description',
			'text' => __( 'Specifies a URL to redirect to for the thank you instead of showing the thank you text', 'rsvp-pro-plugin' ),
		),
		'settings_notcoming_redirect_label'                => array(
			'name' => 'Thank You Attendee Says &quot;No&quot; Redirect Label',
			'text' => __( 'No thank you redirect', 'rsvp-pro-plugin' ),
		),
		'settings_notcoming_redirect_description'          => array(
			'name' => 'No Thank You Redirect Description',
			'text' => __( 'Specifies a URL to redirect to for the thank you when an attendee says &quot;No&quot; instead of showing the thank you text', 'rsvp-pro-plugin' ),
		),
		'settings_show_gpdr_label'                         => array(
			'name' => 'Show GDPR Question Label',
			'text' => __( 'Show GDPR Agreement Question', 'rsvp-pro-plugin' ),
		),
		'settings_show_gdpr_description'                   => array(
			'name' => 'Show GDPR Question Description',
			'text' => __( 'Displays a required GDPR agreement question when people RSVP', 'rsvp-pro-plugin' ),
		),
		'settings_gdpr_question_text_label'                => array(
			'name' => 'Custom GDPR Question Label',
			'text' => __( 'Custom GDPR Question', 'rsvp-pro-plugin' ),
		),
		'settings_gdpr_question_text_description'          => array(
			'name' => 'Custom GDPR Question Description',
			'text' => __( 'Default is: &quot;I agree to having this website store my submitted event related information.&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_hide_main_rsvp_question_label'           => array(
			'name' => 'Hide Main RSVP Question Label',
			'text' => __( 'Hide the main RSVP question prompt', 'rsvp-pro-plugin' ),
		),
		'settings_hide_main_rsvp_question_description'     => array(
			'name' => 'Hide Main RSVP Question Description',
			'text' => __( 'Hides the main RSVP question prompt, the default question is &quot;So, how about it?&quot;.', 'rsvp-pro-plugin' ),
		),
		'settings_hide_welcome_text_label'                 => array(
			'name' => 'Hide Welcome Text Label',
			'text' => __( 'Hide welcome text', 'rsvp-pro-plugin' ),
		),
		'settings_hide_welcome_text_description'           => array(
			'name' => 'Hide Welcome Text Description',
			'text' => __( 'Hides the custom welcome text the defaults start with &quot;There are a few more questions...&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_unique_passcode_label'                   => array(
			'name' => 'Require Unique Passcodes Label',
			'text' => __( 'Require Unique Passcodes', 'rsvp-pro-plugin' ),
		),
		'settings_unique_passcode_description'             => array(
			'name' => 'Requie Unique Passcodes Description',
			'text' => __( 'This will require a unique passcode per-attendee when adding or editing an attendee from the admin-side and front-end. This will not enforce unique passcodes during import.', 'rsvp-pro-plugin' ),
		),
		'settings_unique_passcode_js_label'                => array(
			'name' => 'Unique Passcode Javascript Message Label',
			'text' => __( 'Unique passcode validation message', 'rsvp-pro-plugin' ),
		),
		'settings_unique_passcode_js_description'          => array(
			'name' => 'Unique Passcode JavaScript Message Description',
			'text' => __( 'Default is: &quot;Passcode is already in use&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_unique_email_js_label'                   => array(
			'name' => 'Unique Email Javascript Message Label',
			'text' => __( 'Unique email validation message', 'rsvp-pro-plugin' ),
		),
		'settings_unique_email_js_description'             => array(
			'name' => 'Unique Email JavaScript Message Description',
			'text' => __( 'Default is: &quot;Email is already in use&quot;', 'rsvp-pro-plugin' ),
		),
		'captcha_settings_label'                           => array(
			'name' => 'Captcha Settings Header',
			'text' => __( 'CAPTCHA Settings', 'rsvp-pro-plugin' ),
		),
		'settings_enable_recaptcha_label'                  => array(
			'name' => 'Enable ReCAPTCHA Settings Label',
			'text' => __( 'Enable ReCAPTCHA', 'rsvp-pro-plugin' ),
		),
		'settings_enable_recaptcha_description'            => array(
			'name' => 'Enable ReCAPTCHA Settings Description',
			'text' => __( 'This will enable ReCAPTCHA on the RSVP form for both new and existing attendees', 'rsvp-pro-plugin' ),
		),
		'settings_recaptcha_site_key_label'                => array(
			'name' => 'ReCAPTCHA Site Key Settings Label',
			'text' => __( 'ReCAPTCHA Site Key', 'rsvp-pro-plugin' ),
		),
		'settings_recaptcha_site_key_description'          => array(
			'name' => 'ReCAPTCHA Site Key Settings Description',
			'text' => __( 'Enter in the ReCAPTCHA Site Key Here', 'rsvp-pro-plugin' ),
		),
		'settings_recaptcha_secret_key_label'              => array(
			'name' => 'ReCAPTCHA Secret Key Settings Label',
			'text' => __( 'ReCAPTCHA Secret Key', 'rsvp-pro-plugin' ),
		),
		'settings_recaptcha_secret_key_description'        => array(
			'name' => 'ReCAPTCHA Secret Key Settings Description',
			'text' => __( 'Enter in the ReCAPTCHA Secret Key Here', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_page_size_label'           => array(
			'name' => 'Attendee List Page Size Settings Label',
			'text' => __( 'Number of Attendees Per-Page', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_page_size_description'     => array(
			'name' => 'Attendee List Page Size Settings Description',
			'text' => __( 'The default is &quot;100&quot; attendees per-page', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_page_size_50'              => array(
			'name' => 'Attendee List Page Size 50 Per-Page',
			'text' => __( '50', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_page_size_100'             => array(
			'name' => 'Attendee List Page Size 100 Per-Page',
			'text' => __( '100', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_page_size_250'             => array(
			'name' => 'Attendee List Page Size 250 Per-Page',
			'text' => __( '250', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_page_size_500'             => array(
			'name' => 'Attendee List Page Size 500 Per-Page',
			'text' => __( '500', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_page_size_1000'            => array(
			'name' => 'Attendee List Page Size 1000 Per-Page',
			'text' => __( '1000', 'rsvp-pro-plugin' ),
		),
		'qr_code_label'                                    => array(
			'name' => 'QR Code Message Generation Placeholder',
			'text' => __( 'This places a QR code for the current event attendee combination to allow for them to be checked in via a QR scanner.', 'rsvp-pro-plugin' ),
		),
		'attendee_field_label'                             => array(
			'name' => 'Attendee Field Import Label',
			'text' => __( 'Attendee Field', 'rsvp-pro-plugin' ),
		),
		'excel_column_label'                               => array(
			'name' => 'Excel Column Import Label',
			'text' => __( 'Excel Column', 'rsvp-pro-plugin' ),
		),
		'custom_questions_answer_import_label'             => array(
			'name' => 'Import Custom Question Answers Label',
			'text' => __( 'If you have a lot of answers to add, put them below. One answer per-line.', 'rsvp-pro-plugin' ),
		),
		'settings_display_new_attendee_form_label'         => array(
			'name' => 'Display New Attendee Form First Label',
			'text' => __( 'Show New Attendee Form First', 'rsvp-pro-plugin' ),
		),
		'settings_display_new_attendee_form_description'   => array(
			'name' => 'Display New Attendee Form First Description',
			'text' => __( 'When this is enabled the new attendee form will be displayed first and a link at the bottom will be displayed for returning attendees to edit their registration.', 'rsvp-pro-plugin' ),
		),
		'settings_find_attendee_link_text_label'           => array(
			'name' => 'Find Attendee Link Text Settings Label',
			'text' => __( 'Find Attendees Link Text', 'rsvp-pro-plugin' ),
		),
		'settings_find_attendee_link_text_description'     => array(
			'name' => 'Find Attendee Link Text Settings Description',
			'text' => __( 'The text shown for the find attendee link when the new attendee form is shown first, default is &quot;Modify Your Registration Here&quot;.', 'rsvp-pro-plugin' ),
		),
		'settings_admin_email_body_label'                  => array(
			'name' => 'Admin Email Notification Body Label',
			'text' => __( 'Email body for the admin notification email', 'rsvp-pro-plugin' ),
		),
		'settings_admin_email_body_description'            => array(
			'name' => 'Admin Email Notification Body Description',
			'text' => __( 'Replaces the message that gets sent to &quot;admins&quot; when someone RSVPs', 'rsvp-pro-plugin' ),
		),
		'settings_rsvp_form_label'                         => array(
			'name' => 'Custom RSVP Form URL Label',
			'text' => __( 'Custom RSVP Form URL', 'rsvp-pro-plugin' ),
		),
		'settings_rsvp_form_description'                   => array(
			'name' => 'Custom RSVP Form URL Description',
			'text' => __( 'When specifying a custom RSVP form URL it is assumed that the corresponding page has the correct RSVP Pro shortcode in place to handle the form submission.', 'rsvp-pro-plugin' ),
		),
		'admin_attendee_view_file'                         => array(
			'name' => 'Text for viewing a custom question file upload',
			'text' => __( 'View File', 'rsvp-pro-plugin' ),
		),
		'admin_attendee_delete_file'                       => array(
			'name' => 'Text for deleting a file related to a custom question file upload',
			'text' => __( 'Delete File', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_show_profile_pic_label'    => array(
			'name' => 'Show profile picture on attendee list setting label',
			'text' => __( 'Show Profile Picture on Attendee List', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_show_profile_pic_description' => array(
			'name' => 'Show profile picture on attendee list setting description',
			'text' => __( 'This will try to retrieve the WordPress profile picture for the attendee using the attendee\'s email address.', 'rsvp-pro-plugin' ),
		),
		'settings_form_show_profile_pic_label'             => array(
			'name' => 'Show profile picture on RSVP form setting label',
			'text' => __( 'Show Profile Picture on RSVP form', 'rsvp-pro-plugin' ),
		),
		'settings_form_show_profile_pic_description'       => array(
			'name' => 'Show profile picture on RVSP form setting description',
			'text' => __( 'Displays the attendee\'s WordPress profile picture next to the &quot;welcome&quot; message of the RSVP form. This is based off the attendee\'s email address.', 'rsvp-pro-plugin' ),
		),
		'admin_attendees_per_page_setting_label'           => array(
			'name' => 'Number of attendees per-page on admin attendee list label',
			'text' => __( 'Number of attendees per-page on attendee list', 'rsvp-pro-plugin' ),
		),
		'settings_available_people_to_send_label'          => array(
			'name' => 'Settings label for people to send to',
			'text' => __( 'Available Attendees', 'rsvp-pro-plugin' ),
		),
		'settings_people_being_sent_to_label'              => array(
			'name' => 'Settings label for attendees being sent messages',
			'text' => __( 'Attendees Receiving Message', 'rsvp-pro-plugin' ),
		),
		'settings_always_show_additional_label'            => array(
			'name' => 'Settings label for always show add additional attendees ',
			'text' => __( 'Always Show Add Additional Attendees', 'rsvp-pro-plugin' ),
		),
		'settings_always_show_additional_description'      => array(
			'name' => 'Settings description for always show add additional attendees',
			'text' => __( 'This will always show the add additional button no matter what RSVP response the main attendee has.', 'rsvp-pro-plugin' ),
		),
		'settings_enable_payments_label'                   => array(
			'name' => 'Enable Payments Label',
			'text' => __( 'Enable Payments', 'rsvp-pro-plugin' ),
		),
		'settings_enable_payments_description'             => array(
			'name' => 'Enable Payments Description',
			'text' => __( 'Allows an event and sub-events to receive payments.', 'rsvp-pro-plugin' ),
		),
		'settings_ticket_price_label'                      => array(
			'name' => 'Ticket Price Label',
			'text' => __( 'Ticket Price', 'rsvp-pro-plugin' ),
		),
		'settings_ticket_price_description'                => array(
			'name' => 'Ticket Price Description',
			'text' => __( 'Ticket price for the event', 'rsvp-pro-plugin' ),
		),
		'stripe_form_settings_label'                       => array(
			'name' => 'Stripe Settings Title',
			'text' => __( 'Stripe Settings', 'rsvp-pro-plugin' ),
		),
		'paypal_form_settings_label'                       => array(
			'name' => 'PayPal Settings Title',
			'text' => __( 'PayPal Settings', 'rsvp-pro-plugin' ),
		),
		'paypal_email_settings_label'                      => array(
			'name' => 'PayPal Email Settings Label',
			'text' => __( 'PayPal Email' , 'rsvp-pro-plugin' ),
		),
		'paypal_email_settings_description'                => array(
			'name' => 'PayPal Email Settings Description',
			'text' => __( 'Enter in Your PayPal Account\'s Email Address', 'rsvp-pro-plugin' ),
		),
		'paypal_api_credentials_header'                    => array(
			'name' => 'PayPal API Credentials Header',
			'text' => __( 'PayPal API Credentials', 'rsvp-pro-plugin' ),
		),
		'paypal_identity_token_settings_label'             => array(
			'name' => 'PayPal Identity Token Settings Label',
			'text' => __( 'Identity Token', 'rsvp-pro-plugin' ),
		),
		'paypal_identity_token_settings_description'       => array(
			'name' => 'PayPal Identity Token Settings Description',
			'text' => __( 'The PayPal Identity Token enables Payment Data Transfer. This allows payments to be verified. For more information see our documentation.', 'rsvp-pro-plugin' ),
		),
		'paypal_live_api_username_settings_label'          => array(
			'name' => 'Live API Username Label',
			'text' => __( 'Live API Username', 'rsvp-pro-plugin' ),
		),
		'paypal_live_api_username_settings_description'    => array(
			'name' => 'Live API Username Description',
			'text' => __( 'The live API username.', 'rsvp-pro-plugin' ),
		),
		'paypal_live_api_password_settings_label'          => array(
			'name' => 'Live API Password Label',
			'text' => __( 'Live API Password', 'rsvp-pro-plugin' ),
		),
		'paypal_live_api_password_settings_description'    => array(
			'name' => 'Live API Password Description',
			'text' => __( 'The live API password.', 'rsvp-pro-plugin' ),
		),
		'paypal_live_api_signature_settinngs_label'        => array(
			'name' => 'Live API Signature Label',
			'text' => __( 'Live API Signature', 'rsvp-pro-plugin' ),
		),
		'paypal_live_api_signature_settinngs_description'  => array(
			'name' => 'Live API Signature Description',
			'text' => __( 'The live API signature.', 'rsvp-pro-plugin' ),
		),
		'paypal_test_api_username_settings_label'          => array(
			'name' => 'Test API Username Label',
			'text' => __( 'Test API Username', 'rsvp-pro-plugin' ),
		),
		'paypal_test_api_username_settings_description'    => array(
			'name' => 'Test API Username Description',
			'text' => __( 'The test API username.', 'rsvp-pro-plugin' ),
		),
		'paypal_test_api_password_settings_label'          => array(
			'name' => 'Test API Password Label',
			'text' => __( 'Test API Password', 'rsvp-pro-plugin' ),
		),
		'paypal_test_api_password_settings_description'    => array(
			'name' => 'Test API Password Description',
			'text' => __( 'The test API password.', 'rsvp-pro-plugin' ),
		),
		'paypal_test_api_signature_settings_label'         => array(
			'name' => 'Test API Signature Label',
			'text' => __( 'Test API Signature', 'rsvp-pro-plugin' ),
		),
		'paypal_test_api_signature_settings_description'   => array(
			'name' => 'Test API Signature Description',
			'text' => __( 'The test API signature.', 'rsvp-pro-plugin' ),
		),
		'settings_payments_testing_label'                  => array(
			'name' => 'Test Mode Label',
			'text' => __( 'Test Mode', 'rsvp-pro-plugin' ),
		),
		'settings_payments_testing_description'            => array(
			'name' => 'Test Mode Description',
			'text' => __( 'While in test mode no live transactions are processed. Test accounts needs to be specified for your payment gateway', 'rsvp-pro-plugin' ),
		),
		'attendee_event_list_settings_title'               => array(
			'name' => 'Attendee Event List Settings Title',
			'text' => __( 'Attendee Event List Settings', 'rsvp-pro-plugin' ),
		),
		'attendee_list_greeting_label'                     => array(
			'name' => 'Attendee Event List Greeting Label',
			'text' => __( 'Attendee Event List Greeting', 'rsvp-pro-plugin' ),
		),
		'attendee_list_greeting_description'               => array(
			'name' => 'Attendee Event List Greeting Description',
			'text' => __( 'Defaults to &quot;Enter in your email address to see all events you can RSVP for.&quot;.', 'rsvp-pro-plugin' ),
		),
		'attendee_list_rsvp_for_label'                     => array(
			'name' => 'Attendee Event List Link Text Label',
			'text' => __( 'Link Text', 'rsvp-pro-plugin' ),
		),
		'attendee_list_rsvp_for_description'               => array(
			'name' => 'Attendee Event List Link Text Description',
			'text' => __( 'Defaults to &quot;RSVP for - %s&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_currency_label'                          => array(
			'name' => 'Currency Settings Label',
			'text' => __( 'Currency', 'rsvp-pro-plugin' ),
		),
		'settings_currency_description'                    => array(
			'name' => 'Currency Settings Description',
			'text' => __( 'The currency for the tickets', 'rsvp-pro-plugin' ),
		),
		'settings_currency_position_label'                 => array(
			'name' => 'Currency position settings label',
			'text' => __( 'Currency Position', 'rsvp-pro-plugin' ),
		),
		'settings_currency_position_description'           => array(
			'name' => 'Currency position settings description',
			'text' => __( 'The location of the currency sign', 'rsvp-pro-plugin' ),
		),
		'settings_thousands_separator_label'               => array(
			'name' => 'Thousands separator settings label',
			'text' => __( 'Thousands Separator', 'rsvp-pro-plugin' ),
		),
		'settings_thousands_separator_description'         => array(
			'name' => 'Thousands separator settings description',
			'text' => __( 'The character used for the thousands separator, default is &quot;,&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_decimal_separator_label'                 => array(
			'name' => 'Decimal separator settings label',
			'text' => __( 'Decimal Separator', 'rsvp-pro-plugin' ),
		),
		'settings_decimal_separator_description'           => array(
			'name' => 'Decimal separator settings description',
			'text' => __( 'The character used for the decimal separator, default is &quot;.&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_currency_position_after'                 => array(
			'name' => 'Currency position after label',
			'text' => __( 'After - 1$', 'rsvp-pro-plugin' ),
		),
		'settings_currency_position_before'                => array(
			'name' => 'Currency position before label',
			'text' => __( 'Before - $1', 'rsvp-pro-plugin' ),
		),
		'settings_payment_message_label'                   => array(
			'name' => 'Settings Payment Message Laebl',
			'text' => __( 'Payment Message', 'rsvp-pro-plugin' ),
		),
		'settings_payment_message_description'             => array(
			'name' => 'Settings Payment Message Description',
			'text' => __( 'Defaults to &quot;To finish RSVP\'ing please pay %s.&quot;', 'rsvp-pro-plugin' ),
		),
	);

	return $admin_strings;
}
