<?php
/**
 * Holds the function for listing out all the changes for a given event
 */

function rsvp_pro_admin_show_change_log( $event_id ) {
	global $wpdb;

	$pagenum      = isset( $_GET['pagenum'] ) ? absint( $_GET['pagenum'] ) : 1;
	$limit        = 25; // number of rows in page
	$limitOptions = array( 25, 50, 100, 'all' );
	if ( isset( $_GET['pagesize'] ) && in_array( $_GET['pagesize'], $limitOptions ) ) {
		$limit = $_GET['pagesize'];
	}
	$offset     = ( $pagenum - 1 ) * $limit;
	$page_links = false;

	if ( $limit != 'all' ) {
		$totalQuery = 'SELECT COUNT(a.id) FROM ' . PRO_ATTENDEES_TABLE . ' a 
            INNER JOIN ' . PRO_ATTENDEE_CHANGELOG . ' ac ON ac.attendeeID = a.id
            WHERE rsvpEventID = %d ';

		$total        = $wpdb->get_var( $wpdb->prepare( $totalQuery, $event_id ) );
		$num_of_pages = ceil( $total / $limit );
		$page_links   = paginate_links(
			array(
				'base'      => add_query_arg( 'pagenum', '%#%' ),
				'format'    => '',
				'prev_text' => __( '&laquo;', 'rsvp-pro-plugin' ),
				'next_text' => __( '&raquo;', 'rsvp-pro-plugin' ),
				'total'     => $num_of_pages,
				'current'   => $pagenum,
			)
		);
	}

	$sql = 'SELECT firstName, lastName, changes, change_date
			FROM ' . PRO_ATTENDEES_TABLE . ' a
			JOIN ' . PRO_ATTENDEE_CHANGELOG . ' ac ON ac.attendeeID = a.id
			WHERE a.rsvpEventID = %d
			ORDER BY change_date DESC';

	if ( $limit != 'all' ) {
		$sql .= " LIMIT $offset, $limit ";
	}

	$changes = $wpdb->get_results( $wpdb->prepare( $sql, $event_id ) );
	?>
	<div class="wrap">
		<div id="icon-edit" class="icon32"><br /></div>
		<h2><?php echo rsvp_pro_get_event_name( $event_id ) . ' ' . rsvp_pro_get_admin_string( 'change_log_admin_title' ); ?></h2>
	</div>
	<?php
	if ( $page_links && ( $limit != 'all' ) ) {
		?>
		<div class="tablenav">
			<div class="alignright" style="margin: 1em 0">
				<div class="alignleft">
					<form action="<?php echo esc_url( admin_url( "admin.php?page=rsvp-pro-top-level&action=change_log&eventID=$event_id" ) ); ?>">
						<input type="hidden" name="page" value="rsvp-pro-top-level" />
						<input type="hidden" name="eventID" value="<?php echo $event_id; ?>" />
					<label>
						<?php echo rsvp_pro_get_admin_string( 'results_page_label' ); ?>
						<select name="pagesize" size="1" class="pagesize-selector">
							<option value="25" <?php echo ( $limit == 25 ) ? 'selected="selected"' : ''; ?> ><?php echo rsvp_pro_get_admin_string( 'result_25' ); ?></option>
							<option value="50" <?php echo ( $limit == 50 ) ? 'selected="selected"' : ''; ?>><?php echo rsvp_pro_get_admin_string( 'result_50' ); ?></option>
							<option value="100" <?php echo ( $limit == 100 ) ? 'selected="selected"' : ''; ?>><?php echo rsvp_pro_get_admin_string( 'result_100' ); ?></option>
							<option value="all" <?php echo ( $limit == 'all' ) ? 'selected="selected"' : ''; ?>><?php echo rsvp_pro_get_admin_string( 'result_all' ); ?></option>
						</select>
					</label>
					</form>
				</div>
				<div class="tablenav-pages"><?php echo $page_links; ?></div>
			</div>
		</div>
		<?php
	}
	?>
	<div class="alignleft">
		<a href="<?php echo esc_url( admin_url( 'admin.php?page=rsvp-pro-export-change-log&eventID=' . $event_id ) ); ?>"><?php echo rsvp_pro_get_admin_string( 'export_change_log_label' ); ?></a>
	</div>
	<table class="widefat post fixed striped" cellspacing="0">
		<thead>
			<tr>
				<th><?php echo rsvp_pro_get_admin_string( 'attendee_label' ); ?></th>
				<th><?php echo rsvp_pro_get_admin_string( 'change_date_header_label' ); ?></th>
				<th><?php echo rsvp_pro_get_admin_string( 'changes_header_label' ); ?></th>
			</tr>
		</thead>
		<tbody>
		<?php
		foreach ( $changes as $c ) {
			?>
			<tr>
				<td><?php echo esc_html( stripslashes( $c->firstName . ' ' . $c->lastName ) ); ?></td>
				<td><?php echo date_i18n( get_option( 'date_format' ), strtotime( $c->change_date ) ); ?></td>
				<td>
				<?php
					$attendee_changes = json_decode( stripslashes( $c->changes ) );
				foreach ( $attendee_changes as $change ) {
					if ( is_object( $change ) ) {
						echo '<p>' . $change->field . ': ' . $change->old_value .
							' ' . rsvp_pro_get_admin_string( 'changed_to_label' ) .
							' ' . $change->new_value . '</p>';
					}
				}
				?>
				</td>
			</tr>
			<?php
		}
		?>
		</tbody>
	</table>
	<?php
}

/**
 * Exports all of the change log records for a given event.
 *
 * @since 3.4.9
 */
function rsvp_pro_admin_export_change_log() {
	global $wpdb;
	$event_id = 0;
	$csv      = '';

	if ( isset( $_GET['eventID'] ) && ( $_GET['eventID'] > 0 ) ) {
		$event_id = $_GET['eventID'];
	} else {
		wp_redirect( admin_url( 'admin.php?page=rsvp-pro-top-level' ) );
		return;
	}

	header( 'Content-Description: RSVP Change Log Export' );
	header( 'Content-Type: application/vnd.ms-excel', true );
	header( 'Content-Disposition: attachment; filename="rsvp_change_log.csv"' );

	$csv = "\"Attendee\",\"Change Date\",\"Changes\"\r\n";

	$sql     = 'SELECT firstName, lastName, changes, change_date
			FROM ' . PRO_ATTENDEES_TABLE . ' a
			JOIN ' . PRO_ATTENDEE_CHANGELOG . ' ac ON ac.attendeeID = a.id
			WHERE a.rsvpEventID = %d
			ORDER BY change_date DESC';
	$changes = $wpdb->get_results( $wpdb->prepare( $sql, $event_id ) );
	foreach ( $changes as $c ) {
		$csv .= '"' . stripslashes( $c->firstName . ' ' . $c->lastName ) . '","' .
				date_i18n( get_option( 'date_format' ), strtotime( $c->change_date ) ) . '","';

		$attendee_changes = json_decode( stripslashes( $c->changes ) );
		foreach ( $attendee_changes as $change ) {
			if ( is_object( $change ) ) {
				$csv .= $change->field . ': ' . $change->old_value .
					' ' . rsvp_pro_get_admin_string( 'changed_to_label' ) .
					' ' . $change->new_value . "\r\n";
			}
		}
		$csv .= "\"\r\n";
	}

	echo $csv;
	exit();
}
