<?php
/**
 * File containing the code for the admin dashboard widget
 */

/**
 * Action handler for wiring up and displaying the admin dashboard widget.
 */
function rsvp_pro_admin_dashboard_widget() {
	wp_add_dashboard_widget(
		'rsvp_pro_admin_dashboard',
		rsvp_pro_get_admin_string( 'rsvp_pro_event_responses_label' ),
		'rsvp_pro_admin_dashboard_widget_display'
	);
}
add_action( 'wp_dashboard_setup', 'rsvp_pro_admin_dashboard_widget' );

/**
 * Main function for displaying the admin dashboard widget for RSVP counts. This will display
 * main and sub-event counts in the admin dashboard area.
 */
function rsvp_pro_admin_dashboard_widget_display() {
	global $wpdb;

	$sql    = 'SELECT id, eventName FROM ' . PRO_EVENT_TABLE . ' 
    WHERE parentEventID <= 0 and ( ( eventEndDate >= ' . date( 'Y-m-d' ) . " ) OR ( eventEndDate = '0000-00-00 00:00:00' ) )";
	$events = $wpdb->get_results( $sql );
	foreach ( $events as $e ) {
		?>
	<div class="rsvp_pro_widget_event">
		<h3><a href="<?php echo admin_url( 'admin.php?page=rsvp-pro-top-level&action=attendees&eventID=' . $e->id ); ?>"><?php echo stripslashes( $e->eventName ); ?></a></h3>
		<?php
		rsvp_pro_admin_dashboard_widget_format_rsvp_counts( $e->id );

		$sql        = 'SELECT id, eventName FROM ' . PRO_EVENT_TABLE . ' WHERE parentEventID = %d';
		$sub_events = $wpdb->get_results( $wpdb->prepare( $sql, $e->id ) );
		foreach ( $sub_events as $se ) {
			?>
			<div class="rsvp_pro_widget_sub_event">
				<h3><a href="<?php echo admin_url( 'admin.php?page=rsvp-pro-top-level&action=attendees&eventID=' . $se->id ); ?>"><?php echo stripslashes( $se->eventName ); ?></a></h3>
				<?php
					rsvp_pro_admin_dashboard_widget_format_rsvp_counts( $se->id );
				?>
			</div>
			<?php
		}
		?>
	</div>
		<?php
	}
}

/**
 * This generates the RSVP counts for an event and displays them
 *
 * @param  int $event_id The event ID we want to display the RSVP counts for
 */
function rsvp_pro_admin_dashboard_widget_format_rsvp_counts( $event_id ) {
	$event_counts = rsvp_pro_get_rsvp_counts( $event_id );
	?>
	<table class="form-table">
		<tbody>
			<tr>
				<td>
					<?php echo '<b>' . rsvp_pro_humanize_rsvp_status( 'yes', $event_id ) . '</b>: ' . $event_counts['yes']; ?>
				</td>
				<td>
					<?php echo '<b>' . rsvp_pro_humanize_rsvp_status( 'no', $event_id ) . '</b>: ' . $event_counts['no']; ?>			
				</td>
				<td>
					<?php echo '<b>' . rsvp_pro_humanize_rsvp_status( 'noresponse', $event_id ) . '</b>: ' . $event_counts['no_response']; ?>
				</td>
				<?php
				if ( rsvp_pro_get_event_option( $event_id, RSVP_PRO_OPTION_ENABLE_WAITLIST ) == 'Y' ) {
					echo '<td><b>' . rsvp_pro_humanize_rsvp_status( 'waitlist', $event_id ) . '</b>: ' . $event_counts['wait_list'] . '</td>';
				}
				if ( rsvp_pro_get_event_option( $event_id, RSVP_PRO_OPTION_ENABLE_MAYBE ) == 'Y' ) {
					echo '<td><b>' . rsvp_pro_humanize_rsvp_status( 'maybe', $event_id ) . '</b>: ' . $event_counts['maybe'] . '</td>';
				}

				if ( rsvp_pro_get_event_option( $event_id, RSVP_PRO_OPTION_PLUS_ONE_ENABLED ) == 'Y' ) {
					echo '<td><b>' . rsvp_pro_humanize_rsvp_status( 'plusone', $event_id ) . '</b>: ' . $event_counts['plus_one'] . '</td>';
				}
				?>
			</tr>
		</tbody>
	</table>
	<?php
}
