<?php
/**
 * Displays the event list and main screen for the RSVP Pro admin area
 */
function rsvp_pro_admin_eventList() {
	global $wpdb;
	$free_installed = rsvp_pro_is_free_rsvp_installed();
	rsvp_pro_populate_attendee_tokens();
	?>
	<div class="wrap">
		<div id="icon-edit" class="icon32"><br /></div>
		<h2><?php rsvp_pro_get_admin_string( 'list_events' ); ?><a href="<?php echo admin_url( 'admin.php?page=rsvp-pro-admin-manage-event' ); ?>" class="add-new-h2"><?php echo rsvp_pro_get_admin_string( 'add_events' ); ?></a></h2>
	<?php
	$sql    = 'SELECT id, eventName, open_date, close_date FROM ' . PRO_EVENT_TABLE .
		' WHERE (parentEventID IS NULL OR parentEventID = 0) AND id != ' . RSVP_PRO_GLOBAL_ATTENDEE_EVENT_ID;
	$events = $wpdb->get_results( $sql );
	if ( count( $events ) === 0 ) {
		?>
		<p><?php echo rsvp_pro_get_admin_string( 'no_events_message' ); ?>
			<a href="<?php echo admin_url( 'admin.php?page=rsvp-pro-admin-manage-event' ); ?>">
				<?php echo rsvp_pro_get_admin_string( 'create_event_message' ); ?></a></p>
		<?php
	} else {

		if ( 'Y' === get_option( RSVP_PRO_GLOBAL_ENABLE_GLOBAL_ATTENDEE_LIST ) ) :
			?>
		<table class="widefat post fixed striped">
			<tbody>
				<tr class="format-standard hentry category-uncategorized iedit author-self">
					<td class="post-title column-title page-title">
						<strong><?php echo rsvp_pro_get_admin_string( 'global_attendee_list' ); ?></strong>
						<div>
							<span class="import"><a href="<?php echo admin_url( 'admin.php?page=rsvp-pro-top-level&action=import&eventID=' . RSVP_PRO_GLOBAL_ATTENDEE_EVENT_ID ); ?>">
																	 <?php
																		echo rsvp_pro_get_admin_string( 'import_attendees_label' );
																		?>
							</a> | </span>
							<span class="create_attendee"><a href="<?php echo admin_url( 'admin.php?page=rsvp-pro-top-level&action=modify_attendee&eventID=' . RSVP_PRO_GLOBAL_ATTENDEE_EVENT_ID ); ?>">
																			  <?php
																				echo rsvp_pro_get_admin_string( 'add_attendees_button' );
																				?>
							</a></span>
						</div>
					</td>
					<td><a href="<?php echo admin_url( 'admin.php?page=rsvp-pro-top-level&action=attendees&eventID=' . RSVP_PRO_GLOBAL_ATTENDEE_EVENT_ID ); ?>" title="Manage Attendees"><?php echo rsvp_pro_get_admin_string( 'manage_attendees_label' ); ?></a></td>
				</tr>
			</tbody>
		</table>
		<p><br /></p>
		<?php endif; // Check for if the Global attendee list is enabled. ?>
	<table class="widefat post fixed striped" cellspacing="0">
		<thead>
			<tr>
				<th width="75"><?php echo rsvp_pro_get_admin_string( 'event_id_label' ); ?></th>
				<th><?php echo rsvp_pro_get_frontend_string( 'event_name_label' ); ?></th>
				<th><?php echo rsvp_pro_get_admin_string( 'short_code_label' ); ?></th>
				<th><?php echo rsvp_pro_get_admin_string( 'attendees_label' ); ?></th>
			</tr>
		</thead>
		<?php
		foreach ( $events as $event ) {
			$delete_nonce = wp_create_nonce( 'rsvp-pro-top-level' );
			?>
		<tr class="format-standard hentry category-uncategorized  iedit author-self" valign="top">
			<td><?php echo $event->id; ?></td>
			<td class="post-title page-title column-title">
				<strong><a class="row-title" href="<?php echo admin_url( 'admin.php?page=rsvp-pro-admin-manage-event&id=' . $event->id ); ?>" title="Edit “<?php echo htmlspecialchars( stripslashes( $event->eventName ) ); ?>”">
				<?php echo esc_html( stripslashes( $event->eventName ) ); ?></a></strong>
			<?php
			if ( rsvp_pro_admin_user_has_access_to_settings( $event->id ) ) {
				?>
				<div class="row-actions">
					<span class="edit"><a href="<?php echo admin_url( 'admin.php?page=rsvp-pro-admin-manage-event&id=' . $event->id ); ?>" title="Edit this item"><?php echo rsvp_pro_get_admin_string( 'settings_label' ); ?></a> | </span>
					<span class="trash"><a class="submitdelete" title="Delete this event" href="
					<?php
						echo admin_url( 'admin.php?page=rsvp-pro-top-level&action=delete&eventID=' . $event->id . '&_wpnonce=' . $delete_nonce );
					?>
						"><?php echo rsvp_pro_get_admin_string( 'delete_label' ); ?></a> | </span>
					<span class="export"><a href="<?php echo admin_url( 'admin.php?page=rsvp-pro-top-level&action=export_attendee_form&eventID=' . $event->id ); ?>"><?php echo rsvp_pro_get_admin_string( 'export_attendees_label' ); ?></a> | </span>
					<span class="export"><a href="<?php echo admin_url( 'admin.php?page=rsvp-pro-top-level&action=export&includeSubs=true&eventID=' . $event->id ); ?>"><?php echo rsvp_pro_get_admin_string( 'export_attendees_w_subevent_label' ); ?></a> | </span>
					<span class="import"><a href="<?php echo admin_url( 'admin.php?page=rsvp-pro-top-level&action=import&eventID=' . $event->id ); ?>"><?php echo rsvp_pro_get_admin_string( 'import_attendees_label' ); ?></a> | </span>
					<span class="create_attendee"><a href="<?php echo admin_url( 'admin.php?page=rsvp-pro-top-level&action=modify_attendee&eventID=' . $event->id ); ?>"><?php echo rsvp_pro_get_admin_string( 'add_attendees_button' ); ?></a> | </span>
					<span class="customQ"><a href="<?php echo admin_url( 'admin.php?page=rsvp-pro-top-level&action=custom_questions&eventID=' . $event->id ); ?>"><?php echo rsvp_pro_get_admin_string( 'custom_questions_label' ); ?></a> | </span>
					<span class="copyEvent"><a href="<?php echo admin_url( 'admin.php?page=rsvp-pro-top-level&action=copy&eventID=' . $event->id ); ?>"><?php echo rsvp_pro_get_admin_string( 'copy_event_label' ); ?></a> </span>
					<?php
					if ( $free_installed ) {
						?>
						<span class="importFromFree"> | <a href="<?php echo admin_url( 'admin.php?page=rsvp-pro-top-level&action=import_from_free&eventID=' . $event->id ); ?>"><?php echo rsvp_pro_get_admin_string( 'import_from_free_label' ); ?></a> </span>
						<?php
					}
					?>
					<span class="massEmail"> | <a href="<?php echo admin_url( 'admin.php?page=rsvp-pro-top-level&action=mass_email&eventID=' . $event->id ); ?>"><?php echo rsvp_pro_get_admin_string( 'send_message_label' ); ?></a> | </span>
					<span class="messageLog"> <a href="<?php echo admin_url( 'admin.php?page=rsvp-pro-top-level&action=message_logs&eventID=' . $event->id ); ?>"><?php echo rsvp_pro_get_admin_string( 'message_logs_table_label' ); ?></a> | </span>
					<span class="allAttendees"> <a href="<?php echo admin_url( 'admin.php?page=rsvp-pro-top-level&action=all_attendees&eventID=' . $event->id ); ?>"><?php echo rsvp_pro_get_admin_string( 'all_attendees_label' ); ?></a> | </span>
					<span class="reminders"> <a href="<?php echo admin_url( 'admin.php?page=rsvp-pro-top-level&action=reminders&eventID=' . $event->id ); ?>"><?php echo rsvp_pro_get_admin_string( 'reminders_label' ); ?></a> | </span>
					<span class="rsvp_pro_reset_attendees"> <a href="<?php echo admin_url( 'admin.php?page=rsvp-pro-top-level&action=confirm_reset_all_attendees&eventID=' . $event->id ); ?>"><?php echo rsvp_pro_get_admin_string( 'reset_all_label' ); ?></a> </span>
					<?php
					if ( rsvp_pro_is_change_log_enabled() ) {
						?>
						<span class="rsvp_pro_change_log"> | <a href="<?php echo admin_url( 'admin.php?page=rsvp-pro-top-level&action=change_log&eventID=' . $event->id ); ?>"><?php echo rsvp_pro_get_admin_string( 'change_log_label' ); ?></a> </span>
						<?php
					}
						do_action( 'rsvp_pro_event_list_links', $event->id );
					?>

				</div>
				<?php
			}
			?>
			</td>
			<td class="short-code">[rsvppro id="<?php echo $event->id; ?>"]<br />
					[rsvppro-attendeelist id=&quot;<?php echo $event->id; ?>&quot;]
					<?php do_action( 'rsvp_pro_event_list_shortcodes', $event->id ); ?>
			</td>
			<td><a href="<?php echo admin_url( 'admin.php?page=rsvp-pro-top-level&action=attendees&eventID=' . $event->id ); ?>" title="Manage Attendees"><?php echo rsvp_pro_get_admin_string( 'manage_attendees_label' ); ?></a></td>
		</tr>
			<?php
			$sql       = 'SELECT id, eventName FROM ' . PRO_EVENT_TABLE . ' WHERE parentEventID = %d';
			$subEvents = $wpdb->get_results( $wpdb->prepare( $sql, $event->id ) );
			if ( count( $subEvents ) > 0 ) {
				?>
		<tr class="format-standard hentry category-uncategorized  iedit author-self" valign="top">
			<td></td>
			<td colspan="3">
				<table class="widefat post fixed" cellspacing="0">
					<thead>
						<tr>
							<th width="75"><?php echo rsvp_pro_get_admin_string( 'event_id_label' ); ?></th>
							<th><?php sprintf( rsvp_pro_get_admin_string( 'sub_events_label' ), stripslashes( $event->eventName ) ); ?></th>
							<th><?php echo rsvp_pro_get_admin_string( 'attendees_label' ); ?></th>
						</tr>
					</thead>
					<?php
					foreach ( $subEvents as $se ) {
						?>
					<tr>
						<td><?php echo $se->id; ?></td>
						<td><a class="row-title" href="<?php echo admin_url( 'admin.php?page=rsvp-pro-admin-manage-event&id=' . $se->id ); ?>" title="Edit “<?php echo esc_html( stripslashes( $se->eventName ) ); ?>”"><?php echo esc_html( stripslashes( $se->eventName ) ); ?></a>
						<?php
						if ( rsvp_pro_admin_user_has_access_to_settings( $se->id ) ) {
							?>
							<div class="row-actions">
								<span class="edit"><a href="<?php echo admin_url( 'admin.php?page=rsvp-pro-admin-manage-event&id=' . $se->id ); ?>" title="Edit this item"><?php echo rsvp_pro_get_admin_string( 'settings_label' ); ?></a> | </span>
								<span class="trash"><a class="submitdelete" title="Delete this event" href="
								<?php
									echo admin_url( 'admin.php?page=rsvp-pro-top-level&action=delete&eventID=' . $se->id . '&_wpnonce=' . $delete_nonce );
								?>
									"><?php echo rsvp_pro_get_admin_string( 'delete_label' ); ?></a> | </span>
								<span class="export"><a href="<?php echo admin_url( 'admin.php?page=rsvp-pro-top-level&action=export_attendee_form&eventID=' . $se->id ); ?>"><?php echo rsvp_pro_get_admin_string( 'export_attendees_label' ); ?></a> | </span>
								<span class="massEmail"> <a href="<?php echo admin_url( 'admin.php?page=rsvp-pro-top-level&action=mass_email&eventID=' . $se->id ); ?>"><?php echo rsvp_pro_get_admin_string( 'send_message_label' ); ?></a> | </span>
								<span class="messageLog"> <a href="<?php echo admin_url( 'admin.php?page=rsvp-pro-top-level&action=message_logs&eventID=' . $se->id ); ?>"><?php echo rsvp_pro_get_admin_string( 'message_logs_table_label' ); ?></a> | </span>
								<span class="customQ"><a href="<?php echo admin_url( 'admin.php?page=rsvp-pro-top-level&action=custom_questions&eventID=' . $se->id ); ?>"><?php echo rsvp_pro_get_admin_string( 'custom_questions_label' ); ?></a> | </span>
								<span class="copyEvent"><a href="<?php echo admin_url( 'admin.php?page=rsvp-pro-top-level&action=copy&eventID=' . $se->id ); ?>"><?php echo rsvp_pro_get_admin_string( 'copy_event_label' ); ?></a> | </span>
								<span class="rsvp_pro_reset_attendees"> <a href="<?php echo admin_url( 'admin.php?page=rsvp-pro-top-level&action=confirm_reset_all_attendees&eventID=' . $se->id ); ?>"><?php echo rsvp_pro_get_admin_string( 'reset_all_label' ); ?></a> </span>
								<?php if ( rsvp_pro_is_change_log_enabled() ) { ?>
									<span class="rsvp_pro_change_log"> | <a href="<?php echo admin_url( 'admin.php?page=rsvp-pro-top-level&action=change_log&eventID=' . $se->id ); ?>"><?php echo rsvp_pro_get_admin_string( 'change_log_label' ); ?></a> </span>
								<?php } ?>
							</div>
							<?php
						}
						?>
						</td>
						<td><a href="<?php echo admin_url( 'admin.php?page=rsvp-pro-top-level&action=attendees&eventID=' . $se->id ); ?>" title="Manage Attendees"><?php echo rsvp_pro_get_admin_string( 'manage_attendees_label' ); ?></a></td>
					</tr>
						<?php
					}
					?>
				</table>
			</td>
		</tr>
				<?php
			}
		}
		?>
	</table>
		<?php
	}
	?>
	</div>
	<?php
}

/**
 * Populates the attendee tables with tokens if they are missing.
 */
function rsvp_pro_populate_attendee_tokens() {
	global $wpdb;
	$query     = 'SELECT id FROM ' . PRO_ATTENDEES_TABLE . ' WHERE token = \'\' OR token IS NULL LIMIT 500';
	$attendees = $wpdb->get_results( $query );

	foreach ( $attendees as $a ) {
		$wpdb->update(
			PRO_ATTENDEES_TABLE,
			array(
				'token' => rsvp_pro_generate_attendee_token(),
			),
			array(
				'id' => $a->id,
			),
			array( '%s' ),
			array( '%d' )
		);
	}

	$query        = 'SELECT id FROM ' . PRO_ATTENDEE_SUB_EVENTS_TABLE . ' WHERE token = \'\' OR token IS NULL LIMIT 500';
	$subattendees = $wpdb->get_results( $query );
	foreach ( $subattendees as $sa ) {
		$wpdb->update(
			PRO_ATTENDEE_SUB_EVENTS_TABLE,
			array(
				'token' => rsvp_pro_generate_attendee_token(),
			),
			array(
				'id' => $sa->id,
			),
			array( '%s' ),
			array( '%d' )
		);
	}
}
