<?php
function rsvp_pro_admin_guestlist( $eventID, $showAll = false ) {
	global $wpdb;
	$isSubEvent                   = false;
	$subEventID                   = 0;
	$search_fields                = rsvp_pro_admin_get_search_fields( $eventID );
	$uparrow                      = plugins_url( 'images/uparrow.gif', RSVP_PRO_PLUGIN_FILE );
	$uparrow_active               = plugins_url( 'images/uparrow_selected.gif', RSVP_PRO_PLUGIN_FILE );
	$downarrow                    = plugins_url( 'images/downarrow.gif', RSVP_PRO_PLUGIN_FILE );
	$downarrow_active             = plugins_url( 'images/downarrow_selected.gif', RSVP_PRO_PLUGIN_FILE );
	$previous_searches            = array();
	$global_attendee_list_enabled = ( get_option( RSVP_PRO_GLOBAL_ENABLE_GLOBAL_ATTENDEE_LIST ) == 'Y' ) ? true : false;

	if ( ( $eventID <= 0 ) && ( $eventID != RSVP_PRO_GLOBAL_ATTENDEE_EVENT_ID ) ) {
		rsvp_pro_admin_eventList();
		exit;
	}

	$attendee_list_columns = rsvp_pro_get_attendee_list_columns( $eventID );

	// Check to see if there is a parent event...
	$sql           = 'SELECT parentEventID FROM ' . PRO_EVENT_TABLE . ' WHERE id = %d';
	$parentEventID = $wpdb->get_var( $wpdb->prepare( $sql, $eventID ) );

	if ( $parentEventID > 0 ) {
		$subEventID = $eventID;
		$isSubEvent = true;
	}

	if ( isset( $_GET['prev_searches'] ) && is_array( $_GET['prev_searches'] ) ) {
		$tmp_searches = $_GET['prev_searches'];
		foreach ( $tmp_searches as $s ) {
			$items = explode( ',', $s );
			if ( is_array( $items ) && ( count( $items ) == 2 ) ) {
				$previous_searches[] = array(
					'search_field' => $items[0],
					'search'       => $items[1],
				);
			}
		}
	}

	if ( isset( $_GET['s'] ) && ! empty( $_GET['s'] ) && array_key_exists( $_GET['search_field'], $search_fields ) ) {
		$previous_searches[] = array(
			'search_field' => $_GET['search_field'],
			'search'       => $_GET['s'],
		);
	}

	if ( isset( $_GET['rsvp_status_search'] ) && ! empty( $_GET['rsvp_status_search'] ) && array_key_exists( $_GET['search_field'], $search_fields ) ) {
		$previous_searches[] = array(
			'search_field' => $_GET['search_field'],
			'search'       => $_GET['rsvp_status_search'],
		);
	}

	// Pagination work
	$pagenum      = isset( $_GET['pagenum'] ) ? absint( $_GET['pagenum'] ) : 1;
	$limit        = 25; // number of rows in page
	$limitOptions = array( 25, 50, 100, 'all' );

	if ( in_array( get_option( RSVP_PRO_GLOBAL_OPTION_NUM_ATTENDEES_PER_PAGE ), $limitOptions ) ) {
		$limit = get_option( RSVP_PRO_GLOBAL_OPTION_NUM_ATTENDEES_PER_PAGE );
	}

	if ( isset( $_GET['pagesize'] ) && in_array( $_GET['pagesize'], $limitOptions ) ) {
		$limit = $_GET['pagesize'];
	}
	$offset     = 0;
	$page_links = false;

	if ( $limit != 'all' ) {
		$offset       = ( $pagenum - 1 ) * $limit;
		$totalEventID = $eventID;
		if ( $isSubEvent ) {
			$totalEventID = $parentEventID;
		}
		$totalQuery = 'SELECT COUNT(a.id) FROM ' . PRO_ATTENDEES_TABLE . ' a 
            INNER JOIN ' . PRO_EVENT_TABLE . ' e ON e.id = a.rsvpEventID 
            WHERE ( (rsvpEventID = %d) ';

		if ( $global_attendee_list_enabled ) {
			$totalQuery .= ' OR (rsvpEventID = ' . RSVP_PRO_GLOBAL_ATTENDEE_EVENT_ID . ') ';
		}

		$totalQuery .= ')';

		if ( ! $showAll ) {
			$totalQuery .= " AND ((IFNULL(e.event_access, '" . RSVP_PRO_OPEN_EVENT_ACCESS . "') != '" . RSVP_PRO_PRIVATE_EVENT_ACCESS . "') OR (a.id IN (SELECT rsvpAttendeeID FROM " . PRO_EVENT_ATTENDEE_TABLE . ' WHERE rsvpEventID = e.id)))';
		}

		if ( $isSubEvent ) {
			$totalQuery = 'SELECT COUNT(a.id)
					FROM ' . PRO_ATTENDEES_TABLE . ' a
					LEFT JOIN ' . PRO_ATTENDEE_SUB_EVENTS_TABLE . ' se ON se.rsvpAttendeeID = a.id AND se.rsvpEventID = %d
					WHERE ( ( a.rsvpEventID = %d ) ';

			if ( $global_attendee_list_enabled ) {
				$totalQuery .= ' OR ( a.rsvpEventID = ' . RSVP_PRO_GLOBAL_ATTENDEE_EVENT_ID . ' ) ';
			}

			$totalQuery .= ')';
		}

		foreach ( $previous_searches as $s ) {
			if ( is_array( $s ) && isset( $s['search_field'] ) && array_key_exists( $s['search_field'], $search_fields ) ) {
				if ( strpos( $s['search_field'], 'cq_' ) !== false ) {
					$cq_id = str_replace( 'cq_', '', $s['search_field'] );

					if ( is_numeric( $cq_id ) && ( $cq_id > 0 ) ) {
						$totalQuery .= ' AND a.id IN (SELECT attendeeID FROM ' . PRO_ATTENDEE_ANSWERS . ' WHERE questionID = ' . $cq_id . " AND answer LIKE '%%%s%%' ) ";
					}
				} else {
					if ( $isSubEvent && ( $s['search_field'] == 'rsvpStatus' ) ) {
						$totalQuery .= ' AND ( se.' . esc_sql( $s['search_field'] ) . " = '%s' ) ";
					} elseif ( $s['search_field'] == 'rsvpStatus' ) {
						$totalQuery .= ' AND ( ' . esc_sql( $s['search_field'] ) . " = '%s' ) ";
					} else {
						$totalQuery .= ' AND ( ' . esc_sql( $s['search_field'] ) . " LIKE '%%%s%%' ) ";
					}
				}
			}
		}

		$total_values = array();
		if ( $isSubEvent ) {
			$total_values = array( $subEventID, $totalEventID );
		} else {
			$total_values = array( $totalEventID );
		}

		foreach ( $previous_searches as $s ) {
			if ( is_array( $s ) && isset( $s['search_field'] ) && array_key_exists( $s['search_field'], $search_fields ) ) {
				$total_values[] = $s['search'];
			}
		}

		$total        = $wpdb->get_var( $wpdb->prepare( $totalQuery, $total_values ) );
		$num_of_pages = ceil( $total / $limit );
		$page_links   = paginate_links(
			array(
				'base'      => add_query_arg( 'pagenum', '%#%' ),
				'format'    => '',
				'prev_text' => __( '&laquo;', 'rsvp-pro-plugin' ),
				'next_text' => __( '&raquo;', 'rsvp-pro-plugin' ),
				'total'     => $num_of_pages,
				'current'   => $pagenum,
			)
		);

		$total += $wpdb->get_var( $wpdb->prepare( $totalQuery . " AND a.plus_one = 'Y' ", $total_values ) );
	}

	rsvp_pro_install_passcode_field();
	if ( ( count( $_POST ) > 0 ) && ( $_POST['rsvp-bulk-action'] == 'delete' ) && ( is_array( $_POST['attendee'] ) && ( count( $_POST['attendee'] ) > 0 ) ) ) {
		foreach ( $_POST['attendee'] as $attendee ) {
			/*
			 Note - We don't delete global attendee list except from the global
			attendee list management area */
			if ( is_numeric( $attendee ) && ( $attendee > 0 ) ) {
				rsvp_pro_delete_attendee( $attendee );
			}
		}
	}

	if ( isset( $_POST['rsvp-bulk-action'] ) && ( $_POST['rsvp-bulk-action'] == 'check_in' ) &&
	is_array( $_POST['attendee'] ) && ( count( $_POST['attendee'] ) > 0 ) ) {
		foreach ( $_POST['attendee'] as $attendee ) {
			if ( is_numeric( $attendee ) && ( $attendee > 0 ) ) {
				rsvp_pro_handle_attendee_check_in( $eventID, $attendee, 'Y' );
			}
		}
	}

	$sql          = 'SELECT a.id, firstName, lastName, IFNULL(se.rsvpStatus, a.rsvpStatus) as rsvpStatus, note, ' .
		'additionalAttendee, personalGreeting, passcode, email, IFNULL(se.rsvpDate, a.rsvpDate) as rsvpDate, 
		IFNULL(se.checked_in, a.checked_in) AS checked_in ' .
		'FROM ' . PRO_ATTENDEES_TABLE . ' a
		INNER JOIN ' . PRO_EVENT_TABLE . ' e ON e.id = a.rsvpEventID
		LEFT JOIN ' . PRO_ATTENDEE_SUB_EVENTS_TABLE . ' se ON se.rsvpAttendeeID = a.id AND se.rsvpEventID = %d  ';
	$where_clause = ' WHERE ( (a.rsvpEventID = %d) ';

	if ( $global_attendee_list_enabled ) {
		$where_clause .= ' OR (a.rsvpEventID = ' . RSVP_PRO_GLOBAL_ATTENDEE_EVENT_ID . ') ';
	}

	$where_clause .= " ) AND (((SELECT IFNULL(event_access, '" . RSVP_PRO_OPEN_EVENT_ACCESS . "' ) FROM " . PRO_EVENT_TABLE . " WHERE id = %d) != '" . RSVP_PRO_PRIVATE_EVENT_ACCESS . "') OR (a.id IN (SELECT rsvpAttendeeID FROM " . PRO_EVENT_ATTENDEE_TABLE . ' WHERE rsvpEventID = %d)))';

	if ( $isSubEvent ) {
		$sql          = "SELECT a.id, firstName, lastName, IFNULL(se.rsvpStatus, 'NoResponse') AS rsvpStatus, note, " .
			'additionalAttendee, personalGreeting, passcode, email, se.rsvpDate, se.checked_in ' .
			'FROM ' . PRO_ATTENDEES_TABLE . ' a
			INNER JOIN ' . PRO_EVENT_TABLE . ' e ON e.id = %d
			LEFT JOIN ' . PRO_ATTENDEE_SUB_EVENTS_TABLE . ' se ON se.rsvpAttendeeID = a.id AND se.rsvpEventID = %d ';
		$where_clause = ' WHERE ( (a.rsvpEventID = %d) ';

		if ( $global_attendee_list_enabled ) {
			$where_clause .= ' OR (a.rsvpEventID = ' . RSVP_PRO_GLOBAL_ATTENDEE_EVENT_ID . ') ';
		}
		$where_clause .= " ) AND (( (SELECT IFNULL(event_access, '" . RSVP_PRO_OPEN_EVENT_ACCESS . "' ) FROM " . PRO_EVENT_TABLE . " WHERE id = %d) != '" . RSVP_PRO_PRIVATE_EVENT_ACCESS . "') OR (a.id IN (SELECT rsvpAttendeeID FROM " . PRO_EVENT_ATTENDEE_TABLE . ' WHERE rsvpEventID = %d)))';

	} elseif ( $showAll ) {
		$sql          = 'SELECT a.id, firstName, lastName, rsvpStatus, note, ' .
			'additionalAttendee, personalGreeting, passcode, email, rsvpDate, checked_in ' .
			'FROM ' . PRO_ATTENDEES_TABLE . ' a
			INNER JOIN ' . PRO_EVENT_TABLE . ' e ON e.id = a.rsvpEventID ';
		$where_clause = ' WHERE ( (rsvpEventID = %d) ';

		if ( $global_attendee_list_enabled ) {
			$where_clause .= ' OR (rsvpEventID = ' . RSVP_PRO_GLOBAL_ATTENDEE_EVENT_ID . ') ';
		}

		$where_clause .= ')';
	}

	foreach ( $previous_searches as $s ) {
		if ( is_array( $s ) && isset( $s['search_field'] ) && array_key_exists( $s['search_field'], $search_fields ) ) {
			if ( strpos( $s['search_field'], 'cq_' ) !== false ) {
				$cq_id = str_replace( 'cq_', '', $s['search_field'] );

				if ( is_numeric( $cq_id ) && ( $cq_id > 0 ) ) {
					$where_clause .= ' AND a.id IN (SELECT attendeeID FROM ' . PRO_ATTENDEE_ANSWERS . ' WHERE questionID = ' . $cq_id . " AND answer LIKE '%%%s%%' ) ";
				}
			} else {
				if ( $isSubEvent && ( $s['search_field'] == 'rsvpStatus' ) ) {
					$where_clause .= ' AND ( se.' . esc_sql( $s['search_field'] ) . " = '%s' ) ";
				} elseif ( $s['search_field'] == 'rsvpStatus' ) {
					$where_clause .= ' AND ( (a.' . esc_sql( $s['search_field'] ) . " = '%s') OR (se." . esc_sql( $s['search_field'] ) . " = '%s') ) ";
				} else {
					$where_clause .= ' AND ( ' . esc_sql( $s['search_field'] ) . " LIKE '%%%s%%' ) ";
				}
			}
		}
	}

	$values = array();
	if ( $isSubEvent ) {
		$values = array( $subEventID, $subEventID, $parentEventID, $subEventID, $subEventID );
	} elseif ( $showAll ) {
		$values = array( $eventID );
	} else {
		$values = array( $eventID, $eventID, $eventID, $eventID );
	}

	$base_order_by = ' lastName, firstName';
	$orderBy = $base_order_by;
	if ( isset( $_GET['sort'] ) && ! empty( $_GET['sort'] ) ) {
		if ( strToLower( $_GET['sort'] ) == 'rsvpstatus' ) {
			$orderBy = ' rsvpStatus ';
			if ( $isSubEvent ) {
				$orderBy = ' se.rsvpStatus ';
			}
			$orderBy .= ( ( strtolower( $_GET['sortDirection'] ) == 'desc' ) ? 'DESC' : 'ASC' ) . ', ' . $base_order_by;
		} elseif ( strToLower( $_GET['sort'] ) == 'rsvpdate' ) {
			$orderBy = ' rsvpDate ';
			if ( $isSubEvent ) {
				$orderBy = ' se.rsvpDate ';
			}
			$orderBy .= ( ( strtolower( $_GET['sortDirection'] ) == 'desc' ) ? 'DESC' : 'ASC' ) . ', ' . $base_order_by;
		} elseif ( strToLower( $_GET['sort'] ) == 'attendee' ) {
			$direction = ( ( strtolower( $_GET['sortDirection'] ) == 'desc' ) ? 'DESC' : 'ASC' );
			$orderBy   = " lastName $direction, firstName $direction";
		} elseif ( strToLower( $_GET['sort'] ) == 'additional' ) {
			$orderBy = ' additionalAttendee ' . ( ( strtolower( $_GET['sortDirection'] ) == 'desc' ) ? 'DESC' : 'ASC' ) . ', ' . $base_order_by;
		} elseif ( strToLower( $_GET['sort'] ) == 'passcode' ) {
			$orderBy = ' passcode ' . ( ( strtolower( $_GET['sortDirection'] ) == 'desc' ) ? 'DESC' : 'ASC' ) . ', ' . $base_order_by;
		} elseif ( strtolower( $_GET['sort'] ) === 'checked_in' ) {
			if ( $isSubEvent ) {
				$orderBy = ' se.checked_in ';
			} else {
				$orderBy = ' checked_in ';
			}

			$orderBy .= ( ( strtolower( $_GET['sortDirection'] ) == 'desc' ) ? 'DESC' : 'ASC' ) . ', ' . $base_order_by;
		} elseif ( substr( strtolower( $_GET['sort'] ), 0, 3 ) === 'cq_' ) {
			$cq_id = str_replace( 'cq_', '', $_GET['sort'] );
			if ( is_numeric( $cq_id ) && ( 0 < $cq_id ) ) {
				$sql .= ' LEFT JOIN ' . PRO_ATTENDEE_ANSWERS . ' ans ON ans.attendeeID = a.id AND ans.questionID = ' . intval( $cq_id );
				$orderBy = ' ans.answer ' . ( ( strtolower( $_GET['sortDirection'] ) == 'desc' ) ? 'DESC' : 'ASC' );
			}
		}
	}
	$sql .= $where_clause . ' ORDER BY ' . $orderBy;

	if ( $limit != 'all' ) {
		$sql .= " LIMIT $offset, $limit ";
	}

	foreach ( $previous_searches as $s ) {
		if ( is_array( $s ) && isset( $s['search_field'] ) && array_key_exists( $s['search_field'], $search_fields ) ) {
			$values[] = $s['search'];

			if ( ( $s['search_field'] == 'rsvpStatus' ) && ! $isSubEvent ) {
				$values[] = $s['search'];
			}
		}
	}

	$attendees = $wpdb->get_results( $wpdb->prepare( $sql, $values ) );

	$sort          = '';
	$sortDirection = 'asc';
	if ( isset( $_GET['sort'] ) ) {
		$sort = $_GET['sort'];
	}

	if ( isset( $_GET['sortDirection'] ) ) {
		$sortDirection = $_GET['sortDirection'];
	} ?>
	<script type="text/javascript" language="javascript">
	jQuery(document).ready(function() {
		jQuery("#cb").click(function() {
			if(jQuery("#cb").attr("checked")) {
				jQuery("input[name='attendee[]']").attr("checked", "checked");
			} else {
				jQuery("input[name='attendee[]']").removeAttr("checked");
			}
		});
	});
	</script>
	<div class="wrap">
		<div id="icon-edit" class="icon32"><br /></div>
		<h2><?php echo rsvp_pro_get_admin_string( 'list_attendees_label' ); ?> - <?php echo rsvp_pro_get_event_name( $eventID ); ?></h2>
		<div class="alignright actions">
			<div>
			<?php
			if ( $limit != 'all' ) {
				echo rsvp_pro_get_admin_string( 'attendee_count_label' ) . ':' . $total;
			}
			if ( count( $previous_searches ) > 0 ) :
				if ( $limit != 'all' ) {
					echo ' - ';
				}
				?>
			Searching for
				<?php
				$tmp           = '';
				$search_fields = rsvp_pro_admin_get_search_fields( $eventID );
				foreach ( $previous_searches as $s ) {
					$tmp .= ( ( ! empty( $tmp ) ) ? ' ' . rsvp_pro_get_admin_string( 'and' ) . ' ' : '' );
					$tmp .= $search_fields[ $s['search_field'] ] . ' - ' . esc_html( $s['search'] );
				}
				echo $tmp;
				?>
			- <a href="<?php echo esc_url( admin_url( 'admin.php?page=rsvp-pro-top-level&action=' . ( ( $showAll ) ? 'all_attendees' : 'attendees' ) . "&eventID=$eventID&sort=$sort&sortDirection=$sortDirection" ) ); ?>">clear search</a>
			<?php endif; ?>
		</div>
		<form method="get" action="<?php echo admin_url( 'admin.php' ); ?>">
			<select name="search_field" id="attendee_search_field" size="1">
				<option value=""><?php echo rsvp_pro_get_admin_string( 'field_to_search_label' ); ?></option>
				<?php foreach ( $search_fields as $key => $value ) { ?>
					<option value="<?php echo $key; ?>"><?php echo esc_html( $value ); ?></option>
				<?php } ?>
			</select>
			<input type="text" name="s" id="s" />
			<select name="rsvp_status_search" size="1" id="rsvp_status_search">
				<option value="">--</option>
				<option value="No">
					<?php echo rsvp_pro_humanize_rsvp_status( 'No', $eventID ); ?>
				</option>
				<option value="NoResponse">
					<?php echo rsvp_pro_humanize_rsvp_status( 'NoResponse', $eventID ); ?>
				</option>
				<option value="Yes">
					<?php echo rsvp_pro_humanize_rsvp_status( 'Yes', $eventID ); ?>
				</option>
			<?php
			if ( rsvp_pro_get_event_option( $eventID, RSVP_PRO_OPTION_ENABLE_WAITLIST ) === 'Y' ) {
				?>
				<option value="Waitlist">
				<?php echo rsvp_pro_humanize_rsvp_status( 'Waitlist', $eventID ); ?>
				</option>
				<?php
			}

			if ( rsvp_pro_get_event_option( $eventID, RSVP_PRO_OPTION_ENABLE_MAYBE ) === 'Y' ) {
				?>
				<option value="Maybe">
				<?php echo rsvp_pro_humanize_rsvp_status( 'Maybe', $eventID ); ?>
				</option>
			<?php } ?>
			</select>
			<input type="submit" value="Search Attendees" class="button" />
			<?php
			foreach ( $previous_searches as $s ) {
				?>
				<input type="hidden" name="prev_searches[]" value="<?php echo esc_attr( implode( ',', $s ) ); ?>" />
				<?php
			}
			?>
			<input type="hidden" name="page" value="rsvp-pro-top-level" />
			<input type="hidden" name="action" value="<?php echo ( $showAll ) ? 'all_attendees' : 'attendees'; ?>" />
			<input type="hidden" name="eventID" value="<?php echo $eventID; ?>" />
			<input type="hidden" name="sort" value="<?php echo esc_html( $sort ); ?>" />
			<input type="hidden" name="sortDirection" value="<?php echo esc_html( $sortDirection ); ?>" />
		</form>
	</div>
	<?php
	if ( $page_links && ( $limit != 'all' ) ) {
		?>
			<div class="tablenav">
				<div class="alignright" style="margin: 1em 0">
					<div class="alignleft">
						<form action="<?php echo esc_url( admin_url( "admin.php?page=rsvp-pro-top-level&action=attendees&eventID=$eventID&sort=$sort&sortDirection=$sortDirection" ) ); ?>">
							<input type="hidden" name="page" value="rsvp-pro-top-level" />
							<input type="hidden" name="action" value="<?php echo ( $showAll ) ? 'all_attendees' : 'attendees'; ?>" />
							<input type="hidden" name="eventID" value="<?php echo $eventID; ?>" />
							<input type="hidden" name="sort" value="<?php echo esc_html( $sort ); ?>" />
							<input type="hidden" name="sortDirection" value="<?php echo esc_html( $sortDirection ); ?>" />
							<?php
							foreach ( $previous_searches as $s ) {
								?>
								<input type="hidden" name="prev_searches[]" value="<?php echo esc_attr( implode( ',', $s ) ); ?>" />
								<?php
							}
							?>
						<label>
							<?php echo rsvp_pro_get_admin_string( 'results_page_label' ); ?>
							<select name="pagesize" size="1" class="pagesize-selector">
								<option value="25" <?php echo ( $limit == 25 ) ? 'selected="selected"' : ''; ?> ><?php echo rsvp_pro_get_admin_string( 'result_25' ); ?></option>
								<option value="50" <?php echo ( $limit == 50 ) ? 'selected="selected"' : ''; ?>><?php echo rsvp_pro_get_admin_string( 'result_50' ); ?></option>
								<option value="100" <?php echo ( $limit == 100 ) ? 'selected="selected"' : ''; ?>><?php echo rsvp_pro_get_admin_string( 'result_100' ); ?></option>
								<option value="all" <?php echo ( $limit == 'all' ) ? 'selected="selected"' : ''; ?>><?php echo rsvp_pro_get_admin_string( 'result_all' ); ?></option>
							</select>
						</label>
						</form>
					</div>
					<div class="tablenav-pages"><?php echo $page_links; ?></div>
				</div>
			</div>
		<?php
	}
	?>
	<div class="clear"></div>
	<form method="post" id="rsvp-form" enctype="multipart/form-data" action="<?php echo admin_url( 'admin.php?page=rsvp-pro-top-level&action=' . ( ( $showAll ) ? 'all_attendees' : 'attendees' ) . "&eventID=$eventID" ); ?>">
	<input type="hidden" id="rsvp-bulk-action" name="rsvp-bulk-action" />
	<input type="hidden" id="sortValue" name="sortValue" value="<?php echo htmlentities( $sort, ENT_QUOTES ); ?>" />
	<input type="hidden" name="exportSortDirection" value="<?php echo htmlentities( $sortDirection, ENT_QUOTES ); ?>" />
	<div class="tablenav">
		<div class="alignleft actions">
			<select id="rsvp-action-top" name="rsvpAction">
				<option value="" selected="selected"><?php echo rsvp_pro_get_admin_string( 'bulk_actions_label' ); ?></option>
				<option value="delete"><?php echo rsvp_pro_get_admin_string( 'delete_label' ); ?></option>
				<option value="mass_email"><?php echo rsvp_pro_get_admin_string( 'send_message_label' ); ?></option>
			<?php
			if ( ( rsvp_pro_get_event_option( $eventID, RSVP_PRO_OPTION_ALLOW_CHECKINS ) === 'Y' ) ||
				  ( $isSubEvent && ( rsvp_pro_get_event_option( $parentEventID, RSVP_PRO_OPTION_ALLOW_CHECKINS ) === 'Y' ) ) ) {
				?>
				<option value="check_in"><?php echo rsvp_pro_get_frontend_string( 'check_in_label' ); ?></option>
				<?php
			}
			?>
				</select>
				<input type="submit" value="<?php echo rsvp_pro_get_admin_string( 'apply_label' ); ?>" name="doaction" id="doaction" class="button-secondary action" onclick="document.getElementById('rsvp-bulk-action').value = document.getElementById('rsvp-action-top').value;" />
				<input type="submit" value="<?php echo rsvp_pro_get_admin_string( 'export_attendees_label' ); ?>" name="exportButton" id="exportButton" class="button-secondary action" onclick="document.getElementById('rsvp-bulk-action').value = 'export_show_form';" />

				<a href="<?php echo admin_url( "admin.php?page=rsvp-pro-top-level&action=modify_attendee&eventID=$eventID" ); ?>"><?php echo rsvp_pro_get_admin_string( 'add_attendees_button' ); ?></a>
				|
				<a href="<?php echo admin_url( 'admin.php?page=rsvp-pro-top-level' ); ?>"><?php echo rsvp_pro_get_admin_string( 'event_list_label' ); ?></a>
				</div>
				<?php
				if ( $isSubEvent ) {
					$baseSql = 'SELECT COUNT(*)
    					FROM ' . PRO_ATTENDEES_TABLE . ' a
    					LEFT JOIN ' . PRO_ATTENDEE_SUB_EVENTS_TABLE . ' se ON se.rsvpAttendeeID = a.id AND se.rsvpEventID = %d
    					LEFT JOIN ' . PRO_EVENT_TABLE . " e ON e.id = se.rsvpEventID
    					WHERE ((IFNULL(e.event_access, '" . RSVP_PRO_OPEN_EVENT_ACCESS . "') != '" . RSVP_PRO_PRIVATE_EVENT_ACCESS . "') OR (a.id IN (SELECT rsvpAttendeeID FROM " . PRO_EVENT_ATTENDEE_TABLE . ' WHERE rsvpEventID = e.id))) AND ';

					$rsvp_event_where = ' ( ( a.rsvpEventID = %d ) ';
					if ( $global_attendee_list_enabled ) {
						$rsvp_event_where .= ' OR ( a.rsvpEventID = ' . RSVP_PRO_GLOBAL_ATTENDEE_EVENT_ID . ') ';
					}
					$rsvp_event_where .= ')';

					$sql        = $baseSql . " (se.rsvpStatus = 'Yes' OR se.rsvpStatus = 'PlusOne') AND " . $rsvp_event_where;
					$yesResults = $wpdb->get_var( $wpdb->prepare( $sql, $subEventID, $parentEventID ) );

					$sql       = $baseSql . " se.rsvpStatus = 'No' AND " . $rsvp_event_where;
					$noResults = $wpdb->get_var( $wpdb->prepare( $sql, $subEventID, $parentEventID ) );

					$sql           = $baseSql . " se.rsvpStatus = 'Waitlist' AND " . $rsvp_event_where;
					$waitListCount = $wpdb->get_var( $wpdb->prepare( $sql, $subEventID, $parentEventID ) );

					$sql        = $baseSql . " se.rsvpStatus = 'Maybe' AND " . $rsvp_event_where;
					$maybeCount = $wpdb->get_var( $wpdb->prepare( $sql, $subEventID, $parentEventID ) );

					// We do this as if they say yes, plus one we will want to double the yes count...
					if ( rsvp_pro_get_event_option( $parentEventID, RSVP_PRO_OPTION_PLUS_ONE_ENABLED ) === 'Y' ) {
						$sql         = $baseSql . " se.rsvpStatus = 'PlusOne' AND " . $rsvp_event_where;
						$yesResults += $wpdb->get_var( $wpdb->prepare( $sql, $subEventID, $parentEventID ) );
					}

					$sql = $baseSql . " (se.rsvpStatus = 'NoResponse' OR se.rsvpStatus IS NULL) AND " . $rsvp_event_where;

					if ( rsvp_pro_get_event_information( $subEventID, RSVP_PRO_INFO_EVENT_ACCESS ) == RSVP_PRO_PRIVATE_EVENT_ACCESS ) {
						$sql = 'SELECT COUNT(*) FROM ' . PRO_EVENT_ATTENDEE_TABLE . ' ea
                            LEFT JOIN ' . PRO_ATTENDEE_SUB_EVENTS_TABLE . ' se ON se.rsvpAttendeeID = ea.rsvpAttendeeID
                            JOIN ' . PRO_ATTENDEES_TABLE . " a ON a.id = ea.rsvpAttendeeID
                            WHERE (se.rsvpStatus IS NULL OR se.rsvpStatus = 'NoResponse') AND ea.rsvpEventID = %d 
                            AND " . $rsvp_event_where;
					}

					$noResponseResults = $wpdb->get_var( $wpdb->prepare( $sql, $subEventID, $parentEventID ) );

					if ( rsvp_pro_get_event_option( $parentEventID, RSVP_PRO_OPTION_PLUS_ONE_ENABLED ) === 'Y' ) {
						$sql               .= " AND a.plus_one = 'Y'";
						$noResponseResults += $wpdb->get_var( $wpdb->prepare( $sql, $subEventID, $parentEventID ) );
					}
				} else {
					$baseSql = 'SELECT COUNT(*) FROM ' . PRO_ATTENDEES_TABLE . ' a
    					JOIN ' . PRO_EVENT_TABLE . " e ON e.id = a.rsvpEventID
    					WHERE ((IFNULL(e.event_access, '" . RSVP_PRO_OPEN_EVENT_ACCESS . "') != '" . RSVP_PRO_PRIVATE_EVENT_ACCESS . "') OR (a.id IN (SELECT rsvpAttendeeID FROM " . PRO_EVENT_ATTENDEE_TABLE . ' WHERE rsvpEventID = e.id))) ';

					$yesResults        = $wpdb->get_var( $wpdb->prepare( $baseSql . " AND (rsvpStatus = 'Yes' OR rsvpStatus = 'PlusOne') AND rsvpEventID = %d", $eventID ) );
					$noResults         = $wpdb->get_var( $wpdb->prepare( $baseSql . " AND rsvpStatus = 'No' AND rsvpEventID = %d", $eventID ) );
					$noResponseResults = $wpdb->get_var( $wpdb->prepare( $baseSql . " AND rsvpStatus = 'NoResponse' AND rsvpEventID = %d", $eventID ) );
					$waitListCount     = $wpdb->get_var( $wpdb->prepare( $baseSql . " AND rsvpStatus = 'Waitlist' AND rsvpEventID = %d", $eventID ) );
					$maybeCount        = $wpdb->get_var( $wpdb->prepare( $baseSql . " AND rsvpStatus = 'Maybe' AND rsvpEventID = %d", $eventID ) );

					// We do this as if they say yes, plus one we will want to double the yes count...
					if ( rsvp_pro_get_event_option( $eventID, RSVP_PRO_OPTION_PLUS_ONE_ENABLED ) === 'Y' ) {
						$sql         = $baseSql . " AND rsvpStatus = 'PlusOne' AND rsvpEventID = %d";
						$yesResults += $wpdb->get_var( $wpdb->prepare( $sql, $eventID ) );
					}

					if ( $global_attendee_list_enabled ) {
						$baseSql = 'SELECT COUNT(*) FROM ' . PRO_ATTENDEES_TABLE . ' a 
                            LEFT JOIN ' . PRO_ATTENDEE_SUB_EVENTS_TABLE . ' se ON se.rsvpAttendeeID = a.id AND se.rsvpEventID = %d 
                            LEFT JOIN ' . PRO_EVENT_TABLE . " e ON e.id = se.rsvpEventID
                            WHERE ((IFNULL(e.event_access, '" . RSVP_PRO_OPEN_EVENT_ACCESS . "') != '" . RSVP_PRO_PRIVATE_EVENT_ACCESS . "') OR (a.id IN (SELECT rsvpAttendeeID FROM " . PRO_EVENT_ATTENDEE_TABLE . ' WHERE rsvpEventID = e.id))) AND ';

						$sql         = $baseSql . " (se.rsvpStatus = 'Yes' OR se.rsvpStatus = 'PlusOne') ";
						$yesResults += $wpdb->get_var( $wpdb->prepare( $sql, $eventID ) );

						$sql        = $baseSql . " se.rsvpStatus = 'No'";
						$noResults += $wpdb->get_var( $wpdb->prepare( $sql, $eventID ) );

						$sql               = $baseSql . " (((a.rsvpStatus = 'NoResponse' OR a.rsvpStatus IS NULL) AND a.rsvpEventID = %d) OR ( (se.rsvpStatus = 'NoResponse' OR se.rsvpStatus IS NULL) AND a.rsvpEventID = " . RSVP_PRO_GLOBAL_ATTENDEE_EVENT_ID . ' ) ) ';
						$noResponseResults = $wpdb->get_var( $wpdb->prepare( $sql, $eventID, $eventID ) );

						$sql            = $baseSql . " se.rsvpStatus = 'Waitlist'";
						$waitListCount += $wpdb->get_var( $wpdb->prepare( $sql, $eventID ) );

						$sql         = $baseSql . " se.rsvpStatus = 'Maybe'";
						$maybeCount += $wpdb->get_var( $wpdb->prepare( $sql, $eventID ) );

						if ( rsvp_pro_get_event_option( $eventID, RSVP_PRO_OPTION_PLUS_ONE_ENABLED ) === 'Y' ) {
							$sql         = $baseSql . " se.rsvpStatus = 'PlusOne'";
							$yesResults += $wpdb->get_var( $wpdb->prepare( $sql, $eventID ) );
						}
					}
				}
				?>
				<?php if ( ! $showAll ) : ?>
				<div class="alignright"><?php echo rsvp_pro_get_frontend_string( 'rsvp_count_label' ); ?> -
					<?php echo rsvp_pro_get_frontend_string( 'yes_text' ); ?>: <strong><?php echo $yesResults; ?></strong> &nbsp; &nbsp;  &nbsp; &nbsp;
					<?php echo rsvp_pro_get_frontend_string( 'no_text' ); ?>: <strong><?php echo $noResults; ?></strong> &nbsp; &nbsp;  &nbsp; &nbsp;
					<?php if ( rsvp_pro_waitlist_enabled( $eventID ) ) : ?>
						<?php echo rsvp_pro_get_frontend_string( 'waitlist_text' ); ?>: <strong><?php echo $waitListCount; ?></strong> &nbsp; &nbsp;  &nbsp; &nbsp;
					<?php endif; ?>
					<?php if ( rsvp_pro_get_event_option( $eventID, RSVP_PRO_OPTION_ENABLE_MAYBE ) === 'Y' ) : ?>
						<?php echo rsvp_pro_get_frontend_string( 'maybe_text' ); ?>: <strong><?php echo $maybeCount; ?></strong> &nbsp; &nbsp;  &nbsp; &nbsp;
					<?php endif; ?>
					<?php echo rsvp_pro_get_frontend_string( 'noresponse_text' ); ?>: <strong><?php echo $noResponseResults; ?></strong> &nbsp; &nbsp;  &nbsp; &nbsp;

				</div>
				<?php endif; ?>
				<div class="clear"></div>
			</div>
			<table class="widefat post fixed" cellspacing="0">
				<thead>
					<tr>
					<th scope="col" class="manage-column column-cb check-column" style=""><input type="checkbox" id="cb" /></th>
					<?php if ( in_array( 'attendee_name', $attendee_list_columns ) ) { ?>
					<th scope="col" id="attendeeName" class="manage-column column-title" style=""><?php echo rsvp_pro_get_admin_string( 'attendee_label' ); ?></a> &nbsp;
					<a href="<?php echo admin_url( 'admin.php?page=rsvp-pro-top-level&action=' . ( ( $showAll ) ? 'all_attendees' : 'attendees' ) . "&eventID=$eventID&sort=attendee&amp;sortDirection=asc&pagesize=$limit&pagenum=$pagenum" ); ?>">
						<img src="<?php echo( ( ( $sort == 'attendee' ) && ( $sortDirection == 'asc' ) ) ? $uparrow_active : $uparrow ); ?>" width="11" height="9"
							alt="Sort Ascending Attendee Status" title="Sort Ascending Attendee Status" border="0"></a> &nbsp;
					<a href="<?php echo admin_url( 'admin.php?page=rsvp-pro-top-level&action=' . ( ( $showAll ) ? 'all_attendees' : 'attendees' ) . "&eventID=$eventID&sort=attendee&amp;sortDirection=desc&pagesize=$limit&pagenum=$pagenum" ); ?>">
						<img src="<?php echo( ( ( $sort == 'attendee' ) && ( $sortDirection == 'desc' ) ) ? $downarrow_active : $downarrow ); ?>" width="11" height="9"
							alt="Sort Descending Attendee Status" title="Sort Descending Attendee Status" border="0"></a>
					</th>
						<?php
					}

					if ( in_array( 'rsvp_status', $attendee_list_columns ) ) {
						?>
					<th scope="col" id="rsvpStatus" class="manage-column column-title" style=""><?php echo rsvp_pro_get_frontend_string( 'rsvp_status_label' ); ?> &nbsp;
					<a href="<?php echo admin_url( 'admin.php?page=rsvp-pro-top-level&action=' . ( ( $showAll ) ? 'all_attendees' : 'attendees' ) . "&eventID=$eventID&sort=rsvpStatus&amp;sortDirection=asc&pagesize=$limit&pagenum=$pagenum" ); ?>">
						<img src="<?php echo( ( ( $sort == 'rsvpStatus' ) && ( $sortDirection == 'asc' ) ) ? $uparrow_active : $uparrow ); ?>" width="11" height="9"
							alt="Sort Ascending RSVP Status" title="Sort Ascending RSVP Status" border="0"></a> &nbsp;
					<a href="<?php echo admin_url( 'admin.php?page=rsvp-pro-top-level&action=' . ( ( $showAll ) ? 'all_attendees' : 'attendees' ) . "&eventID=$eventID&sort=rsvpStatus&amp;sortDirection=desc&pagesize=$limit&pagenum=$pagenum" ); ?>">
						<img src="<?php echo( ( ( $sort == 'rsvpStatus' ) && ( $sortDirection == 'desc' ) ) ? $downarrow_active : $downarrow ); ?>" width="11" height="9"
							alt="Sort Descending RSVP Status" title="Sort Descending RSVP Status" border="0"></a>
					</th>
						<?php
					}

					if ( in_array( 'rsvp_date', $attendee_list_columns ) ) {
						?>
					<th scope="col" id="rsvpDate" class="manage-column column-title"><?php echo rsvp_pro_get_admin_string( 'rsvp_date_label' ); ?> &nbsp;
					<a href="<?php echo admin_url( 'admin.php?page=rsvp-pro-top-level&action=' . ( ( $showAll ) ? 'all_attendees' : 'attendees' ) . "&eventID=$eventID&sort=rsvpDate&amp;sortDirection=asc&pagesize=$limit&pagenum=$pagenum" ); ?>">
						<img src="<?php echo( ( ( $sort == 'rsvpDate' ) && ( $sortDirection == 'asc' ) ) ? $uparrow_active : $uparrow ); ?>" width="11" height="9"
							alt="Sort Ascending RSVP Date" title="Sort Ascending RSVP Date" border="0"></a> &nbsp;
					<a href="<?php echo admin_url( 'admin.php?page=rsvp-pro-top-level&action=' . ( ( $showAll ) ? 'all_attendees' : 'attendees' ) . "&eventID=$eventID&sort=rsvpDate&amp;sortDirection=desc&pagesize=$limit&pagenum=$pagenum" ); ?>">
						<img src="<?php echo( ( ( $sort == 'rsvpDate' ) && ( $sortDirection == 'desc' ) ) ? $downarrow_active : $downarrow ); ?>" width="11" height="9"
							alt="Sort Descending RSVP Date" title="Sort Descending RSVP Date" border="0"></a></th>
						<?php
					}

					if ( in_array( 'email', $attendee_list_columns ) ) {
						?>
					<th scope="col" id="rsvpEmail" class="manage-column column-email"><?php echo rsvp_pro_get_frontend_string( 'email_label' ); ?></th>
						<?php
					}

					if ( in_array( 'checked_in', $attendee_list_columns ) && ( ( rsvp_pro_get_event_option( $eventID, RSVP_PRO_OPTION_ALLOW_CHECKINS ) === 'Y' ) ||
						( $isSubEvent && ( rsvp_pro_get_event_option( $parentEventID, RSVP_PRO_OPTION_ALLOW_CHECKINS ) === 'Y' ) ) ) ) {
						?>
							<th scope="col" id="checked_in" class="manage-column column-title"><?php echo rsvp_pro_get_admin_string( 'checked_in_label' ); ?> &nbsp;
								<a href="<?php echo admin_url( 'admin.php?page=rsvp-pro-top-level&action=' . ( ( $showAll ) ? 'all_attendees' : 'attendees' ) . "&eventID=$eventID&sort=checked_in&amp;sortDirection=asc&pagesize=$limit&pagenum=$pagenum" ); ?>">
									<img src="<?php echo( ( ( $sort == 'checked_in' ) && ( $sortDirection == 'asc' ) ) ? $uparrow_active : $uparrow ); ?>" width="11" height="9"
										alt="Sort Ascending Checked In" title="Sort Ascending Checked In" border="0"></a> &nbsp;
								<a href="<?php echo admin_url( 'admin.php?page=rsvp-pro-top-level&action=' . ( ( $showAll ) ? 'all_attendees' : 'attendees' ) . "&eventID=$eventID&sort=checked_in&amp;sortDirection=desc&pagesize=$limit&pagenum=$pagenum" ); ?>">
									<img src="<?php echo( ( ( $sort == 'checked_in' ) && ( $sortDirection == 'desc' ) ) ? $downarrow_active : $downarrow ); ?>" width="11" height="9"
										alt="Sort Descending Checked In" title="Sort Descending Checked In" border="0"></a></th>
						<?php
					}

					if ( ! $isSubEvent && in_array( 'additional_attendee', $attendee_list_columns ) ) {
						?>
						<th scope="col" id="additionalAttendee" class="manage-column column-title" style=""><?php echo rsvp_pro_get_admin_string( 'additional_attendee_label' ); ?>       &nbsp;
									<a href="<?php echo admin_url( 'admin.php?page=rsvp-pro-top-level&action=' . ( ( $showAll ) ? 'all_attendees' : 'attendees' ) . "&eventID=$eventID&sort=additional&amp;sortDirection=asc&pagesize=$limit&pagenum=$pagenum" ); ?>">
										<img src="<?php echo( ( ( $sort == 'additional' ) && ( $sortDirection == 'asc' ) ) ? $uparrow_active : $uparrow ); ?>" width="11" height="9"
											alt="Sort Ascending Additional Attendees Status" title="Sort Ascending Additional Attendees Status" border="0"></a> &nbsp;
									<a href="<?php echo admin_url( 'admin.php?page=rsvp-pro-top-level&action=' . ( ( $showAll ) ? 'all_attendees' : 'attendees' ) . "&eventID=$eventID&sort=additional&amp;sortDirection=desc&pagesize=$limit&pagenum=$pagenum" ); ?>">
										<img src="<?php echo( ( ( $sort == 'additional' ) && ( $sortDirection == 'desc' ) ) ? $downarrow_active : $downarrow ); ?>" width="11" height="9"
											alt="Sort Descending Additional Attendees Status" title="Sort Descending Additional Atttendees Status" border="0"></a>
						</th>
						<?php
					}

					if ( ! $isSubEvent && in_array( 'note', $attendee_list_columns ) ) {
						?>
						<th scope="col" id="note" class="manage-column column-title" style=""><?php echo rsvp_pro_get_admin_string( 'note_label' ); ?></th>
						<?php
					}

					if ( rsvp_pro_require_passcode( $eventID ) && in_array( 'passcode', $attendee_list_columns ) ) {
						?>
						<th scope="col" id="passcode" class="manage-column column-title" style=""><?php echo rsvp_pro_get_frontend_string( 'passcode_label' ); ?>&nbsp;
						<a href="<?php echo admin_url( 'admin.php?page=rsvp-pro-top-level&action=' . ( ( $showAll ) ? 'all_attendees' : 'attendees' ) . "&eventID=$eventID&sort=passcode&amp;sortDirection=asc&pagesize=$limit&pagenum=$pagenum" ); ?>">
							<img src="<?php echo( ( ( $sort == 'passcode' ) && ( $sortDirection == 'asc' ) ) ? $uparrow_active : $uparrow ); ?>" width="11" height="9"
								alt="Sort Ascending Passcode" title="Sort Ascending Passcode" border="0"></a> &nbsp;
						<a href="<?php echo admin_url( 'admin.php?page=rsvp-pro-top-level&action=' . ( ( $showAll ) ? 'all_attendees' : 'attendees' ) . "&eventID=$eventID&sort=passcode&amp;sortDirection=desc&pagesize=$limit&pagenum=$pagenum" ); ?>">
							<img src="<?php echo( ( ( $sort == 'passcode' ) && ( $sortDirection == 'desc' ) ) ? $downarrow_active : $downarrow ); ?>" width="11" height="9"
								alt="Sort Descending Passcode" title="Sort Descending Passcode" border="0"></a></th>
						<?php
					}

					$sql = 'SELECT id, question FROM ' . PRO_QUESTIONS_TABLE . '
							WHERE rsvpEventID = %d
							ORDER BY sortOrder, id';
					$qRs = $wpdb->get_results( $wpdb->prepare( $sql, $eventID ) );
					if ( count( $qRs ) > 0 ) {
						foreach ( $qRs as $q ) {
							if ( in_array( 'custom_question_' . $q->id, $attendee_list_columns ) ) {
								?>
							<th scope="col" class="manage-column -column-title"><?php echo esc_html( rsvp_pro_admin_prepare_custom_question_for_display( $q->question ) ); ?>
								<a href="<?php echo admin_url( 'admin.php?page=rsvp-pro-top-level&action=' . ( ( $showAll ) ? 'all_attendees' : 'attendees' ) . "&eventID=$eventID&sort=cq_" . $q->id . "&amp;sortDirection=asc&pagesize=$limit&pagenum=$pagenum" ); ?>">
								<img src="<?php echo( ( ( $sort == 'cq_' . $q->id ) && ( $sortDirection == 'asc' ) ) ? $uparrow_active : $uparrow ); ?>" width="11" height="9" alt="Sort Ascending" title="Sort Ascending" border="0"></a> &nbsp;
								<a href="<?php echo admin_url( 'admin.php?page=rsvp-pro-top-level&action=' . ( ( $showAll ) ? 'all_attendees' : 'attendees' ) . "&eventID=$eventID&sort=cq_" . $q->id . "&amp;sortDirection=desc&pagesize=$limit&pagenum=$pagenum" ); ?>">
								<img src="<?php echo( ( ( $sort == 'cq_' . $q->id ) && ( $sortDirection == 'desc' ) ) ? $downarrow_active : $downarrow ); ?>" width="11" height="9" alt="Sort Descending" title="Sort Descending" border="0"></a>
							</th>
								<?php
							}
						}
					}

					if ( in_array( 'associated_attendees', $attendee_list_columns ) ) {
						?>
						<th scope="col" id="associatedAttendees" class="manage-column column-title" style=""><?php echo rsvp_pro_get_frontend_string( 'associated_attendees_label' ); ?></th>
					<?php } ?>
					</tr>
				</thead>
				<tbody>
				<?php
				$i = 0;
				foreach ( $attendees as $attendee ) {
					?>
					<tr class="<?php echo( ( $i % 2 == 0 ) ? 'alternate' : '' ); ?> author-self">
						<th scope="row" class="check-column"><input type="checkbox" name="attendee[]" value="<?php echo $attendee->id; ?>" /></th>
						<?php if ( in_array( 'attendee_name', $attendee_list_columns ) ) { ?>
						<td>
							<a href="<?php echo admin_url( "admin.php?page=rsvp-pro-top-level&action=modify_attendee&eventID=$eventID&id=$attendee->id" ); ?>">
								<?php echo htmlentities( stripslashes( $attendee->firstName ) . ' ' . stripslashes( $attendee->lastName ) ); ?></a>
						</td>
							<?php
						}

						if ( in_array( 'rsvp_status', $attendee_list_columns ) ) {
							?>
							<td><?php echo rsvp_pro_humanize_rsvp_status( $attendee->rsvpStatus, $eventID ); ?></td>
							<?php
						}

						if ( in_array( 'rsvp_date', $attendee_list_columns ) ) {
							?>
							<td>
							<?php
							if ( ! empty( $attendee->rsvpDate ) && ( $attendee->rsvpDate !== '0000-00-00' ) ) {
								echo date_i18n( get_option( 'date_format' ), strtotime( $attendee->rsvpDate ) );
							}
							?>
							</td>
							<?php
						}

						if ( in_array( 'email', $attendee_list_columns ) ) {
							?>
							<td><?php echo esc_attr( stripslashes( $attendee->email ) ); ?></td>
							<?php
						}

						if ( in_array( 'checked_in', $attendee_list_columns ) && ( ( rsvp_pro_get_event_option( $eventID, RSVP_PRO_OPTION_ALLOW_CHECKINS ) === 'Y' ) ||
							  ( $isSubEvent && ( rsvp_pro_get_event_option( $parentEventID, RSVP_PRO_OPTION_ALLOW_CHECKINS ) === 'Y' ) ) ) ) {
							?>
							<td>
								<?php echo( ( $attendee->checked_in == 'Y' ) ? rsvp_pro_get_frontend_string( 'yes_text' ) : rsvp_pro_get_frontend_string( 'no_text' ) ); ?>
							</td>
							<?php
						}

						if ( ! $isSubEvent && in_array( 'additional_attendee', $attendee_list_columns ) ) {
							?>
							<td>
							<?php
							if ( $attendee->rsvpStatus == 'NoResponse' ) {
								echo '--';
							} else {
								echo( ( $attendee->additionalAttendee == 'Y' ) ? rsvp_pro_get_frontend_string( 'yes_text' ) : rsvp_pro_get_frontend_string( 'no_text' ) );
							}
							?>
							</td>
							<?php
						}

						if ( ! $isSubEvent && in_array( 'note', $attendee_list_columns ) ) {
							?>
							<td><?php echo nl2br( esc_html( stripslashes( trim( $attendee->note ) ) ) ); ?></td>
							<?php
						}
						if ( rsvp_pro_require_passcode( $eventID ) && in_array( 'passcode', $attendee_list_columns ) ) {
							?>
							<td><?php echo $attendee->passcode; ?></td>
							<?php
						}
						$sql = 'SELECT question, answer, q.id FROM ' . PRO_QUESTIONS_TABLE . ' q
									LEFT JOIN ' . PRO_ATTENDEE_ANSWERS . ' ans ON q.id = ans.questionID AND ans.attendeeID = %d
									WHERE rsvpEventID = %d
									ORDER BY q.sortOrder, q.id';
						$aRs = $wpdb->get_results( $wpdb->prepare( $sql, $attendee->id, $eventID ) );
						if ( count( $aRs ) > 0 ) {
							foreach ( $aRs as $a ) {
								if ( in_array( 'custom_question_' . $a->id, $attendee_list_columns ) ) {
									?>
								<td><?php echo esc_html( str_replace( '||', ', ', stripslashes( $a->answer ) ) ); ?></td>
									<?php
								}
							}
						}

						if ( in_array( 'associated_attendees', $attendee_list_columns ) ) {
							?>
							<td>
							<?php
							if ( $isSubEvent ) {
								$sql = 'SELECT firstName, lastName FROM ' . PRO_ATTENDEES_TABLE . ' a
									LEFT JOIN ' . PRO_EVENT_TABLE . ' e ON e.id = %d
									WHERE ( (a.rsvpEventID = %d ) '; 

								if ( true === $global_attendee_list_enabled ) {
									$sql .= ' OR ( a.rsvpEventID = ' . RSVP_PRO_GLOBAL_ATTENDEE_EVENT_ID . ' ) ';
								}

								$sql         .= ' ) AND (a.id IN (SELECT attendeeID FROM ' . PRO_ASSOCIATED_ATTENDEES_TABLE . ' WHERE associatedAttendeeID = %d)
										OR a.id in (SELECT associatedAttendeeID FROM ' . PRO_ASSOCIATED_ATTENDEES_TABLE . " WHERE attendeeID = %d)) AND
										(
											(IFNULL(e.event_access, '" . RSVP_PRO_OPEN_EVENT_ACCESS . "') != '" . RSVP_PRO_PRIVATE_EVENT_ACCESS . "') OR
											(a.id IN (SELECT rsvpAttendeeID FROM " . PRO_EVENT_ATTENDEE_TABLE . ' WHERE rsvpEventID = %d))
										)';
								$associations = $wpdb->get_results( $wpdb->prepare( $sql, $eventID, $parentEventID, $attendee->id, $attendee->id, $eventID ) );
							} else {
								$sql = 'SELECT firstName, lastName FROM ' . PRO_ATTENDEES_TABLE . ' a
									JOIN ' . PRO_EVENT_TABLE . ' e ON e.id = a.rsvpEventID
									WHERE (a.id IN (SELECT attendeeID FROM ' . PRO_ASSOCIATED_ATTENDEES_TABLE . ' WHERE associatedAttendeeID = %d)
										OR a.id in (SELECT associatedAttendeeID FROM ' . PRO_ASSOCIATED_ATTENDEES_TABLE . " WHERE attendeeID = %d)) AND
										(
											(IFNULL(e.event_access, '" . RSVP_PRO_OPEN_EVENT_ACCESS . "') != '" . RSVP_PRO_PRIVATE_EVENT_ACCESS . "') OR
											(a.id IN (SELECT rsvpAttendeeID FROM " . PRO_EVENT_ATTENDEE_TABLE . ' WHERE rsvpEventID = %d))
										)';
								if ( $showAll ) {
									$sql          = 'SELECT firstName, lastName FROM ' . PRO_ATTENDEES_TABLE . ' a
										JOIN ' . PRO_EVENT_TABLE . ' e ON e.id = a.rsvpEventID
										WHERE (a.id IN (SELECT attendeeID FROM ' . PRO_ASSOCIATED_ATTENDEES_TABLE . ' WHERE associatedAttendeeID = %d)
											OR a.id in (SELECT associatedAttendeeID FROM ' . PRO_ASSOCIATED_ATTENDEES_TABLE . ' WHERE attendeeID = %d)) ';
									$associations = $wpdb->get_results( $wpdb->prepare( $sql, $attendee->id, $attendee->id ) );
								} else {
									$associations = $wpdb->get_results( $wpdb->prepare( $sql, $attendee->id, $attendee->id, $eventID ) );
								}
							}
							foreach ( $associations as $a ) {
								echo esc_html( stripslashes( $a->firstName . ' ' . $a->lastName ) ) . '<br />';
							}
							?>
							</td>
							<?php
						}
						?>
						</tr>
					<?php
					$i++;
				}
				?>
				</tbody>
				</table>
				</form>
				<?php
				if ( $page_links && ( $limit != 'all' ) ) {
					?>
						<div class="tablenav">
							<div class="alignright" style="margin: 1em 0">
								<div class="alignleft">
									<form action="<?php echo admin_url( 'admin.php' ); ?>">
										<input type="hidden" name="page" value="rsvp-pro-top-level" />
										<input type="hidden" name="action" value="attendees" />
										<input type="hidden" name="eventID" value="<?php echo $eventID; ?>" />
										<input type="hidden" name="sort" value="<?php echo esc_html( $sort ); ?>" />
										<input type="hidden" name="sortDirection" value="<?php echo esc_html( $sortDirection ); ?>" />
										<?php
										foreach ( $previous_searches as $s ) {
											?>
											<input type="hidden" name="prev_searches[]" value="<?php echo esc_attr( implode( ',', $s ) ); ?>" />
											<?php
										}
										?>
									<label>
										<?php echo rsvp_pro_get_admin_string( 'results_page_label' ); ?>
										<select name="pagesize" size="1" class="pagesize-selector">
											<option value="25" <?php echo ( $limit == 25 ) ? 'selected="selected"' : ''; ?> ><?php echo rsvp_pro_get_admin_string( 'result_25' ); ?></option>
											<option value="50" <?php echo ( $limit == 50 ) ? 'selected="selected"' : ''; ?>><?php echo rsvp_pro_get_admin_string( 'result_50' ); ?></option>
											<option value="100" <?php echo ( $limit == 100 ) ? 'selected="selected"' : ''; ?>><?php echo rsvp_pro_get_admin_string( 'result_100' ); ?></option>
											<option value="all" <?php echo ( $limit == 'all' ) ? 'selected="selected"' : ''; ?>><?php echo rsvp_pro_get_admin_string( 'result_all' ); ?></option>
										</select>
									</label>
									</form>
								</div>
								<div class="tablenav-pages"><?php echo $page_links; ?></div>
							</div>
						</div>
					<?php
				}
				?>
		</div>
	<?php
}
