<?php
class Rsvp_Pro_Event_List_Widget extends WP_Widget {


	/**
	 * Sets up the widgets name etc
	 */
	public function __construct() {
		$widget_ops = array(
			'classname'   => 'rsvp_pro_event_list_widget',
			'description' => rsvp_pro_get_frontend_string( 'event_list_header' ),
		);
		parent::__construct( 'rsvp_pro_event_list_widget', rsvp_pro_get_frontend_string( 'event_list_header' ), $widget_ops );
	}

	/**
	 * Outputs the content of the widget
	 *
	 * @param array $args
	 * @param array $instance
	 */
	public function widget( $args, $instance ) {
		global $wpdb;

		$title = apply_filters( 'widget_title', empty( $instance['title'] ) ? $format_string : $instance['title'], $instance, $this->id_base );

		$tmp_content_width        = $GLOBALS['content_width'];
		$GLOBALS['content_width'] = 306;

		echo $args['before_widget']; ?>
		<h1 class="widget-title"><?php echo esc_html( $title ); ?></h1>
		<?php
		$sql    = 'SELECT id, eventName, open_date, close_date, close_date_time, event_access, eventStartDate, eventLocation, eventEndDate,
			 (SELECT COUNT(*) FROM ' . PRO_ATTENDEES_TABLE . " WHERE rsvpEventID = e.id AND rsvpStatus = 'Yes') AS yesCount,
			 (SELECT COUNT(*) FROM " . PRO_ATTENDEES_TABLE . " WHERE rsvpEventID = e.id AND rsvpStatus = 'No') AS noCount,
			 (SELECT COUNT(*) FROM " . PRO_ATTENDEES_TABLE . " WHERE rsvpEventID = e.id AND rsvpStatus = 'NoResponse') AS noResponseCount
		FROM " . PRO_EVENT_TABLE . " e
		WHERE (parentEventID IS NULL OR parentEventID = 0) AND event_access != 'select'
		ORDER BY close_date, eventStartDate ";
		$events = $wpdb->get_results( $sql );

		// Will be used when displaying the time information in the event list
		$time_zone = new DateTimeZone( rsvp_pro_wp_get_timezone_string() );

		foreach ( $events as $e ) {
			if ( ! rsvp_pro_is_event_closed( $e->id ) ) {
				// Get the page that is linked....
				$queryString = array(
					's'        => '[rsvppro id="' . $e->id . '"]',
					'sentence' => 1,
				);
				$query       = new WP_Query( $queryString );
				$url         = '';
				if ( $query->have_posts() ) {
					$query->the_post();
					$url = get_permalink();
				}
				wp_reset_postdata();
				?>
				<div class="rsvp_pro_width_event">
					<p>
					<?php
					if ( ! empty( $url ) ) {
						?>
						<a href="<?php echo $url; ?>">
						<?php
					}
					esc_html_e( stripslashes( $e->eventName ) );

					if ( ! empty( $url ) ) {
						?>
						</a>
						<?php
					}
					?>
					</p>
				</div>
				<?php
			}
		}

		echo $args['after_widget'];
	}

	/**
	 * Outputs the options form on admin
	 *
	 * @param array $instance The widget options
	 */
	public function form( $instance ) {
		$title = empty( $instance['title'] ) ? '' : esc_attr( $instance['title'] );
		?>
			<p><label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php echo rsvp_pro_get_frontend_string( 'title_label' ); ?>:</label>
			<input id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" class="widefat" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>"></p>
		<?php
	}

	/**
	 * Processing widget options on save
	 *
	 * @param array $new_instance The new options
	 * @param array $old_instance The previous options
	 */
	public function update( $new_instance, $old_instance ) {
		$instance['title'] = strip_tags( $new_instance['title'] );

		return $instance;
	}
}

function rsvp_pro_register_event_list_widget() {
	register_widget( 'Rsvp_Pro_Event_List_Widget' );
}
add_action( 'widgets_init', 'rsvp_pro_register_event_list_widget' );
