<?php
/**
 * Additional Attendee JS Functions
 *
 * @package rsvp-pro
 * @author Swim or Die Software
 * @since 2.1.6
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Outputs the JavaScript for the normal attendee form process
 *
 * @param  int    $rsvpId     The event ID that we want to output the additional JavaScript for.
 * @param  result $attendee   The main attendee we are adding the additional attendee to.
 * @param  int    $attendeeID The main attendee's ID.
 * @return none.
 */
function rsvp_pro_output_additional_js( $rsvpId, $attendee, $attendeeID ) {
	if ( rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_HIDE_ADDITIONAL ) != 'Y' ) {
		$yesText              = rsvp_pro_get_frontend_string( 'yes_text' );
		$noText               = rsvp_pro_get_frontend_string( 'no_text' );
		$maybe_text           = rsvp_pro_get_frontend_string( 'maybe_text' );
		$waitlistText         = rsvp_pro_get_frontend_string( 'waitlist_text' );
		$noResponseText       = rsvp_pro_get_frontend_string( 'noresponse_text' );
		$hasAccessToMainEvent = does_user_have_access_to_event( $rsvpId, $attendeeID );
		$salutation           = rsvp_pro_get_frontend_string( 'salutation_text' );
		$firstName            = rsvp_pro_get_frontend_string( 'first_name_label' );
		$passcode_label       = rsvp_pro_get_frontend_string( 'attendee_passcode_label' );
		$lastName             = rsvp_pro_get_frontend_string( 'last_name_label' );
		$suffix               = rsvp_pro_get_frontend_string( 'suffix_label' );
		$email                = rsvp_pro_get_frontend_string( 'email_label' );
		$removeButton         = rsvp_pro_get_frontend_string( 'remove_guest_label' );
		$js_email_validation  = rsvp_pro_get_frontend_string( 'javascript_email_validation' );

		if ( rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_YES_VERBIAGE ) != '' ) {
			$yesText = rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_YES_VERBIAGE );
		}
		$yesText = apply_filters( 'rsvp_yes_associated', $yesText, null, $rsvpId );

		if ( rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_NO_VERBIAGE ) != '' ) {
			$noText = rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_NO_VERBIAGE );
		}
		$noText = apply_filters( 'rsvp_no_associated', $noText, null, $rsvpId );

		if ( rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_WAITLIST_VERBIAGE ) != '' ) {
			$waitlistText = rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_WAITLIST_VERBIAGE );
		}
		$waitlistText = apply_filters( 'rsvp_waitlist_associated', $waitlistText, null, $rsvpId );

		if ( rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_MAYBE_VERBIAGE ) != '' ) {
			$maybe_text = rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_MAYBE_VERBIAGE );
		}
		$maybe_text = apply_filters( 'rsvp_maybe_associated', $maybe_text, null, $rsvpId );

		if ( rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_NO_RESPONSE_TEXT ) != '' ) {
			$noResponseText = rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_NO_RESPONSE_TEXT );
		}
		$noResponseText = apply_filters( 'rsvp_no_response_associated', $noResponseText, null, $rsvpId );

		if ( rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_SALUTATION_LABEL ) != '' ) {
			$salutation = rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_SALUTATION_LABEL );
		}

		if ( rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_FIRST_NAME_LABEL ) != '' ) {
			$firstName = rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_FIRST_NAME_LABEL );
		}

		if ( rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_LAST_NAME_LABEL ) != '' ) {
			$lastName = rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_LAST_NAME_LABEL );
		}

		if ( rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_SUFFIX_LABEL ) != '' ) {
			$suffix = rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_SUFFIX_LABEL );
		}

		if ( rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_PASSCODE_EDITABLE_LABEL ) != '' ) {
			$passcode_label = rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_PASSCODE_EDITABLE_LABEL );
		}

		if ( rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_EMAIL_LABEL ) != '' ) {
			$email = rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_EMAIL_LABEL );
		}

		if ( rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_REMOVE_ATTENDEE_BUTTON_TEXT ) != '' ) {
			$removeButton = rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_REMOVE_ATTENDEE_BUTTON_TEXT );
		}

		$greeting = rsvp_pro_get_frontend_string( 'additional_attendee_greeting_text' );
		if ( rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_ADDITIONAL_GREETING_TEXT ) != '' ) {
			$greeting = rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_ADDITIONAL_GREETING_TEXT );
		}

		$numGuests = 3;
		if ( rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_NUM_ADDITIONAL_GUESTS ) != '' ) {
			$numGuests = rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_NUM_ADDITIONAL_GUESTS );
			if ( ! is_numeric( $numGuests ) || ( $numGuests < 0 ) ) {
				$numGuests = 3;
			}
		}

		if ( ( $attendee !== null ) && ( $attendee->numGuests > 0 ) ) {
			$numGuests = $attendee->numGuests;
		}
		$default_status = 'Noresponse';
		if ( rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_DEFAULT_RSVP_VALUE ) !== '' ) {
			$default_status = ucfirst( rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_DEFAULT_RSVP_VALUE ) );
		}

		if ( rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_EMAIL_JS_MESSAGE ) !== '' ) {
			$js_email_validation = rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_EMAIL_JS_MESSAGE );
		}

		ob_start();
		$rsvp_form_js_ids = array();
		?>
		<script type="text/javascript" language="javascript">
			var rsvp_pro_max_guests = <?php echo $numGuests; ?>;
			function handleAddRsvpClick() {
				var numAdditional = jQuery("#additionalProRsvp").val();
				numAdditional++;
				if(numAdditional > <?php echo $numGuests; ?>) {
					<?php
						$alert_text = sprintf( rsvp_pro_get_frontend_string( 'additional_max_alert_text' ), $numGuests );
					?>
					alert('<?php echo esc_html( $alert_text ); ?>');
				} else {
					var additionalId = Math.random().toString(36).substring(2, 7);
					jQuery("#additionalRsvpContainer").append("<div class=\"rsvpAdditionalAttendee\">" +
						"<div class=\"rsvpAdditionalAttendeeQuestions\">" +
					<?php
					if ( $hasAccessToMainEvent ) {
							$required = '';
						if ( rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_RSVP_REQUIRED ) == 'Y' ) {
							$required = ' required';
						}

						if ( rsvp_pro_frontend_max_limit_hit( $rsvpId ) ) {
							$required .= ' disabled=\\"true\\"';
						}

							$rsvp_js_id               = uniqid();
							$rsvp_form_js_ids['main'] = $rsvp_js_id . '|| + additionalId + ||';
						if ( rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_RSVP_HIDE ) === 'Y' ) {
							?>
								"<input type=\"hidden\" name=\"newAttending" + additionalId + "\" data-rsvp-js-id=\"<?php echo $rsvp_js_id; ?>" + additionalId + "\" value=\"<?php echo rsvp_pro_translate_status_to_form_value( $default_status ); ?>\" id=\"newAttending" + additionalId + "Y\" class=\"rsvpStatusInput\" />" +
							<?php
						} else {
							?>
								"<div class=\"rsvpFormField rsvpRsvpGreeting\">" +
								"<h4><?php echo addslashes( str_replace( "\r\n", '', nl2br( $greeting ) ) ); ?></h4>" +
								"<div class=\"rsvpFormField rsvpRsvpQuestionArea\">" +
									"<input type=\"radio\" name=\"newAttending" + additionalId + "\" data-rsvp-js-id=\"<?php echo $rsvp_js_id; ?>" + additionalId + "\" value=\"Y\" id=\"newAttending" + additionalId + "Y\" <?php echo $required; ?> <?php echo ( ( $default_status === 'Yes' ) ? 'checked=\\"checked\\"' : '' ); ?> class=\"rsvpStatusInput\" />" +
									" <label for=\"newAttending" + additionalId + "Y\"><?php echo addslashes( $yesText ); ?></label></div> " +
							<?php
							if ( rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_ENABLE_MAYBE ) == 'Y' ) {
								?>
									"<div class=\"rsvpFormField rsvpRsvpQuestionArea\">" +
										"<input type=\"radio\" name=\"newAttending" + additionalId + "\" data-rsvp-js-id=\"<?php echo $rsvp_js_id; ?>" + additionalId + "\" value=\"M\" id=\"newAttending" + additionalId + "Maybe\" <?php echo ( ( $default_status === 'Maybe' ) ? 'checked=\\"checked\\"' : '' ); ?> class=\"rsvpStatusInput\" /> <label for=\"newAttending" + additionalId + "Maybe\"><?php echo esc_html( $maybe_text ); ?></label></div>" +
								<?php
							}
							?>
								"<div class=\"rsvpFormField rsvpRsvpQuestionArea\">" +
									"<input type=\"radio\" name=\"newAttending" + additionalId + "\" data-rsvp-js-id=\"<?php echo $rsvp_js_id; ?>" + additionalId + "\" value=\"N\" id=\"newAttending" + additionalId + "N\" <?php echo ( ( $default_status === 'No' ) ? 'checked=\\"checked\\"' : '' ); ?> class=\"rsvpStatusInput\" /> <label for=\"newAttending" + additionalId + "N\"><?php echo addslashes( $noText ); ?></label></div>" +
								<?php
								if ( ( rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_ENABLE_WAITLIST ) == 'Y' ) && rsvp_pro_frontend_max_limit_hit( $rsvpId ) ) {
									?>
									"<div class=\"rsvpFormField rsvpRsvpQuestionArea\">" +
										"<input type=\"radio\" name=\"newAttending" + additionalId + "\" data-rsvp-js-id=\"<?php echo $rsvp_js_id; ?>" + additionalId + "\" value=\"W\" id=\"newAttending" + additionalId + "Waitlist\" <?php echo ( ( $default_status === 'Waitlist' ) ? 'checked=\\"checked\\"' : '' ); ?> class=\"rsvpStatusInput\" /> <label for=\"newAttending" + additionalId + "Waitlist\"><?php echo esc_html( $waitlistText ); ?></label></div>" +
									<?php
								}

								if ( rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_SHOW_NORESPONSE_FOR_ASSOCIATED ) == 'Y' ) {
									?>
									"<div class=\"rsvpFormField rsvpRsvpQuestionArea\">" +
										"<input type=\"radio\" name=\"newAttending" + additionalId + "\" value=\"NoResponse\" id=\"newAttending" + additionalId + "NoResponse\" <?php echo ( ( $default_status === 'Noresponse' ) ? 'checked=\\"checked=\\"' : '' ); ?> class=\"rsvpStatusInput\" /> <label for=\"newAttending" + additionalId + "NoResponse\"><?php echo esc_html( $noResponseText ); ?></label></div>" +
									<?php
								}
								?>

								"</div>" +
							<?php
						}
					} // if ($hasAccessToMain...)

					if ( rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_SHOW_SALUTATION ) == 'Y' ) {
						?>
						"<div class=\"rsvpFormField\">" +
						"   <label for=\"newAttending" + additionalId + "Salutation\"><?php echo esc_html( $salutation ); ?></label>" +
						"   <select name=\"newAttending" + additionalId + "Salutation\" id=\"newAttending" + additionalId + "Salutation\" size=\"1\"><option value=\"\">--</option>" +
						<?php
						$salutations = rsvp_pro_get_salutation_options( $rsvpId );
						foreach ( $salutations as $s ) {
							?>
							"<option value=\"<?php echo esc_html( $s ); ?>\"><?php echo esc_html( $s ); ?></option>" +
							<?php
						}
						?>
						"</select></div>" +
						<?php
					}
					?>

						"<div class=\"rsvpFormField\">" +
						"   <label for=\"newAttending" + additionalId + "FirstName\"><?php echo esc_html( $firstName ); ?></label>" +
						"   <input type=\"text\" name=\"newAttending" + additionalId + "FirstName\" id=\"newAttending" + additionalId + "FirstName\" required=\"required\" />" +
						"</div>" +
						"<div class=\"rsvpFormField\">" +
						"   <label for=\"newAttending" + additionalId + "LastName\"><?php echo esc_html( $lastName ); ?></label>" +
						"  <input type=\"text\" name=\"newAttending" + additionalId + "LastName\" id=\"newAttending" + additionalId + "LastName\" <?php echo ( ( rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_LAST_NAME_NOT_REQUIRED ) !== 'Y' ) ? 'required=\"required\"' : '' ); ?> />" +
						"</div>" +

						<?php
						if ( rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_SHOW_SUFFIX ) === 'Y' ) {
							?>
							"<div class=\"rsvpFormField\">" +
							"   <label for=\"newAttending" + additionalId + "Suffix\"><?php echo esc_html( $suffix ); ?></label>" +
							"  <input type=\"text\" name=\"newAttending" + additionalId + "Suffix\" id=\"newAttending" + additionalId + "Suffix\" />" +
							"</div>" +
							<?php
						}

						if ( rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_PASSCODE_EDITABLE ) === 'Y' ) {
							?>
							"<div class=\"rsvpFormField\">" +
							"  <label for=\"newAttending" + additionalId + "Passcode\"><?php echo esc_html( $passcode_label ); ?></label>" +
							"  <input type=\"text\" name=\"newAttending" + additionalId + "Passcode\" id=\"newAttending" + additionalId + "Passcode\" required class=\"rsvpPasscodeField\" data-rule-rsvpProPasscodeUnique=\"true\" />" +
							"</div>" +
							<?php
						}

						if ( rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_HIDE_EMAIL_FIELD ) != 'Y' ) {
							?>
							"<div class=\"rsvpFormField\">" +
							"  <label for=\"newAttending" + additionalId + "Email\"><?php echo esc_html( $email ); ?></label>" +
							"  <input type=\"text\" name=\"newAttending" + additionalId + "Email\" id=\"newAttending" + additionalId + "Email\" <?php echo ( ( rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_EMAIL_REQUIRED ) == 'Y' ) ? 'required data-rule-email=\\"true\\" ' : '' ); ?> " + 
							" class=\"rsvpEmailField\" data-rule-rsvpProEmailUnique=\"true\" data-msg-required=\"<?php echo esc_attr( $js_email_validation ); ?>\" />" +
							"</div>" +
							<?php
						}

						$tmpVar = str_replace( "\r\n", '', str_replace( '||', '"', addSlashes( rsvp_pro_build_sub_event_main_form( 0, '|| + additionalId + ||', $rsvp_form_js_ids, false ) ) ) );
						?>

						"<?php echo $tmpVar; ?>" +
						<?php
						$tmpVar = str_replace( "\r\n", '', str_replace( '||', '"', addSlashes( rsvp_pro_buildAdditionalQuestions( 0, '|| + additionalId + ||', false, $rsvp_form_js_ids ) ) ) );
						?>

						"<?php echo $tmpVar; ?>" +
							"<p><button onclick=\"removeAdditionalRSVP(this);\" class=\"rsvpButton\"><?php echo esc_html( $removeButton ); ?></button></p>" +
						"</div>");
						jQuery("#additionalProRsvp").val(numAdditional);
						var additionalIds = jQuery("#additionalRsvpIds").val();
						additionalIds = additionalIds.split(",");
						additionalIds.push(additionalId);
						jQuery("#additionalRsvpIds").val(additionalIds.join());

						jQuery("#numAvailableToAdd").text(<?php echo $numGuests; ?> - numAdditional);
						jQuery(document).resize();
						wireup_rsvp_questions_for_custom_question_toggle();
						rsvpProWireUpCostCalculation();
						toggle_custom_questions_on_load();
					}
				}

				function removeAdditionalRSVP(rsvp) {
					var numAdditional = jQuery("#additionalProRsvp").val();
					numAdditional--;
					// TODO: rewrite this....or do we need to...
					jQuery(rsvp).parent().parent().remove();
					jQuery("#additionalProRsvp").val(numAdditional);
					jQuery("#numAvailableToAdd").text(<?php echo $numGuests; ?> - numAdditional);
					jQuery(document).resize();
					wireup_rsvp_questions_for_custom_question_toggle();
				}
			</script>
		<?php
		echo ob_get_clean();
	}
}

function rsvp_pro_wizard_output_additional_js( $rsvpId, $attendee, $attendeeID ) {
	$form = '';

	if ( rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_HIDE_ADDITIONAL ) != 'Y' ) {
		$numGuests           = get_number_additional( $rsvpId, $attendee );
		$salutation          = rsvp_pro_get_frontend_string( 'salutation_text' );
		$firstName           = rsvp_pro_get_frontend_string( 'first_name_label' );
		$lastName            = rsvp_pro_get_frontend_string( 'last_name_label' );
		$passcode_label      = rsvp_pro_get_frontend_string( 'attendee_passcode_label' );
		$suffix              = rsvp_pro_get_frontend_string( 'suffix_label' );
		$email               = rsvp_pro_get_frontend_string( 'email_label' );
		$removeGuest         = rsvp_pro_get_frontend_string( 'remove_guest_label' );
		$js_email_validation = rsvp_pro_get_frontend_string( 'javascript_email_validation' );

		if ( rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_SALUTATION_LABEL ) != '' ) {
				$salutation = rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_SALUTATION_LABEL );
		}

		if ( rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_FIRST_NAME_LABEL ) != '' ) {
				$firstName = rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_FIRST_NAME_LABEL );
		}

		if ( rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_LAST_NAME_LABEL ) != '' ) {
				$lastName = rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_LAST_NAME_LABEL );
		}

		if ( rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_SUFFIX_LABEL ) != '' ) {
				$suffix = rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_SUFFIX_LABEL );
		}

		if ( rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_EMAIL_LABEL ) != '' ) {
				$email = rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_EMAIL_LABEL );
		}

		if ( rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_PASSCODE_EDITABLE_LABEL ) != '' ) {
			$passcode_label = rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_PASSCODE_EDITABLE_LABEL );
		}

		if ( rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_REMOVE_ATTENDEE_BUTTON_TEXT ) != '' ) {
				$removeGuest = rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_REMOVE_ATTENDEE_BUTTON_TEXT );
		}

		if ( rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_EMAIL_JS_MESSAGE ) !== '' ) {
			$js_email_validation = rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_EMAIL_JS_MESSAGE );
		}
		ob_start();
		?>
		<script type="text/javascript" language="javascript">
			function handleAddWizardRsvpClick() {
				var numAdditional = jQuery("#additionalProRsvp").val();
				numAdditional++;
				if(numAdditional > <?php echo $numGuests; ?>) {
					<?php
						$alert_text = sprintf( rsvp_pro_get_frontend_string( 'additional_max_alert_text' ), $numGuests );
					?>
					alert('<?php echo esc_html( $alert_text ); ?>');
				} else {
					var additionalId = Math.random().toString(36).substring(2, 7);
					jQuery("#additionalRsvpContainer").append("<div class=\"rsvpAdditionalAttendee\">" +
						"<div class=\"rsvpAdditionalAttendeeQuestions\">" +
					<?php
					if ( rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_SHOW_SALUTATION ) == 'Y' ) {
						?>
						"<div class=\"rsvpFormField\">" +
						"   <label for=\"newAttending" + additionalId + "Salutation\"><?php esc_html( $salutation ); ?></label>" +
						"   <select name=\"newAttending" + additionalId + "Salutation\" id=\"newAttending" + additionalId + "Salutation\" size=\"1\"><option value=\"\">--</option>" +
						<?php
						$salutations = rsvp_pro_get_salutation_options( $rsvpId );
						foreach ( $salutations as $s ) {
							?>
					"<option value=\"<?php echo esc_html( $s ); ?>\"><?php echo esc_html( $s ); ?></option>" +
							<?php
						}
						?>
						"   </select></div>" +
						<?php
					}
					?>

					"<div class=\"rsvpFormField\">" +
					"   <label for=\"newAttending" + additionalId + "FirstName\"><?php echo esc_html( $firstName ); ?></label>" +
					"   <input type=\"text\" name=\"newAttending" + additionalId + "FirstName\" id=\"newAttending" + additionalId + "FirstName\" />" +
					"</div>" +
					"<div class=\"rsvpFormField\">" +
					"   <label for=\"newAttending" + additionalId + "LastName\"><?php echo esc_html( $lastName ); ?></label>" +
					"   <input type=\"text\" name=\"newAttending" + additionalId + "LastName\" id=\"newAttending" + additionalId + "LastName\" />" +
					"</div>" +

					<?php
					if ( rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_SHOW_SUFFIX ) == 'Y' ) {
						?>
						"<div class=\"rsvpFormField\">" +
						"  <label for=\"newAttending" + additionalId + "Suffix\"><?php echo esc_html( $suffix ); ?></label>" +
						"  <input type=\"text\" name=\"newAttending" + additionalId + "Suffix\" id=\"newAttending" + additionalId + "Suffix\" />" +
						"</div>" +
						<?php
					}

					if ( rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_PASSCODE_EDITABLE ) === 'Y' ) {
						?>
						"<div class=\"rsvpFormField\">" +
						"  <label for=\"newAttending" + additionalId + "Passcode\"><?php echo esc_html( $passcode_label ); ?></label>" +
						"  <input type=\"text\" name=\"newAttending" + additionalId + "Passcode\" id=\"newAttending" + additionalId + "Passcode\" required class=\"rsvpPasscodeField\" data-rule-rsvpProPasscodeUnique=\"true\" />" +
						"</div>" +
						<?php
					}

					if ( rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_HIDE_EMAIL_FIELD ) != 'Y' ) {
						?>
						"<div class=\"rsvpFormField\">" +
						"  <label for=\"newAttending" + additionalId + "Email\"><?php echo esc_html( $email ); ?></label>" +
						"  <input type=\"text\" name=\"newAttending" + additionalId + "Email\" id=\"newAttending" + additionalId + "Email\" <?php echo ( ( rsvp_pro_get_event_option( $rsvpId, RSVP_PRO_OPTION_EMAIL_REQUIRED ) == 'Y' ) ? 'required data-rule-email=\\"true\\" ' : '' ); ?> " + 
						" class=\"rsvpEmailField\" data-rule-rsvpProEmailUnique=\"true\" data-msg-required=\"<?php echo esc_attr( $js_email_validation ); ?>\" />" +
						"</div>" +
						<?php
					}
					?>

					"<p><button onclick=\"removeAdditionalRSVP(this);\"><?php echo esc_html( $removeGuest ); ?></button></p>" +
					"</div>");
					jQuery("#additionalProRsvp").val(numAdditional);
					var additionalIds = jQuery("#additionalRsvpIds").val();
					additionalIds = additionalIds.split(",");
					additionalIds.push(additionalId);
					jQuery("#additionalRsvpIds").val(additionalIds.join());
					jQuery("#numAvailableToAdd").text(<?php echo $numGuests; ?> - numAdditional);
					jQuery(document).resize();
				}
			}

			function removeAdditionalRSVP(rsvp) {
				var numAdditional = jQuery("#additionalProRsvp").val();
				numAdditional--;
				jQuery(rsvp).parent().parent().remove();
				jQuery("#additionalProRsvp").val(numAdditional);
				jQuery("#numAvailableToAdd").text(<?php echo $numGuests; ?> - numAdditional);
				jQuery(document).resize();
			}
		</script>
		<?php
		echo ob_get_clean();
	}
}
