<?php
/**
 * Class file that handles PayPal payment processing and settings.
 *
 * @since 4.1.5
 * @package rsvp-pro-plugin
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) :
	exit;
endif;

/**
 * Class for handling PayPal payment handling.
 *
 * @since 4.1.5
 */
class Rsvp_Pro_PayPal_Payment_Gateway {

	/**
	 * Creates the RSVP Pro PayPal Payment Gateway object.
	 */
	public function __construct() {
		add_action( 'rsvp_pro_event_payment_settings_tab', array( $this, 'display_paypal_payment_settings' ) );
		add_filter( 'rsvp_pro_event_save_additional_settings', array( $this, 'save' ) );
		// add_filter( 'rsvp_pro_frontend_payment_form', array( $this, 'frontend_payment_form' ) );
	}

	/**
	 * Displays the form elements for getting PayPal payments integrated with the RSVP form.
	 *
	 * @param  array $options The options associated with the paypal payments.
	 */
	public function display_paypal_payment_settings( $options ) {
		$event_options = $options['event_options'];
		?>
		<tr class="subEventHide">
			<th scope="row">
				<h3><?php echo rsvp_pro_get_admin_string( 'paypal_form_settings_label' ); ?></h3>
			</th>
		</tr>
		<tr class="subEventHide">
			<th scope="row">
				<label for="paypal_email"><?php echo rsvp_pro_get_admin_string( 'paypal_email_settings_label' ); ?></label>
			</th>
			<td>
				<input type="text" name="paypal_email" id="paypal_email" value="<?php echo esc_attr( stripslashes( $event_options->retrieve_value( 'paypal_email' ) ) ); ?>" />
				<br />
				<span class="description"><?php echo rsvp_pro_get_admin_string( 'paypal_email_settings_description' ); ?></span>
			</td>
		</tr>
		<tr class="subEventHide">
			<th scope="row">
				<label for="paypal_identity_token"><?php echo rsvp_pro_get_admin_string( 'paypal_identity_token_settings_label' ); ?></label>
			</th>
			<td>
				<input type="text" name="paypal_identity_token" id="paypal_identity_token" value="<?php echo esc_attr( stripslashes( $event_options->retrieve_value( 'paypal_identity_token' ) ) ); ?>" />
				<br />
				<span class="description"><?php echo rsvp_pro_get_admin_string( 'paypal_identity_token_settings_description' ); ?></span>
			</td>
		</tr>
		<tr class="subEventHide">
			<th scope="row">
				<h3><?php echo rsvp_pro_get_admin_string( 'paypal_api_credentials_header' ); ?></h3>
			</th>
		</tr>
		<tr class="subEventHide">
			<th scope="row">
				<label for="paypal_live_api_username"><?php echo rsvp_pro_get_admin_string( 'paypal_live_api_username_settings_label' ); ?></label>
			</th>
			<td>
				<input type="text" name="paypal_live_api_username" id="paypal_live_api_username" value="<?php echo esc_attr( stripslashes( $event_options->retrieve_value( 'paypal_live_api_username' ) ) ); ?>" />
				<br />
				<span class="description"><?php echo rsvp_pro_get_admin_string( 'paypal_live_api_username_settings_description' ); ?></span>
			</td>
		</tr>
		<tr class="subEventHide">
			<th scope="row">
				<label for="paypal_live_api_password"><?php echo rsvp_pro_get_admin_string( 'paypal_live_api_password_settings_label' ); ?></label>
			</th>
			<td>
				<input type="text" name="paypal_live_api_password" id="paypal_live_api_password" value="<?php echo esc_attr( stripslashes( $event_options->retrieve_value( 'paypal_live_api_password' ) ) ); ?>" />
				<br />
				<span class="description"><?php echo rsvp_pro_get_admin_string( 'paypal_live_api_password_settings_description' ); ?></span>
			</td>
		</tr>
		<tr class="subEventHide">
			<th scope="row">
				<label for="paypal_live_api_signature"><?php echo rsvp_pro_get_admin_string( 'paypal_live_api_signature_settinngs_label' ); ?></label>
			</th>
			<td>
				<input type="text" name="paypal_live_api_signature" id="paypal_live_api_signature" value="<?php echo esc_attr( stripslashes( $event_options->retrieve_value( 'paypal_live_api_signature' ) ) ); ?>" />
				<br />
				<span class="description"><?php echo rsvp_pro_get_admin_string( 'paypal_live_api_signature_settinngs_description' ); ?></span>
			</td>
		</tr>
		<tr class="subEventHide">
			<th scope="row">
				<label for="paypal_test_api_username"><?php echo rsvp_pro_get_admin_string( 'paypal_test_api_username_settings_label' ); ?></label>
			</th>
			<td>
				<input type="text" name="paypal_test_api_username" id="paypal_test_api_username" value="<?php echo esc_attr( stripslashes( $event_options->retrieve_value( 'paypal_test_api_username' ) ) ); ?>" />
				<br />
				<span class="description"><?php echo rsvp_pro_get_admin_string( 'paypal_test_api_username_settings_description' ); ?></span>
			</td>
		</tr>
		<tr class="subEventHide">
			<th scope="row">
				<label for="paypal_test_api_password"><?php echo rsvp_pro_get_admin_string( 'paypal_test_api_password_settings_label' ); ?></label>
			</th>
			<td>
				<input type="text" name="paypal_test_api_password" id="paypal_test_api_password" value="<?php echo esc_attr( stripslashes( $event_options->retrieve_value( 'paypal_test_api_password' ) ) ); ?>" />
				<br />
				<span class="description"><?php echo rsvp_pro_get_admin_string( 'paypal_test_api_password_settings_description' ); ?></span>
			</td>
		</tr>
		<tr class="subEventHide">
			<th scope="row">
				<label for="paypal_test_api_signature"><?php echo rsvp_pro_get_admin_string( 'paypal_test_api_signature_settings_label' ); ?></label>
			</th>
			<td>
				<input type="text" name="paypal_test_api_signature" id="paypal_test_api_signature" value="<?php echo esc_attr( stripslashes( $event_options->retrieve_value( 'paypal_test_api_signature' ) ) ); ?>" />
				<br />
				<span class="description"><?php echo rsvp_pro_get_admin_string( 'paypal_test_api_signature_settings_description' ); ?></span>
			</td>
		</tr>
		<?php
	}

	/**
	 * Displays the front-end to pay for the event with PayPal.
	 *
	 * @param  stirng $output    The existing output that we want to add to.
	 * @param  int    $event_id  The main event ID we are wanting to pay for.
	 * @param  double $total_due The total amount due for this set of attendee(s).
	 * @return string            The additional output so people can pay with PayPal.
	 */
	public function frontend_payment_form( $output, $event_id, $total_due ) {
		return $output;
	}


	/**
	 * Saves the information to the event's main settings array and then returns it.
	 *
	 * @param  array $options The key=>value array that holds this event's information.
	 * @return array          The options array with the PayPal settings saved.
	 */
	public function save( $options ) {
		$options['paypal_email']              = $_POST['paypal_email'];
		$options['paypal_identity_token']     = $_POST['paypal_identity_token'];
		$options['paypal_live_api_username']  = $_POST['paypal_live_api_username'];
		$options['paypal_live_api_password']  = $_POST['paypal_live_api_password'];
		$options['paypal_live_api_signature'] = $_POST['paypal_live_api_signature'];
		$options['paypal_test_api_username']  = $_POST['paypal_test_api_username'];
		$options['paypal_test_api_password']  = $_POST['paypal_test_api_password'];
		$options['paypal_test_api_signature'] = $_POST['paypal_test_api_signature'];
		return $options;
	}
}
