<?php
function rsvp_pro_frontend_wizard_eventForm( $currentEventID, $attendeeID ) {
	global $wpdb;
	global $rsvp_id;
	global $rsvp_saved_form_vars;

	$form        = '';
	$isMainEvent = rsvp_pro_is_parent_event( $currentEventID );
	$function    = 'rsvp_pro_get_event_option';
	if ( $isMainEvent ) {
		$sql = 'SELECT a.id, firstName, lastName, email, IFNULL(se.rsvpStatus, a.rsvpStatus) AS rsvpStatus, 
			note, additionalAttendee, personalGreeting, IFNULL( se.numGuests, a.numGuests) AS numGuests, suffix, salutation, 
			IFNULL(se.plus_one, a.plus_one) AS plus_one
			FROM ' . PRO_ATTENDEES_TABLE . ' a
			LEFT JOIN ' . PRO_ATTENDEE_SUB_EVENTS_TABLE . ' se ON se.rsvpAttendeeID = a.id AND se.rsvpEventID = %d 
			WHERE a.id = %d AND ( (a.rsvpEventID = %d) ';

		if ( rsvp_pro_is_shared_attendee_list_enabled() ) {
			$sql .= ' OR (a.rsvpEventID = ' . RSVP_PRO_GLOBAL_ATTENDEE_EVENT_ID . ') ';
		}

		$sql     .= ')';
		$attendee = $wpdb->get_row( $wpdb->prepare( $sql, $currentEventID, $attendeeID, $currentEventID ) );
	} else {
		$attendee = $wpdb->get_row(
			$wpdb->prepare(
				'SELECT a.id, firstName, lastName, email, ase.rsvpStatus, note, ase.kidsMeal, 
				additionalAttendee, ase.veggieMeal, personalGreeting, IFNULL( se.numGuests, a.numGuests) AS numGuests, suffix, salutation
				FROM ' . PRO_ATTENDEES_TABLE . ' a
			LEFT JOIN ' . PRO_ATTENDEE_SUB_EVENTS_TABLE . ' ase ON ase.rsvpAttendeeID = a.id  AND ase.rsvpEventID = %d
				WHERE a.id = %d',
				$currentEventID,
				$attendeeID
			)
		);
		$function = 'rsvp_pro_get_sub_event_option';
	}

	$rsvp_form_js_ids = array();
	$yesVerbiage      = ( ( trim( $function( $currentEventID, RSVP_PRO_OPTION_YES_VERBIAGE ) ) != '' ) ? $function( $currentEventID, RSVP_PRO_OPTION_YES_VERBIAGE ) :
		rsvp_pro_get_frontend_string( 'rsvp_yes_label' ) );
	$noVerbiage       = ( ( trim( $function( $currentEventID, RSVP_PRO_OPTION_NO_VERBIAGE ) ) != '' ) ? $function( $currentEventID, RSVP_PRO_OPTION_NO_VERBIAGE ) :
		rsvp_pro_get_frontend_string( 'rsvp_no_label' ) );
	$waitlistVerbiage = rsvp_pro_get_frontend_string( 'rsvp_waitlist_label' );
	if ( trim( $function( $currentEventID, RSVP_PRO_OPTION_WAITLIST_VERBIAGE ) ) != '' ) {
		$waitlistVerbiage = trim( $function( $currentEventID, RSVP_PRO_OPTION_WAITLIST_VERBIAGE ) );
	}

	$maybe_verbiage = rsvp_pro_get_frontend_string( 'rsvp_maybe_label' );
	if ( trim( $function( $currentEventID, RSVP_PRO_OPTION_MAYBE_VERBIAGE ) ) != '' ) {
		$maybe_verbiage = trim( $function( $currentEventID, RSVP_PRO_OPTION_MAYBE_VERBIAGE ) );
	}

	$noResponseText = rsvp_pro_get_frontend_string( 'rsvp_no_response_label' );
	if ( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_NO_RESPONSE_TEXT ) != '' ) {
		$noResponseText = rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_NO_RESPONSE_TEXT );
	}

	if ( does_user_have_access_to_event( $currentEventID, $attendeeID ) ) :
		$mainFirstName   = ( isset( $attendee->firstName ) ? $attendee->firstName : '' );
		$mainLastName    = ( isset( $attendee->lastName ) ? $attendee->lastName : '' );
		$requiredRsvp    = '';
		$event_limit_hit = rsvp_pro_frontend_max_limit_hit( $currentEventID );

		if ( isset( $_POST['attendeeFirstName'] ) && ! empty( $_POST['attendeeFirstName'] ) ) {
			$mainFirstName = $_POST['attendeeFirstName'];
		}
		if ( isset( $_POST['attendeeLastName'] ) && ! empty( $_POST['attendeeLastName'] ) ) {
			$mainLastName = $_POST['attendeeLastName'];
		}

		$eventTitleText = rsvp_pro_get_frontend_string( 'rsvp_for_label' );
		if ( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_MULTI_EVENT_TITLE ) != '' ) {
			$eventTitleText = rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_MULTI_EVENT_TITLE );
		}
		$form .= '<h3>' . sprintf( $eventTitleText, esc_html( rsvp_pro_get_event_name( $currentEventID ) ) ) . '</h3>';

		if ( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_RSVP_REQUIRED ) == 'Y' ) {
			$requiredRsvp = ' required';
		}

		if ( $event_limit_hit ) {
			$form         .= rsvp_pro_handle_max_limit_reached_message( $currentEventID );
			$form         .= rsvp_pro_handle_waitlist_message( $currentEventID );
			$requiredRsvp .= ' disabled="true"';
		}

		if ( 'Y' !== rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_HIDE_RSVP_QUESTION ) ) {
			$form .= RSVP_PRO_START_PARA;
			if ( '' !== trim( $function( $currentEventID, RSVP_PRO_OPTION_QUESTION ) ) ) {
				$form .= trim( $function( $currentEventID, RSVP_PRO_OPTION_QUESTION ) );
			} else {
				$form .= rsvp_pro_get_frontend_string( 'rsvp_question' );
			}
			$form .= RSVP_PRO_END_PARA;
		}

		$mainName   = 'mainRsvp';
		$rsvp_js_id = uniqid();
		if ( ! $isMainEvent ) {
			$mainName                                        = "mainRsvpSub{$currentEventID}";
			$rsvp_form_js_ids[ 'RsvpSub' . $currentEventID ] = $rsvp_js_id;
		} else {
			$rsvp_form_js_ids['main'] = $rsvp_js_id;
		}

		$greeting = rsvp_pro_get_frontend_string( 'associated_greeting' );
		if ( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_ASSOCIATED_ATTENDEE_GREETING ) != '' ) {
			$greeting = rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_ASSOCIATED_ATTENDEE_GREETING );
		}

		if ( strpos( $greeting, '%s' ) !== false ) {
			$greeting = sprintf( $greeting, esc_html( stripslashes( $mainFirstName . ' ' . $mainLastName ) ) );
		}

		$user_rsvp_status = 'NoResponse';
		if ( $function( $currentEventID, RSVP_PRO_OPTION_DEFAULT_RSVP_VALUE ) !== '' ) {
			$user_rsvp_status = $function( $currentEventID, RSVP_PRO_OPTION_DEFAULT_RSVP_VALUE );
			$user_rsvp_status = ucfirst( $user_rsvp_status );
		}

		if ( $event_limit_hit && ( 'Yes' === $user_rsvp_status ) ) {
			$user_rsvp_status = 'NoResponse';
		}

		if ( isset( $attendee ) && ( strtolower( $attendee->rsvpStatus ) !== 'noresponse' ) && ! empty( $attendee->rsvpStatus ) ) {
			$user_rsvp_status = $attendee->rsvpStatus;
		} elseif ( isset( $rsvp_saved_form_vars[ $mainName ] ) ) {
			$user_rsvp_status = rsvp_pro_translate_form_value_to_status( $rsvp_saved_form_vars[ $mainName ] );
		} elseif ( isset( $_REQUEST['rsvpStatus'] ) && rsvp_pro_is_allowed_status( $_REQUEST['rsvpStatus'] ) ) {
			$user_rsvp_status = $_REQUEST['rsvpStatus'];
		}

		if ( $function( $currentEventID, RSVP_PRO_OPTION_RSVP_HIDE ) === 'Y' ) {
			$form .= '<input type="hidden" name="' . $mainName . '" value="' . rsvp_pro_translate_status_to_form_value( $user_rsvp_status ) . '" data-rsvp-js-id="' . $rsvp_js_id . '" class="rsvpStatusInput" />';
		} else {
			$yes_additional_attribs = array();
			if ( $event_limit_hit && ( 'Yes' !== $user_rsvp_status ) ) {
				$yes_additional_attribs['style'] = 'display: none;';
			}
			$form .= rsvp_pro_beginning_form_field( '', 'rsvpRsvpGreeting' ) .
					 RSVP_PRO_START_PARA . $greeting . RSVP_PRO_END_PARA .
					 RSVP_PRO_END_FORM_FIELD .
					 rsvp_pro_beginning_form_field( '', 'rsvpRsvpQuestionArea', $yes_additional_attribs ) .
					 "<input type=\"radio\" name=\"{$mainName}\" value=\"Y\" data-rsvp-js-id=\"${rsvp_js_id}\" id=\"{$mainName}Y\" " . ( ( $user_rsvp_status == 'Yes' ) ? 'checked="checked"' : '' ) . " $requiredRsvp class=\"rsvpStatusInput\" /> <label for=\"{$mainName}Y\">" . $yesVerbiage . '</label>' .
					 RSVP_PRO_END_FORM_FIELD;

			if ( $function( $currentEventID, RSVP_PRO_OPTION_ENABLE_MAYBE ) == 'Y' ) {
				$form .= rsvp_pro_beginning_form_field( '', 'rsvpRsvpQuestionArea' ) .
						 "<input type=\"radio\" name=\"{$mainName}\" value=\"M\" data-rsvp-js-id=\"${rsvp_js_id}\" id=\"{$mainName}Maybe\" " . ( ( $user_rsvp_status == 'Maybe' ) ? 'checked="checked"' : '' ) . ' class="rsvpStatusInput" /> ' .
						 "<label for=\"{$mainName}Maybe\">" . $maybe_verbiage . '</label>' .
						 RSVP_PRO_END_FORM_FIELD;
			}

			$form .= rsvp_pro_beginning_form_field( '', 'rsvpRsvpQuestionArea' ) .
					 "<input type=\"radio\" name=\"{$mainName}\" value=\"N\" data-rsvp-js-id=\"${rsvp_js_id}\" id=\"{$mainName}N\" " . ( ( $user_rsvp_status == 'No' ) ? 'checked="checked"' : '' ) . ' class="rsvpStatusInput" /> ' .
					 "<label for=\"{$mainName}N\">" . $noVerbiage . '</label>' .
					 RSVP_PRO_END_FORM_FIELD;

			if ( ( $function( $currentEventID, RSVP_PRO_OPTION_ENABLE_WAITLIST ) == 'Y' ) && rsvp_pro_frontend_max_limit_hit( $currentEventID ) ) {
				$form .= rsvp_pro_beginning_form_field( '', 'rsvpRsvpQuestionArea' ) .
						 "<input type=\"radio\" name=\"{$mainName}\" value=\"W\" data-rsvp-js-id=\"${rsvp_js_id}\" id=\"{$mainName}Waitlist\" " . ( ( $user_rsvp_status == 'Waitlist' ) ? 'checked="checked"' : '' ) . ' class="rsvpStatusInput" /> ' .
						 "<label for=\"{$mainName}Waitlist\">" . $waitlistVerbiage . '</label>' .
						 RSVP_PRO_END_FORM_FIELD;
			}

			if ( 'Y' === rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_PLUS_ONE_ENABLED ) ) {
				$label = rsvp_pro_get_frontend_string( 'plus_one_label' );
				if ( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_PLUS_ONE_LABEL ) !== '' ) {
					$label = rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_PLUS_ONE_LABEL );
				}

				$form .= rsvp_pro_beginning_form_field( '', 'rsvpRsvpQuestionArea' ) .
						 '<input type="radio" name="' . $mainName . '" id="mainPlusone" data-rsvp-js-id="' . $rsvp_js_id . '" value="PlusOne" ' .
						 ( ( $user_rsvp_status === 'PlusOne' ) ? 'checked=\"checked\"' : '' ) . ' class="rsvpStatusInput" />' .
						 ' <label for="mainPlusone">' . $label . '</label> ' .
						 RSVP_PRO_END_FORM_FIELD;
			}
		}

		$form .= rsvp_pro_buildAdditionalQuestionsForEvent( $attendeeID, 'main', $currentEventID, true, $rsvp_form_js_ids );

		if ( $isMainEvent ) {
			$sql = 'SELECT a.id, firstName, lastName, email, personalGreeting, 
                        IFNULL(se.rsvpStatus, a.rsvpStatus) as rsvpStatus, salutation, suffix 
                    FROM ' . PRO_ATTENDEES_TABLE . ' a
                    LEFT JOIN ' . PRO_ATTENDEE_SUB_EVENTS_TABLE . ' se ON se.rsvpAttendeeID = a.id AND se.rsvpEventID = %d 
            		WHERE (a.id IN (SELECT attendeeID FROM ' . PRO_ASSOCIATED_ATTENDEES_TABLE . ' WHERE associatedAttendeeID = %d)
              		OR a.id in (SELECT associatedAttendeeID FROM ' . PRO_ASSOCIATED_ATTENDEES_TABLE . ' WHERE attendeeID = %d) OR
              		a.id IN (SELECT waa1.attendeeID FROM ' . PRO_ASSOCIATED_ATTENDEES_TABLE . ' waa1
                   	INNER JOIN ' . PRO_ASSOCIATED_ATTENDEES_TABLE . ' waa2 ON waa2.attendeeID = waa1.attendeeID  OR
                                                             waa1.associatedAttendeeID = waa2.attendeeID
                   	WHERE waa2.associatedAttendeeID = %d AND waa1.attendeeID <> %d)) AND ( (a.rsvpEventID = %d) ';

			if ( rsvp_pro_is_shared_attendee_list_enabled() ) {
				$sql .= ' OR (a.rsvpEventID = ' . RSVP_PRO_GLOBAL_ATTENDEE_EVENT_ID . ')';
			}

			$sql         .= ')';
			$associations = $wpdb->get_results( $wpdb->prepare( $sql, $rsvp_id, $attendeeID, $attendeeID, $attendeeID, $attendeeID, $rsvp_id ) );
		} else {
			$sql          = 'SELECT a.id, a.firstName, a.lastName, a.email, a.personalGreeting, ase.rsvpStatus, a.salutation, a.suffix
            		FROM ' . PRO_ATTENDEES_TABLE . ' a
            		LEFT JOIN ' . PRO_ATTENDEE_SUB_EVENTS_TABLE . ' ase ON ase.rsvpAttendeeID = a.id  AND ase.rsvpEventID = %d
            		WHERE (a.id IN (SELECT attendeeID FROM ' . PRO_ASSOCIATED_ATTENDEES_TABLE . ' WHERE associatedAttendeeID = %d)
              		OR a.id in (SELECT associatedAttendeeID FROM ' . PRO_ASSOCIATED_ATTENDEES_TABLE . ' WHERE attendeeID = %d) OR
              		a.id IN (SELECT waa1.attendeeID FROM ' . PRO_ASSOCIATED_ATTENDEES_TABLE . ' waa1
                   	INNER JOIN ' . PRO_ASSOCIATED_ATTENDEES_TABLE . ' waa2 ON waa2.attendeeID = waa1.attendeeID  OR
                                                             waa1.associatedAttendeeID = waa2.attendeeID
                   	WHERE waa2.associatedAttendeeID = %d AND waa1.attendeeID <> %d)) AND a.rsvpEventID = %d';
			$associations = $wpdb->get_results( $wpdb->prepare( $sql, $currentEventID, $attendeeID, $attendeeID, $attendeeID, $attendeeID, $rsvp_id ) );
		}

		if ( count( $associations ) > 0 ) {
			$attendeeForm = '';

			foreach ( $associations as $a ) {
				$rsvp_form_js_ids = array();
				if ( ( $a->id != $attendeeID ) && does_user_have_access_to_event( $currentEventID, $a->id ) ) {
					$associated_yes_verbiage      = apply_filters( 'rsvp_yes_associated', $yesVerbiage, $a, $currentEventID );
					$associated_maybe_verbiage    = apply_filters( 'rsvp_maybe_associated', $maybe_verbiage, $a, $currentEventID );
					$associated_no_verbiage       = apply_filters( 'rsvp_no_associated', $noVerbiage, $a, $currentEventID );
					$associated_waitlist_verbiage = apply_filters( 'rsvp_waitlist_associated', $waitlistVerbiage, $a, $currentEventID );
					$associated_no_response_text  = apply_filters( 'rsvp_no_response_associated', $noResponseText, $a, $currentEventID );

					$attendeeForm .= "<div class=\"rsvpAdditionalAttendee\">\r\n";
					$attendeeForm .= "<div class=\"rsvpAdditionalAttendeeQuestions\">\r\n";

					$requiredRsvp = '';
					if ( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_RSVP_REQUIRED ) == 'Y' ) {
						$requiredRsvp = ' required';
					}

					$mainName   = 'attending' . $a->id;
					$rsvp_js_id = uniqid();
					if ( ! $isMainEvent ) {
						$mainName                                        = $a->id . 'ExistingRsvpSub' . $currentEventID;
						$rsvp_form_js_ids[ 'RsvpSub' . $currentEventID ] = $rsvp_js_id;
					} else {
						$rsvp_form_js_ids['main'] = $rsvp_js_id;
					}

					$greeting = rsvp_pro_get_frontend_string( 'associated_greeting' );
					if ( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_ASSOCIATED_ATTENDEE_GREETING ) != '' ) {
						$greeting = rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_ASSOCIATED_ATTENDEE_GREETING );
					}

					$first_name = stripslashes( $a->firstName );
					$last_name  = stripslashes( $a->lastName );

					if ( ! empty( $_POST[ 'attending' . $a->id . 'FirstName' ] ) ) {
						$first_name = $_POST[ 'attending' . $a->id . 'FirstName' ];
					}

					if ( ! empty( $_POST[ 'attending' . $a->id . 'LastName' ] ) ) {
						$last_name = $_POST[ 'attending' . $a->id . 'LastName' ];
					}

					if ( strpos( $greeting, '%s' ) !== false ) {
						$greeting = sprintf( $greeting, esc_html( $first_name . ' ' . $last_name ) );
					}

					$attendeeForm .= rsvp_pro_beginning_form_field( '', 'rsvpRsvpGreeting' ) . RSVP_PRO_START_PARA . $greeting . RSVP_PRO_END_PARA . RSVP_PRO_END_FORM_FIELD;

					if ( rsvp_pro_frontend_max_limit_hit( $currentEventID ) ) {
						$attendeeForm .= rsvp_pro_handle_max_limit_reached_message( $currentEventID );
						$attendeeForm .= rsvp_pro_handle_waitlist_message( $currentEventID );
						$requiredRsvp .= ' disabled="true"';
					}

					$user_rsvp_status = 'NoResponse';
					if ( $function( $currentEventID, RSVP_PRO_OPTION_DEFAULT_RSVP_VALUE ) !== '' ) {
						$user_rsvp_status = $function( $currentEventID, RSVP_PRO_OPTION_DEFAULT_RSVP_VALUE );
						$user_rsvp_status = ucfirst( $user_rsvp_status );
					}

					if ( isset( $a ) && ( strtolower( $a->rsvpStatus ) !== 'noresponse' ) && ! empty( $a->rsvpStatus ) ) {
						$user_rsvp_status = $a->rsvpStatus;
					} elseif ( isset( $_REQUEST['rsvpStatus'] ) && rsvp_pro_is_allowed_status( $_REQUEST['rsvpStatus'] ) ) {
						$user_rsvp_status = $_REQUEST['rsvpStatus'];
					}

					if ( $function( $currentEventID, RSVP_PRO_OPTION_RSVP_HIDE ) === 'Y' ) {
						$attendeeForm .= '<input type="hidden" name="' . $mainName . '" value="' . rsvp_pro_translate_status_to_form_value( $user_rsvp_status ) . '" data-rsvp-js-id="' . $rsvp_js_id . '" class="rsvpStatusInput" />';
					} else {
						$attendeeForm .= rsvp_pro_beginning_form_field( '', 'rsvpRsvpQuestionArea' ) .
										 "<input type=\"radio\" name=\"{$mainName}\" value=\"Y\" data-rsvp-js-id=\"${rsvp_js_id}\" id=\"{$mainName}Y\" " . ( ( $user_rsvp_status == 'Yes' ) ? 'checked="checked"' : '' ) . " $requiredRsvp class=\"rsvpStatusInput\" /> " .
										 "<label for=\"{$mainName}Y\">$associated_yes_verbiage</label>" .
										 RSVP_PRO_END_FORM_FIELD;

						if ( $function( $currentEventID, RSVP_PRO_OPTION_ENABLE_MAYBE ) == 'Y' ) {
							$attendeeForm .= rsvp_pro_beginning_form_field( '', 'rsvpRsvpQuestionArea' ) .
											 "<input type=\"radio\" name=\"{$mainName}\" value=\"M\" data-rsvp-js-id=\"${rsvp_js_id}\" id=\"{$mainName}Maybe\" " . ( ( $user_rsvp_status == 'Maybe' ) ? 'checked="checked"' : '' ) . ' class="rsvpStatusInput" /> ' .
											 "<label for=\"{$mainName}Maybe\">" . $associated_maybe_verbiage . '</label>' .
											 RSVP_PRO_END_FORM_FIELD;
						}

						$attendeeForm .= rsvp_pro_beginning_form_field( '', 'rsvpRsvpQuestionArea' ) .
										 "<input type=\"radio\" name=\"{$mainName}\" value=\"N\" data-rsvp-js-id=\"${rsvp_js_id}\" id=\"{$mainName}N\" " . ( ( $user_rsvp_status == 'No' ) ? 'checked="checked"' : '' ) . ' class="rsvpStatusInput" /> ' .
										 "<label for=\"{$mainName}N\">$associated_no_verbiage</label>" . RSVP_PRO_END_FORM_FIELD;

						if ( ( $function( $currentEventID, RSVP_PRO_OPTION_ENABLE_WAITLIST ) == 'Y' ) && rsvp_pro_frontend_max_limit_hit( $currentEventID ) ) {
							$attendeeForm .= rsvp_pro_beginning_form_field( '', 'rsvpRsvpQuestionArea' ) .
											 "<input type=\"radio\" name=\"{$mainName}\" value=\"W\" data-rsvp-js-id=\"${rsvp_js_id}\" id=\"{$mainName}Waitlist\" " . ( ( $user_rsvp_status == 'Waitlist' ) ? 'checked="checked"' : '' ) . ' class="rsvpStatusInput" /> ' .
											 "<label for=\"{$mainName}Waitlist\">" . $associated_waitlist_verbiage . '</label>' .
											 RSVP_PRO_END_FORM_FIELD;
						}

						if ( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_SHOW_NORESPONSE_FOR_ASSOCIATED ) == 'Y' ) {
							$attendeeForm .= rsvp_pro_beginning_form_field( '', 'rsvpRsvpQuestionArea' ) .
											 "<input type=\"radio\" name=\"{$mainName}\" value=\"NoResponse\" data-rsvp-js-id=\"${rsvp_js_id}\" id=\"{$mainName}NoResponse\" " . ( ( $user_rsvp_status == 'NoResponse' ) ? 'checked="checked"' : '' ) . ' class="rsvpStatusInput" /> ' .
											 "<label for=\"{$mainName}NoResponse\">$associated_no_response_text</label>" .
											 RSVP_PRO_END_FORM_FIELD;
						}
					}

					if ( ! empty( $a->personalGreeting ) ) {
						$attendeeForm .= RSVP_PRO_START_PARA . nl2br( $a->personalGreeting ) . RSVP_PRO_END_PARA;
					}

					$attendeeForm .= rsvp_pro_buildAdditionalQuestionsForEvent( $a->id, $a->id, $currentEventID, false, $rsvp_form_js_ids );
					$attendeeForm .= "</div>\r\n"; // -- rsvpAdditionalAttendeeQuestions
					$attendeeForm .= "</div>\r\n";
				} // if($a->id != ...)
			} // foreach($associations...)

			if ( ! empty( $attendeeForm ) ) {
				$message = rsvp_pro_get_frontend_string( 'associated_label' );
				if ( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_ASSOCIATED_MESSAGE ) != '' ) {
					$message = rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_ASSOCIATED_MESSAGE );
				}
				$form .= '<h3>' . $message . '</h3>';
				$form .= $attendeeForm;
			}
		}

		if ( isset( $_POST['additionalRsvp'] ) &&
			 is_numeric( $_POST['additionalRsvp'] ) &&
			 ( $_POST['additionalRsvp'] > 0 ) &&
			 isset( $_POST['additionalRsvpIds'] ) &&
			 ! empty( $_POST['additionalRsvpIds'] ) ) {
			$additional_ids = explode( ',', $_POST['additionalRsvpIds'] );
			foreach ( $additional_ids as $i ) {
				if ( isset( $_POST[ 'newAttending' . $i . 'FirstName' ] ) && isset( $_POST[ 'newAttending' . $i . 'LastName' ] ) ) {
					$firstName        = $_POST[ 'newAttending' . $i . 'FirstName' ];
					$lastName         = $_POST[ 'newAttending' . $i . 'LastName' ];
					$form            .= "<div class=\"rsvpAdditionalAttendee\">\r\n";
					$form            .= "<div class=\"rsvpAdditionalAttendeeQuestions\">\r\n";
					$rsvp_form_js_ids = array();

					if ( does_user_have_access_to_event( $currentEventID, $attendeeID ) ) {
						$requiredRsvp = '';
						if ( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_RSVP_REQUIRED ) == 'Y' ) {
							$requiredRsvp = ' required';
						}

						$mainName   = 'newAttending' . $i;
						$rsvp_js_id = uniqid();
						if ( ! $isMainEvent ) {
							$mainName                                        = $i . 'RsvpSub' . $currentEventID;
							$rsvp_form_js_ids[ 'RsvpSub' . $currentEventID ] = $rsvp_js_id;
						} else {
							$rsvp_form_js_ids['main'] = $rsvp_js_id;
						}

						$greeting = rsvp_pro_get_frontend_string( 'associated_greeting' );
						if ( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_ASSOCIATED_ATTENDEE_GREETING ) != '' ) {
							$greeting = rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_ASSOCIATED_ATTENDEE_GREETING );
						}

						if ( strpos( $greeting, '%s' ) !== false ) {
							$greeting = sprintf( $greeting, esc_html( stripslashes( $firstName . ' ' . $lastName ) ) );
						}

						$user_rsvp_status = 'NoResponse';
						if ( $function( $currentEventID, RSVP_PRO_OPTION_DEFAULT_RSVP_VALUE ) !== '' ) {
							$user_rsvp_status = $function( $currentEventID, RSVP_PRO_OPTION_DEFAULT_RSVP_VALUE );
							$user_rsvp_status = ucfirst( $user_rsvp_status );
						} elseif ( isset( $_REQUEST['rsvpStatus'] ) && rsvp_pro_is_allowed_status( $_REQUEST['rsvpStatus'] ) ) {
							$user_rsvp_status = $_REQUEST['rsvpStatus'];
						}

						if ( $function( $currentEventID, RSVP_PRO_OPTION_RSVP_HIDE ) === 'Y' ) {
							$form .= '<input type="hidden" name="' . $mainName . '" value="' . rsvp_pro_translate_status_to_form_value( $user_rsvp_status ) . '" data-rsvp-js-id="' . $rsvp_js_id . '" class="rsvpStatusInput" />';
						} else {
							$form .= rsvp_pro_beginning_form_field( '', 'rsvpRsvpGreeting' ) . RSVP_PRO_START_PARA . $greeting . RSVP_PRO_END_PARA . RSVP_PRO_END_FORM_FIELD .
									 rsvp_pro_beginning_form_field( '', 'rsvpRsvpQuestionArea' ) .
									 "<input type=\"radio\" name=\"{$mainName}\" value=\"Y\" data-rsvp-js-id=\"${rsvp_js_id}\" id=\"{$mainName}Y\" $requiredRsvp  " . ( ( $user_rsvp_status == 'Yes' ) ? 'checked="checked"' : '' ) . ' class=\"rsvpStatusInput\" /> ';

							if ( $function( $currentEventID, RSVP_PRO_OPTION_ENABLE_MAYBE ) == 'Y' ) {
								$form .= rsvp_pro_beginning_form_field( '', 'rsvpRsvpQuestionArea' ) .
										 "<input type=\"radio\" name=\"{$mainName}\" value=\"M\" data-rsvp-js-id=\"${rsvp_js_id}\" id=\"{$mainName}Maybe\" " . ( ( $user_rsvp_status == 'Maybe' ) ? 'checked="checked"' : '' ) . ' class="rsvpStatusInput" /> ' .
										 "<label for=\"{$mainName}Maybe\">" . $maybe_verbiage . '</label>' .
										 RSVP_PRO_END_FORM_FIELD;
							}

							$form .= "<label for=\"{$mainName}Y\">$yesVerbiage</label>" . RSVP_PRO_END_FORM_FIELD .
									 rsvp_pro_beginning_form_field( '', 'rsvpRsvpQuestionArea' ) .
									 "<input type=\"radio\" name=\"{$mainName}\" value=\"N\" data-rsvp-js-id=\"${rsvp_js_id}\" id=\"{$mainName}N\" " . ( ( $user_rsvp_status == 'No' ) ? 'checked="checked"' : '' ) . ' class="rsvpStatusInput" /> ' .
									 "<label for=\"{$mainName}N\">$noVerbiage</label>" . RSVP_PRO_END_FORM_FIELD;

							if ( ( $function( $currentEventID, RSVP_PRO_OPTION_ENABLE_WAITLIST ) == 'Y' ) && rsvp_pro_frontend_max_limit_hit( $rsvp_id ) ) {
								$form .= rsvp_pro_beginning_form_field( '', 'rsvpRsvpQuestionArea' ) .
										 "<input type=\"radio\" name=\"{$mainName}\" value=\"W\" data-rsvp-js-id=\"${rsvp_js_id}\" id=\"{$mainName}Waitlist\" " . ( ( $user_rsvp_status == 'Waitlist' ) ? 'checked="checked"' : '' ) . ' class="rsvpStatusInput" /> ' .
										 "<label for=\"{$mainName}Waitlist\">" . $waitlistVerbiage . '</label>' .
										 RSVP_PRO_END_FORM_FIELD;
							}

							if ( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_SHOW_NORESPONSE_FOR_ASSOCIATED ) == 'Y' ) {
								$form .= rsvp_pro_beginning_form_field( '', 'rsvpRsvpQuestionArea' ) .
										 "<input type=\"radio\" name=\"{$mainName}\" value=\"NoResponse\" data-rsvp-js-id=\"${rsvp_js_id}\" id=\"{$mainName}NoResponse\" " . ( ( $user_rsvp_status == 'NoResponse' ) ? 'checked="checked"' : '' ) . ' class="rsvpStatusInput" /> ' .
										 "<label for=\"{$mainName}NoResponse\">$noResponseText</label>" . RSVP_PRO_END_FORM_FIELD;
							}
							$form .= RSVP_PRO_END_FORM_FIELD;
						}
					}

					$form .= rsvp_pro_buildAdditionalQuestionsForEvent( $attendeeID, $i, $currentEventID, false, $rsvp_form_js_ids );
					$form .= "</div>\r\n"; // -- rsvpAdditionalAttendeeQuestions
					$form .= "</div>\r\n";
				}
			} // for($i = 1; $i <= $_POST['additionalRsvp']; $i++) {
		}
	endif; // if(does_user_have_access_to_event($rsvp_id, $attendeeID)) :

	return $form;
}

function rsvp_pro_frontend_wizard_personalInfo( $attendee, $attendeeID ) {
	global $wpdb, $rsvp_id;
	global $my_plugin_file;
	global $rsvp_saved_form_vars;

	$noteVerbiage = ( ( trim( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_NOTE_VERBIAGE ) ) != '' ) ? rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_NOTE_VERBIAGE ) :
		rsvp_pro_get_frontend_string( 'note_text' ) );

	$sql = 'SELECT id FROM ' . PRO_ATTENDEES_TABLE . '
	 	WHERE (id IN (SELECT attendeeID FROM ' . PRO_ASSOCIATED_ATTENDEES_TABLE . ' WHERE associatedAttendeeID = %d)
			OR id in (SELECT associatedAttendeeID FROM ' . PRO_ASSOCIATED_ATTENDEES_TABLE . ' WHERE attendeeID = %d))
			AND ( (rsvpEventID = %d) ';

	if ( rsvp_pro_is_shared_attendee_list_enabled() ) {
		$sql .= ' OR (rsvpEventID = ' . RSVP_PRO_GLOBAL_ATTENDEE_EVENT_ID . ')';
	}

	$sql     .= ')';
	$newRsvps = $wpdb->get_results( $wpdb->prepare( $sql, $attendeeID, $attendeeID, $rsvp_id ) );

	$form      = '';
	$numGuests = get_number_additional( $rsvp_id, $attendee );

	if ( ! empty( $attendee->personalGreeting ) ) {
		$form .= rsvp_pro_beginning_form_field( 'rsvpCustomGreeting', '' ) . nl2br( stripslashes( $attendee->personalGreeting ) ) . RSVP_PRO_END_FORM_FIELD;
	}

	if ( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_SHOW_SALUTATION ) == 'Y' ) {
		$label = rsvp_pro_get_frontend_string( 'salutation_text' );
		if ( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_SALUTATION_LABEL ) != '' ) {
			$label = rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_SALUTATION_LABEL );
		}
		$attendee_salutation = isset( $attendee ) ? $attendee->salutation : '';

		$form       .= rsvp_pro_beginning_form_field( '', 'rsvpBorderTop' ) .
						RSVP_PRO_START_PARA . '<label for="mainSalutation">' . $label . '</label>' . RSVP_PRO_END_PARA .
						'<select name="mainSalutation" id="mainSalutation" size="1"><option value="">--</option>';
		$salutations = rsvp_pro_get_salutation_options( $rsvp_id );
		foreach ( $salutations as $s ) {
			$form .= '<option value="' . esc_html( $s ) . '" ' . ( ( $s == $attendee_salutation ) ? 'selected="selected"' : '' ) . '>' . esc_html( $s ) . '</option>';
		}

		$form .= '</select>' .
				 RSVP_PRO_END_FORM_FIELD;
	}

	// New Attendee fields when open registration is allowed
	if ( ( $attendeeID <= 0 ) || ( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_FIRST_LAST_EDITABLE ) === 'Y' ) ) {
		$first_name = $rsvp_saved_form_vars['attendeeFirstName'];
		$last_name  = $rsvp_saved_form_vars['attendeeLastName'];

		if ( ( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_FIRST_LAST_EDITABLE ) === 'Y' ) &&
			 ( $attendee != null ) ) {
			$first_name = stripslashes( $attendee->firstName );
			$last_name  = stripslashes( $attendee->lastName );
		}

		$firstNameLabel = rsvp_pro_get_frontend_string( 'first_name_label' );
		if ( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_FIRST_NAME_LABEL ) != '' ) {
			$firstNameLabel = rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_FIRST_NAME_LABEL );
		}

		$lastNameLabel = rsvp_pro_get_frontend_string( 'last_name_label' );
		if ( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_LAST_NAME_LABEL ) != '' ) {
			$lastNameLabel = rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_LAST_NAME_LABEL );
		}

		$form .= RSVP_PRO_START_PARA;
		$form .= rsvp_pro_beginning_form_field( '', 'rsvpMainAttendeeFirstNameContainer' ) .
				 '<label for="attendeeFirstName">' . $firstNameLabel . ':</label>' .
				 '<input type="text" name="attendeeFirstName" id="attendeeFirstName" value="' . esc_html( $first_name ) . '" required />' .
				 RSVP_PRO_END_FORM_FIELD;
		$form .= RSVP_PRO_END_PARA;

		$form .= RSVP_PRO_START_PARA;
		$form .= rsvp_pro_beginning_form_field( '', 'rsvpMainAttendeeLastNameContainer' ) .
				 '<label for="attendeeLastName">' . $lastNameLabel . ':</label>' .
				 '<input type="text" name="attendeeLastName" id="attendeeLastName" value="' . esc_html( $last_name ) . '" ' . ( ( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_LAST_NAME_NOT_REQUIRED ) !== 'Y' ) ? 'required' : '' ) . ' />' .
				 RSVP_PRO_END_FORM_FIELD;
		$form .= RSVP_PRO_END_PARA;
	}

	if ( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_SHOW_SUFFIX ) == 'Y' ) {
		$label = rsvp_pro_get_frontend_string( 'suffix_label' );
		if ( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_SUFFIX_LABEL ) != '' ) {
			$label = rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_SUFFIX_LABEL );
		}
		$form .= RSVP_PRO_START_PARA . rsvp_pro_beginning_form_field( '', 'rsvpBorderTop' ) .
				 '<label for="mainSuffix">' . $label . '</label>' .
				 '<input type="text" name="mainSuffix" id="mainSuffix" value="' . ( isset( $attendee->suffix ) ? esc_html( $attendee->suffix ) : '' ) . '" />' .
				 RSVP_PRO_END_FORM_FIELD . RSVP_PRO_END_PARA;
	}

	if ( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_PASSCODE_EDITABLE ) === 'Y' ) {
		$passcode = isset( $attendee ) ? stripslashes( $attendee->passcode ) : '';

		$passcode_label = rsvp_pro_get_frontend_string( 'attendee_passcode_label' );
		if ( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_PASSCODE_EDITABLE_LABEL ) != '' ) {
			$passcode_label = rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_PASSCODE_EDITABLE_LABEL );
		}
		$form .= RSVP_PRO_START_PARA;
		$form .= rsvp_pro_beginning_form_field( '', '' ) .
				 '<label for="attendeePasscode"> ' . $passcode_label . '</label>' .
				 '<input type="text" name="attendeePasscode" id="attendeePasscode" class="rsvpPasscodeField" data-rule-rsvpProPasscodeUnique="true" value="' . esc_html( $passcode ) . '" />' .
				 RSVP_PRO_END_FORM_FIELD;
		$form .= RSVP_PRO_END_PARA;
	}

	if ( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_HIDE_EMAIL_FIELD ) != 'Y' ) {
		$email_value = '';

		if ( isset( $rsvp_saved_form_vars['attendeeEmail'] ) ) {
			$email_value = $rsvp_saved_form_vars['attendeeEmail'];
		} elseif ( isset( $attendee->email ) ) {
			$email_value = $attendee->email;
		}

		$label = rsvp_pro_get_frontend_string( 'email_label' );
		if ( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_EMAIL_LABEL ) != '' ) {
			$label = rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_EMAIL_LABEL );
		}

		$js_email_validation = rsvp_pro_get_frontend_string( 'javascript_email_validation' );
		if ( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_EMAIL_JS_MESSAGE ) !== '' ) {
			$js_email_validation = rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_EMAIL_JS_MESSAGE );
		}

		$form .= RSVP_PRO_START_PARA . rsvp_pro_beginning_form_field( '', 'rsvpMainAttendeeEmailContainer' ) .
				 '<label for="mainEmail">' . $label . '</label>' .
				 '<input type="text" name="mainEmail" id="mainEmail" value="' . esc_html( $email_value ) . '" ' .
				 ( ( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_EMAIL_REQUIRED ) == 'Y' ) ? 'required data-rule-email="true"' : '' ) .
				 ' class="rsvpEmailField" data-rule-rsvpProEmailUnique="true" data-msg-required="' . esc_attr( $js_email_validation ) . '" />' .
				 RSVP_PRO_END_FORM_FIELD . RSVP_PRO_END_PARA;
	}

	$form .= rsvp_pro_beginning_form_field( '', 'rsvpBorderTop' );
	$form .= RSVP_PRO_END_FORM_FIELD;

	if ( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_HIDE_NOTE ) != 'Y' ) {
		$form .= RSVP_PRO_START_PARA . $noteVerbiage . RSVP_PRO_END_PARA .

				 $note = '';
		if ( ! empty( $attendee->note ) ) {
			$note = stripslashes( $attendee->note );
		} elseif ( isset( $rsvp_saved_form_vars['rsvp_note'] ) ) {
			$note = $rsvp_saved_form_vars['rsvp_note'];
		}

		$form .= rsvp_pro_beginning_form_field( '', '' ) .
				 '<textarea name="rsvp_note" id="rsvp_note" rows="7" cols="50">' .
				 esc_html( $note ) . '</textarea>' .
				 RSVP_PRO_END_FORM_FIELD;
	}

	$sql = 'SELECT a.id, firstName, lastName, email, personalGreeting, 
            IFNULL(se.rsvpStatus, a.rsvpStatus) as rsvpStatus, salutation, suffix, passcode 
        FROM ' . PRO_ATTENDEES_TABLE . ' a
        LEFT JOIN ' . PRO_ATTENDEE_SUB_EVENTS_TABLE . ' se ON se.rsvpAttendeeID = a.id AND se.rsvpEventID = %d 
	 	WHERE (a.id IN (SELECT attendeeID FROM ' . PRO_ASSOCIATED_ATTENDEES_TABLE . ' WHERE associatedAttendeeID = %d)
			OR a.id in (SELECT associatedAttendeeID FROM ' . PRO_ASSOCIATED_ATTENDEES_TABLE . ' WHERE attendeeID = %d) OR
      a.id IN (SELECT waa1.attendeeID FROM ' . PRO_ASSOCIATED_ATTENDEES_TABLE . ' waa1
           INNER JOIN ' . PRO_ASSOCIATED_ATTENDEES_TABLE . ' waa2 ON waa2.attendeeID = waa1.attendeeID  OR
                                                     waa1.associatedAttendeeID = waa2.attendeeID
           WHERE waa2.associatedAttendeeID = %d AND waa1.attendeeID <> %d)) AND ( (a.rsvpEventID = %d) ';

	if ( rsvp_pro_is_shared_attendee_list_enabled() ) {
		$sql .= ' OR (a.rsvpEventID = ' . RSVP_PRO_GLOBAL_ATTENDEE_EVENT_ID . ')';
	}

	$sql .= ')';

	$associations = $wpdb->get_results( $wpdb->prepare( $sql, $rsvp_id, $attendeeID, $attendeeID, $attendeeID, $attendeeID, $rsvp_id ) );
	if ( count( $associations ) > 0 ) {
		$message = rsvp_pro_get_frontend_string( 'associated_label' );
		if ( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_ASSOCIATED_MESSAGE ) != '' ) {
			$message = rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_ASSOCIATED_MESSAGE );
		}

		$form .= '<h3>' . $message . '</h3>';
		foreach ( $associations as $a ) {
			if ( $a->id != $attendeeID ) {
				$form .= "<div class=\"rsvpAdditionalAttendee\">\r\n";
				$form .= "<div class=\"rsvpAdditionalAttendeeQuestions\">\r\n";
				$form .= RSVP_PRO_END_FORM_FIELD;

				$optionsText = rsvp_pro_get_frontend_string( 'options_text' );
				if ( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_MULTI_OPTION_TEXT ) != '' ) {
					$optionsText = rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_MULTI_OPTION_TEXT );
				}

				$form .= RSVP_PRO_START_PARA . esc_html( stripslashes( $a->firstName . ' ' . $a->lastName ) . ' ' ) . $optionsText . RSVP_PRO_END_PARA;

				if ( ! empty( $a->personalGreeting ) ) {
					$form .= RSVP_PRO_START_PARA . nl2br( $a->personalGreeting ) . RSVP_PRO_END_PARA;
				}

				if ( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_SHOW_SALUTATION ) == 'Y' ) {
					$label = rsvp_pro_get_frontend_string( 'salutation_text' );

					if ( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_SALUTATION_LABEL ) != '' ) {
						$label = rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_SALUTATION_LABEL );
					}

					$form       .= RSVP_PRO_START_PARA . rsvp_pro_beginning_form_field( '', '' ) .
									'<label for="attending' . $a->id . 'Salutation">' . $label . '</label>' .
									'<select name="attending' . $a->id . 'Salutation" id="attending' . $a->id . 'Salutation" size="1"><option value="">--</option>';
					$salutations = rsvp_pro_get_salutation_options( $rsvp_id );
					foreach ( $salutations as $s ) {
						$form .= '<option value="' . esc_html( $s ) . '" ' . ( ( $s == $a->salutation ) ? 'selected="selected"' : '' ) . '>' . esc_html( $s ) . '</option>';
					}

					$form .= '</select>' . RSVP_PRO_END_FORM_FIELD . RSVP_PRO_END_PARA;
				}

				if ( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_FIRST_LAST_EDITABLE ) === 'Y' ) {
					$first_name_label = rsvp_pro_get_frontend_string( 'first_name_label' );
					if ( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_FIRST_NAME_LABEL ) !== '' ) {
						$first_name_label = rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_FIRST_NAME_LABEL );
					}

					$last_name_label = rsvp_pro_get_frontend_string( 'last_name_label' );
					if ( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_LAST_NAME_LABEL ) !== '' ) {
						$last_name_label = rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_LAST_NAME_LABEL );
					}

					$form .= RSVP_PRO_START_PARA;
					$form .= rsvp_pro_beginning_form_field( '', '' ) .
							 '<label for="attending' . $a->id . 'FirstName">' . $first_name_label . '</label>' .
							 '<input type="text" name="attending' . $a->id . 'FirstName" id="attending' . $a->id . 'FirstName" value="' . esc_html( stripslashes( $a->firstName ) ) . '" required />' .
							 RSVP_PRO_END_FORM_FIELD;
					$form .= RSVP_PRO_END_PARA;

					$form .= RSVP_PRO_START_PARA;
					$form .= rsvp_pro_beginning_form_field( '', '' ) .
							 '<label for="attending' . $a->id . 'LastName">' . $last_name_label . '</label>' .
							 '<input type="text" name="attending' . $a->id . 'LastName" id="attending' . $a->id . 'LastName" value="' . esc_html( stripslashes( $a->lastName ) ) . '" ' . ( ( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_LAST_NAME_NOT_REQUIRED ) !== 'Y' ) ? 'required' : '' ) . ' />' .
							 RSVP_PRO_END_FORM_FIELD;
					$form .= RSVP_PRO_END_PARA;
				}

				if ( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_SHOW_SUFFIX ) == 'Y' ) {
					$label = rsvp_pro_get_frontend_string( 'suffix_label' );
					if ( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_SUFFIX_LABEL ) != '' ) {
						$label = rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_SUFFIX_LABEL );
					}
					$form .= RSVP_PRO_START_PARA . rsvp_pro_beginning_form_field( '', '' ) .
							 RSVP_PRO_START_PARA . '<label for="attending' . $a->id . 'Suffix">' . $label . '</label>' . RSVP_PRO_END_PARA .
							 '<input type="text" name="attending' . $a->id . 'Suffix" id="attending' . $a->id . 'Suffix" value="' . esc_html( $a->suffix ) . '" />' .
							 RSVP_PRO_END_FORM_FIELD . RSVP_PRO_END_PARA;
				}

				if ( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_PASSCODE_EDITABLE ) === 'Y' ) {
					$passcode = stripslashes( $a->passcode );

					$passcode_label = rsvp_pro_get_frontend_string( 'attendee_passcode_label' );
					if ( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_PASSCODE_EDITABLE_LABEL ) != '' ) {
						$passcode_label = rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_PASSCODE_EDITABLE_LABEL );
					}
					$form .= RSVP_PRO_START_PARA;
					$form .= rsvp_pro_beginning_form_field( '', '' ) .
							 '<label for="attending' . $a->id . 'Passcode"> ' . $passcode_label . '</label>' .
							 '<input type="text" name="attending' . $a->id . 'Passcode" id="attending' . $a->id . 'Passcode" value="' . esc_html( $passcode ) . '" class="rsvpPasscodeField" data-rule-rsvpProPasscodeUnique="true" />' .
							 RSVP_PRO_END_FORM_FIELD;
					$form .= RSVP_PRO_END_PARA;
				}

				if ( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_HIDE_EMAIL_FIELD ) != 'Y' ) {
					$label = rsvp_pro_get_frontend_string( 'email_label' );
					if ( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_EMAIL_LABEL ) != '' ) {
						$label = rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_EMAIL_LABEL );
					}

					$js_email_validation = rsvp_pro_get_frontend_string( 'javascript_email_validation' );
					if ( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_EMAIL_JS_MESSAGE ) !== '' ) {
						$js_email_validation = rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_EMAIL_JS_MESSAGE );
					}

					$form .= RSVP_PRO_START_PARA . rsvp_pro_beginning_form_field( '', '' ) .
							 '<label for="attending' . $a->id . 'Email">' . $label . '</label>' .
							 '<input type="text" name="attending' . $a->id . 'Email" id="attending' . $a->id . 'Email" value="' . htmlspecialchars( $a->email ) . '" ' .
							 ( ( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_EMAIL_REQUIRED ) == 'Y' ) ? 'required data-rule-email="true"' : '' ) . ' 
                         class="rsvpEmailField" data-rule-rsvpProEmailUnique="true" data-msg-required="' . esc_attr( $js_email_validation ) . '" />' .
							 RSVP_PRO_END_FORM_FIELD . RSVP_PRO_END_PARA;
				}
				$form .= "</div>\r\n"; // -- rsvpAdditionalAttendeeQuestions
			} // if($a->id != ...)
		} // foreach($associations...)
	}

	// Text for adding additional attendees...
	if ( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_HIDE_ADDITIONAL ) != 'Y' ) {
		$availableGuestCount = $numGuests - count( $newRsvps );
		$text                = sprintf( rsvp_pro_get_frontend_string( 'invite_message' ), $availableGuestCount );

		$additionalVerbiageText = trim( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_ADD_ADDITIONAL_VERBIAGE ) );
		if ( $additionalVerbiageText != '' ) {
			if ( ( strpos( $additionalVerbiageText, '%d' ) !== false ) || ( strpos( $additionalVerbiageText, '%s' ) !== false ) ) {
				$text = sprintf( $additionalVerbiageText, $availableGuestCount );
			} else {
				$text = $additionalVerbiageText;
			}
		}

		if ( $availableGuestCount > 0 ) {
			$buttonText = rsvp_pro_get_frontend_string( 'add_additional_guests' );
			if ( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_ADD_ATTENDEE_BUTTON_TEXT ) != '' ) {
				$buttonText = stripslashes( rsvp_pro_get_event_option( $rsvp_id, RSVP_PRO_OPTION_ADD_ATTENDEE_BUTTON_TEXT ) );
			}

			$form .= "<div id=\"additionalRsvpContainerText\">\r\n
						<h3>$text</h3>\r\n
						<input type=\"hidden\" name=\"additionalRsvpIds\" id=\"additionalRsvpIds\" value=\"\" />
						<input type=\"hidden\" name=\"additionalRsvp\" id=\"additionalProRsvp\" value=\"" . count( $newRsvps ) . "\" />
						<div style=\"text-align:right\" id=\"addWizardRsvp\"><button class=\"rsvpButton\">$buttonText</button></div>" .
					'</div>';
		}
	}

	$form .= "<div id=\"additionalRsvpContainer\">\r\n
              <input type=\"hidden\" name=\"junkTest\" value=\"\" />
				</div>";
	rsvp_pro_wizard_output_additional_js( $rsvp_id, $attendee, $attendeeID );

	return $form;
}

function rsvp_pro_buildAdditionalQuestionsForEvent( $attendeeID, $prefix, $eventId, $includeGroupQuestions, $rsvp_form_js_ids ) {
	global $wpdb, $rsvp_saved_form_vars;

	$output = '<div class="rsvpCustomQuestions">';

	$sql = 'SELECT q.id, q.question, questionType, q.sortOrder, q.required, q.required_text, e.id AS rsvpEventID, q.only_show_on_status FROM ' . PRO_QUESTIONS_TABLE . ' q
					INNER JOIN ' . PRO_QUESTION_TYPE_TABLE . ' qt ON qt.id = q.questionTypeID
          INNER JOIN ' . PRO_EVENT_TABLE . " e ON e.id = q.rsvpEventID
					WHERE (q.permissionLevel = 'public'
					  OR (q.permissionLevel = 'private' AND q.id IN (SELECT questionID FROM " . PRO_QUESTION_ATTENDEES_TABLE . " WHERE attendeeID = $attendeeID)))
            AND qt.questionType <> 'hidden'
            AND q.rsvpEventID = %d ";
	if ( ! $includeGroupQuestions ) {
		$sql .= "  AND grouping <> '" . RSVP_PRO_QG_MULTI . "' ";
	}

	$sql .= ' ORDER BY sortOrder';

	$questions = $wpdb->get_results( $wpdb->prepare( $sql, $eventId ) );
	$output   .= rsvp_pro_create_question_inputs( $attendeeID, $prefix, $questions, $rsvp_form_js_ids );

	return $output . '</div>';
}
