<?php
/**
 * @package rsvp-pro
 * @subpackage includes/admin
 * @author WPChill
 * @since 2.6.7
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) :
	exit;
endif;

/**
 * Class for creating the editor button to make it easier to insert the RSVP
 * shortcode into pages and posts.
 *
 * @since 2.6.7
 */
class Rsvp_Pro_Editor_Button {
	/**
	 * Checks to see if we are on a page that will need the form button
	 *
	 * @return bool     true or false depending on if the page supports a form button
	 * @since 2.6.7
	 */
	public static function page_supports_add_form_button() {
		$is_post_edit_page = in_array( basename( $_SERVER['PHP_SELF'] ), array( 'post.php', 'page.php', 'page-new.php', 'post-new.php' ) );

		return $is_post_edit_page;
	}

	/**
	 * Outputs the form button to allow short codes to be more easily added.
	 *
	 * @since 2.6.7
	 */
	public static function add_form_buttons() {
		$is_add_form_page = self::page_supports_add_form_button();
		if ( ! $is_add_form_page ) {
			return;
		}

		add_thickbox();

		echo '<style>
			.rsvppro_media_icon {
				background: url(' . plugins_url( '/images/rsvp_pro_icon_16_x_16.png', RSVP_PRO_PLUGIN_FILE ) . ') no-repeat top left;
				display: inline-block;
				height: 16px;
				width: 16px;
				vertical-align: text-top;
				margin: 0 2px;
			}
		</style>';

		echo '
			<a href="#TB_inline?width=480&inlineId=select_rsvp_pro_form" class="thickbox button rsvppro_media_link" id="add_rsvppro" title="' . rsvp_pro_get_admin_string( 'add_rsvp_pro_form_label' ) . '"><span class="rsvppro_media_icon"></span> ' . rsvp_pro_get_admin_string( 'add_rsvp_pro_form_label' ) . '</a>
		';
	}

	/**
	 * Adds in the needed JavaScript and HTML for the pop-up to select the RSVP
	 * Pro shortcode in the editor
	 *
	 * @since 2.6.8
	 */
	public static function add_form_popup() {
		global $wpdb; ?>
		<script>
			function InsertRsvpProForm(){
				var sc_type = jQuery("#rsvp_pro_type").val();
				var rsvp_id = jQuery("#add_rsvp_pro_form_id").val();

				if( sc_type == "event_list" ) {
					window.send_to_editor("[rsvppro-eventlist]");
				} else if ( sc_type == "attendee_event_list" ) {
					window.send_to_editor("[rsvp-pro-attendee-events]");
				} else if ( sc_type == "attendee_list" ) {
					window.send_to_editor("[rsvppro-attendeelist id=\"" + rsvp_id + "\"]");
				} else {
					window.send_to_editor("[rsvppro id=\"" + rsvp_id + "\"]");
				}
			}

			jQuery(document).ready(function($) {
				$("#insert_rsvp_form_button").click(function( event ) {
					event.preventDefault();
					InsertRsvpProForm();
				})
				$("#cancel_rsvp_form_button").click(function( event ) {
					event.preventDefault();
					tb_remove();
				});

				$("#rsvp_pro_type").change( function() {

					var sc_type = $("#rsvp_pro_type").val();

					if( sc_type == "event_list" || sc_type == "attendee_event_list" ) {
						$("#insert_rsvp_form_button").removeAttr("disabled");
						$("#event_selector_container").hide();
					} else if ( sc_type == "" ) {
						$("#insert_rsvp_form_button").attr("disabled", "true");
						$("#event_selector_container").hide();
					} else {
						$("#event_selector_container").show();
					}

				});

				$("#add_rsvp_pro_form_id").change( function() {
					if( $("#add_rsvp_pro_form_id").val() != "" ) {
						$("#insert_rsvp_form_button").removeAttr("disabled");
					} else {
						$("#insert_rsvp_form_button").attr("disabled", "true");
					}
				});
			});
		</script>

		<div id="select_rsvp_pro_form" style="display:none;">
			<div class="wrap">
				<div>
					<div>
						<h3><?php echo rsvp_pro_get_admin_string( 'insert_rsvp_pro_form_label' ); ?></h3>
					</div>
					<div>
						<label for="rsvp_pro_type"><?php echo rsvp_pro_get_admin_string( 'select_information_to_display_label' ); ?>:</label>
						<select id="rsvp_pro_type">
							<option value="">--</option>
							<option value="event_form"><?php echo rsvp_pro_get_admin_string( 'rsvp_form_label' ); ?></option>
							<option value="attendee_list"><?php echo rsvp_pro_get_admin_string( 'attendee_list_label' ); ?></option>
							<option value="event_list"><?php echo rsvp_pro_get_admin_string( 'event_list_label' ); ?></option>
							<option value="attendee_event_list"><?php echo rsvp_pro_get_admin_string( 'attendee_event_list_label' ); ?></option>
						</select>
					</div>
					<div><br /></div>
					<div id="event_selector_container" class="hidden">
						<label for="add_rsvp_pro_form_id"><?php echo rsvp_pro_get_admin_string( 'select_event_label' ); ?>:</label>
						<select id="add_rsvp_pro_form_id">
							<option value="">--</option>
							<?php
								$sql = 'SELECT id, eventName FROM ' . PRO_EVENT_TABLE . ' WHERE parentEventID = 0 OR parentEventID IS NULL';
							$events  = $wpdb->get_results( $sql );
							foreach ( $events as $e ) {
								?>
									<option value="<?php echo $e->id; ?>"><?php echo esc_html( $e->eventName ); ?></option>
								<?php
							}
							?>
						</select>
					</div>
					<div style="padding:15px;">
						<input type="button" id="insert_rsvp_form_button" class="button-primary" disabled="true" value="<?php echo rsvp_pro_get_admin_string( 'insert_event_label' ); ?>" />&nbsp;&nbsp;&nbsp;
						<a class="button" href="#" id="cancel_rsvp_form_button"><?php echo rsvp_pro_get_admin_string( 'cancel_label' ); ?></a>
					</div>
				</div>
			</div>
		</div>
		<?php
	}
}
?>
