<?php
	/**
	 * Sends out the reminder notifications.
	 *
	 * @since 2.2.4
	 */
function rsvp_pro_handle_reminder_notifications() {
	global $wpdb;

	$sql       = 'SELECT r.id, rsvpEventID FROM ' . PRO_EVENT_REMINDERS_TABLE . ' r
			JOIN ' . PRO_EVENT_TABLE . ' e ON e.id = r.rsvpEventID';
	$reminders = $wpdb->get_results( $sql );
	$currTime  = time();
	$headers   = array( 'Content-Type: text/html; charset=UTF-8' );
	foreach ( $reminders as $r ) {
		$queryString = 's=[rsvppro id="' . $r->rsvpEventID . '"]';
		$query       = new WP_Query( $queryString );
		$eventUrl    = '';
		if ( $query->have_posts() ) {
			$query->the_post();
			$eventUrl = get_permalink();
		}
		wp_reset_postdata();

		$base     = new Rsvp_Pro_Event_Reminders( $r->rsvpEventID );
		$reminder = new Rsvp_Pro_Event_Reminder_Dao( $r->id );

		$event_date = $base->get_reminder_base_date();
		if ( strToTime( $event_date ) >= $currTime ) {
			if ( rsvp_pro_time_to_send_reminder( $reminder, $currTime, $event_date ) ) {
				$sql = 'SELECT a.id, firstName, lastName, IFNULL(se.rsvpStatus, a.rsvpStatus) as rsvpStatus, 
                            note, passcode, email, salutation, suffix, IFNULL(se.rsvpDate, a.rsvpDate) as rsvpDate, a.token
		  					FROM ' . PRO_ATTENDEES_TABLE . ' a
		                	INNER JOIN ' . PRO_EVENT_TABLE . ' e ON e.id = a.rsvpEventID
                            LEFT JOIN ' . PRO_ATTENDEE_SUB_EVENTS_TABLE . ' se ON se.rsvpAttendeeID = a.id AND se.rsvpEventID = %d 
		                	WHERE ( (a.rsvpEventID = %d) ';

				if ( rsvp_pro_is_shared_attendee_list_enabled() ) {
					$sql .= ' OR (a.rsvpEventID = ' . RSVP_PRO_GLOBAL_ATTENDEE_EVENT_ID . ') ';
				}

				$sql         .= ") AND email <> '' AND ((IFNULL(e.event_access, '" . RSVP_PRO_OPEN_EVENT_ACCESS . "') != '" . RSVP_PRO_PRIVATE_EVENT_ACCESS . "') OR (a.id IN (SELECT rsvpAttendeeID FROM " . PRO_EVENT_ATTENDEE_TABLE . ' WHERE rsvpEventID = e.id)))';
				$rsvpStatuses = $reminder->get_RsvpStatuses();
				if ( ! empty( $rsvpStatuses ) ) {
					$sql .= " AND ( ( a.rsvpStatus IN ('" . implode( "','", explode( ',', $rsvpStatuses ) ) . "') AND a.rsvpEventID != " . RSVP_PRO_GLOBAL_ATTENDEE_EVENT_ID . " ) OR 
                            ( se.rsvpStatus IN ('" . implode( "','", explode( ',', $rsvpStatuses ) ) . "') ) ) ";
				}
				$attendees  = $wpdb->get_results( $wpdb->prepare( $sql, $r->rsvpEventID, $r->rsvpEventID ) );
				$junk_array = array();
				$email_body = $reminder->get_MessageBody();
				$base_email_body = apply_filters( 'rsvp_pro_notification_email_body', $email_body );
				foreach ( $attendees as $a ) {
					$subject    = rsvp_pro_admin_replaceVariablesForEmail( $a, $eventUrl, $reminder->get_MessageSubject(), $r->rsvpEventID, $junk_array );
					$email_body = rsvp_pro_admin_replaceVariablesForEmail( $a, $eventUrl, $base_email_body, $r->rsvpEventID, $junk_array );
					$subject    = stripslashes( $subject );
					$email_body = nl2br( stripslashes( $email_body ) );
					rsvp_pro_send_mail( $a->email, $subject, $email_body, $headers );
				}
			}
		}
	}
}

	/**
	 * Checks to see if this reminder needs to be sent on the current day or not.
	 *
	 * @param  Rsvp_Pro_Event_Reminder_Dao $reminder The data-access object for the reminder
	 * @param  time                        $currTime Current time that we started to run this check
	 * @param  date                        $event_date The current event date we are using...
	 * @return bool           Either true we need to run the time or false otherwise.
	 */
function rsvp_pro_time_to_send_reminder( $reminder, $currTime, $event_date ) {
	$reminderDate = strtotime( '-' . $reminder->get_Period() . ' ' . $reminder->get_TimeType(), strtotime( $event_date ) );
	$sendOn       = strtotime( $reminder->get_SendOn() );

	if ( strtotime( date( 'm/d/Y', $reminderDate ) ) == strtotime( date( 'm/d/Y', $currTime ) ) ) {
		return true;
	}

	if ( ! empty( $sendOn ) &&
		( strtotime( date( 'm/d/Y', $sendOn ) ) == strtotime( date( 'm/d/Y', $currTime ) ) ) &&
		( $sendOn != '0' ) ) {
		return true;
	}

	return false;
}
