<?php

/**
 * Registers the string to polylang so it can be edited via the admin panel
 *
 * @param  string $string_name  The name of the string that will be shown in the admin panel.
 * @param  string $string_value The string that will be displayed to the user.
 * @param  string $group_name The string settings group name the strings should be displayed under.
 */
function rsvp_pro_register_polylang_strings( $string_name, $string_value, $group_name = 'RSVP Pro' ) {
	if ( function_exists( 'pll_register_string' ) ) {
		pll_register_string( $string_name, $string_value, $group_name );
	}
}

/**
 * Registers the strings for WPML. This is only used for strings that are dynamic.
 * As WPML handles strings automatically using gettext.
 *
 * @param  string $string_name  The name of the string.
 * @param  string $string_value The string that needs to be made available for translation.
 * @param  int.   $event_id     The current event ID.
 * @param  string $event_name   The event name.
 */
function rsvp_pro_register_wpml_strings( $string_name, $string_value, $event_id, $event_name ) {
	if ( has_action( 'wpml_register_string' ) ) {
		$package  = array(
			'kind'  => "RSVPPro - {$event_id}",
			'name'  => "rsvp-pro-plugin-{$event_id}",
			'title' => "RSVP Pro Plugin - {$event_name}",
		);
		$key_name = strtolower( $string_name );
		$key_name = str_replace( ' ', '-', $key_name );
		do_action( 'wpml_register_string', $string_value, $key_name, $package, $string_name, 'AREA' );
	}
}

/**
 * Iterates through the frontend and admin strings and registers them so they can be modified
 * in the admin area.
 */
function rsvp_pro_register_strings() {
	global $wpdb;
	global $us_rsvp_pro_frontend_strings;

	foreach ( $us_rsvp_pro_frontend_strings as $key => $val ) {
		rsvp_pro_register_polylang_strings( $val['name'], $val['text'] );
	}

	$admin_strings = rsvp_pro_get_admin_strings();
	foreach ( $admin_strings as $key => $val ) {
		rsvp_pro_register_polylang_strings( $val['name'], $val['text'], 'RSVP Pro Admin' );
	}

	$sql    = 'SELECT id, eventName, eventLocation, eventDescription FROM ' . PRO_EVENT_TABLE . ' WHERE id != ' . RSVP_PRO_GLOBAL_ATTENDEE_EVENT_ID;
	$events = $wpdb->get_results( $sql );
	foreach ( $events as $e ) {
		$event_name = stripslashes( $e->eventName );

		$sql       = 'SELECT id, question FROM ' . PRO_QUESTIONS_TABLE . ' WHERE rsvpEventID = %d';
		$questions = $wpdb->get_results( $wpdb->prepare( $sql, $e->id ) );
		foreach ( $questions as $q ) {
			$key_name = stripslashes( $e->eventName . ' - ' . $q->question );
			$question = stripslashes( $q->question );
			rsvp_pro_register_dynamic_strings( $key_name, $question, $e->id, $event_name );

			$sql     = 'SELECT id, answer FROM ' . PRO_QUESTION_ANSWERS_TABLE . ' WHERE questionID = %d';
			$answers = $wpdb->get_results( $wpdb->prepare( $sql, $q->id ) );
			foreach ( $answers as $a ) {
				$key_name = stripslashes( $q->question . ' - ' . $a->answer );
				rsvp_pro_register_dynamic_strings( $key_name, stripslashes( $a->answer ), $e->id, $event_name );
			}
		}

		// Get the options to add as option for translation for email templates.
		$options = new Rsvp_Pro_Event_Options( $e->id );

		$strings_to_register = array(
			array(
				'key'   => $event_name . ' - ' . rsvp_pro_get_admin_string( 'settings_guest_eamil_text_label' ),
				'value' => $options->get_rsvp_email_text(),
			),
			array(
				'key'   => $event_name . ' - ' . rsvp_pro_get_admin_string( 'settings_email_attendee_body_label' ),
				'value' => $options->get_email_body(),
			),
			array(
				'key'   => $event_name . ' - ' . rsvp_pro_get_admin_string( 'settings_email_attendee_body_no_label' ),
				'value' => $options->get_no_email_body(),
			),
			array(
				'key'   => $event_name . ' - ' . rsvp_pro_get_admin_string( 'settings_attendee_list_format_description' ),
				'value' => $options->get_waitlist_status_email(),
			),
			array(
				'key'   => $event_name . ' - ' . rsvp_pro_get_frontend_string( 'event_location_label' ),
				'value' => stripslashes( $e->eventLocation ),
			),
			array(
				'key'   => $event_name . ' - ' . rsvp_pro_get_admin_string( 'settings_event_description_label' ),
				'value' => stripslashes( $e->eventDescription ),
			),
			array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_QUESTION,
				'value' => $options->get_rsvp_question_text(),
			),
			array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_YES_VERBIAGE,
				'value' => $options->get_rsvp_yes_label(),
			),
			array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_NO_VERBIAGE,
				'value' => $options->get_rsvp_no_label(),
			),
			array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_WAITLIST_VERBIAGE,
				'value' => $options->get_rsvp_waitlist_label(),
			),
			array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_MAYBE_VERBIAGE,
				'value' => $options->get_rsvp_maybe_label(),
			),
			array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_PLUS_ONE_LABEL,
				'value' => $options->get_plus_one_label(),
			),
			array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_MAX_COUNT_REACHED_TEXT,
				'value' => $options->get_rsvp_limit_text(),
			),
			array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_WAITLIST_TEXT,
				'value' => $options->get_rsvp_waitlist_text(),
			),
			array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_CALENDAR_LINK_TEXT,
				'value' => $options->get_calendar_link_text(),
			),
			array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_GOOGLE_CALENDAR_LINK_TEXT,
				'value' => $options->get_google_calendar_link_text(),
			),
		);

		if ( ! rsvp_pro_is_sub_event( $e->id ) ) {
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_FIRST_NAME_LABEL,
				'value' => $options->get_first_name_label(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_LAST_NAME_LABEL,
				'value' => $options->get_last_name_label(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_YES_TEXT,
				'value' => $options->get_yes_text(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_NO_TEXT,
				'value' => $options->get_no_text(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_MAYBE_TEXT,
				'value' => $options->get_maybe_text(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_YES_PLUS_ONE_TEXT,
				'value' => $options->get_plus_one_text(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_HI_TEXT,
				'value' => $options->get_hi_text(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_NO_RESPONSE_TEXT,
				'value' => $options->get_no_response_text(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_OPEN_DATE_TEXT,
				'value' => $options->get_open_date_text(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_CLOSE_DATE_TEXT,
				'value' => $options->get_close_date_text(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_GREETING,
				'value' => $options->get_greeting_text(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_MODIFY_REGISTRATION_TEXT,
				'value' => $options->get_modify_registration_text(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_PASSCODE_LABEL,
				'value' => $options->get_passcode_label(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_NEW_ATTENDEE_BUTTON_TEXT,
				'value' => $options->get_new_attendee_button_text(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_DISPLAY_SEARCH_FORM_TEXT,
				'value' => $options->get_display_search_form_text(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_COMPLETE_BUTTON_TEXT,
				'value' => $options->get_complete_button_text(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_UNABLE_TO_FIND_TEXT,
				'value' => $options->get_unable_find_text(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_EDIT_PROMPT_TEXT,
				'value' => $options->get_edit_prompt_text(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_RSVP_ONLY_ONCE_TEXT,
				'value' => $options->get_rsvp_only_once_text(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_FUZZY_MATCH_TEXT,
				'value' => $options->get_fuzzy_match_text(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_MULTIPLE_MATCHES_TEXT,
				'value' => $options->get_multiple_matches_text(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_MULTIPLE_ATTENDEE_TEXT,
				'value' => $options->get_multiple_attendee_text(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_PROMPT_TO_ADD_IF_NOT_FOUND_TEXT,
				'value' => $options->get_rsvp_prompt_to_add_not_found_text(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_WELCOME_TEXT,
				'value' => $options->get_welcome_text(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_WELCOME_BACK_TEXT,
				'value' => $options->get_welcome_back_text(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_SALUTATION_LABEL,
				'value' => $options->get_salutation_label(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_SUFFIX_LABEL,
				'value' => $options->get_suffix_label(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_EMAIL_LABEL,
				'value' => $options->get_email_label(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_PASSCODE_EDITABLE_LABEL,
				'value' => $options->get_passcode_editable_label(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_UNDER_RSVP_TEXT,
				'value' => $options->get_text_under_rsvp(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_NOTE_VERBIAGE,
				'value' => $options->get_additional_note_label(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_RSVP_BUTTON_TEXT,
				'value' => $options->get_rsvp_frontend_button_text(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_NEXT_BUTTON_TEXT,
				'value' => $options->get_next_button_text(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_ADD_ADDITIONAL_VERBIAGE,
				'value' => $options->get_add_additional_text(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_ASSOCIATED_ATTENDEE_GREETING,
				'value' => $options->get_associated_greeting(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_ADD_ATTENDEE_BUTTON_TEXT,
				'value' => $options->get_add_attendee_button_text(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_REMOVE_ATTENDEE_BUTTON_TEXT,
				'value' => $options->get_remove_attendee_button(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_ASSOCIATED_MESSAGE,
				'value' => $options->get_associated_message(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_ADDITIONAL_GREETING_TEXT,
				'value' => $options->get_additional_attendee_text(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_GDPR_QUESTION_TEXT,
				'value' => $options->get_gdpr_question_text(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_FIRST_NAME_JS_MESSAGE,
				'value' => $options->get_first_name_js_message(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_LAST_NAME_JS_MESSAGE,
				'value' => $options->get_last_name_js_message(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_NOTE_JS_MESSAGE,
				'value' => $options->get_note_js_message(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_EMAIL_JS_MESSAGE,
				'value' => $options->get_email_js_message(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_GDPR_JS_MESSAGE,
				'value' => $options->get_gdpr_js_message(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_UNIQUE_PASSCODE_JS_MESSAGE,
				'value' => $options->get_unique_passcode_js_message(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_UNIQUE_EMAIL_JS_MESSAGE,
				'value' => $options->get_unique_email_js_message(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_MULTI_EVENT_TITLE,
				'value' => $options->get_multi_event_title(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_MULTI_OPTION_TEXT,
				'value' => $options->get_multi_option_text(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_THANKYOU_MODIFY_TEXT,
				'value' => $options->get_thankyou_modify_text(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_THANKYOU_PASSWORD_TEXT,
				'value' => $options->get_thankyou_password_text(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_THANKYOU_ASSOCIATED_TEXT,
				'value' => $options->get_thankyou_associated_text(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_THANKYOU,
				'value' => $options->get_thank_you_text(),
			);
			$strings_to_register[] = array(
				'key'   => $event_name . ' - ' . RSVP_PRO_OPTION_NOT_COMING,
				'value' => $options->get_not_coming_verbiage(),
			);
		}

		foreach ( $strings_to_register as $s ) {
			rsvp_pro_register_dynamic_strings( $s['key'], $s['value'], $e->id, $event_name );
		}
	}
}

/**
 * Used to register a dynamic string in WPML and Polylang.
 *
 * @param  string $key_name   The name of the key which we will use later to retrieve the translation.
 * @param  string $value      The value we wish to store for the translation.
 * @param  $int    $event_id   The event ID we want to register this string for.
 * @param  string $event_name The name of the event.
 */
function rsvp_pro_register_dynamic_strings( $key_name, $value, $event_id, $event_name ) {
	rsvp_pro_register_polylang_strings( $key_name, $value );
	rsvp_pro_register_wpml_strings( $key_name, $value, $event_id, $event_name );
}
