<?php

if ( !defined( 'ABSPATH' ) ){
	exit;
}

class RSVP_PRO_Screen_Options {

	/**
	 * The class instance.
	 *
	 * @var null
	 */
	private static $instance = null;

	/**
	 * Our options
	 *
	 * @var array
	 */
	public $options = array();

	private static $screen_option = 'rsvp_screen_options';

	/**
	 * The admin page where options should be shown
	 *
	 * @var string
	 */
	private static $adminpage = 'toplevel_page_rsvp-pro-top-level';

	/**
	 * Creates or returns an instance of this class.
	 *
	 * @return RSVP_PRO_Screen_Options A single instance of this class.
	 * @since  4.4.8
	 */
	public static function get_instance(){
		if ( null === self::$instance ){
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * The class constructor.
	 *
	 * @since 4.4.8
	 */
	private function __construct(){

		add_filter( 'screen_settings', array( $this, 'show_screen_options' ), 10, 2 );
		add_filter( 'set_screen_option_' . self::$screen_option, array( $this, 'screen_option_values' ), 15, 3 );
		$this->set_screen_options();
	}

	/**
	 * The HTML markup to wrap around each option.
	 *
	 * @since 4.4.8
	 */
	public function before(){
		?>
		<fieldset>
		<?php
	wp_nonce_field( 'screen-options-nonce', 'screenoptionnonce', false, false )
		?>
		<legend><?php esc_html_e( 'RSVP Screen options', 'rsvp-pro-plugin' ); ?></legend>
		<div class="metabox-prefs">
		<input type="hidden" name="wp_screen_options[option]" value="<?php echo esc_attr( self::$screen_option ); ?>"/>
		<input type="hidden" name="wp_screen_options[value]" value="yes"/>
		<div class="">
		<?php
	}

	/**
	 * The HTML markup to close the options.
	 *
	 * @since 4.4.8
	 */
	public function after(){
		$button = get_submit_button( esc_html__( 'Apply', 'rsvp-pro-plugin' ), 'button button-primary', 'screen-options-apply', false );
		?>
		</div>
		</div><!-- metabox-prefs -->
		</fieldset>
		<br class="clear">
		<?php
		echo $button; // WPCS: XSS ok.
	}

	/**
	 * Display a screen option.
	 *
	 * @param $key
	 * @param $value
	 *
	 * @since 4.4.8
	 */
	public function show_option( $key, $value ){
		$id        = "rsvp_screen_option_$key";
		$user_meta = get_user_meta( get_current_user_id(), self::$screen_option );

		switch ( $value['type'] ){
			case 'number' :
				?>
				<label for="<?php echo esc_textarea( $id ); ?>">
					<?php echo esc_html( $value['title'] ); ?>
					<input type="number" name="rsvp_screen_option[<?php echo esc_textarea( $key ); ?>]"
						   id="<?php echo esc_textarea( $id ); ?>"
						   value="<?php echo esc_attr( ( $user_meta && isset( $user_meta[0][ $key ] ) ? $user_meta[0][ $key ] : $value['default'] ) ); ?>"/>
				</label>
				<?php
				break;
			default :
				do_action( 'rsvp_screen_options_type_' . $value['type'], $id, $key, $value );
		}
	}

	/**
	 * Render the screen options block.
	 *
	 * @param string $status The screen options markup.
	 * @param object $args   An object of screen options data.
	 *
	 * @return string         The filtered screen options block.
	 *
	 * @since 4.4.8
	 */
	public function show_screen_options( $status, $args ){
		$screen = get_current_screen();

		// Add screen options only for attendees
		if ( !is_object( $screen ) || self::$adminpage !== $screen->id || !isset( $_GET['action'] ) || 'attendees' != $_GET['action'] ){
			return;
		}

		ob_start();

		$this->before();

		foreach ( $this->options as $key => $value ){
			$this->show_option( $key, $value );
		}
		$this->after();

		return ob_get_clean();
	}

	/**
	 * Set our screen options
	 *
	 * @since 4.4.8
	 */
	public function set_screen_options(){

		$this->options = apply_filters( 'rsvp_screen_options',
				array(
						'pagesize' => array(
								'default' => '25',
								'title'   => __( 'Number of items per page: ', 'rsvp-pro-plugin' ),
								'type'    => 'number'
						),
				)
		);
	}

	/**
	 * User submitted values for our options
	 *
	 * @param $screen_option
	 * @param $option
	 * @param $value
	 *
	 * @return array
	 * @Since 4.4.8
	 */
	public function screen_option_values( $screen_option, $option, $value ){
		$values = array();

		if ( $_POST && isset( $_POST['rsvp_screen_option'] ) ){
			if ( !empty( $_POST['rsvp_screen_option'] ) ){

				foreach ( $_POST['rsvp_screen_option'] as $rsvp_option => $rsvp_value ){
					$values[ $rsvp_option ] = $rsvp_value;
				}
			}
			return $values;
		}

		return $value;

	}
}

RSVP_PRO_Screen_Options::get_instance();
