<?php

/**
 * Handles the functionality to allow attendees to look up all
 * events that they are associated with via their email address.
 *
 * @return string The HTML for this functionality.
 */
function rsvp_pro_frontend_attendee_event_list() {
	$output = '<div id="rsvp_pro_attendee_event_lookup">';
	if ( isset( $_POST['email'] ) && ! empty( $_POST['email'] ) ) {
		$output .= rsvp_pro_frontend_attendee_event_lookup( $_POST['email'] );
	} else {
		$output .= rsvp_pro_frontend_attendee_event_lookup_form();
	}

	return $output . '</div>';
}

/**
 * Tries to find an attendee based on the email address and then prints
 * out all of the associated events.
 *
 * @param  string $email The email address we are looking up for.
 * @return string        The output from the lookup.
 */
function rsvp_pro_frontend_attendee_event_lookup( $email ) {
	global $wpdb;
	$output = '';
	ob_start();
	$events    = array();
	$sql       = 'SELECT DISTINCT e.id, e.eventName
		FROM ' . PRO_ATTENDEES_TABLE . ' a 
		JOIN ' . PRO_EVENT_TABLE . ' e ON e.id = a.rsvpEventID
		WHERE email = %s AND e.id != ' . RSVP_PRO_GLOBAL_ATTENDEE_EVENT_ID . ' AND ( ( e.event_access != \'select\' ) OR a.id IN (SELECT rsvpAttendeeID FROM ' . PRO_EVENT_ATTENDEE_TABLE . ' WHERE rsvpEventID = e.id) ) ';
	$db_events = $wpdb->get_results( $wpdb->prepare( $sql, $email ) );
	foreach ( $db_events as $e ) {
		$events[ $e->id ] = stripslashes_deep( $e->eventName );
	}

	// See if the attendee is found in the global attendee list.
	if ( rsvp_pro_is_shared_attendee_list_enabled() ) {
		$sql = 'SELECT id FROM ' . PRO_ATTENDEES_TABLE . ' WHERE email = %s';
		$aid = $wpdb->get_var( $wpdb->prepare( $sql, $email ) );
		if ( null !== $aid ) {
			$sql = 'SELECT DISTINCT e.id, e.eventName 
			FROM ' . PRO_EVENT_TABLE . ' e  
			WHERE (parentEventID = 0 OR parentEventID IS NULL) AND 
			( ( e.event_access != \'select\' ) OR ( SELECT COUNT(*) FROM ' . PRO_EVENT_ATTENDEE_TABLE . ' eae JOIN  ' . PRO_ATTENDEES_TABLE . ' a ON eae.rsvpAttendeeID = a.id WHERE e.id = eae.rsvpEventID AND a.email = %s AND a.rsvpEventID = ' . RSVP_PRO_GLOBAL_ATTENDEE_EVENT_ID . ' ) > 0 )';
			$db_events = $wpdb->get_results( $wpdb->prepare( $sql, $email ) );
			foreach( $db_events as $e ) {
				if ( ! isset( $events[ $e->id ] ) ) {
					$events[ $e->id ] = stripslashes_deep( $e->eventName );
				}
			}
		}
	}
	if ( count( $events ) <= 0 ) {
		?>
		<p class="rsvpParagraph"><?php echo rsvp_pro_get_frontend_string( 'attendee_event_list_unable_message' ); ?></p>
		<?php
		echo rsvp_pro_frontend_attendee_event_lookup_form();
	} else {
		$event_link_text = rsvp_pro_get_frontend_string( 'attendee_event_list_link_text' );

		if ( get_option( RSVP_PRO_GLOBAL_OPTION_ATTENDEE_RSVP_FOR_TEXT ) !== '' ) {
			$event_link_text = get_option( RSVP_PRO_GLOBAL_OPTION_ATTENDEE_RSVP_FOR_TEXT );
		}

		foreach ( $events as $key => $val ) {
			$event_url = rsvp_pro_get_event_permalink( $key );
			if ( '' !== $event_url ) {
				?>
				<p class="rsvpParagraph">
					<a href="<?php echo $event_url; ?>"><?php echo esc_html( sprintf( $event_link_text, $val ) ); ?></a>
				</p>
				<?php
			}
		}
	}

	$output = ob_get_clean();
	return $output;
}

/**
 * Returns the output for the initial form for looking up an attendee's events.
 *
 * @return string The HTML form output.
 */
function rsvp_pro_frontend_attendee_event_lookup_form() {
	$output = '';
	ob_start();
	$greeting_message = rsvp_pro_get_frontend_string( 'attendee_event_list_greeting' );

	if ( '' !== get_option( RSVP_PRO_GLOBAL_OPTION_ATTENDEE_LIST_GREETING_TEXT ) ) {
		$greeting_message = get_option( RSVP_PRO_GLOBAL_OPTION_ATTENDEE_LIST_GREETING_TEXT );
	}
	?>
	<p class="rsvpParagraph"><?php echo $greeting_message; ?></p>
	<form id="rsvp_pro_attendee_event_list_lookup" method="post">
		<div class="rsvpFormField">
			<label for="email"><?php rsvp_pro_get_frontend_string( 'email_label' ); ?></label>
			<input type="text" name="email" id="email" required />
		</div>
		<div class="rsvpFormField">
			<p class="rsvpSubmitContainer rsvpParagraph">
				<input type="submit" class="rsvpSubmit" value="<?php echo rsvp_pro_get_frontend_string( 'find_me_label' ); ?>" />
			</p>
		</div>
	</form>
	<?php
	$output = ob_get_clean();
	return $output;
}
