<?php
/**
 * @package rsvp-pro
 * @author WPChill
 * @version 4.4.14
 * Plugin Name: RSVP Pro
 * Text Domain: rsvp-pro-plugin
 * Plugin URI: https://rsvpproplugin.com
 * Description: This plugin allows guests to RSVP to an event.
 * Author: WPChill
 * Version: 4.4.14
 * Author URI: https://wpchill.com/
 * License: GPL
 *
 * INSTALLATION: see readme.txt
 *
 * USAGE: Once the RSVP plugin has been installed, you can set the custom text
 *        via Settings -> RSVP Options in the  admin area.
 *
 *        To add, edit, delete and see rsvp status there will be a new RSVP admin
 *        area just go there.
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! defined( 'RSVP_PRO_PLUGIN_PATH' ) ) {
	$my_plugin_file = __FILE__;
	define( 'RSVP_PRO_PLUGIN_PATH', WP_PLUGIN_DIR . '/' . basename( dirname( $my_plugin_file ) ) );
}
/**
 * Main RSVP Pro Class, this is a singleton.
 *
 * @since 2.1.4
 */
final class Rsvp_Pro {
	/**
	 * @var Singleton instance variable
	 * @since 2.1.4
	 */
	private static $instance;

	/**
	 *  Creates the instance for the Rsvp_Pro object.
	 *
	 *  Enforces that this object is a singleton and is only created once..
	 *
	 * @since 2.1.4
	 * @static
	 * @return object|Rsvp_Pro
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) && ! ( self::$instance instanceof Rsvp_Pro ) ) {
			self::$instance = new Rsvp_Pro();
			self::$instance->create_constants();
			self::$instance->include_files();
		}

		return self::$instance;
	}

	/**
	 * Create the bootstrap constants needed for this plugin
	 *
	 * @access private
	 * @since 2.1.4
	 * @return void
	 */
	private function create_constants() {
		global $plugin, $mu_plugin, $network_plugin;

		$my_plugin_file = __FILE__;

		if ( isset( $plugin ) && strstr( $plugin, 'rsvp-pro.php' ) ) {
			$my_plugin_file = $plugin;
		} elseif ( isset( $mu_plugin ) ) {
			$my_plugin_file = $mu_plugin;
		} elseif ( isset( $network_plugin ) ) {
			$my_plugin_file = $network_plugin;
		}

		if ( ! defined( 'RSVP_PRO_PLUGIN_FILE' ) ) {
			define( 'RSVP_PRO_PLUGIN_FILE', $my_plugin_file );
		}

	}

	/**
	 * Include the files for the plugin to run. This function will slowly
	 * be removed as we refactor
	 *
	 * @access private
	 * @since 2.1.4
	 * @return void
	 */
	private function include_files() {
		require_once RSVP_PRO_PLUGIN_PATH . '/includes/wp-constants.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/includes/frontend/rsvp-pro-frontend-strings.inc.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/includes/admin/rsvp-pro-admin-strings.inc.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/includes/rsvp-utils.inc.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/includes/rsvp-db-setup.inc.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/includes/rsvp-frontend.inc.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/includes/rsvp-licensing.inc.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/includes/rsvp-pro-wizard-forms.inc.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/includes/admin/class-rsvp-pro-list-table.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/includes/admin/class-rsvp-pro-events-list-table.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/includes/admin/class-rsvp-pro-attendees-list-table.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/includes/admin/class-rsvp-pro-questions-list-table.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/includes/admin/class-rsvp-pro-admin-helper.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/includes/admin/class-rsvp-pro-screen-options.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/includes/admin/reoccurring-handler.inc.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/includes/admin/cron-attendee-list-notifications.inc.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/includes/admin/cron-reminder-notifications.inc.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/includes/admin/export_attendee_handler.inc.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/includes/admin/rsvp_pro_admin_dashboard_widget.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/includes/admin/rsvp_pro_admin_event_list.inc.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/includes/admin/rsvp_pro_admin_guest_list.inc.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/includes/admin/rsvp_pro_admin_change_log.inc.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/includes/admin/rsvp_pro_admin_attendee_form.inc.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/includes/admin/rsvp_pro_admin_mass_email.inc.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/includes/admin/rsvp_pro_admin_import.inc.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/includes/admin/rsvp_pro_translator_integrations.inc.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/includes/rsvp-updater.inc.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/includes/class_rsvp_pro_event_options.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/external-libs/wp-simple-nonce/wp-simple-nonce.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/external-libs/phpqrcode/qrlib.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/includes/frontend/rsvp-pro-handle-payment-responses.inc.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/includes/frontend/rsvp-pro-handle-rsvp.inc.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/includes/frontend/rsvp-pro-additional-attendee-js.inc.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/includes/frontend/rsvp-pro-attendee-list.inc.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/includes/frontend/rsvp-pro-event-list.inc.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/includes/frontend/class-rsvp-pro-event-list-widget.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/includes/admin/class_rsvp_pro_message_logs.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/includes/admin/class_rsvp_pro_reminders.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/includes/admin/class_rsvp_pro_reminder_dao.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/includes/admin/class_rsvp_pro_editor_button.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/includes/class-rsvp-pro-attendee.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/includes/class-rsvp-pro-attendee-answers.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/includes/class-rsvp-pro-attendee-changelog.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/includes/class-rsvp-pro-attendee-subevent.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/includes/class-rsvp-pro-attendee-event-costs.php';
		if ( interface_exists( 'Psr\Log\LoggerInterface' ) === false ) {
			require_once RSVP_PRO_PLUGIN_PATH . '/external-libs/Psr/Log/LoggerInterface.php';
		}

		if ( class_exists( 'Psr\Log\LogLevel' ) === false ) {
			require_once RSVP_PRO_PLUGIN_PATH . '/external-libs/Psr/Log/LogLevel.php';
		}

		if ( class_exists( 'Psr\Log\AbstractLogger' ) === false ) {
			require_once RSVP_PRO_PLUGIN_PATH . '/external-libs/Psr/Log/AbstractLogger.php';
		}
		require_once RSVP_PRO_PLUGIN_PATH . '/external-libs/paypal/autoload.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/includes/payment_gateways/class-rsvp-pro-stripe-payment-gateway.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/includes/payment_gateways/class-rsvp-pro-paypal-payment-gateway.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/includes/frontend/rsvp-pro-attendee-event-list.inc.php';
		require_once RSVP_PRO_PLUGIN_PATH . '/includes/wp-rsvp.php';
	}
}

/**
 * Main function that returns the object for the RSVP Pro Plugin.
 *
 * It will return a singleton of the main object for the plugin
 *
 * @since 2.1.4
 * @return object|Rsvp_Pro
 */
function rsvp_pro() {
	return Rsvp_Pro::instance();
}

// Get the plugin running.
rsvp_pro();
