<?php
/**
 * Uninstall RSVP Pro Plugin
 *
 * @package     rsvp pro
 * @subpackage  Uninstall
 * @copyright   Copyright (c) 2016, MDE Development, LLC
 * @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since       2.0.7
 */

// Exit if accessed directly
if (! defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

global $wpdb;

require_once( 'rsvp-pro.php' );

if ( get_option( RSVP_PRO_GLOBAL_OPTION_DELETE_TABLES ) == 'Y' ) {

	// Delete the tables
	$wpdb->query( 'DROP TABLE IF EXISTS ' . $wpdb->prefix . 'rsvpAttendeeSubEvents' );
	$wpdb->query( 'DROP TABLE IF EXISTS ' . $wpdb->prefix . 'rsvpAssociatedAttendees' );
	$wpdb->query( 'DROP TABLE IF EXISTS ' . $wpdb->prefix . 'rsvpAttendeesChangelog' );
	$wpdb->query( 'DROP TABLE IF EXISTS ' . $wpdb->prefix . 'rsvpAttendees' );
	$wpdb->query( 'DROP TABLE IF EXISTS ' . $wpdb->prefix . 'rsvpProCustomQuestions' );
	$wpdb->query( 'DROP TABLE IF EXISTS ' . $wpdb->prefix . 'rsvpProQuestionTypes' );
	$wpdb->query( 'DROP TABLE IF EXISTS ' . $wpdb->prefix . 'rsvpAttendeeAnswers' );
	$wpdb->query( 'DROP TABLE IF EXISTS ' . $wpdb->prefix . 'rsvpProCustomQuestionAnswers' );
	$wpdb->query( 'DROP TABLE IF EXISTS ' . $wpdb->prefix . 'rsvpProCustomQuestionAttendees' );
	$wpdb->query( 'DROP TABLE IF EXISTS ' . $wpdb->prefix . 'rsvpEvents' );
	$wpdb->query( 'DROP TABLE IF EXISTS ' . $wpdb->prefix . 'rsvpEventAttendees' );
	$wpdb->query( 'DROP TABLE IF EXISTS ' . $wpdb->prefix . 'rsvpEventReminders' );
	$wpdb->query( 'DROP TABLE IF EXISTS ' . $wpdb->prefix . 'rsvpMessageLog' );
	$wpdb->query( 'DROP TABLE IF EXISTS ' . $wpdb->prefix . 'rsvpMessageLogAttendees' );
	$wpdb->query( 'DROP TABLE IF EXISTS ' . $wpdb->prefix . 'rsvpAttendeeEventCosts' );

	// Delete the options.
	delete_option( 'rsvp_pro_db_version' );
	delete_option( RSVP_PRO_GLOBAL_OPTION_DELETE_TABLES );
	delete_option( RSVP_PRO_GLOBAL_OPTION_STYLES );
	delete_option( RSVP_PRO_GLOBAL_OPTION_AUTO_CREATE_PAGE );
	delete_option( RSVP_PRO_GLOBAL_OPTION_ADD_ATTENDEE_LIST_TO_PAGE );
	delete_option( RSVP_PRO_GLOBAL_OPTION_AUTO_POST_TYPE );
	delete_option( RSVP_PRO_GLOBAL_OPTION_AUTO_CREATE_ATTENDEE_LIST );
	delete_option( RSVP_PRO_GLOBAL_OPTION_DISABLE_COMMENTS );
	delete_option( RSVP_PRO_GLOBAL_ENABLE_GLOBAL_ATTENDEE_LIST );
	delete_option( RSVP_PRO_GLOBAL_OPTION_ENABLE_ATTENDEE_CHANGELOG );
}
