<?php
/**
 * Class file that handles the event options
 *
 * @since 2.4.2
 * @package rsvp-pro-plugin
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) :
	exit;
endif;

/**
 * Class for handling all of the event options and saving them back to the database.
 *
 * @since 2.2.4
 */
class Rsvp_Pro_Event_Options {

	/**
	 * Current event ID, can be zero
	 *
	 * @var int
	 */
	private $event_id = 0;

	private $greeting_text                 = '';
	private $welcome_text                  = '';
	private $hide_welcome_text             = 'N';
	private $hide_main_rsvp_question       = 'N';
	private $rsvp_question_text            = '';
	private $rsvp_yes_label                = '';
	private $rsvp_no_label                 = '';
	private $rsvp_waitlist_label           = '';
	private $rsvp_maybe_label              = '';
	private $text_under_rsvp               = '';
	private $additional_note_label         = '';
	private $thank_you_text                = '';
	private $thank_you_redirect            = '';
	private $hide_additional_guests        = 'N';
	private $notify_user                   = 'N';
	private $notify_email                  = '';
	private $require_passcode              = 'N';
	private $passcode_editable             = 'N';
	private $passcode_editable_label       = '';
	private $hide_note                     = 'N';
	private $rsvp_open_reg                 = 'N';
	private $display_search_button_text    = '';
	private $rsvp_hide_search              = 'N';
	private $rsvp_show_search_button_text  = '';
	private $rsvp_open_prompt_to_add       = 'N';
	private $rsvp_open_prompt_to_add_text  = '';
	private $dont_use_hash                 = 'N';
	private $add_additional_text           = '';
	private $guest_email_confirm           = 'N';
	private $num_additional_guests         = '';
	private $hide_email_field              = 'N';
	private $unique_email_validation       = 'N';
	private $disable_custom_email_from     = 'N';
	private $only_passcode                 = 'N';
	private $unique_passcode               = 'N';
	private $rsvp_email_text               = '';
	private $rsvp_no_editing               = 'N';
	private $rsvp_no_edit_prompt           = 'N';
	private $rsvp_only_once                = 'N';
	private $rsvp_only_once_text           = '';
	private $rsvp_disable_user_search      = 'N';
	private $not_coming_verbiage           = '';
	private $not_coming_redirect           = '';
	private $thankyou_modify_text          = '';
	private $thankyou_password_text        = '';
	private $thankyou_associated_text      = '';
	private $show_suffix                   = 'N';
	private $show_salutation               = 'N';
	private $salutations                   = RSVP_PRO_DEFAULT_SALUTATION;
	private $password_length               = 6;
	private $show_no_response              = 'N';
	private $require_email                 = 'N';
	private $require_rsvp_values           = 'N';
	private $hide_rsvp                     = 'N';
	private $default_rsvp_value            = '';
	private $no_passcode_on_open           = 'N';
	private $frontend_wizard               = 'N';
	private $new_attendee_button_text      = '';
	private $rsvp_frontend_button_text     = '';
	private $next_button_text              = '';
	private $rsvp_limit                    = '';
	private $rsvp_limit_text               = '';
	private $rsvp_enable_waitlist          = 'N';
	private $rsvp_enable_maybe             = 'N';
	private $rsvp_waitlist_text            = '';
	private $open_date_text                = '';
	private $close_date_text               = '';
	private $attendeelist_filter           = array();
	private $attendeelist_sort_order       = '';
	private $attendeelist_hide_status      = 'N';
	private $attendeelist_custom_qs        = array();
	private $attendeelist_allow_checkin    = 'N';
	private $attendeelist_show_search      = 'N';
	private $attendeelist_filter_text      = '';
	private $attendeelist_checkin_text     = '';
	private $attendeelist_checked_in_text  = '';
	private $attendee_list_show_email      = 'N';
	private $attendee_list_show_note       = 'N';
	private $attendee_list_show_summary    = 'N';
	private $attendee_list_show_associated = 'N';
	private $attendee_list_export_button   = 'N';
	private $attendee_list_page_size       = '';
	private $allow_checkin                 = 'N';
	private $attendee_auto_login           = 'N';
	private $modify_registration_text      = '';
	private $add_attendee_button_text      = '';
	private $admin_roles                   = array();
	private $email_from                    = '';
	private $email_cc_associated           = 'N';
	private $email_associated_individually = 'N';
	private $email_bcc_addresses           = '';
	private $email_subject                 = '';
	private $admin_email_subject           = '';
	private $email_body                    = '';
	private $no_email_body                 = '';
	private $maybe_email_body              = '';
	private $waitlist_email_body           = '';
	private $email_include_ics             = 'N';
	private $first_name_label              = '';
	private $last_name_label               = '';
	private $complete_button_text          = '';
	private $passcode_label                = '';
	private $edit_prompt_text              = '';
	private $suffix_label                  = '';
	private $salutation_label              = '';
	private $email_label                   = '';
	private $associated_message            = '';
	private $associated_greeting           = '';
	private $multi_event_title             = '';
	private $multi_option_text             = '';
	private $remove_attendee_button        = '';
	private $yes_text                      = '';
	private $no_text                       = '';
	private $maybe_text                    = '';
	private $plus_one_text                 = '';
	private $hi_text                       = '';
	private $no_response_text              = '';
	private $multiple_matches_text         = '';
	private $multiple_attendee_text        = '';
	private $fuzzy_match_text              = '';
	private $unable_find_text              = '';
	private $welcome_back_text             = '';
	private $partial_user_search           = 'N';
	private $first_name_js_message         = '';
	private $last_name_js_message          = '';
	private $note_js_message               = '';
	private $email_js_message              = '';
	private $unique_email_js_message       = '';
	private $gdpr_js_message               = '';
	private $unique_passcode_js_message    = '';
	private $last_name_not_required        = 'N';
	private $auto_waitlist_to_yes          = 'N';
	private $waitlist_yes_unavailable      = 'N';
	private $waitlist_perm_switch          = 'N';
	private $waitlist_status_email         = '';
	private $show_calendar_link            = 'N';
	private $calendar_link_text            = '';
	private $google_calendar_link_text     = '';
	private $additional_attendee_text      = '';
	private $plus_one_enabled              = 'N';
	private $plus_one_label                = '';
	private $repeat_do_not_save_event      = 'N';
	private $use_email_for_lookup          = 'N';
	private $show_event_info               = 'N';
	private $attendee_list_allow_rsvp      = 'N';
	private $send_attendee_list_email      = '';
	private $send_attendee_list_format     = '';
	private $send_attendee_list_note       = '';
	private $first_last_editable           = 'N';
	private $always_show_additional        = 'N';

	/**
	 * Specifies the WordPress roles that should be auto-enrolled into the event.
	 *
	 * @var array
	 */
	private $roles_auto_enroll = array();

	/**
	 * Specifies if the GDPR question should be shown for a person or not.
	 *
	 * @var string
	 */
	private $show_gdpr_question = 'N';

	/**
	 * Holds the GDPR custom question text.
	 *
	 * @var string
	 */
	private $gdpr_question_text = '';

	/**
	 * The columns to be used when exporting attendees.
	 *
	 * @var array
	 */
	private $export_columns = array();

	/**
	 * Enables the payments for the event.
	 *
	 * @var string
	 */
	private $enable_payments = 'N';

	/**
	 * Sets the ticket price for the event.
	 *
	 * @var string
	 */
	private $ticket_price = '';

	/**
	 * Holds the custom admin notification email body.
	 *
	 * @var string
	 */
	private $admin_email_body = '';

	/**
	 * Holds the flag to enable or disable recaptcha.
	 *
	 * @var string
	 */
	private $enable_recaptcha = 'N';

	/**
	 * Holds the site key for the recaptcha option.
	 *
	 * @var string
	 */
	private $recaptcha_site_key = '';

	/**
	 * Holds the secret key for the recaptcha setting.
	 *
	 * @var string
	 */
	private $recaptcha_secret_key = '';

	/**
	 * Holds the flag for if the new attendee form should be shown first
	 * instead of the "lookup" screen.
	 *
	 * @var string
	 */
	private $show_new_attendee_form_first = 'N';

	/**
	 * The "find attendee" link text that will be used at the bottom of the "new attendee form."
	 *
	 * @var string
	 */
	private $find_attendee_link_text = '';

	/**
	 * Specifies if we should enable AJAX on the front-end forms.
	 *
	 * @var string
	 */
	private $enable_ajax = 'N';

	/**
	 * Holds the raw value of the options that come from the database.
	 *
	 * @var array
	 */
	private $options;

	/**
	 * Holds the value for the waitlist short friendly text.
	 *
	 * @var string
	 */
	private $waitlist_friendly_text = '';

	/**
	 * Holds a custom RSVP form url
	 *
	 * @var string
	 */
	private $rsvp_form_url = '';

	/**
	 * Option to specify if the profile picture should be shown on the attendee list.
	 *
	 * @var string
	 */
	private $attendee_list_show_profile_pic = 'N';

	/**
	 * Specifies if attendee list should show the qr code prefill URL
	 *
	 * @var string
	 */
	private $attendee_list_show_qr_prefill = 'N';

	/**
	 * Option to specify if the profile picture should be shown on the RSVP forms.
	 *
	 * @var string
	 */
	private $form_show_profile_pic = 'N';

	/**
	 * Specifies if payments should be in testing mode or not.
	 *
	 * @var string
	 */
	private $payment_testing = 'N';

	/**
	 * The currency used for checking out the payments.
	 *
	 * @var string
	 */
	private $currency = 'USD';

	/**
	 * The currency position for the amounts shown.
	 *
	 * @var string
	 */
	private $currency_position = 'before';

	/**
	 * The character used for the thousands separator.
	 *
	 * @var string
	 */
	private $thousands_separator = ',';

	/**
	 * The character used for the decimal separator.
	 *
	 * @var string
	 */
	private $decimal_separator = '.';

	/**
	 * The message that should be displayed when an attendee pays for an event.
	 *
	 * @var string
	 */
	private $payment_message = '';

	/**
	 * The URL specified for the payment success page.
	 *
	 * @var string
	 */
	private $payment_success_url = '';

	/**
	 * The URL specified for the payment failure page.
	 *
	 * @var string
	 */
	private $payment_failure_url = '';

	/**
	 * Description for the payment that is sent over to the payment processor.
	 *
	 * @var string
	 */
	private $payment_description = '';

	/**
	 * Specifies full name search on the front-end.
	 *
	 * @var string
	 */
	private $full_name_search = 'N';

	/**
	 * The label displayed on the front-end look-up when "full name" search is enabled.
	 *
	 * @var string
	 */
	private $name_label = '';

	/**
	 * Constructor for this class
	 *
	 * @param int $event_id Optional event ID we want to load the information for.
	 */
	public function __construct( $event_id = 0 ) {
		if ( is_numeric( $event_id ) && ( $event_id > 0 ) ) {
			$this->event_id = $event_id;
			$this->load_options();
		}
	}

	/**
	 * Loads the options from the database to be accessible for this object
	 *
	 * @since 2.4.2
	 */
	private function load_options() {
		global $wpdb;

		if ( $this->event_id > 0 ) {
			$sql     = 'SELECT options FROM ' . PRO_EVENT_TABLE . ' WHERE id = %d';
			$options = $wpdb->get_var( $wpdb->prepare( $sql, $this->event_id ) );
			if ( $options !== null ) {
				$options       = json_decode( $options, true );
				$this->options = $options;

				$this->set_greeting_text( stripslashes_deep( $options[ RSVP_PRO_OPTION_GREETING ] ) );
				$this->set_welcome_text( stripslashes( $options[ RSVP_PRO_OPTION_WELCOME_TEXT ] ) );
				$this->set_hide_welcome( $this->retrieve_value( RSVP_PRO_OPTION_HIDE_WELCOME ) );
				$this->set_hide_rsvp_question( $this->retrieve_value( RSVP_PRO_OPTION_HIDE_RSVP_QUESTION ) );
				$this->set_rsvp_question_text( stripslashes( $options[ RSVP_PRO_OPTION_QUESTION ] ) );
				$this->set_rsvp_yes_label( stripslashes( $options[ RSVP_PRO_OPTION_YES_VERBIAGE ] ) );
				$this->set_rsvp_no_label( stripslashes( $options[ RSVP_PRO_OPTION_NO_VERBIAGE ] ) );
				$this->set_additional_note_label( stripslashes( $options[ RSVP_PRO_OPTION_NOTE_VERBIAGE ] ) );
				$this->set_text_under_rsvp( stripslashes( $this->retrieve_value( RSVP_PRO_OPTION_UNDER_RSVP_TEXT ) ) );
				$this->set_thank_you_text( stripslashes( $options[ RSVP_PRO_OPTION_THANKYOU ] ) );
				$this->set_thank_you_redirect( $this->retrieve_value( RSVP_PRO_OPTION_THANKYOU_REDIRECT ) );
				$this->set_hide_additional_guests( $options[ RSVP_PRO_OPTION_HIDE_ADDITIONAL ] );
				$this->set_plus_one_enabled( $this->retrieve_value( RSVP_PRO_OPTION_PLUS_ONE_ENABLED ) );
				$this->set_plus_one_label( $this->retrieve_value( RSVP_PRO_OPTION_PLUS_ONE_LABEL ) );
				$this->set_notify_user( $options[ RSVP_PRO_OPTION_NOTIFY_ON_RSVP ] );
				$this->set_notify_email( $options[ RSVP_PRO_OPTION_NOTIFY_EMAIL ] );
				$this->set_require_passcode( $options[ RSVP_PRO_OPTION_PASSCODE ] );
				$this->set_unique_passcode( $this->retrieve_value( RSVP_PRO_OPTION_PASSCODE_UNIQUE ) );
				$this->set_passcode_editable( $this->retrieve_value( RSVP_PRO_OPTION_PASSCODE_EDITABLE ) );
				$this->set_passcode_editable_label( stripslashes( $this->retrieve_value( RSVP_PRO_OPTION_PASSCODE_EDITABLE_LABEL ) ) );
				$this->set_hide_note( $options[ RSVP_PRO_OPTION_HIDE_NOTE ] );
				$this->set_rsvp_open_reg( $options[ RSVP_PRO_OPTION_OPEN_REGISTRATION ] );
				$this->set_rsvp_hide_search_form( $this->retrieve_value( RSVP_PRO_OPTION_HIDE_SEARCH_FORM ) );
				$this->set_display_search_button_text( $this->retrieve_value( RSVP_PRO_OPTION_DISPLAY_SEARCH_FORM_TEXT ) );
				$this->set_rsvp_prompt_to_add_not_found( $this->retrieve_value( RSVP_PRO_OPTION_PROMPT_TO_ADD_IF_NOT_FOUND ) );
				$this->set_rsvp_prompt_to_add_not_found_text( $this->retrieve_value( RSVP_PRO_OPTION_PROMPT_TO_ADD_IF_NOT_FOUND_TEXT ) );
				$this->set_dont_use_hash( $options[ RSVP_PRO_OPTION_DONT_USE_HASH ] );
				$this->set_add_additional_text( stripslashes( $options[ RSVP_PRO_OPTION_ADD_ADDITIONAL_VERBIAGE ] ) );
				$this->set_guest_email_confirm( $options[ RSVP_PRO_GUEST_EMAIL_CONFIRMATION ] );
				$this->set_num_additional_guests( $options[ RSVP_PRO_NUM_ADDITIONAL_GUESTS ] );
				$this->set_hide_email_field( $options[ RSVP_PRO_HIDE_EMAIL_FIELD ] );
				$this->set_unique_email_validation( $this->retrieve_value( RSVP_PRO_OPTION_EMAIL_UNIQUE_VALIDATION ) );
				$this->set_only_passcode( $options[ RSVP_PRO_ONLY_PASSCODE ] );
				$this->set_rsvp_email_text( stripslashes( $options[ RSVP_PRO_OPTION_EMAIL_TEXT ] ) );
				$this->set_rsvp_no_editing( $options[ RSVP_PRO_OPTION_CANT_EDIT ] );
				$this->set_rsvp_no_edit_prompt( $this->retrieve_value( RSVP_PRO_OPTION_NO_EDIT_PROMPT ) );
				$this->set_rsvp_only_once( $this->retrieve_value( RSVP_PRO_OPTION_ONLY_RSVP_ONCE ) );
				$this->set_rsvp_only_once_text( stripslashes_deep( $this->retrieve_value( RSVP_PRO_OPTION_RSVP_ONLY_ONCE_TEXT ) ) );
				$this->set_rsvp_disable_user_search( $options[ RSVP_PRO_OPTION_DISABLE_USER_SEARCH ] );
				$this->set_not_coming_verbiage( stripslashes( $options[ RSVP_PRO_OPTION_NOT_COMING ] ) );
				$this->set_not_coming_redirect( $this->retrieve_value( RSVP_PRO_OPTION_NOT_COMING_REDIRECT ) );
				$this->set_thankyou_modify_text( stripslashes( $this->retrieve_value( RSVP_PRO_OPTION_THANKYOU_MODIFY_TEXT ) ) );
				$this->set_thankyou_password_text( stripslashes( $this->retrieve_value( RSVP_PRO_OPTION_THANKYOU_PASSWORD_TEXT ) ) );
				$this->set_thankyou_associated_text( stripslashes( $this->retrieve_value( RSVP_PRO_OPTION_THANKYOU_ASSOCIATED_TEXT ) ) );
				$this->set_show_salutation( $options[ RSVP_PRO_OPTION_SHOW_SALUTATION ] );
				$this->set_show_suffix( $options[ RSVP_PRO_OPTION_SHOW_SUFFIX ] );
				$this->set_show_no_response( $options[ RSVP_PRO_OPTION_SHOW_NORESPONSE_FOR_ASSOCIATED ] );
				$this->set_require_email( $options[ RSVP_PRO_OPTION_EMAIL_REQUIRED ] );
				$this->set_no_passcode_on_open( $options[ RSVP_PRO_OPTION_RSVP_OPEN_NO_PASSCODE ] );
				$this->set_require_rsvp_values( $options[ RSVP_PRO_OPTION_RSVP_REQUIRED ] );
				$this->set_first_name_js_message( stripslashes( $this->retrieve_value( RSVP_PRO_OPTION_FIRST_NAME_JS_MESSAGE ) ) );
				$this->set_gdpr_js_message( stripslashes( $this->retrieve_value( RSVP_PRO_OPTION_GDPR_JS_MESSAGE ) ) );
				$this->set_last_name_js_message( stripslashes( $this->retrieve_value( RSVP_PRO_OPTION_LAST_NAME_JS_MESSAGE ) ) );
				$this->set_note_js_message( stripslashes( $this->retrieve_value( RSVP_PRO_OPTION_NOTE_JS_MESSAGE ) ) );
				$this->set_email_js_message( stripslashes( $this->retrieve_value( RSVP_PRO_OPTION_EMAIL_JS_MESSAGE ) ) );
				$this->set_unique_passcode_js_message( stripslashes( $this->retrieve_value( RSVP_PRO_OPTION_UNIQUE_PASSCODE_JS_MESSAGE ) ) );
				$this->set_unique_email_js_message( stripslashes( $this->retrieve_value( RSVP_PRO_OPTION_UNIQUE_EMAIL_JS_MESSAGE ) ) );
				$this->set_hide_rsvp( $options[ RSVP_PRO_OPTION_RSVP_HIDE ] );
				$this->set_default_rsvp_value( $options[ RSVP_PRO_OPTION_DEFAULT_RSVP_VALUE ] );
				$this->set_frontend_wizard( $options[ RSVP_PRO_OPTION_FRONTEND_WIZARD ] );
				$this->set_new_attendee_button_text( stripslashes( $options[ RSVP_PRO_OPTION_NEW_ATTENDEE_BUTTON_TEXT ] ) );
				$this->set_rsvp_frontend_button_text( stripslashes( $options[ RSVP_PRO_OPTION_RSVP_BUTTON_TEXT ] ) );
				$this->set_next_button_text( stripslashes( $options[ RSVP_PRO_OPTION_NEXT_BUTTON_TEXT ] ) );
				$this->set_rsvp_limit( $options[ RSVP_PRO_OPTION_EVENT_COUNT_LIMIT ] );
				$this->set_rsvp_limit_text( stripslashes( $options[ RSVP_PRO_OPTION_MAX_COUNT_REACHED_TEXT ] ) );
				$this->set_rsvp_enable_waitlist( $options[ RSVP_PRO_OPTION_ENABLE_WAITLIST ] );
				$this->set_rsvp_enable_maybe( $options[ RSVP_PRO_OPTION_ENABLE_MAYBE ] );
				$this->set_rsvp_waitlist_text( stripslashes( $options[ RSVP_PRO_OPTION_WAITLIST_TEXT ] ) );
				$this->set_open_date_text( stripslashes( $options[ RSVP_PRO_OPTION_OPEN_DATE_TEXT ] ) );
				$this->set_close_date_text( stripslashes( $options[ RSVP_PRO_OPTION_CLOSE_DATE_TEXT ] ) );
				$this->set_rsvp_waitlist_label( stripslashes( $options[ RSVP_PRO_OPTION_WAITLIST_VERBIAGE ] ) );
				$this->set_rsvp_maybe_label( stripslashes( $options[ RSVP_PRO_OPTION_MAYBE_VERBIAGE ] ) );
				$this->set_attendeelist_sort_order( stripslashes( $options[ RSVP_PRO_OPTION_ATTENDEE_LIST_SORT_ORDER ] ) );
				$this->set_attendee_list_export_button( $this->retrieve_value( RSVP_PRO_OPTION_ATTENDEE_LIST_EXPORT_BUTTON ) );
				$this->set_attendeelist_hide_status( $options[ RSVP_PRO_OPTION_ATTENDEE_LIST_HIDE_STATUS ] );
				$this->set_attendee_list_show_email( $options[ RSVP_PRO_OPTION_ATTENDEE_LIST_SHOW_EMAIL ] );
				$this->set_attendee_list_show_summary( $this->retrieve_value( RSVP_PRO_OPTION_ATTENDEE_LIST_SHOW_SUMMARY ) );
				$this->set_attendee_list_show_note( $this->retrieve_value( RSVP_PRO_OPTION_ATTENDEE_LIST_SHOW_NOTE ) );
				$this->set_attendee_list_show_associated( $this->retrieve_value( RSVP_PRO_OPTION_ATTENDEE_LIST_SHOW_ASSOCIATED ) );
				$this->set_attendee_list_show_qr_prefill( $this->retrieve_value( RSVP_PRO_OPTION_ATTENDEE_LIST_SHOW_QR_PREFILL ) );
				$this->set_attendee_auto_login( $options[ RSVP_PRO_OPTION_AUTO_LOGIN_ATTENDEE ] );
				$this->set_modify_registration_text( stripslashes( $options[ RSVP_PRO_OPTION_MODIFY_REGISTRATION_TEXT ] ) );
				$this->set_add_attendee_button_text( stripslashes( $options[ RSVP_PRO_OPTION_ADD_ATTENDEE_BUTTON_TEXT ] ) );
				$this->set_email_from( stripslashes( $options[ RSVP_PRO_OPTION_EMAIL_FROM ] ) );
				$this->set_email_cc_associated( $this->retrieve_value( RSVP_PRO_OPTION_EMAIL_CC_ASSOCIATED ) );
				$this->set_email_associated_individually( $this->retrieve_value( RSVP_PRO_OPTION_EMAIL_ASSOCIATED_INDIVIDUALLY ) );
				$this->set_email_bcc_addresses( stripslashes( $options[ RSVP_PRO_OPTION_EMAIL_BCC_ADDRESS ] ) );
				$this->set_email_subject( stripslashes( $options[ RSVP_PRO_OPTION_EMAIL_SUBJECT ] ) );
				$this->set_admin_email_subject( stripslashes( $this->retrieve_value( RSVP_PRO_OPTION_ADMIN_EMAIL_SUBJECT ) ) );
				$this->set_admin_email_body( stripslashes( $this->retrieve_value( RSVP_PRO_OPTION_ADMIN_EMAIL_BODY ) ) );
				$this->set_first_name_label( stripslashes( $options[ RSVP_PRO_OPTION_FIRST_NAME_LABEL ] ) );
				$this->set_last_name_label( stripslashes( $options[ RSVP_PRO_OPTION_LAST_NAME_LABEL ] ) );
				$this->set_complete_button_text( stripslashes( $options[ RSVP_PRO_OPTION_COMPLETE_BUTTON_TEXT ] ) );
				$this->set_passcode_label( stripslashes( $options[ RSVP_PRO_OPTION_PASSCODE_LABEL ] ) );
				$this->set_edit_prompt_text( stripslashes( $options[ RSVP_PRO_OPTION_EDIT_PROMPT_TEXT ] ) );
				$this->set_suffix_label( stripslashes( $options[ RSVP_PRO_OPTION_SUFFIX_LABEL ] ) );
				$this->set_salutation_label( stripslashes( $options[ RSVP_PRO_OPTION_SALUTATION_LABEL ] ) );
				$this->set_email_label( stripslashes( $options[ RSVP_PRO_OPTION_EMAIL_LABEL ] ) );
				$this->set_associated_message( stripslashes( $options[ RSVP_PRO_OPTION_ASSOCIATED_MESSAGE ] ) );
				$this->set_associated_greeting( stripslashes( $options[ RSVP_PRO_OPTION_ASSOCIATED_ATTENDEE_GREETING ] ) );
				$this->set_multi_event_title( stripslashes( $options[ RSVP_PRO_OPTION_MULTI_EVENT_TITLE ] ) );
				$this->set_multi_option_text( stripslashes( $options[ RSVP_PRO_OPTION_MULTI_OPTION_TEXT ] ) );
				$this->set_remove_attendee_button( stripslashes( $options[ RSVP_PRO_OPTION_REMOVE_ATTENDEE_BUTTON_TEXT ] ) );
				$this->set_yes_text( stripslashes( $options[ RSVP_PRO_OPTION_YES_TEXT ] ) );
				$this->set_maybe_text( stripslashes( $options[ RSVP_PRO_OPTION_MAYBE_TEXT ] ) );
				$this->set_plus_one_text( stripslashes( $this->retrieve_value( RSVP_PRO_OPTION_YES_PLUS_ONE_TEXT ) ) );
				$this->set_no_text( stripslashes( $options[ RSVP_PRO_OPTION_NO_TEXT ] ) );
				$this->set_hi_text( stripslashes( $options[ RSVP_PRO_OPTION_HI_TEXT ] ) );
				$this->set_no_response_text( stripslashes( $options[ RSVP_PRO_OPTION_NO_RESPONSE_TEXT ] ) );
				$this->set_multiple_matches_text( stripslashes( $options[ RSVP_PRO_OPTION_MULTIPLE_MATCHES_TEXT ] ) );
				$this->set_multiple_attendee_text( stripslashes( $this->retrieve_value( RSVP_PRO_OPTION_MULTIPLE_ATTENDEE_TEXT ) ) );
				$this->set_fuzzy_match_text( stripslashes( $options[ RSVP_PRO_OPTION_FUZZY_MATCH_TEXT ] ) );
				$this->set_welcome_back_text( stripslashes( $options[ RSVP_PRO_OPTION_WELCOME_BACK_TEXT ] ) );
				$this->set_unable_find_text( stripslashes( $options[ RSVP_PRO_OPTION_UNABLE_TO_FIND_TEXT ] ) );
				$this->set_partial_user_search( stripslashes( $options[ RSVP_PRO_OPTION_PARTIAL_MATCH_USER_SEARCH ] ) );
				$this->set_last_name_not_required( $options[ RSVP_PRO_OPTION_LAST_NAME_NOT_REQUIRED ] );
				$this->set_auto_waitlist_to_yes( $options[ RSVP_PRO_OPTION_WAITLIST_AUTO_CHANGE ] );
				$this->set_waitlist_yes_unavailable( $options[ RSVP_PRO_OPTION_WAITLIST_YES_UNAVAILABLE ] );
				$this->set_waitlist_perm_switch( $options[ RSVP_PRO_OPTION_WAITLIST_PERM_SWITCH ] );
				$this->set_waitlist_status_email( stripslashes( $options[ RSVP_PRO_OPTION_WAITLIST_STATUS_CHANGE_EMAIL ] ) );
				$this->set_show_calendar_link( $options[ RSVP_PRO_OPTION_SHOW_CALENDAR_LINK ] );
				$this->set_calendar_link_text( stripslashes( $options[ RSVP_PRO_OPTION_CALENDAR_LINK_TEXT ] ) );
				$this->set_google_calendar_link_text( stripslashes( $this->retrieve_value( RSVP_PRO_OPTION_GOOGLE_CALENDAR_LINK_TEXT ) ) );
				$this->set_additional_attendee_text( stripslashes( $options[ RSVP_PRO_OPTION_ADDITIONAL_GREETING_TEXT ] ) );
				$this->set_repeat_do_not_save_event( $options[ RSVP_PRO_OPTION_REPEAT_DONT_SAVE_EVENTS ] );
				$this->set_use_email_for_lookup( $options[ RSVP_PRO_OPTION_ATTENDEE_LOOKUP_VIA_EMAIL ] );
				$this->set_show_event_info( $options[ RSVP_PRO_OPTION_SHOW_EVENT_INFO_ON_FRONTEND ] );
				$this->set_attendee_list_allow_rsvp( $options[ RSVP_PRO_OPTION_ATTENDEE_LIST_ALLOW_RSVP_CHANGE ] );
				$this->set_send_attendee_list_note( stripslashes( $options[ RSVP_PRO_OPTION_SEND_ATTENDEE_LIST_NOTE ] ) );
				$this->set_send_attendee_list_format( stripslashes( $options[ RSVP_PRO_OPTION_SEND_ATTENDEE_LIST_FORMAT ] ) );
				$this->set_send_attendee_list_email( stripslashes( $options[ RSVP_PRO_OPTION_SEND_ATTENDEE_LIST_EMAIL ] ) );
				$this->set_first_last_editable( stripslashes( $options[ RSVP_PRO_OPTION_FIRST_LAST_EDITABLE ] ) );
				$this->set_attendee_list_show_search( $options[ RSVP_PRO_OPTION_ATTENDEE_LIST_SHOW_SEARCH ] );
				$this->set_attendee_list_search_text( $options[ RSVP_PRO_OPTION_ATTENDEE_LIST_FILTER_TEXT ] );
				$this->set_attendee_list_allow_checkin( $options[ RSVP_PRO_OPTION_ATTENDEE_LIST_ALLOW_CHECKIN ] );
				$this->set_attendee_list_checkin_text( $options[ RSVP_PRO_OPTION_ATTENDEE_LIST_CHECKIN_TEXT ] );
				$this->set_attendee_list_checked_in_text( $options[ RSVP_PRO_OPTION_ATTENDEE_LIST_CHECKED_IN_TEXT ] );
				$this->set_attendee_list_page_size( $this->retrieve_value( RSVP_PRO_OPTION_ATTENDEE_LIST_PAGE_SIZE ) );
				$this->set_allow_checkin( $options[ RSVP_PRO_OPTION_ALLOW_CHECKINS ] );
				$this->set_email_body( stripslashes( $options[ RSVP_PRO_OPTION_EMAIL_BODY ] ) );
				$this->set_no_email_body( stripslashes( $this->retrieve_value( RSVP_PRO_OPTION_NO_EMAIL_BODY ) ) );
				$this->set_maybe_email_body( stripslashes( $this->retrieve_value( RSVP_PRO_OPTION_MAYBE_EMAIL_BODY ) ) );
				$this->set_waitlist_email_body( $this->retrieve_value( RSVP_PRO_OPTION_WAITLIST_EMAIL_BODY ) );
				$this->set_email_include_ics( $options[ RSVP_PRO_OPTION_EMAIL_INCLUDE_ICS ] );
				$this->set_show_gdpr_question( stripslashes( $this->retrieve_value( RSVP_PRO_OPTION_SHOW_GDPR_QUESTION ) ) );
				$this->set_gdpr_question_text( stripslashes( $this->retrieve_value( RSVP_PRO_OPTION_GDPR_QUESTION_TEXT ) ) );
				$this->set_enable_recaptcha( $this->retrieve_value( RSVP_PRO_OPTION_ENABLE_RECAPTCHA ) );
				$this->set_recaptcha_site_key( stripslashes( $this->retrieve_value( RSVP_PRO_OPTION_RECAPTCHA_SITE_KEY ) ) );
				$this->set_recaptcha_secret_key( stripslashes( $this->retrieve_value( RSVP_PRO_OPTION_RECAPTCHA_SECRET_KEY ) ) );
				$this->set_enable_ajax( $this->retrieve_value( RSVP_PRO_OPTION_ENABLE_AJAX ) );
				$this->set_show_new_attendee_form_first( $this->retrieve_value( RSVP_PRO_OPTION_SHOW_NEW_ATTENDEE_FORM_FIRST ) );
				$this->set_find_attendees_link_text( stripslashes( $this->retrieve_value( RSVP_PRO_OPTION_FIND_ATTENDEES_LINK_TEXT ) ) );
				$this->set_waitlist_friendly_text( stripslashes( $this->retrieve_value( RSVP_PRO_OPTION_WAITLIST_FRIENDLY_TEXT ) ) );
				$this->set_rsvp_form_url( stripslashes( $this->retrieve_value( RSVP_PRO_OPTION_FORM_URL ) ) );
				$this->set_attendee_list_show_profile_pic(
					$this->retrieve_value( RSVP_PRO_OPTION_ATTENDEE_LIST_SHOW_PROFILE )
				);
				$this->set_form_show_profile_pic(
					$this->retrieve_value( RSVP_PRO_OPTION_SHOW_PROFILE_ON_FORM )
				);
				$this->set_always_show_additional( $this->retrieve_value( RSVP_PRO_OPTION_ALWAYS_SHOW_ADDITIONAL ) );
				$this->set_enable_payments( $this->retrieve_value( RSVP_PRO_OPTION_ENABLE_PAYMENTS ) );
				$this->set_ticket_price( $this->retrieve_value( RSVP_PRO_OPTION_TICKET_PRICE ) );
				$this->set_payment_testing( $this->retrieve_value( RSVP_PRO_OPTION_PAYMENT_IN_TESTING ) );
				$this->set_currency( $this->retrieve_value( RSVP_PRO_OPTION_CURRENCY ) );
				$this->set_currency_position( $this->retrieve_value( RSVP_PRO_OPTION_CURRENCY_POSITION ) );
				$this->set_thousands_separator( $this->retrieve_value( RSVP_PRO_OPTION_THOUSANDS_SEPARATOR ) );
				$this->set_decimal_separator( $this->retrieve_value( RSVP_PRO_OPTION_DECIMAL_SEPARATOR ) );
				$this->set_payment_message( $this->retrieve_value( RSVP_PRO_OPTION_PAYMENT_MESSAGE ) );
				$this->set_payment_success_url( $this->retrieve_value( RSVP_PRO_OPTION_PAYMENT_SUCCESS_URL ) );
				$this->set_payment_failure_url( $this->retrieve_value( RSVP_PRO_OPTION_PAYMENT_FAILURE_URL ) );
				$this->set_payment_description( $this->retrieve_value( RSVP_PRO_OPTION_PAYMENT_DESCRIPTION ) );
				$this->set_full_name_search( $this->retrieve_value( RSVP_PRO_OPTION_FULL_NAME_SEARCH ) );
				$this->set_name_label( $this->retrieve_value( RSVP_PRO_OPTION_NAME_LABEL ) );

				if ( is_array( $options[ RSVP_PRO_OPTION_ADMIN_ROLES ] ) ) {
					$this->set_admin_roles( $options[ RSVP_PRO_OPTION_ADMIN_ROLES ] );
				}

				if ( is_array( $options[ RSVP_PRO_OPTION_ATTENDEE_LIST_CUSTOM_QUESTIONS ] ) ) {
					$this->set_attendeelist_custom_qs( $options[ RSVP_PRO_OPTION_ATTENDEE_LIST_CUSTOM_QUESTIONS ] );
				}

				if ( is_array( $options[ RSVP_PRO_OPTION_ATTENDEE_LIST_FILTER ] ) ) {
					$this->set_attendeelist_filter( $options[ RSVP_PRO_OPTION_ATTENDEE_LIST_FILTER ] );
				}

				if ( is_array( $options[ RSVP_PRO_OPTION_AUTO_ENROLL_ROLE ] ) ) {
					$this->set_roles_auto_enroll( $options[ RSVP_PRO_OPTION_AUTO_ENROLL_ROLE ] );
				}

				if ( isset( $options[ RSVP_PRO_OPTION_SAVED_EXPORT_COLUMNS ] ) && is_array( $options[ RSVP_PRO_OPTION_SAVED_EXPORT_COLUMNS ] ) ) {
					$this->set_export_columns( $options[ RSVP_PRO_OPTION_SAVED_EXPORT_COLUMNS ] );
				}

				if ( ! empty( $options[ RSVP_PRO_OPTION_SALUTATIONS ] ) ) {
					$this->set_salutations( stripslashes( $options[ RSVP_PRO_OPTION_SALUTATIONS ] ) );
				}

				if ( is_numeric( $options[ RSVP_PRO_OPTION_PASSWORD_LENGTH ] ) && ( $options[ RSVP_PRO_OPTION_PASSWORD_LENGTH ] <= 50 ) ) {
					$this->set_password_length( $options[ RSVP_PRO_OPTION_PASSWORD_LENGTH ] );
				}
			}
		}
	}

	/**
	 * Saves the options to the event's table record
	 *
	 * @since 2.4.2
	 */
	public function save_options() {
		global $wpdb;

		if ( $this->event_id > 0 ) {
			$options = array(
				RSVP_PRO_OPTION_GREETING                   => $this->get_greeting_text(),
				RSVP_PRO_OPTION_WELCOME_TEXT               => $this->get_welcome_text(),
				RSVP_PRO_OPTION_HIDE_WELCOME               => $this->get_hide_welcome(),
				RSVP_PRO_OPTION_HIDE_RSVP_QUESTION         => $this->get_hide_rsvp_question(),
				RSVP_PRO_OPTION_THANKYOU                   => $this->get_thank_you_text(),
				RSVP_PRO_OPTION_THANKYOU_REDIRECT          => $this->get_thank_you_redirect(),
				RSVP_PRO_OPTION_YES_VERBIAGE               => $this->get_rsvp_yes_label(),
				RSVP_PRO_OPTION_NO_VERBIAGE                => $this->get_rsvp_no_label(),
				RSVP_PRO_OPTION_QUESTION                   => $this->get_rsvp_question_text(),
				RSVP_PRO_OPTION_UNDER_RSVP_TEXT            => $this->get_text_under_rsvp(),
				RSVP_PRO_OPTION_HIDE_ADDITIONAL            => $this->get_hide_additional_guests(),
				RSVP_PRO_OPTION_PLUS_ONE_ENABLED           => $this->get_plus_one_enabled(),
				RSVP_PRO_OPTION_PLUS_ONE_LABEL             => $this->get_plus_one_label(),
				RSVP_PRO_OPTION_NOTIFY_ON_RSVP             => $this->get_notify_user(),
				RSVP_PRO_OPTION_NOTIFY_EMAIL               => $this->get_notify_email(),
				RSVP_PRO_OPTION_PASSCODE                   => $this->get_require_passcode(),
				RSVP_PRO_OPTION_PASSCODE_UNIQUE            => $this->get_unique_passcode(),
				RSVP_PRO_OPTION_PASSCODE_EDITABLE          => $this->get_passcode_editable(),
				RSVP_PRO_OPTION_PASSCODE_EDITABLE_LABEL    => $this->get_passcode_editable_label(),
				RSVP_PRO_OPTION_HIDE_NOTE                  => $this->get_hide_note(),
				RSVP_PRO_OPTION_NOTE_VERBIAGE              => $this->get_additional_note_label(),
				RSVP_PRO_OPTION_OPEN_REGISTRATION          => $this->get_rsvp_open_reg(),
				RSVP_PRO_OPTION_HIDE_SEARCH_FORM           => $this->get_rsvp_hide_search_form(),
				RSVP_PRO_OPTION_DISPLAY_SEARCH_FORM_TEXT   => $this->get_display_search_form_text(),
				RSVP_PRO_OPTION_PROMPT_TO_ADD_IF_NOT_FOUND => $this->get_rsvp_prompt_to_add_not_found(),
				RSVP_PRO_OPTION_PROMPT_TO_ADD_IF_NOT_FOUND_TEXT => $this->get_rsvp_prompt_to_add_not_found_text(),
				RSVP_PRO_OPTION_DONT_USE_HASH              => $this->get_dont_use_hash(),
				RSVP_PRO_OPTION_ADD_ADDITIONAL_VERBIAGE    => $this->get_add_additional_text(),
				RSVP_PRO_GUEST_EMAIL_CONFIRMATION          => $this->get_guest_email_confirm(),
				RSVP_PRO_NUM_ADDITIONAL_GUESTS             => $this->get_num_additional_guests(),
				RSVP_PRO_HIDE_EMAIL_FIELD                  => $this->get_hide_email_field(),
				RSVP_PRO_OPTION_EMAIL_UNIQUE_VALIDATION    => $this->get_unique_email_validation(),
				RSVP_PRO_ONLY_PASSCODE                     => $this->get_only_passcode(),
				RSVP_PRO_OPTION_EMAIL_TEXT                 => $this->get_rsvp_email_text(),
				RSVP_PRO_OPTION_CANT_EDIT                  => $this->get_rsvp_no_editing(),
				RSVP_PRO_OPTION_NO_EDIT_PROMPT             => $this->get_rsvp_no_edit_prompt(),
				RSVP_PRO_OPTION_ONLY_RSVP_ONCE             => $this->get_rsvp_only_once(),
				RSVP_PRO_OPTION_RSVP_ONLY_ONCE_TEXT        => $this->get_rsvp_only_once_text(),
				RSVP_PRO_OPTION_DISABLE_USER_SEARCH        => $this->get_rsvp_disable_user_search(),
				RSVP_PRO_OPTION_NOT_COMING                 => $this->get_not_coming_verbiage(),
				RSVP_PRO_OPTION_NOT_COMING_REDIRECT        => $this->get_not_coming_redirect(),
				RSVP_PRO_OPTION_THANKYOU_MODIFY_TEXT       => $this->get_thankyou_modify_text(),
				RSVP_PRO_OPTION_THANKYOU_PASSWORD_TEXT     => $this->get_thankyou_password_text(),
				RSVP_PRO_OPTION_THANKYOU_ASSOCIATED_TEXT   => $this->get_thankyou_associated_text(),
				RSVP_PRO_OPTION_SHOW_SALUTATION            => $this->get_show_salutation(),
				RSVP_PRO_OPTION_SHOW_SUFFIX                => $this->get_show_suffix(),
				RSVP_PRO_OPTION_SALUTATIONS                => $this->get_salutations(),
				RSVP_PRO_OPTION_PASSWORD_LENGTH            => $this->get_password_length(),
				RSVP_PRO_OPTION_SHOW_NORESPONSE_FOR_ASSOCIATED => $this->get_show_no_response(),
				RSVP_PRO_OPTION_EMAIL_REQUIRED             => $this->get_require_email(),
				RSVP_PRO_OPTION_RSVP_REQUIRED              => $this->get_require_rsvp_values(),
				RSVP_PRO_OPTION_FIRST_NAME_JS_MESSAGE      => $this->get_first_name_js_message(),
				RSVP_PRO_OPTION_LAST_NAME_JS_MESSAGE       => $this->get_last_name_js_message(),
				RSVP_PRO_OPTION_NOTE_JS_MESSAGE            => $this->get_note_js_message(),
				RSVP_PRO_OPTION_GDPR_JS_MESSAGE            => $this->get_gdpr_js_message(),
				RSVP_PRO_OPTION_EMAIL_JS_MESSAGE           => $this->get_email_js_message(),
				RSVP_PRO_OPTION_UNIQUE_PASSCODE_JS_MESSAGE => $this->get_unique_passcode_js_message(),
				RSVP_PRO_OPTION_UNIQUE_EMAIL_JS_MESSAGE    => $this->get_unique_email_js_message(),
				RSVP_PRO_OPTION_RSVP_HIDE                  => $this->get_hide_rsvp(),
				RSVP_PRO_OPTION_DEFAULT_RSVP_VALUE         => $this->get_default_rsvp_value(),
				RSVP_PRO_OPTION_RSVP_OPEN_NO_PASSCODE      => $this->get_no_passcode_on_open(),
				RSVP_PRO_OPTION_FRONTEND_WIZARD            => $this->get_frontend_wizard(),
				RSVP_PRO_OPTION_NEW_ATTENDEE_BUTTON_TEXT   => $this->get_new_attendee_button_text(),
				RSVP_PRO_OPTION_RSVP_BUTTON_TEXT           => $this->get_rsvp_frontend_button_text(),
				RSVP_PRO_OPTION_NEXT_BUTTON_TEXT           => $this->get_next_button_text(),
				RSVP_PRO_OPTION_EVENT_COUNT_LIMIT          => $this->get_rsvp_limit(),
				RSVP_PRO_OPTION_MAX_COUNT_REACHED_TEXT     => $this->get_rsvp_limit_text(),
				RSVP_PRO_OPTION_ENABLE_WAITLIST            => $this->get_rsvp_enable_waitlist(),
				RSVP_PRO_OPTION_ENABLE_MAYBE               => $this->get_rsvp_enable_maybe(),
				RSVP_PRO_OPTION_WAITLIST_TEXT              => $this->get_rsvp_waitlist_text(),
				RSVP_PRO_OPTION_OPEN_DATE_TEXT             => $this->get_open_date_text(),
				RSVP_PRO_OPTION_CLOSE_DATE_TEXT            => $this->get_close_date_text(),
				RSVP_PRO_OPTION_WAITLIST_VERBIAGE          => $this->get_rsvp_waitlist_label(),
				RSVP_PRO_OPTION_MAYBE_VERBIAGE             => $this->get_rsvp_maybe_label(),
				RSVP_PRO_OPTION_ATTENDEE_LIST_FILTER       => $this->get_attendeelist_filter(),
				RSVP_PRO_OPTION_ATTENDEE_LIST_SORT_ORDER   => $this->get_attendeelist_sort_order(),
				RSVP_PRO_OPTION_ATTENDEE_LIST_HIDE_STATUS  => $this->get_attendeelist_hide_status(),
				RSVP_PRO_OPTION_ATTENDEE_LIST_CUSTOM_QUESTIONS => $this->get_attendeelist_custom_qs(),
				RSVP_PRO_OPTION_ATTENDEE_LIST_SHOW_EMAIL   => $this->get_attendee_list_show_email(),
				RSVP_PRO_OPTION_ATTENDEE_LIST_SHOW_NOTE    => $this->get_attendee_list_show_note(),
				RSVP_PRO_OPTION_ATTENDEE_LIST_SHOW_SUMMARY => $this->get_attendee_list_show_summary(),
				RSVP_PRO_OPTION_ATTENDEE_LIST_SHOW_ASSOCIATED => $this->get_attendee_list_show_associated(),
				RSVP_PRO_OPTION_ATTENDEE_LIST_EXPORT_BUTTON => $this->get_attendee_list_export_button(),
				RSVP_PRO_OPTION_ATTENDEE_LIST_PAGE_SIZE    => $this->get_attendee_list_page_size(),
				RSVP_PRO_OPTION_AUTO_LOGIN_ATTENDEE        => $this->get_attendee_auto_login(),
				RSVP_PRO_OPTION_MODIFY_REGISTRATION_TEXT   => $this->get_modify_registration_text(),
				RSVP_PRO_OPTION_ADD_ATTENDEE_BUTTON_TEXT   => $this->get_add_attendee_button_text(),
				RSVP_PRO_OPTION_ADMIN_ROLES                => $this->get_admin_roles(),
				RSVP_PRO_OPTION_EMAIL_FROM                 => $this->get_email_from(),
				RSVP_PRO_OPTION_EMAIL_BODY                 => $this->get_email_body(),
				RSVP_PRO_OPTION_NO_EMAIL_BODY              => $this->get_no_email_body(),
				RSVP_PRO_OPTION_MAYBE_EMAIL_BODY           => $this->get_maybe_email_body(),
				RSVP_PRO_OPTION_WAITLIST_EMAIL_BODY        => $this->get_waitlist_email_body(),
				RSVP_PRO_OPTION_EMAIL_INCLUDE_ICS          => $this->get_email_include_ics(),
				RSVP_PRO_OPTION_EMAIL_CC_ASSOCIATED        => $this->get_email_cc_associated(),
				RSVP_PRO_OPTION_EMAIL_ASSOCIATED_INDIVIDUALLY => $this->get_email_associated_individually(),
				RSVP_PRO_OPTION_EMAIL_BCC_ADDRESS          => $this->get_email_bcc_addresses(),
				RSVP_PRO_OPTION_EMAIL_SUBJECT              => $this->get_email_subject(),
				RSVP_PRO_OPTION_ADMIN_EMAIL_SUBJECT        => $this->get_admin_email_subject(),
				RSVP_PRO_OPTION_ADMIN_EMAIL_BODY           => $this->get_admin_email_body(),
				RSVP_PRO_OPTION_FIRST_NAME_LABEL           => $this->get_first_name_label(),
				RSVP_PRO_OPTION_LAST_NAME_LABEL            => $this->get_last_name_label(),
				RSVP_PRO_OPTION_COMPLETE_BUTTON_TEXT       => $this->get_complete_button_text(),
				RSVP_PRO_OPTION_PASSCODE_LABEL             => $this->get_passcode_label(),
				RSVP_PRO_OPTION_EDIT_PROMPT_TEXT           => $this->get_edit_prompt_text(),
				RSVP_PRO_OPTION_SUFFIX_LABEL               => $this->get_suffix_label(),
				RSVP_PRO_OPTION_SALUTATION_LABEL           => $this->get_salutation_label(),
				RSVP_PRO_OPTION_EMAIL_LABEL                => $this->get_email_label(),
				RSVP_PRO_OPTION_ASSOCIATED_MESSAGE         => $this->get_associated_message(),
				RSVP_PRO_OPTION_ASSOCIATED_ATTENDEE_GREETING => $this->get_associated_greeting(),
				RSVP_PRO_OPTION_MULTI_OPTION_TEXT          => $this->get_multi_option_text(),
				RSVP_PRO_OPTION_MULTI_EVENT_TITLE          => $this->get_multi_event_title(),
				RSVP_PRO_OPTION_REMOVE_ATTENDEE_BUTTON_TEXT => $this->get_remove_attendee_button(),
				RSVP_PRO_OPTION_YES_TEXT                   => $this->get_yes_text(),
				RSVP_PRO_OPTION_HI_TEXT                    => $this->get_hi_text(),
				RSVP_PRO_OPTION_NO_TEXT                    => $this->get_no_text(),
				RSVP_PRO_OPTION_MAYBE_TEXT                 => $this->get_maybe_text(),
				RSVP_PRO_OPTION_YES_PLUS_ONE_TEXT          => $this->get_plus_one_text(),
				RSVP_PRO_OPTION_NO_RESPONSE_TEXT           => $this->get_no_response_text(),
				RSVP_PRO_OPTION_MULTIPLE_MATCHES_TEXT      => $this->get_multiple_matches_text(),
				RSVP_PRO_OPTION_MULTIPLE_ATTENDEE_TEXT     => $this->get_multiple_attendee_text(),
				RSVP_PRO_OPTION_FUZZY_MATCH_TEXT           => $this->get_fuzzy_match_text(),
				RSVP_PRO_OPTION_WELCOME_BACK_TEXT          => $this->get_welcome_back_text(),
				RSVP_PRO_OPTION_UNABLE_TO_FIND_TEXT        => $this->get_unable_find_text(),
				RSVP_PRO_OPTION_PARTIAL_MATCH_USER_SEARCH  => $this->get_partial_user_search(),
				RSVP_PRO_OPTION_LAST_NAME_NOT_REQUIRED     => $this->get_last_name_not_required(),
				RSVP_PRO_OPTION_WAITLIST_AUTO_CHANGE       => $this->get_auto_waitlist_to_yes(),
				RSVP_PRO_OPTION_WAITLIST_YES_UNAVAILABLE   => $this->get_waitlist_yes_unavailable(),
				RSVP_PRO_OPTION_WAITLIST_PERM_SWITCH       => $this->get_waitlist_perm_switch(),
				RSVP_PRO_OPTION_WAITLIST_STATUS_CHANGE_EMAIL => $this->get_waitlist_status_email(),
				RSVP_PRO_OPTION_SHOW_CALENDAR_LINK         => $this->get_show_calendar_link(),
				RSVP_PRO_OPTION_CALENDAR_LINK_TEXT         => $this->get_calendar_link_text(),
				RSVP_PRO_OPTION_GOOGLE_CALENDAR_LINK_TEXT  => $this->get_google_calendar_link_text(),
				RSVP_PRO_OPTION_ADDITIONAL_GREETING_TEXT   => $this->get_additional_attendee_text(),
				RSVP_PRO_OPTION_REPEAT_DONT_SAVE_EVENTS    => $this->get_repeat_do_not_save_event(),
				RSVP_PRO_OPTION_ATTENDEE_LOOKUP_VIA_EMAIL  => $this->get_use_email_for_lookup(),
				RSVP_PRO_OPTION_SHOW_EVENT_INFO_ON_FRONTEND => $this->get_show_event_info(),
				RSVP_PRO_OPTION_ATTENDEE_LIST_ALLOW_RSVP_CHANGE => $this->get_attendee_list_allow_rsvp(),
				RSVP_PRO_OPTION_SEND_ATTENDEE_LIST_NOTE    => $this->get_send_attendee_list_note(),
				RSVP_PRO_OPTION_SEND_ATTENDEE_LIST_EMAIL   => $this->get_send_attendee_list_email(),
				RSVP_PRO_OPTION_SEND_ATTENDEE_LIST_FORMAT  => $this->get_send_attendee_list_format(),
				RSVP_PRO_OPTION_FIRST_LAST_EDITABLE        => $this->get_first_last_editable(),
				RSVP_PRO_OPTION_AUTO_ENROLL_ROLE           => $this->get_roles_auto_enroll(),
				RSVP_PRO_OPTION_SAVED_EXPORT_COLUMNS       => $this->get_export_columns(),
				RSVP_PRO_OPTION_ATTENDEE_LIST_SHOW_SEARCH  => $this->get_attendee_list_show_search(),
				RSVP_PRO_OPTION_ATTENDEE_LIST_FILTER_TEXT  => $this->get_attendee_list_search_text(),
				RSVP_PRO_OPTION_ATTENDEE_LIST_ALLOW_CHECKIN => $this->get_attendee_list_allow_checkin(),
				RSVP_PRO_OPTION_ATTENDEE_LIST_CHECKIN_TEXT => $this->get_attendee_list_checkin_text(),
				RSVP_PRO_OPTION_ALLOW_CHECKINS             => $this->get_allow_checkin(),
				RSVP_PRO_OPTION_ATTENDEE_LIST_CHECKED_IN_TEXT => $this->get_attendee_list_checked_in_text(),
				RSVP_PRO_OPTION_SHOW_GDPR_QUESTION         => $this->get_show_gdpr_question(),
				RSVP_PRO_OPTION_GDPR_QUESTION_TEXT         => $this->get_gdpr_question_text(),
				RSVP_PRO_OPTION_ENABLE_RECAPTCHA           => $this->get_enable_recaptcha(),
				RSVP_PRO_OPTION_RECAPTCHA_SITE_KEY         => $this->get_recaptcha_site_key(),
				RSVP_PRO_OPTION_RECAPTCHA_SECRET_KEY       => $this->get_recaptcha_secret_key(),
				RSVP_PRO_OPTION_ENABLE_AJAX                => $this->get_enable_ajax(),
				RSVP_PRO_OPTION_SHOW_NEW_ATTENDEE_FORM_FIRST => $this->get_show_new_attendee_form_first(),
				RSVP_PRO_OPTION_FIND_ATTENDEES_LINK_TEXT   => $this->get_find_attendees_link_text(),
				RSVP_PRO_OPTION_WAITLIST_FRIENDLY_TEXT     => $this->get_waitlist_friendly_text(),
				RSVP_PRO_OPTION_FORM_URL                   => $this->get_rsvp_form_url(),
				RSVP_PRO_OPTION_SHOW_PROFILE_ON_FORM       => $this->get_form_show_profile_pic(),
				RSVP_PRO_OPTION_ATTENDEE_LIST_SHOW_PROFILE => $this->get_attendee_list_show_profile_pic(),
				RSVP_PRO_OPTION_ALWAYS_SHOW_ADDITIONAL     => $this->get_always_show_additional(),
				RSVP_PRO_OPTION_ENABLE_PAYMENTS            => $this->get_enable_payments(),
				RSVP_PRO_OPTION_TICKET_PRICE               => $this->get_ticket_price(),
				RSVP_PRO_OPTION_PAYMENT_IN_TESTING         => $this->get_payment_testing(),
				RSVP_PRO_OPTION_CURRENCY                   => $this->get_currency(),
				RSVP_PRO_OPTION_CURRENCY_POSITION          => $this->get_currency_position(),
				RSVP_PRO_OPTION_THOUSANDS_SEPARATOR        => $this->get_thousands_separator(),
				RSVP_PRO_OPTION_DECIMAL_SEPARATOR          => $this->get_decimal_separator(),
				RSVP_PRO_OPTION_PAYMENT_MESSAGE            => $this->get_payment_message(),
				RSVP_PRO_OPTION_PAYMENT_SUCCESS_URL        => $this->get_payment_success_url(),
				RSVP_PRO_OPTION_PAYMENT_FAILURE_URL        => $this->get_payment_failure_url(),
				RSVP_PRO_OPTION_PAYMENT_DESCRIPTION        => $this->get_payment_description(),
				RSVP_PRO_OPTION_FULL_NAME_SEARCH           => $this->get_full_name_search(),
				RSVP_PRO_OPTION_NAME_LABEL                 => $this->get_name_label(),
				RSVP_PRO_OPTION_ATTENDEE_LIST_SHOW_QR_PREFILL => $this->get_attendee_list_show_qr_prefill(),
			);

			$options      = apply_filters( 'rsvp_pro_event_save_additional_settings', $options );
			$json_options = json_encode( $options );

			$wpdb->update(
				PRO_EVENT_TABLE,
				array( 'options' => $json_options ),
				array( 'id' => $this->get_event_id() ),
				array( '%s' ),
				array( '%d' )
			);
		}
	}

	/**
	 * Sanitizes the enum value and makes sure it is either 'Y' or 'N'
	 *
	 * @param  string $value_in The value that needs to be sanitized
	 *
	 * @return string           Either 'Y' or 'N'
	 */
	private function sanitize_yes_no( $value_in ) {
		return ( strtoupper( $value_in ) == 'Y' ) ? 'Y' : 'N';
	}

	/**
	 * Retrieves the value from the options if it exists. If it
	 * does not exist an empty string is returned.
	 *
	 * @param  string $key Key of data we are trying to retrieve.
	 *
	 * @return mixed      Data stored or an empty string.
	 */
	public function retrieve_value( $key ) {
		if ( isset( $this->options[ $key ] ) ) {
			return $this->options[ $key ];
		}

		return '';
	}

	/* Getters and Setters below */

	/**
	 * Returns the ID for this event.
	 *
	 * @return int The event ID.
	 */
	public function get_event_id() {
		return $this->event_id;
	}

	/**
	 * Sets the event ID for this event.
	 *
	 * @param int $in The id for this event.
	 */
	public function set_event_id( $in ) {
		$this->event_id = $in;
	}

	public function get_greeting_text() {
		return $this->greeting_text;
	}

	public function set_greeting_text( $in ) {
		$this->greeting_text = $in;
	}

	public function get_welcome_text() {
		return $this->welcome_text;
	}

	public function set_welcome_text( $in ) {
		$this->welcome_text = $in;
	}

	public function get_hide_welcome() {
		return $this->hide_welcome_text;
	}

	public function set_hide_welcome( $in ) {
		$this->hide_welcome_text = $this->sanitize_yes_no( $in );
	}

	public function get_hide_rsvp_question() {
		return $this->hide_main_rsvp_question;
	}

	public function set_hide_rsvp_question( $in ) {
		$this->hide_main_rsvp_question = $this->sanitize_yes_no( $in );
	}

	public function get_rsvp_question_text() {
		return $this->rsvp_question_text;
	}

	public function set_rsvp_question_text( $in ) {
		$this->rsvp_question_text = $in;
	}

	public function get_rsvp_yes_label() {
		return $this->rsvp_yes_label;
	}

	public function set_rsvp_yes_label( $in ) {
		$this->rsvp_yes_label = $in;
	}

	public function get_rsvp_no_label() {
		return $this->rsvp_no_label;
	}

	public function set_rsvp_no_label( $in ) {
		$this->rsvp_no_label = $in;
	}

	public function get_rsvp_waitlist_label() {
		return $this->rsvp_waitlist_label;
	}

	public function set_rsvp_waitlist_label( $in ) {
		$this->rsvp_waitlist_label = $in;
	}

	public function get_rsvp_maybe_label() {
		return $this->rsvp_maybe_label;
	}

	public function set_rsvp_maybe_label( $in ) {
		$this->rsvp_maybe_label = $in;
	}

	public function get_additional_note_label() {
		return $this->additional_note_label;
	}

	public function set_additional_note_label( $in ) {
		$this->additional_note_label = $in;
	}

	public function get_text_under_rsvp() {
		return $this->text_under_rsvp;
	}

	public function set_text_under_rsvp( $in ) {
		$this->text_under_rsvp = $in;
	}

	public function get_plus_one_enabled() {
		return $this->plus_one_enabled;
	}

	public function set_plus_one_enabled( $in ) {
		$this->plus_one_enabled = $this->sanitize_yes_no( $in );
	}

	public function get_plus_one_label() {
		return $this->plus_one_label;
	}

	public function set_plus_one_label( $in ) {
		$this->plus_one_label = $in;
	}

	public function get_thank_you_text() {
		return $this->thank_you_text;
	}

	public function set_thank_you_text( $in ) {
		$this->thank_you_text = $in;
	}

	public function get_thank_you_redirect() {
		return $this->thank_you_redirect;
	}

	public function set_thank_you_redirect( $in ) {
		$this->thank_you_redirect = $in;
	}

	public function get_hide_additional_guests() {
		return $this->hide_additional_guests;
	}

	public function set_hide_additional_guests( $in ) {
		$this->hide_additional_guests = $this->sanitize_yes_no( $in );
	}

	public function get_notify_user() {
		return $this->notify_user;
	}

	public function set_notify_user( $in ) {
		$this->notify_user = $this->sanitize_yes_no( $in );
	}

	public function get_notify_email() {
		return $this->notify_email;
	}

	public function set_notify_email( $in ) {
		$this->notify_email = $in;
	}

	public function get_require_passcode() {
		return $this->require_passcode;
	}

	public function set_require_passcode( $in ) {
		$this->require_passcode = $this->sanitize_yes_no( $in );
	}

	public function get_unique_passcode() {
		return $this->unique_passcode;
	}

	public function set_unique_passcode( $in ) {
		$this->unique_passcode = $this->sanitize_yes_no( $in );
	}

	public function get_passcode_editable() {
		return $this->passcode_editable;
	}

	public function set_passcode_editable( $in ) {
		$this->passcode_editable = $this->sanitize_yes_no( $in );
	}

	public function get_passcode_editable_label() {
		return $this->passcode_editable_label;
	}

	public function set_passcode_editable_label( $in ) {
		$this->passcode_editable_label = $in;
	}

	public function get_first_name_js_message() {
		return $this->first_name_js_message;
	}

	public function set_first_name_js_message( $in ) {
		$this->first_name_js_message = $in;
	}

	public function get_last_name_js_message() {
		return $this->last_name_js_message;
	}

	public function set_last_name_js_message( $in ) {
		$this->last_name_js_message = $in;
	}

	public function get_note_js_message() {
		return $this->note_js_message;
	}

	public function set_note_js_message( $in ) {
		$this->note_js_message = $in;
	}

	public function get_email_js_message() {
		return $this->email_js_message;
	}

	public function set_email_js_message( $in ) {
		$this->email_js_message = $in;
	}

	public function get_gdpr_js_message() {
		return $this->gdpr_js_message;
	}

	public function set_gdpr_js_message( $in ) {
		$this->gdpr_js_message = $in;
	}

	public function get_unique_passcode_js_message() {
		return $this->unique_passcode_js_message;
	}

	public function set_unique_passcode_js_message( $in ) {
		$this->unique_passcode_js_message = $in;
	}

	public function get_unique_email_js_message() {
		return $this->unique_email_js_message;
	}

	public function set_unique_email_js_message( $in ) {
		$this->unique_email_js_message = $in;
	}

	public function get_hide_note() {
		return $this->hide_note;
	}

	public function set_hide_note( $in ) {
		$this->hide_note = $this->sanitize_yes_no( $in );
	}

	public function get_rsvp_open_reg() {
		return $this->rsvp_open_reg;
	}

	public function set_rsvp_open_reg( $in ) {
		$this->rsvp_open_reg = $this->sanitize_yes_no( $in );
	}

	public function get_rsvp_hide_search_form() {
		return $this->rsvp_hide_search;
	}

	public function set_rsvp_hide_search_form( $in ) {
		$this->rsvp_hide_search = $this->sanitize_yes_no( $in );
	}

	public function get_display_search_form_text() {
		return $this->display_search_button_text;
	}

	public function set_display_search_button_text( $in ) {
		$this->display_search_button_text = $in;
	}

	public function set_rsvp_prompt_to_add_not_found( $in ) {
		$this->rsvp_open_prompt_to_add = $this->sanitize_yes_no( $in );
	}

	public function get_rsvp_prompt_to_add_not_found() {
		return $this->rsvp_open_prompt_to_add;
	}

	public function set_rsvp_prompt_to_add_not_found_text( $in ) {
		$this->rsvp_open_prompt_to_add_text = $in;
	}

	public function get_rsvp_prompt_to_add_not_found_text() {
		return $this->rsvp_open_prompt_to_add_text;
	}

	public function get_dont_use_hash() {
		return $this->dont_use_hash;
	}

	public function set_dont_use_hash( $in ) {
		$this->dont_use_hash = $this->sanitize_yes_no( $in );
	}

	public function get_add_additional_text() {
		return $this->add_additional_text;
	}

	public function set_add_additional_text( $in ) {
		$this->add_additional_text = $in;
	}

	public function get_guest_email_confirm() {
		return $this->guest_email_confirm;
	}

	public function set_guest_email_confirm( $in ) {
		$this->guest_email_confirm = $this->sanitize_yes_no( $in );
	}

	public function get_num_additional_guests() {
		return $this->num_additional_guests;
	}

	public function set_num_additional_guests( $in ) {
		$this->num_additional_guests = $in;
	}

	public function get_hide_email_field() {
		return $this->hide_email_field;
	}

	public function set_hide_email_field( $in ) {
		$this->hide_email_field = $this->sanitize_yes_no( $in );
	}

	public function get_unique_email_validation() {
		return $this->unique_email_validation;
	}

	public function set_unique_email_validation( $in ) {
		$this->unique_email_validation = $this->sanitize_yes_no( $in );
	}

	public function get_disable_custom_email_from() {
		return $this->disable_custom_email_from;
	}

	public function set_disable_custom_email_from( $in ) {
		$this->disable_custom_email_from = $this->sanitize_yes_no( $in );
	}

	public function get_only_passcode() {
		return $this->only_passcode;
	}

	public function set_only_passcode( $in ) {
		$this->only_passcode = $this->sanitize_yes_no( $in );
	}

	public function get_rsvp_email_text() {
		return $this->rsvp_email_text;
	}

	public function set_rsvp_email_text( $in ) {
		$this->rsvp_email_text = $in;
	}

	public function get_rsvp_no_editing() {
		return $this->rsvp_no_editing;
	}

	public function set_rsvp_no_editing( $in ) {
		$this->rsvp_no_editing = $this->sanitize_yes_no( $in );
	}

	public function get_rsvp_no_edit_prompt() {
		return $this->rsvp_no_edit_prompt;
	}

	public function set_rsvp_no_edit_prompt( $in ) {
		$this->rsvp_no_edit_prompt = $this->sanitize_yes_no( $in );
	}

	public function get_rsvp_only_once() {
		return $this->rsvp_only_once;
	}

	public function set_rsvp_only_once( $in ) {
		$this->rsvp_only_once = $this->sanitize_yes_no( $in );
	}

	public function get_rsvp_only_once_text() {
		return $this->rsvp_only_once_text;
	}

	public function set_rsvp_only_once_text( $in ) {
		$this->rsvp_only_once_text = $in;
	}

	public function get_rsvp_disable_user_search() {
		return $this->rsvp_disable_user_search;
	}

	public function set_rsvp_disable_user_search( $in ) {
		$this->rsvp_disable_user_search = $this->sanitize_yes_no( $in );
	}

	public function get_not_coming_verbiage() {
		return $this->not_coming_verbiage;
	}

	public function set_not_coming_verbiage( $in ) {
		$this->not_coming_verbiage = $in;
	}

	public function get_not_coming_redirect() {
		return $this->not_coming_redirect;
	}

	public function set_not_coming_redirect( $in ) {
		$this->not_coming_redirect = $in;
	}

	public function get_thankyou_modify_text() {
		return $this->thankyou_modify_text;
	}

	public function set_thankyou_modify_text( $in ) {
		$this->thankyou_modify_text = $in;
	}

	public function get_thankyou_password_text() {
		return $this->thankyou_password_text;
	}

	public function set_thankyou_password_text( $in ) {
		$this->thankyou_password_text = $in;
	}

	public function get_thankyou_associated_text() {
		return $this->thankyou_associated_text;
	}

	public function set_thankyou_associated_text( $in ) {
		$this->thankyou_associated_text = $in;
	}

	public function get_show_suffix() {
		return $this->show_suffix;
	}

	public function set_show_suffix( $in ) {
		$this->show_suffix = $this->sanitize_yes_no( $in );
	}

	public function get_show_salutation() {
		return $this->show_salutation;
	}

	public function set_show_salutation( $in ) {
		$this->show_salutation = $this->sanitize_yes_no( $in );
	}

	public function get_salutations() {
		return $this->salutations;
	}

	public function set_salutations( $in ) {
		$this->salutations = $in;
	}

	public function get_password_length() {
		return $this->password_length;
	}

	public function set_password_length( $in ) {
		$this->password_length = $in;
	}

	public function get_show_no_response() {
		return $this->show_no_response;
	}

	public function set_show_no_response( $in ) {
		$this->show_no_response = $this->sanitize_yes_no( $in );
	}

	public function get_require_email() {
		return $this->require_email;
	}

	public function set_require_email( $in ) {
		$this->require_email = $this->sanitize_yes_no( $in );
	}

	public function get_require_rsvp_values() {
		return $this->require_rsvp_values;
	}

	public function set_require_rsvp_values( $in ) {
		$this->require_rsvp_values = $this->sanitize_yes_no( $in );
	}

	public function get_hide_rsvp() {
		return $this->hide_rsvp;
	}

	public function set_hide_rsvp( $in ) {
		$this->hide_rsvp = $this->sanitize_yes_no( $in );
	}

	public function get_default_rsvp_value() {
		return $this->default_rsvp_value;
	}

	public function set_default_rsvp_value( $in ) {
		if ( rsvp_pro_is_allowed_status( $in ) ) {
			$this->default_rsvp_value = $in;
		}
	}

	public function get_no_passcode_on_open() {
		return $this->no_passcode_on_open;
	}

	public function set_no_passcode_on_open( $in ) {
		$this->no_passcode_on_open = $this->sanitize_yes_no( $in );
	}

	public function get_frontend_wizard() {
		return $this->frontend_wizard;
	}

	public function set_frontend_wizard( $in ) {
		$this->frontend_wizard = $this->sanitize_yes_no( $in );
	}

	public function get_new_attendee_button_text() {
		return $this->new_attendee_button_text;
	}

	public function set_new_attendee_button_text( $in ) {
		$this->new_attendee_button_text = $in;
	}

	public function get_rsvp_frontend_button_text() {
		return $this->rsvp_frontend_button_text;
	}

	public function set_rsvp_frontend_button_text( $in ) {
		$this->rsvp_frontend_button_text = $in;
	}

	public function get_next_button_text() {
		return $this->next_button_text;
	}

	public function set_next_button_text( $in ) {
		$this->next_button_text = $in;
	}

	public function get_rsvp_limit() {
		return $this->rsvp_limit;
	}

	public function set_rsvp_limit( $in ) {
		$this->rsvp_limit = $in;
	}

	public function get_rsvp_limit_text() {
		return $this->rsvp_limit_text;
	}

	public function set_rsvp_limit_text( $in ) {
		$this->rsvp_limit_text = $in;
	}

	public function get_rsvp_enable_waitlist() {
		return $this->rsvp_enable_waitlist;
	}

	public function set_rsvp_enable_waitlist( $in ) {
		$this->rsvp_enable_waitlist = $this->sanitize_yes_no( $in );
	}

	public function get_rsvp_enable_maybe() {
		return $this->rsvp_enable_maybe;
	}

	public function set_rsvp_enable_maybe( $in ) {
		$this->rsvp_enable_maybe = $this->sanitize_yes_no( $in );
	}

	public function get_rsvp_waitlist_text() {
		return $this->rsvp_waitlist_text;
	}

	public function set_rsvp_waitlist_text( $in ) {
		$this->rsvp_waitlist_text = $in;
	}

	public function get_open_date_text() {
		return $this->open_date_text;
	}

	public function set_open_date_text( $in ) {
		$this->open_date_text = $in;
	}

	public function get_close_date_text() {
		return $this->close_date_text;
	}

	public function set_close_date_text( $in ) {
		$this->close_date_text = $in;
	}

	public function get_attendeelist_filter() {
		return $this->attendeelist_filter;
	}

	public function set_attendeelist_filter( $in ) {
		if ( ! is_array( $in ) ) {
			$this->attendeelist_filter = array();
		} else {
			$this->attendeelist_filter = $in;
		}
	}

	public function get_attendeelist_sort_order() {
		return $this->attendeelist_sort_order;
	}

	public function set_attendeelist_sort_order( $in ) {
		$this->attendeelist_sort_order = $in;
	}

	public function get_attendeelist_hide_status() {
		return $this->attendeelist_hide_status;
	}

	public function set_attendeelist_hide_status( $in ) {
		$this->attendeelist_hide_status = $this->sanitize_yes_no( $in );
	}

	public function get_attendeelist_custom_qs() {
		return $this->attendeelist_custom_qs;
	}

	public function set_attendeelist_custom_qs( $in ) {
		$this->attendeelist_custom_qs = $in;
	}

	public function get_attendee_list_show_email() {
		return $this->attendee_list_show_email;
	}

	public function set_attendee_list_show_email( $in ) {
		$this->attendee_list_show_email = $this->sanitize_yes_no( $in );
	}

	/**
	 * Let's us know if we should show the pre-fill QR code on the front-end attendee list.
	 * @return string Either Y or N.
	 */
	public function get_attendee_list_show_qr_prefill () {
		return $this->attendee_list_show_qr_prefill;
	}

	/**
	 * Sets if we should show the pre-fill QR code on the front-end attendee list.
	 *
	 * @param string $in If we should show the prefill QR code on the public attendee list.
	 */
	public function set_attendee_list_show_qr_prefill( $in ) {
		$this->attendee_list_show_qr_prefill = $this->sanitize_yes_no( $in );
	}

	/**
	 * Gets if the attendee list should show a note or not.
	 *
	 * @return String Either returns a "Y" or "N".
	 */
	public function get_attendee_list_show_note() {
		return $this->attendee_list_show_note;
	}

	/**
	 * Sets if the attendee list should show the note or not.
	 *
	 * @param string $in Either a "Y" or a "N" to specify if the note should be shown.
	 */
	public function set_attendee_list_show_note( $in ) {
		$this->attendee_list_show_note = $this->sanitize_yes_no( $in );
	}

	public function get_attendee_list_show_summary() {
		return $this->attendee_list_show_summary;
	}

	public function get_attendee_list_page_size() {
		return $this->attendee_list_page_size;
	}

	public function set_attendee_list_page_size( $in ) {
		$this->attendee_list_page_size = $in;
	}

	public function set_attendee_list_show_summary( $in ) {
		$this->attendee_list_show_summary = $this->sanitize_yes_no( $in );
	}

	public function get_attendee_list_show_associated() {
		return $this->attendee_list_show_associated;
	}

	public function set_attendee_list_show_associated( $in ) {
		$this->attendee_list_show_associated = $this->sanitize_yes_no( $in );
	}

	public function get_attendee_list_export_button() {
		return $this->attendee_list_export_button;
	}

	public function set_attendee_list_export_button( $in ) {
		$this->attendee_list_export_button = $this->sanitize_yes_no( $in );
	}

	public function get_roles_auto_enroll() {
		return $this->roles_auto_enroll;
	}

	public function set_roles_auto_enroll( $in ) {
		$this->roles_auto_enroll = $in;
	}

	public function get_export_columns() {
		return $this->export_columns;
	}

	public function set_export_columns( $in ) {
		$this->export_columns = $in;
	}

	public function get_attendee_auto_login() {
		return $this->attendee_auto_login;
	}

	public function set_attendee_auto_login( $in ) {
		$this->attendee_auto_login = $this->sanitize_yes_no( $in );
	}

	public function get_modify_registration_text() {
		return $this->modify_registration_text;
	}

	public function set_modify_registration_text( $in ) {
		$this->modify_registration_text = $in;
	}

	public function get_add_attendee_button_text() {
		return $this->add_attendee_button_text;
	}

	public function set_add_attendee_button_text( $in ) {
		$this->add_attendee_button_text = $in;
	}

	public function get_admin_roles() {
		return $this->admin_roles;
	}

	public function set_admin_roles( $in ) {
		$this->admin_roles = $in;
	}

	public function get_email_from() {
		return $this->email_from;
	}

	public function set_email_from( $in ) {
		$this->email_from = $in;
	}

	public function get_email_cc_associated() {
		return $this->email_cc_associated;
	}

	public function set_email_cc_associated( $in ) {
		$this->email_cc_associated = $this->sanitize_yes_no( $in );
	}

	public function get_email_associated_individually() {
		return $this->email_associated_individually;
	}

	public function set_email_associated_individually( $in ) {
		$this->email_associated_individually = $this->sanitize_yes_no( $in );
	}

	public function get_email_bcc_addresses() {
		return $this->email_bcc_addresses;
	}

	public function set_email_bcc_addresses( $in ) {
		$this->email_bcc_addresses = $in;
	}

	public function get_email_subject() {
		return $this->email_subject;
	}

	public function set_email_subject( $in ) {
		$this->email_subject = $in;
	}

	public function get_admin_email_subject() {
		return $this->admin_email_subject;
	}

	public function set_admin_email_subject( $in ) {
		$this->admin_email_subject = $in;
	}

	/**
	 * Returns the custom admin email body.
	 *
	 * @return string The custom admin notification email body.
	 */
	public function get_admin_email_body() {
		return $this->admin_email_body;
	}

	/**
	 * Allows the user to set a custom admin email body.
	 *
	 * @param string $in The admin email body we want to send.
	 */
	public function set_admin_email_body( $in ) {
		$this->admin_email_body = $in;
	}

	public function get_email_body() {
		return $this->email_body;
	}

	public function set_email_body( $in ) {
		$this->email_body = $in;
	}

	public function get_no_email_body() {
		return $this->no_email_body;
	}

	public function set_no_email_body( $in ) {
		$this->no_email_body = $in;
	}

	public function get_maybe_email_body() {
		return $this->maybe_email_body;
	}

	public function set_maybe_email_body( $in ) {
		$this->maybe_email_body = $in;
	}

	/**
	 * Getter for the waitlist email body.
	 *
	 * @return string The waitlist email body.
	 */
	public function get_waitlist_email_body() {
		return $this->waitlist_email_body;
	}

	/**
	 * Sets the waitlist email body.
	 *
	 * @param string $in The waitlist email body.
	 */
	public function set_waitlist_email_body( $in ) {
		$this->waitlist_email_body = $in;
	}

	public function get_email_include_ics() {
		return $this->email_include_ics;
	}

	public function set_email_include_ics( $in ) {
		$this->email_include_ics = $this->sanitize_yes_no( $in );
	}

	public function get_first_name_label() {
		return $this->first_name_label;
	}

	public function set_first_name_label( $in ) {
		$this->first_name_label = $in;
	}

	public function get_last_name_label() {
		return $this->last_name_label;
	}

	public function set_last_name_label( $in ) {
		$this->last_name_label = $in;
	}

	public function get_complete_button_text() {
		return $this->complete_button_text;
	}

	public function set_complete_button_text( $in ) {
		$this->complete_button_text = $in;
	}

	public function get_passcode_label() {
		return $this->passcode_label;
	}

	public function set_passcode_label( $in ) {
		$this->passcode_label = $in;
	}

	public function get_edit_prompt_text() {
		return $this->edit_prompt_text;
	}

	public function set_edit_prompt_text( $in ) {
		$this->edit_prompt_text = $in;
	}

	public function get_suffix_label() {
		return $this->suffix_label;
	}

	public function set_suffix_label( $in ) {
		$this->suffix_label = $in;
	}

	public function get_salutation_label() {
		return $this->salutation_label;
	}

	public function set_salutation_label( $in ) {
		$this->salutation_label = $in;
	}

	public function get_email_label() {
		return $this->email_label;
	}

	public function set_email_label( $in ) {
		$this->email_label = $in;
	}

	public function get_associated_message() {
		return $this->associated_message;
	}

	public function set_associated_message( $in ) {
		$this->associated_message = $in;
	}

	public function get_associated_greeting() {
		return $this->associated_greeting;
	}

	public function set_associated_greeting( $in ) {
		$this->associated_greeting = $in;
	}

	public function get_multi_event_title() {
		return $this->multi_event_title;
	}

	public function set_multi_event_title( $in ) {
		$this->multi_event_title = $in;
	}

	public function get_multi_option_text() {
		return $this->multi_option_text;
	}

	public function set_multi_option_text( $in ) {
		$this->multi_option_text = $in;
	}

	public function get_remove_attendee_button() {
		return $this->remove_attendee_button;
	}

	public function set_remove_attendee_button( $in ) {
		$this->remove_attendee_button = $in;
	}

	public function get_yes_text() {
		return $this->yes_text;
	}

	public function set_yes_text( $in ) {
		$this->yes_text = $in;
	}

	public function get_no_text() {
		return $this->no_text;
	}

	public function set_no_text( $in ) {
		$this->no_text = $in;
	}

	public function get_maybe_text() {
		return $this->maybe_text;
	}

	public function set_maybe_text( $in ) {
		$this->maybe_text = $in;
	}

	public function get_plus_one_text() {
		return $this->plus_one_text;
	}

	public function set_plus_one_text( $in ) {
		$this->plus_one_text = $in;
	}

	public function get_hi_text() {
		return $this->hi_text;
	}

	public function set_hi_text( $in ) {
		$this->hi_text = $in;
	}

	public function get_no_response_text() {
		return $this->no_response_text;
	}

	public function set_no_response_text( $in ) {
		$this->no_response_text = $in;
	}

	public function get_multiple_matches_text() {
		return $this->multiple_matches_text;
	}

	public function set_multiple_matches_text( $in ) {
		$this->multiple_matches_text = $in;
	}

	public function get_multiple_attendee_text() {
		return $this->multiple_attendee_text;
	}

	public function set_multiple_attendee_text( $in ) {
		$this->multiple_attendee_text = $in;
	}

	public function get_fuzzy_match_text() {
		return $this->fuzzy_match_text;
	}

	public function set_fuzzy_match_text( $in ) {
		$this->fuzzy_match_text = $in;
	}

	public function get_unable_find_text() {
		return $this->unable_find_text;
	}

	public function set_unable_find_text( $in ) {
		$this->unable_find_text = $in;
	}

	public function get_welcome_back_text() {
		return $this->welcome_back_text;
	}

	public function set_welcome_back_text( $in ) {
		$this->welcome_back_text = $in;
	}

	public function get_partial_user_search() {
		return $this->partial_user_search;
	}

	public function set_partial_user_search( $in ) {
		$this->partial_user_search = $this->sanitize_yes_no( $in );
	}

	public function get_last_name_not_required() {
		return $this->last_name_not_required;
	}

	public function set_last_name_not_required( $in ) {
		$this->last_name_not_required = $this->sanitize_yes_no( $in );
	}

	public function get_auto_waitlist_to_yes() {
		return $this->auto_waitlist_to_yes;
	}

	public function set_auto_waitlist_to_yes( $in ) {
		$this->auto_waitlist_to_yes = $this->sanitize_yes_no( $in );
	}

	public function get_waitlist_yes_unavailable() {
		return $this->waitlist_yes_unavailable;
	}

	public function set_waitlist_yes_unavailable( $in ) {
		$this->waitlist_yes_unavailable = $this->sanitize_yes_no( $in );
	}

	public function get_waitlist_perm_switch() {
		return $this->waitlist_perm_switch;
	}

	public function set_waitlist_perm_switch( $in ) {
		$this->waitlist_perm_switch = $this->sanitize_yes_no( $in );
	}

	public function get_waitlist_status_email() {
		return $this->waitlist_status_email;
	}

	public function set_waitlist_status_email( $in ) {
		$this->waitlist_status_email = $in;
	}

	public function get_show_calendar_link() {
		return $this->show_calendar_link;
	}

	public function set_show_calendar_link( $in ) {
		$this->show_calendar_link = $this->sanitize_yes_no( $in );
	}

	public function get_calendar_link_text() {
		return $this->calendar_link_text;
	}

	public function set_calendar_link_text( $in ) {
		$this->calendar_link_text = $in;
	}

	public function get_google_calendar_link_text() {
		return $this->google_calendar_link_text;
	}

	public function set_google_calendar_link_text( $in ) {
		$this->google_calendar_link_text = $in;
	}

	public function get_additional_attendee_text() {
		return $this->additional_attendee_text;
	}

	public function set_additional_attendee_text( $in ) {
		$this->additional_attendee_text = $in;
	}

	public function get_repeat_do_not_save_event() {
		return $this->repeat_do_not_save_event;
	}

	public function set_repeat_do_not_save_event( $in ) {
		$this->repeat_do_not_save_event = $this->sanitize_yes_no( $in );
	}

	public function get_use_email_for_lookup() {
		return $this->use_email_for_lookup;
	}

	public function set_use_email_for_lookup( $in ) {
		$this->use_email_for_lookup = $this->sanitize_yes_no( $in );
	}

	public function get_show_event_info() {
		return $this->show_event_info;
	}

	public function set_show_event_info( $in ) {
		$this->show_event_info = $this->sanitize_yes_no( $in );
	}

	public function get_attendee_list_allow_rsvp() {
		return $this->attendee_list_allow_rsvp;
	}

	public function set_attendee_list_allow_rsvp( $in ) {
		$this->attendee_list_allow_rsvp = $this->sanitize_yes_no( $in );
	}

	public function get_send_attendee_list_email() {
		return $this->send_attendee_list_email;
	}

	public function set_send_attendee_list_email( $in ) {
		$this->send_attendee_list_email = $in;
	}

	public function get_send_attendee_list_format() {
		return $this->send_attendee_list_format;
	}

	public function set_send_attendee_list_format( $in ) {
		$this->send_attendee_list_format = $in;
	}

	public function get_send_attendee_list_note() {
		return $this->send_attendee_list_note;
	}

	public function set_send_attendee_list_note( $in ) {
		$this->send_attendee_list_note = $in;
	}

	public function get_first_last_editable() {
		return $this->first_last_editable;
	}

	public function set_first_last_editable( $in ) {
		$this->first_last_editable = $this->sanitize_yes_no( $in );
	}

	public function get_attendee_list_show_search() {
		return $this->attendeelist_show_search;
	}

	public function set_attendee_list_show_search( $in ) {
		$this->attendeelist_show_search = $this->sanitize_yes_no( $in );
	}

	public function get_attendee_list_allow_checkin() {
		return $this->attendeelist_allow_checkin;
	}

	public function set_attendee_list_allow_checkin( $in ) {
		$this->attendeelist_allow_checkin = $this->sanitize_yes_no( $in );
	}

	public function get_attendee_list_search_text() {
		return $this->attendeelist_filter_text;
	}

	public function set_attendee_list_search_text( $in ) {
		$this->attendeelist_filter_text = $in;
	}

	public function get_attendee_list_checkin_text() {
		return $this->attendeelist_checkin_text;
	}

	public function set_attendee_list_checkin_text( $in ) {
		$this->attendeelist_checkin_text = $in;
	}

	public function get_attendee_list_checked_in_text() {
		return $this->attendeelist_checked_in_text;
	}

	public function set_attendee_list_checked_in_text( $in ) {
		return $this->attendeelist_checked_in_text = $in;
	}

	public function get_allow_checkin() {
		return $this->allow_checkin;
	}

	public function set_allow_checkin( $in ) {
		$this->allow_checkin = $this->sanitize_yes_no( $in );
	}

	public function get_show_gdpr_question() {
		return $this->show_gdpr_question;
	}

	public function set_show_gdpr_question( $in ) {
		$this->show_gdpr_question = $this->sanitize_yes_no( $in );
	}

	public function get_gdpr_question_text() {
		return $this->gdpr_question_text;
	}

	public function set_gdpr_question_text( $in ) {
		$this->gdpr_question_text = $in;
	}

	public function get_enable_recaptcha() {
		return $this->enable_recaptcha;
	}

	public function set_enable_recaptcha( $in ) {
		$this->enable_recaptcha = $this->sanitize_yes_no( $in );
	}

	public function get_recaptcha_site_key() {
		return $this->recaptcha_site_key;
	}

	public function set_recaptcha_site_key( $in ) {
		$this->recaptcha_site_key = $in;
	}

	public function get_recaptcha_secret_key() {
		return $this->recaptcha_secret_key;
	}

	public function set_recaptcha_secret_key( $in ) {
		$this->recaptcha_secret_key = $in;
	}

	/**
	 * Specifies if the profile picture should be shown on the attendee list.
	 *
	 * @param string $in Y or N for showing profile picture.
	 */
	public function set_attendee_list_show_profile_pic( $in ) {
		$this->attendee_list_show_profile_pic = $this->sanitize_yes_no( $in );
	}

	/**
	 * Gets the option to show profile picture for the attendee list.
	 *
	 * @return string Either a Y or N for showing profile picture.
	 */
	public function get_attendee_list_show_profile_pic() {
		return $this->attendee_list_show_profile_pic;
	}

	/**
	 * Sets if the user's profile picture should be shown on the RSVP form.
	 *
	 * @param string $in Either a Y or a N for if the profile picture should be shown on the RSVP form.
	 */
	public function set_form_show_profile_pic( $in ) {
		$this->form_show_profile_pic = $this->sanitize_yes_no( $in );
	}

	/**
	 * Gets whether the profile picture should be shown on the RSVP form.
	 *
	 * @return string Either a "Y" or a "N".
	 */
	public function get_form_show_profile_pic() {
		return $this->form_show_profile_pic;
	}

	/**
	 * Gets to see if we should enable AJAX on the front-end form.
	 *
	 * @return string Either Y or N is returned.
	 */
	public function get_enable_ajax() {
		return $this->enable_ajax;
	}

	/**
	 * Allows us to set if we should enable AJAX on the front-end form.
	 *
	 * @param string $in Valid values are Y or N.
	 */
	public function set_enable_ajax( $in ) {
		$this->enable_ajax = $this->sanitize_yes_no( $in );
	}

	/**
	 * Returns if we should be showing the new attendee form first before attendee search.
	 *
	 * @return string Either a string with a value of Y or N.
	 */
	public function get_show_new_attendee_form_first() {
		return $this->show_new_attendee_form_first;
	}

	/**
	 * Allows us to record if we should show the new attendee form first before attendee search.
	 *
	 * @param string $in A string with a value of Y or N (default).
	 */
	public function set_show_new_attendee_form_first( $in ) {
		$this->show_new_attendee_form_first = $this->sanitize_yes_no( $in );
	}

	/**
	 * Returns the text for the "find attendee" link when we show the new attendee form first.
	 *
	 * @return string The text for the find attendee link.
	 */
	public function get_find_attendees_link_text() {
		return $this->find_attendee_link_text;
	}

	/**
	 * Sets the text for the find attendee link.
	 *
	 * @param string $in The text we want the user to see to go find an attendee.
	 */
	public function set_find_attendees_link_text( $in ) {
		$this->find_attendee_link_text = $in;
	}

	/**
	 * Gets the waitlist friendly short text.
	 *
	 * @return string The waitlist friendly text.
	 */
	public function get_waitlist_friendly_text() {
		return $this->waitlist_friendly_text;
	}

	/**
	 * Sets the waitlist friendly short text.
	 *
	 * @param string $in The waitlist friendly short text.
	 */
	public function set_waitlist_friendly_text( $in ) {
		$this->waitlist_friendly_text = $in;
	}

	/**
	 * Gets the custom RSVP form URL.
	 *
	 * @return string
	 */
	public function get_rsvp_form_url() {
		return $this->rsvp_form_url;
	}

	/**
	 * Sets the custom RSVP form URL.
	 *
	 * @param string $in The RSVP form URL we want to set.
	 */
	public function set_rsvp_form_url( $in ) {
		$this->rsvp_form_url = $in;
	}

	/**
	 * Specifies if we should always show the additional attendee button no matter what the main attendee's RSVP status.
	 *
	 * @param string $in Either Y or N to specify if we should always show the additional attendee button.
	 */
	public function set_always_show_additional( $in ) {
		$this->always_show_additional = $this->sanitize_yes_no( $in );
	}

	/**
	 * Specifies if we should always show the additional attendee button no matter what the main attendee's RSVP status.
	 *
	 * @return string Either Y or N if we should always show the additional attendee area.
	 */
	public function get_always_show_additional() {
		return $this->always_show_additional;
	}

	/**
	 * Returns if payments are enabled for this event or not.
	 *
	 * @return string Either a Y or a N for if payments are enabled.
	 */
	public function get_enable_payments() {
		return $this->enable_payments;
	}

	/**
	 * Sets if the payments are enabled or not.
	 *
	 * @param string $in Either a Y or a N for if the payments should be enabled.
	 */
	public function set_enable_payments( $in ) {
		$this->enable_payments = $this->sanitize_yes_no( $in );
	}

	/**
	 * Gets the ticket price for the event.
	 *
	 * @return string The ticket price.
	 */
	public function get_ticket_price() {
		return $this->ticket_price;
	}

	/**
	 * Sets the ticket price for the event.
	 *
	 * @param string $in The ticket price for the event.
	 */
	public function set_ticket_price( $in ) {
		$this->ticket_price = $in;
	}

	/**
	 * Gets if payments should be in testing mode or not.
	 *
	 * @return string Either Y or N if payments should be in "testing."
	 */
	public function get_payment_testing() {
		return $this->payment_testing;
	}

	/**
	 * Sets if payments should be in testing mode or not.
	 *
	 * @param string $in Either Y if in testing, N otherwise.
	 */
	public function set_payment_testing( $in ) {
		$this->payment_testing = $this->sanitize_yes_no( $in );
	}

	/**
	 * Gets the currency specified for this event.
	 *
	 * @return string The currency for this event.
	 */
	public function get_currency() {
		return ( '' === $this->currency ) ? 'USD' : $this->currency;
	}

	/**
	 * Sets the currency for this event.
	 *
	 * @param string $in The currency for this event.
	 */
	public function set_currency( $in ) {
		$this->currency = $in;
	}

	/**
	 * Gets the currency position for the event.
	 *
	 * @return string The currency position for the event.
	 */
	public function get_currency_position() {
		return ( '' === $this->currency_position ) ? 'before' : $this->currency_position;
	}

	/**
	 * Sets the currency position for the event.
	 *
	 * @param string $in The currency position for the event.
	 */
	public function set_currency_position( $in ) {
		$this->currency_position = $in;
	}

	/**
	 * Returns the thousands separator we will use for total amount formatting.
	 *
	 * @return string The thousands separator for the amounts, default will be a comma.
	 */
	public function get_thousands_separator() {
		return ( '' === $this->thousands_separator ) ? ',' : $this->thousands_separator;
	}

	/**
	 * Sets the thousands separator for this event.
	 *
	 * @param string $in The thousands separator for the amounts.
	 */
	public function set_thousands_separator( $in ) {
		$this->thousands_separator = $in;
	}

	/**
	 * Gets the decimal separator for this event.
	 *
	 * @return string The decimal separator for this event. By default it will be a dot.
	 */
	public function get_decimal_separator() {
		return ( '' === $this->decimal_separator ) ? '.' : $this->decimal_separator;
	}

	/**
	 * Sets the decimal separator for this event.
	 *
	 * @param string $in The decimal separator for this event.
	 */
	public function set_decimal_separator( $in ) {
		$this->decimal_separator = $in;
	}

	/**
	 * Returns the custom payment message an attendee sees.
	 *
	 * @return string The payment message an attendee sees when they are abbout to pay.
	 */
	public function get_payment_message() {
		return $this->payment_message;
	}

	/**
	 * Sets the custom payment message an attendee sees.
	 *
	 * @param string $in The payment message an attendee sees when they are about to pay.
	 */
	public function set_payment_message( $in ) {
		$this->payment_message = $in;
	}

	/**
	 * Get the payment success URL.
	 *
	 * @return string The payment success URL that should be used.
	 */
	public function get_payment_success_url() {
		return $this->payment_success_url;
	}

	/**
	 * Sets the payment success URL.
	 *
	 * @param string $in The payment success URL.
	 */
	public function set_payment_success_url( $in ) {
		$this->payment_success_url = $in;
	}

	/**
	 * Gets the payment failure URL.
	 *
	 * @return string The payment failure URL.
	 */
	public function get_payment_failure_url() {
		return $this->payment_failure_url;
	}

	/**
	 * Sets the payment failure URL.
	 *
	 * @param string $in The payment failure URL.
	 */
	public function set_payment_failure_url( $in ) {
		$this->payment_failure_url = $in;
	}

	/**
	 * Gets the custom payment description.
	 *
	 * @return string The payment description that will be sent over to the payment processor.
	 */
	public function get_payment_description() {
		return $this->payment_description;
	}

	/**
	 * Sets the custom payment description.
	 *
	 * @param string $in The payment description that is sent over to the payment processor.
	 */
	public function set_payment_description( $in ) {
		$this->payment_description = $in;
	}

	/**
	 * Sets if full name search is enabled or not.
	 *
	 * @param string $in Either a Y or N for if that functionality is enabled.
	 */
	public function set_full_name_search( $in ) {
		$this->full_name_search = $this->sanitize_yes_no( $in );
	}

	/**
	 * Gets if full name search is enabled or not.
	 *
	 * @return string Either a Y or N for if that functionality is enabled.
	 */
	public function get_full_name_search() {
		return $this->full_name_search;
	}

	/**
	 * Gets the name label displayed on the front-end area.
	 *
	 * @return string The name label.
	 */
	public function get_name_label() {
		return $this->name_label;
	}

	/**
	 * Sets the name label displayed on the front-end area.
	 *
	 * @param string $in The name label.
	 */
	public function set_name_label( $in ) {
		$this->name_label = $in;
	}

	/**
	 * Returns the raw array of settings that is stored in the database.
	 *
	 * @return array The raw key-value pair array that is the event options.
	 */
	public function get_options() {
		return $this->options;
	}
}
