( function() {
	var __                = wp.i18n.__; // The __() function for internationalization.
	var el                = wp.element.createElement; // The wp.element.createElement() function to create elements.
	var registerBlockType = wp.blocks.registerBlockType; // The registerBlockType() function to register blocks.
	var InspectorControls = wp.editor.InspectorControls;
	var SelectControl     = wp.components.SelectControl;
	var TextControl       = wp.components.TextControl;
	var Component         = wp.element;
	var Editable          = wp.blocks.Editable; // For creating editable elements.

	function rsvp_pro_event_list_operations( props ) {
		return el(
			'div', // Tag type.
			{
				className: props.className,  // Class name is generated using the block's name prefixed with wp-block-, replacing the / namespace separator with a single -.
			},
			'[rsvppro-eventlist]' 
		);
	}
	/**
	 * Register RSVP Pro Event List block
	 *
	 * @param  {string}   name     Block name.
	 * @param  {Object}   settings Block settings.
	 * @return {?WPBlock}          Block itself, if registered successfully,
	 *                             otherwise "undefined".
	 */
	registerBlockType(
		'rsvp-pro/event-list',
		{
			title: __( 'RSVP Pro Event List' ), 
			icon: 'yes', // Block icon from Dashicons. https://developer.wordpress.org/resource/dashicons/.
			category: 'embed', // Block category. Group blocks together based on common traits E.g. common, formatting, layout widgets, embed.
			edit: rsvp_pro_event_list_operations,
			save: rsvp_pro_event_list_operations,
		}
	);

	function rsvp_pro_attendee_event_list_operations( props ) {
		return el(
			'div', // Tag type.
			{
				className: props.className,  // Class name is generated using the block's name prefixed with wp-block-, replacing the / namespace separator with a single -.
			},
			'[rsvp-pro-attendee-events]' 
		);
	}
	/**
	 * Register RSVP Pro Attendee Event List block
	 *
	 * @param  {string}   name     Block name.
	 * @param  {Object}   settings Block settings.
	 * @return {?WPBlock}          Block itself, if registered successfully,
	 *                             otherwise "undefined".
	 */
	registerBlockType(
		'rsvp-pro/attendee-event-list',
		{
			title: __( 'RSVP Pro Attendee Event List' ), 
			icon: 'yes', // Block icon from Dashicons. https://developer.wordpress.org/resource/dashicons/.
			category: 'embed', // Block category. Group blocks together based on common traits E.g. common, formatting, layout widgets, embed.
			edit: rsvp_pro_attendee_event_list_operations,
			save: rsvp_pro_attendee_event_list_operations,
		}
	);



	/**
	 * Register RSVP Pro Event Form block
	 *
	 * @param  {string}   name     Block name.
	 * @param  {Object}   settings Block settings.
	 * @return {?WPBlock}          Block itself, if registered successfully,
	 *                             otherwise "undefined".
	 */
	registerBlockType(
		'rsvp-pro/event-form',
		{
			title: __( 'RSVP Pro Event Form' ),
			description: __('Select an event below to add the event\'s RSVP form to your page' ), 
			icon: 'yes', // Block icon from Dashicons. https://developer.wordpress.org/resource/dashicons/.
			category: 'embed',
			supports: {
				customClassName: false,
				className: false,
				html: true
			},
			attributes: {
				event_id: {
					type: 'string',
				},
			},
			edit: function( props) {
				var isSelected = props.isSelected;
				props.attributes.event_id = props.attributes.event_id && props.attributes.event_id != '0' ? props.attributes.event_id : false;
				tmp_event = null;
				if ( props.attributes.event_id != false ) {
					for( var i = 0; i < rsvppro_event_block_params.events.length; i++ ) {
						if ( rsvppro_event_block_params.events[i].value == props.attributes.event_id ) {
							tmp_event = rsvppro_event_block_params.events[i];
							break;
						}
					}
				}
				return [
					isSelected && el(
						InspectorControls,
						{key: 'inspector'},
						el(
							SelectControl,
							{
								label: __('RSVP Pro Event' ),
								value: props.attributes.event_id,
								onChange: function (value) {
									props.setAttributes({event_id: value});
								},
								options: rsvppro_event_block_params.events,
							}
						)
					),
					el('div',
						{key: 'rsvp-pro-event'},
						props.attributes.event_id ? __('RSVP Pro Event Form: ') + tmp_event.label : __('Select Your Event')
					)
				];
			},
			save: function (props) {
				return el(
					'div',
					{
						event_id: props.event_id
					},
					'[rsvppro id="' + props.attributes.event_id + '"]'
				);
			},
		}
	);

	/**
	 * Register RSVP Pro Attendee List block
	 *
	 * @param  {string}   name     Block name.
	 * @param  {Object}   settings Block settings.
	 * @return {?WPBlock}          Block itself, if registered successfully,
	 *                             otherwise "undefined".
	 */
	registerBlockType(
		'rsvp-pro/event-attendee-list',
		{
			title: __( 'RSVP Pro Event Attendee List' ),
			description: __('Select an event below to add the event\'s attendee list to your page' ), 
			icon: 'yes', // Block icon from Dashicons. https://developer.wordpress.org/resource/dashicons/.
			category: 'embed',
			supports: {
				customClassName: false,
				className: false,
				html: true
			},
			attributes: {
				event_id: {
					type: 'number',
				},
			},
			edit: function( props) {
				var isSelected = props.isSelected;
				props.attributes.event_id = props.attributes.event_id && props.attributes.event_id != '0' ? props.attributes.event_id : false;
				tmp_event = null;
				if ( props.attributes.event_id != false ) {
					for( var i = 0; i < rsvppro_event_block_params.events.length; i++ ) {
						if ( rsvppro_event_block_params.events[i].value == props.attributes.event_id ) {
							tmp_event = rsvppro_event_block_params.events[i];
							break;
						}
					}
				}

				return [
					isSelected && el(
						InspectorControls,
						{key: 'inspector'},
						el(
							SelectControl,
							{
								label: __('RSVP Pro Event' ),
								value: props.attributes.event_id,
								onChange: function (value) {
									props.setAttributes({event_id: value});
								},
								options: rsvppro_event_block_params.events,
							}
						)
					),
					el('div',
						{key: 'rsvp-pro-event'},
						props.attributes.event_id ? __('RSVP Pro Event Attendee List: ') + tmp_event.label : __('Select Your Event')
					)
				];
			},
			save: function (props) {
				return el(
					'div',
					{},
					'[rsvppro-attendeelist id="' + props.attributes.event_id + '"]'
				);
			},
		}
	);
})();