jQuery( document ).ready( function () {
	jQuery( "#associatedAttendeesSelect" ).multiSelect();
	jQuery( "#attendeesQuestionSelect" ).multiSelect();
	jQuery( "#attendeeAccessSelect" ).multiSelect();
	jQuery( "#rsvp_pro_admin_roles" ).multiSelect();
	jQuery( "#rsvp_attendee_list_custom_questions" ).multiSelect();
	jQuery( "#reminder-rsvp-statuses" ).multiSelect();
	jQuery( "#events_to_export" ).multiSelect();
	jQuery( "#rsvp_auto_enroll_role" ).multiSelect();
	jQuery( "#rsvp_attendee_list_filter" ).multiSelect();
	jQuery( "#rsvp_pro_mass_email_attendees" ).multiSelect();
	jQuery( "#open_date" ).datepicker( {
		dateFormat: 'yy-mm-dd'
	} );
	jQuery( "#rsvp_date" ).datepicker(
		{
			dateFormat: 'yy-mm-dd'
		} );
	jQuery( "#open_date_time" ).timepicker( {
		timeFormat: 'h:mmp'
	} );
	jQuery( "#close_date" ).datepicker( {
		dateFormat: 'yy-mm-dd'
	} );
	jQuery( "#close_date_time" ).timepicker( {
		timeFormat: 'h:mmp'
	} );
	jQuery( "#rsvp_repeat_start_date" ).datepicker( {
		dateFormat: 'yy-mm-dd'
	} );
	jQuery( "#rsvp_repeat_end_date" ).datepicker( {
		dateFormat: 'yy-mm-dd'
	} );
	jQuery( ".rsvp_pro_datepicker_question" ).datepicker( {
		dateFormat: 'yy-mm-dd'
	} )

	jQuery( "#parentEventID" ).change( function () {
		handleParentEventChange();
	} )

	jQuery( "#rsvp_show_salutation" ).change( function () {
		handleShowSalutationChange();
	} );
	handleShowSalutationChange();

	jQuery( ".pagesize-selector" ).change( function () {
		this.form.submit();
	} )

	jQuery( "#rsvp_pro_admin_mass_email_deselect_all" ).on( "click", function ( event ) {
		event.preventDefault();
		jQuery( "#rsvp_pro_mass_email_attendees" ).multiSelect( "deselect_all" );
	} )

	jQuery( "#rsvp_pro_admin_mass_email_select_all" ).on( "click", function ( event ) {
		event.preventDefault();
		jQuery( "#rsvp_pro_mass_email_attendees" ).multiSelect( "select_all" );
	} )

	jQuery( "#rsvp_status_search" ).hide();
	jQuery( "#attendee_search_field" ).change( function () {
		if ( jQuery( "#attendee_search_field" ).val() == "rsvpStatus" ) {
			jQuery( "#rsvp_status_search" ).show();
			jQuery( "#s" ).hide();
		} else {
			jQuery( "#rsvp_status_search" ).hide();
			jQuery( "#s" ).show();
		}
	} );

	jQuery( ".delete_attendee_attachment" ).on( "click", function ( event ) {
		event.preventDefault();
		let token = jQuery( this ).attr( "data-attendee-token" );
		let qid = jQuery( this ).attr( "data-question-id" );

		if ( (token != '') && (qid != '') ) {
			var datastring = "attendee_token=" + token + "&qid=" + qid;
			datastring += "&action=rsvp_delete_custom_question_file";
			jQuery.ajax( {
				context: this,
				type   : "POST",
				url    : rsvp_pro_admin_data.ajaxurl,
				data   : datastring,
				success: function ( response ) {
					jQuery( this ).parent().remove();
				},
			} );
		}
	} );

	jQuery( "#rsvp_pro_admin_settings_tabs" ).tabs();

	jQuery( '.select-all-multiselect' ).click( function () {
		if ( jQuery( this ).attr( 'data-ms-id' ) != '' ) {
			jQuery( '#' + jQuery( this ).attr( 'data-ms-id' ) ).multiSelect( 'select_all' );
		}

		return false;
	} );

	jQuery( '.deselect-all-multiselect' ).click( function () {
		if ( jQuery( this ).attr( 'data-ms-id' ) != '' ) {
			jQuery( '#' + jQuery( this ).attr( 'data-ms-id' ) ).multiSelect( 'deselect_all' );
		}

		return false;
	} );

	if ( jQuery.validator != undefined ) {
		jQuery.validator.addMethod( "rsvpProAdminPasscodeUnique", function ( value, element ) {
			var eventId = jQuery( '#eventID' ).val();
			var attendeeId = jQuery( '#attendeeID' ).val();
			var isUnique = true;

			if ( attendeeId == undefined ) {
				attendeeId = 0;
			}

			var datastring = "rsvp_id=" + eventId + "&attendee_id=" + attendeeId + "&passcode=" + value;
			datastring += "&action=rsvp_pro_has_passcode_been_used";
			jQuery.ajax( {
				type   : "POST",
				async  : true,
				url    : rsvp_pro_admin_data.ajaxurl,
				data   : datastring,
				success: function ( response ) {
					var json = JSON.parse( response );
					if ( json.has_been_used == true ) {
						isUnique = false;
					}
				},
			} );

			return isUnique;
		}, "<br />A unique passcode is required for this event." );


		jQuery.validator.addMethod( "rsvpProImportHeaderValidation", function ( value, element ) {
			if ( (jQuery( "#first_name" ).val() == '') && (jQuery( "#last_name" ).val() == '') ) {
				return false;
			}

			return true;
		}, "<br />You must select the first AND/OR last name column before importing." );

		jQuery( '#rsvp_pro_attendee_contact' ).validate( {
			rules: {
				passcode: "rsvpProAdminPasscodeUnique"
			}
		} );

		jQuery( "#rsvp_import_column_select" ).validate( {
			rules: {
				first_name: "rsvpProImportHeaderValidation"
			}
		} )
	}
} );

function handleParentEventChange() {
	if ( (jQuery( "#parentEventID" ).val() == "") || (jQuery( "#parentEventID" ).val() == 0) ) {
		showAllEventOptionsElements();
	} else {
		hideParentEventOptionsElements();
	}
}

function showAllEventOptionsElements() {
	jQuery( ".subEventHide" ).show();
}

function hideParentEventOptionsElements() {
	jQuery( ".subEventHide" ).hide();
}

function handleShowSalutationChange() {
	if ( jQuery( "#rsvp_show_salutation" ).attr( "checked" ) ) {
		jQuery( "#rsvpProOptionSalutationsContainer" ).show();
	} else {
		jQuery( "#rsvpProOptionSalutationsContainer" ).hide();
	}
}

(function ( $ ) {
	$( 'table.toplevel_page_rsvp-pro-top-level #the-list.event-questions' ).sortable( {
		'items' : 'tr',
		'axis'  : 'y',
		'helper': fixHelper,
		'update': function ( e, ui ) {
			$.post( ajaxurl, {
				action: 'update-rsvp-pro-questions-menu-order',
				order : $( '#the-list.event-questions' ).sortable( 'serialize' ),
			} );
		}
	} );

	var fixHelper = function ( e, ui ) {
		ui.children().children().each( function () {
			$( this ).width( $( this ).width() );
		} );
		return ui;
	};

	/****
	 * Fix for table breaking
	 */
	jQuery( window ).on( 'load', function () {

		// make the array for the sizes
		var td_array = new Array();
		var i = 0;

		jQuery( 'table.toplevel_page_rsvp-pro-top-level #the-list.event-questions tr:first-child' ).find( 'td' ).each( function () {

			td_array[i] = $( this ).outerWidth();

			i += 1;
		} );

		jQuery( 'table.toplevel_page_rsvp-pro-top-level #the-list.event-questions' ).find( 'tr' ).each( function () {
			var j = 0;
			$( this ).find( 'td' ).each( function () {

				var paddingx = parseInt( $( this ).css( 'padding-left' ).replace( 'px', '' ) ) + parseInt( $( this ).css( 'padding-right' ).replace( 'px', '' ) );
				$( this ).width( td_array[j] - paddingx );

				j += 1;
			} );
		} );

		var y = 0;

		// check if there are items in the table
		if ( jQuery( 'table.toplevel_page_rsvp-pro-top-level #the-list.event-questions > tr.no-items' ).length == 0 ) {
			jQuery( '#the-list' ).parent().find( 'thead' ).find( 'th' ).each( function () {

				var paddingx = parseInt( $( this ).css( 'padding-left' ).replace( 'px', '' ) ) + parseInt( $( this ).css( 'padding-right' ).replace( 'px', '' ) );
				$( this ).width( td_array[y] - paddingx );

				y += 1;
			} );

			var z = 0;
			jQuery( 'table.toplevel_page_rsvp-pro-top-level #the-list.event-questions' ).parent().find( 'tfoot' ).find( 'th' ).each( function () {

				var paddingx = parseInt( $( this ).css( 'padding-left' ).replace( 'px', '' ) ) + parseInt( $( this ).css( 'padding-right' ).replace( 'px', '' ) );
				$( this ).width( td_array[z] - paddingx );

				z += 1;
			} );
		}

	} );

	/*****
	 *  End table breaking fix
	 */
})( jQuery )