<table class="form-table">
	<tbody>
		<tr>
			<th scope="row" colspan="2">
				<h3><?php esc_html_e( 'Coming soon! This doesn\'t work quite yet.', 'rsvp-pro-plugin'); ?></h3>
			</th>
		</tr>
		<tr class="subEventHide">
			<th scope="row">
				<label for="<?php echo RSVP_PRO_OPTION_ENABLE_PAYMENTS; ?>"><?php echo rsvp_pro_get_admin_string( 'settings_enable_payments_label' ); ?></label>
			</th>
			<td>
				<input type="checkbox" name="<?php echo RSVP_PRO_OPTION_ENABLE_PAYMENTS; ?>" id="<?php echo RSVP_PRO_OPTION_ENABLE_PAYMENTS; ?>" value="Y" <?php echo ( $event_options->get_enable_payments() === 'Y' ) ? 'checked="checked"' : ''; ?> />
				<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_enable_payments_description' ); ?></span>
			</td>
		</tr>
		<tr class="subEventHide">
			<th scope="row">
				<label for="<?php echo RSVP_PRO_OPTION_PAYMENT_IN_TESTING; ?>"><?php echo rsvp_pro_get_admin_string( 'settings_payments_testing_label' ); ?></label>
			</th>
			<td>
				<input type="checkbox" name="<?php echo RSVP_PRO_OPTION_PAYMENT_IN_TESTING; ?>" id="<?php echo RSVP_PRO_OPTION_PAYMENT_IN_TESTING; ?>" value="Y" <?php echo ( $event_options->get_payment_testing() === 'Y' ) ? 'checked="checked"' : ''; ?> />
				<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_payments_testing_description' ); ?></span>
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for="<?php echo RSVP_PRO_OPTION_TICKET_PRICE; ?>"><?php echo rsvp_pro_get_admin_string( 'settings_ticket_price_label' ); ?></label>
			</th>
			<td>
				<input type="text" name="<?php echo RSVP_PRO_OPTION_TICKET_PRICE; ?>" id="<?php echo RSVP_PRO_OPTION_TICKET_PRICE; ?>" value="<?php echo esc_attr( $event_options->get_ticket_price() ); ?>" />
				<br />
				<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_ticket_price_description' ); ?></span>
			</td>
		</tr>
		<tr class="subEventHide">
			<th scope="row">
				<label for="<?php echo RSVP_PRO_OPTION_CURRENCY; ?>"><?php echo rsvp_pro_get_admin_string( 'settings_currency_label' ); ?></label>
			</th>
			<td>
				<select name="<?php echo RSVP_PRO_OPTION_CURRENCY; ?>" id="<?php echo RSVP_PRO_OPTION_CURRENCY; ?>" size="1">
					<option value="">--</option>
					<?php
					foreach ( rsvp_pro_get_currencies() as $currency ) {
						?>
						<option value="<?php echo esc_attr( $currency['code'] ); ?>" <?php echo ( $event_options->get_currency() === $currency['code'] ) ? 'selected="selected"' : ''; ?>><?php echo esc_html( $currency['name'] ); ?></option>
						<?php
					}
					?>
				</select>
				<br />
				<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_currency_description' ); ?></span>
			</td>
		</tr>
		<tr class="subEventHide">
			<th scope="row">
				<label for="<?php echo RSVP_PRO_OPTION_CURRENCY_POSITION; ?>"><?php echo rsvp_pro_get_admin_string( 'settings_currency_position_label' ); ?></label>
			</th>
			<td>
				<select name="<?php echo RSVP_PRO_OPTION_CURRENCY_POSITION; ?>" id="<?php echo RSVP_PRO_OPTION_CURRENCY_POSITION; ?>" size="1">
					<option value="after" <?php echo ( $event_options->get_currency_position() === 'after' ) ? 'selected="selected"' : ''; ?>><?php echo rsvp_pro_get_admin_string( 'settings_currency_position_after' ); ?></option>
					<option value="before" <?php echo ( $event_options->get_currency_position() === 'before' ) ? 'selected="selected"' : ''; ?>><?php echo rsvp_pro_get_admin_string( 'settings_currency_position_before' ); ?></option>
				</select>
				<br />
				<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_currency_position_description' ); ?></span>
			</td>
		</tr>
		<tr class="subEventHide">
			<th scope="row">
				<label for="<?php echo RSVP_PRO_OPTION_THOUSANDS_SEPARATOR; ?>"><?php echo rsvp_pro_get_admin_string( 'settings_thousands_separator_label' ); ?></label>
			</th>
			<td>
				<input type="text" name="<?php echo RSVP_PRO_OPTION_THOUSANDS_SEPARATOR; ?>" id="<?php echo RSVP_PRO_OPTION_THOUSANDS_SEPARATOR; ?>" value="<?php echo esc_attr( $event_options->get_thousands_separator() ); ?>" maxlength="1" />
				<br />
				<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_thousands_separator_description' ); ?></span>
			</td>
		</tr>
		<tr class="subEventHide">
			<th scope="row">
				<label for="<?php echo RSVP_PRO_OPTION_DECIMAL_SEPARATOR; ?>"><?php echo rsvp_pro_get_admin_string( 'settings_decimal_separator_label' ); ?></label>
			</th>
			<td>
				<input type="text" name="<?php echo RSVP_PRO_OPTION_DECIMAL_SEPARATOR; ?>" id="<?php echo RSVP_PRO_OPTION_DECIMAL_SEPARATOR; ?>" value="<?php echo esc_attr( $event_options->get_decimal_separator() ); ?>" maxlength="1" />
				<br />
				<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_decimal_separator_description' ); ?></span>
			</td>
		</tr>
		<tr class="subEventHide">
			<th scope="row">
				<label for="<?php echo RSVP_PRO_OPTION_PAYMENT_MESSAGE; ?>"><?php echo rsvp_pro_get_admin_string( 'settings_payment_message_label' ); ?></label>
			</th>
			<td>
				<input type="text" name="<?php echo RSVP_PRO_OPTION_PAYMENT_MESSAGE; ?>" id="<?php echo RSVP_PRO_OPTION_PAYMENT_MESSAGE; ?>" class="regular-text" value="<?php echo esc_attr( $event_options->get_payment_message() ); ?>" />
				<br />
				<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_payment_message_description' ); ?></span>
			</td>
		</tr>
		<tr class="subEventHide">
			<th scope="row">
				<label for="<?php echo RSVP_PRO_OPTION_PAYMENT_DESCRIPTION; ?>"><?php echo rsvp_pro_get_admin_string( 'settings_payment_description_label' ); ?></label>
			</th>
			<td>
				<input type="text" name="<?php echo RSVP_PRO_OPTION_PAYMENT_DESCRIPTION; ?>" id="<?php echo RSVP_PRO_OPTION_PAYMENT_DESCRIPTION; ?>" class="regular-text" value="<?php echo esc_attr( $event_options->get_payment_description() ); ?>" />
				<br />
				<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_payment_description' ); ?></span>
			</td>
		</tr>
		<tr class="subEventHide">
			<th scope="row">
				<label for="<?php echo RSVP_PRO_OPTION_PAYMENT_SUCCESS_URL; ?>"><?php echo rsvp_pro_get_admin_string( 'settings_payment_success_url_label' ); ?></label>
			</th>
			<td>
				<input type="text" name="<?php echo RSVP_PRO_OPTION_PAYMENT_SUCCESS_URL; ?>" id="<?php echo RSVP_PRO_OPTION_PAYMENT_SUCCESS_URL; ?>" class="regular-text" value="<?php echo esc_attr( $event_options->get_payment_success_url() ); ?>" />
				<br />
				<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_payment_success_url_description' ); ?></span>
			</td>
		</tr>
		<tr class="subEventHide">
			<th scope="row">
				<label for="<?php echo RSVP_PRO_OPTION_PAYMENT_FAILURE_URL; ?>"><?php echo rsvp_pro_get_admin_string( 'settings_payment_failure_url_label' ); ?></label>
			</th>
			<td>
				<input type="text" name="<?php echo RSVP_PRO_OPTION_PAYMENT_FAILURE_URL; ?>" id="<?php echo RSVP_PRO_OPTION_PAYMENT_FAILURE_URL; ?>" class="regular-text" value="<?php echo esc_attr( $event_options->get_payment_failure_url() ); ?>" />
				<br />
				<span class="description"><?php echo rsvp_pro_get_admin_string( 'settings_payment_failure_url_description' ); ?></span>
			</td>
		</tr>
			<?php
			$parameters = array(
				'event_id'      => $eventID,
				'event_options' => $event_options,
			);
			do_action( 'rsvp_pro_event_payment_settings_tab', $parameters );
			?>
	</tbody>
</table>
