<?php
/**
 * Admin List Table
 *
 * @version 0.2.1
 */

class RSVP_PRO_Questions_List_Table extends RSVP_PRO_List_Table {

	/**
	 * Message to be displayed when there are no items
	 *
	 * @since  4.4.8
	 * @access public
	 */
	public function no_items(){
		_e( 'No questions found.', 'rsvp-pro-plugin' );
	}

	/**
	 * Prepare our data
	 *
	 * @param array $data
	 *
	 * @since4.4.8
	 */
	public function prepare_items( $data = array() ){

		$columns  = $this->get_columns();
		$hidden   = $this->get_hidden_columns();
		$sortable = $this->get_sortable_columns();

		$this->_column_headers = array( $columns, $hidden, $sortable );

		// Sort the list
		if ( isset( $_GET['orderby'] ) ){
			usort( $data, array( &$this, 'usort_reorder' ) );
		}

		$this->items = $data;
	}

	/**
	 * Question columns
	 *
	 * @return array
	 * @Since4.4.8
	 */
	public function get_columns(){
		$columns = array(
				'cb'       => __( 'ID', 'rsvp-pro-plugin' ),
				'question' => __( 'Question', 'rsvp-pro-plugin' ),
		);

		return $columns;
	}

	public function get_hidden_columns(){
		return array();
	}

	/**
	 * Sortable columns
	 *
	 * @return array[]
	 * @since4.4.8
	 */
	public function get_sortable_columns(){
		return array(
				'question' => array( 'id', false ),
		);
	}

	/**
	 * Sor our questions
	 *
	 * @param $a
	 * @param $b
	 *
	 * @return int|lt
	 * @since4.4.8
	 */
	public function usort_reorder( $a, $b ){

		// If no order, default to asc
		$order = ( !empty( $_GET['order'] ) ) ? $_GET['order'] : 'asc';

		$result = strcasecmp( $a['question'], $b['question'] );

		// Send final sort direction to usort
		return ( $order === 'asc' ) ? $result : -$result;
	}


	/**
	 * Question column
	 *
	 * @param $item
	 *
	 * @since4.4.8
	 */
	public function column_question( $item ){

		// Edit link
		$edit_link = add_query_arg( array(
				'page'    => 'rsvp-pro-top-level',
				'action'  => 'modify_custom_question',
				'id'      => $item['id'],
				'eventID' => $item['eventID']
		), admin_url( 'admin.php' ) );

		// Delete link
		$delete_link = add_query_arg( array(
				'action'  => 'delete-rsvp-pro-question',
				'id'      => absint( $item['id'] ),
				'eventID' => $item['eventID']
		), admin_url( 'admin.php' ) );

		echo '<a class="row-title" href="' . $edit_link . '">' . esc_html( $item['question'] ) . '</a>';

		// Assemble links

		$actions           = array();
		$actions['edit']   = '<a href="' . $edit_link . '">' . __( 'Edit', 'rsvp-pro-plugin' ) . '</a>';
		$actions['delete'] = "<a class='submitdelete' href='" . wp_nonce_url( $delete_link, 'delete-rsvp-pro-question_' . absint( $item['id'] ) ) . "' onclick=\"if ( confirm( '" . esc_js( sprintf( __( 'Delete "%s"?', 'rsvp-pro-plugin' ), esc_html( $item['question'] ) ) ) . "' ) ) { return true;} return false;\">" . __( 'Delete', 'rsvp-pro-plugin' ) . '</a>';

		$actions = apply_filters( 'rsvp_questions_actions', $actions, $item );

		echo $this->row_actions( $actions );
	}

	/**
	 * Default column
	 *
	 * @param $item
	 * @param $column_name
	 *
	 * @return mixed|void
	 * @since4.4.8
	 */
	public function column_default( $item, $column_name ){

		switch ( $column_name ){
			case 'question':
				$text = $item[ $column_name ];
				break;
			case 'private_import_key':
				$text = $item[ $column_name ];
				break;
			default:
				$text = $item[ $column_name ];
		}

		return apply_filters( "rsvp_question_list_column_$column_name", $text, $item );
	}

	/**
	 * Display the table
	 *
	 * @since  4.4.8
	 * @access public
	 */
	public function display(){
		$singular = $this->_args['singular'];
		// Disabling the table nav options to regain some real estate.
		//$this->display_tablenav( 'top' );
		?>
		<form id="posts-filter" method="get">

			<table class="wp-list-table <?php echo implode( ' ', $this->get_table_classes() ); ?>">
				<thead>
				<tr>
					<?php $this->print_column_headers(); ?>
				</tr>
				</thead>

				<tbody id="the-list"<?php
				if ( $singular ){
					echo " data-wp-lists='list:$singular'";
				} ?> class="event-questions">
				<?php $this->display_rows_or_placeholder(); ?>
				</tbody>

				<tfoot>
				<tr>
					<?php $this->print_column_headers( false ); ?>
				</tr>
				</tfoot>

			</table>
			<?php
			$this->display_tablenav( 'bottom' );
			?>
		</form>
		<?php
	}

	/**
	 * Prepare our questions for display
	 *
	 * @param $questions
	 *
	 * @return mixed
	 * @since4.4.8
	 */
	function prepare_questions( $questions ){

		$return = array();

		foreach ( $questions as $view ){

			$return[ $view->id ] = array(
					'id'       => $view->id,
					'question' => $view->question,
					'eventID'  => $view->rsvpEventID
			);
		}

		return $return;
	}

	/**
	 * Handles the checkbox column output.
	 *
	 * @param $item
	 *
	 * @since4.4.8
	 */
	public function column_cb( $item ){
		?>
		<input id="cb-select-<?php echo absint( $item['id'] ); ?>" type="checkbox" name="q[]"
			   value="<?php echo absint( $item['id'] ); ?>"/>
		<div class="locked-indicator">
			<span class="locked-indicator-icon" aria-hidden="true"></span>
		</div>
		<?php

	}
}
