<?php
/**
 * @package rsvp-pro
 * @subpackage includes/admin
 * @author WPChill
 * @since 2.2.4
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) :
	exit;
endif;

/**
 * Class for interfacing with a specific reminder
 *
 * @since 2.2.4
 */
class Rsvp_Pro_Event_Reminder_Dao {

	private $ID;

	private $rsvpEventID;

	private $name;

	private $timeType;

	private $sendOn;

	private $period;

	private $rsvpStatuses;

	private $messageBody;

	private $messageSubject;

	public function __construct( $reminderId = 0 ) {
		if ( $reminderId > 0 ) {
			$this->load_data( $reminderId );
		}
	}

	public function load_data( $reminderID ) {
		global $wpdb;

		$sql = 'SELECT id, rsvpEventID, name, timeType, sendOn,
		period, rsvpStatuses, messageBody, messageSubject
		FROM ' . PRO_EVENT_REMINDERS_TABLE . ' WHERE id = %d';

		$reminder = $wpdb->get_row( $wpdb->prepare( $sql, $reminderID ) );

		if ( $reminder ) {
			$this->ID = $reminder->id;
			$this->set_RsvpEventID( $reminder->rsvpEventID );
			$this->set_Name( stripslashes( $reminder->name ) );
			$this->set_TimeType( $reminder->timeType );
			$this->set_SendOn( $reminder->sendOn );
			$this->set_Period( $reminder->period );
			$this->set_RsvpStatuses( $reminder->rsvpStatuses );
			$this->set_MessageBody( stripslashes( $reminder->messageBody ) );
			$this->set_MessageSubject( stripslashes( $reminder->messageSubject ) );
		}
	}

	public function save() {
		global $wpdb;

		if ( $this->ID > 0 ) {
			$wpdb->update(
				PRO_EVENT_REMINDERS_TABLE,
				array(
					'rsvpEventID'    => $this->get_RsvpEventID(),
					'name'           => $this->get_Name(),
					'timeType'       => $this->get_TimeType(),
					'period'         => $this->get_Period(),
					'rsvpStatuses'   => $this->get_RsvpStatuses(),
					'messageBody'    => $this->get_MessageBody(),
					'messageSubject' => $this->get_MessageSubject(),
					'sendOn'         => ( $this->get_SendOn() === '' ) ? null : date( 'Y-m-d', strtotime( $this->get_SendOn() ) ),
				),
				array( 'id' => $this->ID ),
				array( '%d', '%s', '%s', '%s', '%s', '%s', '%s', '%s' ),
				array( '%d' )
			);
		} else {
			$wpdb->insert(
				PRO_EVENT_REMINDERS_TABLE,
				array(
					'rsvpEventID'    => $this->get_RsvpEventID(),
					'name'           => $this->get_Name(),
					'timeType'       => $this->get_TimeType(),
					'period'         => $this->get_Period(),
					'rsvpStatuses'   => $this->get_RsvpStatuses(),
					'messageBody'    => $this->get_MessageBody(),
					'messageSubject' => $this->get_MessageSubject(),
					'sendOn'         => ( $this->get_SendOn() === '' ) ? null : date( 'Y-m-d', strtotime( $this->get_SendOn() ) ),
				),
				array( '%d', '%s', '%s', '%s', '%s', '%s', '%s', '%s' )
			);
		}
	}

	public function delete() {
		global $wpdb;

		if ( $this->ID > 0 ) {
			$wpdb->delete(
				PRO_EVENT_REMINDERS_TABLE,
				array( 'id' => $this->ID ),
				array( '%d' )
			);
		}
	}

	// Just boring getters and setters below...
	public function get_ID() {
		return $this->ID;
	}

	public function get_RsvpEventID() {
		return $this->rsvpEventID;
	}

	public function set_RsvpEventID( $rsvpEventID ) {
		if ( is_numeric( $rsvpEventID ) && ( $rsvpEventID > 0 ) ) {
			$this->rsvpEventID = $rsvpEventID;
		}
	}

	public function get_Name() {
		return $this->name;
	}

	public function set_Name( $name ) {
		$this->name = $name;
	}

	public function get_TimeType() {
		return $this->timeType;
	}

	public function set_TimeType( $tt ) {
		$tt             = strToLower( $tt );
		$allowed_values = array( 'day', 'week', 'month', 'static' );

		if ( in_array( $tt, $allowed_values ) ) {
			$this->timeType = $tt;
		}
	}

	public function get_SendOn() {
		if ( $this->sendOn != '' ) {
			return wp_date( get_option( 'date_format' ), strtotime( $this->sendOn ) );
		}

		return '';
	}

	public function set_SendOn( $sendOn ) {
		if ( ( strtotime( $sendOn ) !== false ) && ( $sendOn !== '1/1/1970' ) ) {
			$this->sendOn = date( 'Y-m-d', strtotime( $sendOn ) );
		} else {
			$this->sendOn = '';
		}
	}

	public function get_Period() {
		return $this->period;
	}

	public function set_Period( $period ) {
		if ( is_numeric( $period ) ) {
			$this->period = $period;
		} else {
			$this->period = null;
		}
	}

	public function get_RsvpStatuses() {
		return $this->rsvpStatuses;
	}

	public function set_RsvpStatuses( $statuses ) {
		$tmp         = explode( ',', $statuses );
		$newStatuses = array();
		foreach ( $tmp as $t ) {
			if ( rsvp_pro_is_allowed_status( $t ) ) {
				$newStatuses[] = $t;
			}
		}

		$this->rsvpStatuses = implode( ',', $newStatuses );
	}

	public function get_MessageBody() {
		return $this->messageBody;
	}

	public function set_MessageBody( $body ) {
		$this->messageBody = $body;
	}

	public function get_MessageSubject() {
		return $this->messageSubject;
	}

	public function set_MessageSubject( $subject ) {
		return $this->messageSubject = $subject;
	}
}
