<?php
/**
 * This is used for handling the sending of attendee list cron jobs
 *
 * @package rsvp-pro-plugin
 */


/**
 * Sends the attendee list notifications for all events that need to have
 * one sent.
 *
 * @since 2.3.5
 */
function rsvp_pro_cron_attendee_list_notifications() {
	global $wpdb;

	$sql    = 'SELECT id, close_date FROM ' . PRO_EVENT_TABLE .
	" WHERE ((parentEventID = 0) OR (parentEventID IS NULL )) AND send_attendee_list = 'Y' AND attendee_list_sent_on IS NULL";
	$events = $wpdb->get_results( $sql );
	foreach ( $events as $e ) {
		if ( rsvp_pro_is_event_closed( $e->id ) ) {
			rsvp_pro_send_attendee_list_notifications( $e->id );
		}
	}
}
