<?php
/**
 * Returns all of the strings that exist for the admin interface.
 *
 * @return array An array of all strings for the admin interface.
 */
function rsvp_pro_get_admin_strings() {
	$admin_strings = array(
		'invalid_license'                                  => array(
			'name' => esc_html__('Invalid license message','rsvp-pro-plugin'),
			'text' => __( 'License is invalid, please activate your license in <a href="%s">RSVP Pro -> License</a>', 'rsvp-pro-plugin' ),
		),
		'event_deleted'                                    => array(
			'name' => esc_html__('Event deleted message','rsvp-pro-plugin'),
			'text' => __( 'Event deleted', 'rsvp-pro-plugin' ),
		),
		'delete_question'                                  => array(
			'name' => esc_html__('Event delete confirmation','rsvp-pro-plugin'),
			'text' => __( 'Are you sure you want to delete ', 'rsvp-pro-plugin' ),
		),
		'list_events'                                      => array(
			'name' => esc_html__('List of Events','rsvp-pro-plugin'),
			'text' => __( 'List of Events', 'rsvp-pro-plugin' ),
		),
		'change_log_admin_title'                           => array(
			'name' => esc_html__('Attendee change log title','rsvp-pro-plugin'),
			'text' => __( 'Attendee Change Log', 'rsvp-pro-plugin' ),
		),
		'add_events'                                       => array(
			'name' => esc_html__('Add Events Button','rsvp-pro-plugin'),
			'text' => __( 'Add Event', 'rsvp-pro-plugin' ),
		),
		'no_events_message'                                => array(
			'name' => esc_html__('No Events Message','rsvp-pro-plugin'),
			'text' => __( 'No events have been created yet.', 'rsvp-pro-plugin' ),
		),
		'create_event_message'                             => array(
			'name' => esc_html__('Create One Message','rsvp-pro-plugin'),
			'text' => __( 'Create one now', 'rsvp-pro-plugin' ),
		),
		'event_id_label'                                   => array(
			'name' => esc_html__('Event ID Label','rsvp-pro-plugin'),
			'text' => __( 'Event ID', 'rsvp-pro-plugin' ),
		),
		'short_code_label'                                 => array(
			'name' => esc_html__('Short Code Label','rsvp-pro-plugin'),
			'text' => __( 'Short Code', 'rsvp-pro-plugin' ),
		),
		'attendees_label'                                  => array(
			'name' => esc_html__('Attendees Label','rsvp-pro-plugin'),
			'text' => __( 'Attendees', 'rsvp-pro-plugin' ),
		),
		'settings_label'                                   => array(
			'name' => esc_html__('Settings Label','rsvp-pro-plugin'),
			'text' => __( 'Settings', 'rsvp-pro-plugin' ),
		),
		'delete_label'                                     => array(
			'name' => esc_html__('Delete Label','rsvp-pro-plugin'),
			'text' => __( 'Delete', 'rsvp-pro-plugin' ),
		),
		'export_attendees_label'                           => array(
			'name' => esc_html__('Export Attendees Label','rsvp-pro-plugin'),
			'text' => __( 'Export Attendees', 'rsvp-pro-plugin' ),
		),
		'export_change_log_label'                          => array(
			'name' => esc_html__('Export Change Log Label','rsvp-pro-plugin'),
			'text' => __( 'Export Change Log', 'rsvp-pro-plugin' ),
		),
		'export_attendees_w_subevent_label'                => array(
			'name' => esc_html__('Export Attendess w/Sub-Event Label','rsvp-pro-plugin'),
			'text' => __( 'Export Attendees w/Sub-Event Information', 'rsvp-pro-plugin' ),
		),
		'import_attendees_label'                           => array(
			'name' => esc_html__('Import Attendess Label','rsvp-pro-plugin'),
			'text' => __( 'Import Attendees', 'rsvp-pro-plugin' ),
		),
		'add_attendees_button'                             => array(
			'name' => esc_html__('Add Attendees Button','rsvp-pro-plugin'),
			'text' => __( 'Add Attendee', 'rsvp-pro-plugin' ),
		),
		'custom_questions_label'                           => array(
			'name' => esc_html__('Custom Questions Label','rsvp-pro-plugin'),
			'text' => __( 'Custom Questions', 'rsvp-pro-plugin' ),
		),
		'copy_event_label'                                 => array(
			'name' => esc_html__('clone Event Label','rsvp-pro-plugin'),
			'text' => __( 'Clone Event', 'rsvp-pro-plugin' ),
		),
		'import_from_free_label'                           => array(
			'name' => esc_html__('Import from RSVP Free Label','rsvp-pro-plugin'),
			'text' => __( 'Import attendees and custom questions from Free RSVP', 'rsvp-pro-plugin' ),
		),
		'send_message_label'                               => array(
			'name' => esc_html__('Send Message Label','rsvp-pro-plugin'),
			'text' => __( 'Send Message', 'rsvp-pro-plugin' ),
		),
		'all_attendees_label'                              => array(
			'name' => esc_html__('All Attendees Label','rsvp-pro-plugin'),
			'text' => __( 'All Attendees', 'rsvp-pro-plugin' ),
		),
		'reminders_label'                                  => array(
			'name' => esc_html__('Reminders Label','rsvp-pro-plugin'),
			'text' => __( 'Reminders', 'rsvp-pro-plugin' ),
		),
		'reset_all_label'                                  => array(
			'name' => esc_html__('Reset All Attendees Label','rsvp-pro-plugin'),
			'text' => __( 'Reset All Attendees', 'rsvp-pro-plugin' ),
		),
		'change_log_label'                                 => array(
			'name' => esc_html__('Change Log Label','rsvp-pro-plugin'),
			'text' => __( 'Attendee Change Log', 'rsvp-pro-plugin' ),
		),
		'manage_attendees_label'                           => array(
			'name' => esc_html__('Manage Attendees Label','rsvp-pro-plugin'),
			'text' => __( 'Manage Attendees', 'rsvp-pro-plugin' ),
		),
		'sub_events_label'                                 => array(
			'name' => esc_html__('Sub-Events Label','rsvp-pro-plugin'),
			'text' => __( 'Sub-Events for <strong>%s</strong>', 'rsvp-pro-plugin' ),
		),
		'note_label'                                       => array(
			'name' => esc_html__('Note Label','rsvp-pro-plugin'),
			'text' => __( 'Note', 'rsvp-pro-plugin' ),
		),
		'nicknames_label'                                  => array(
			'name' => esc_html__('Nicknames Label','rsvp-pro-plugin'),
			'text' => __( 'Nicknames', 'rsvp-pro-plugin' ),
		),
		'list_attendees_label'                             => array(
			'name' => esc_html__('List of Attendees Label','rsvp-pro-plugin'),
			'text' => __( 'List of current attendees', 'rsvp-pro-plugin' ),
		),
		'attendee_count_label'                             => array(
			'name' => esc_html__('Attendee Count Label','rsvp-pro-plugin'),
			'text' => __( 'Attendee Count', 'rsvp-pro-plugin' ),
		),
		'and'                                              => array(
			'name' => esc_html__('And Label','rsvp-pro-plugin'),
			'text' => __( 'and', 'rsvp-pro-plugin' ),
		),
		'field_to_search_label'                            => array(
			'name' => esc_html__('Field to Search Label','rsvp-pro-plugin'),
			'text' => __( 'Field to search', 'rsvp-pro-plugin' ),
		),
		'results_page_label'                               => array(
			'name' => esc_html__('Results Per Page Label','rsvp-pro-plugin'),
			'text' => __( 'Results per page', 'rsvp-pro-plugin' ),
		),
		'result_25'                                        => array(
			'name' => esc_html__('25 Results Per Page','rsvp-pro-plugin'),
			'text' => __( '25', 'rsvp-pro-plugin' ),
		),
		'result_50'                                        => array(
			'name' => esc_html__('50 Results Per Page','rsvp-pro-plugin'),
			'text' => __( '50', 'rsvp-pro-plugin' ),
		),
		'result_100'                                       => array(
			'name' => esc_html__('100 Results Per Page','rsvp-pro-plugin'),
			'text' => __( '100', 'rsvp-pro-plugin' ),
		),
		'result_all'                                       => array(
			'name' => esc_html__('All Results','rsvp-pro-plugin'),
			'text' => __( 'All', 'rsvp-pro-plugin' ),
		),
		'bulk_actions_label'                               => array(
			'name' => esc_html__('Bulk Actions Label','rsvp-pro-plugin'),
			'text' => __( 'Bulk Actions', 'rsvp-pro-plugin' ),
		),
		'apply_label'                                      => array(
			'name' => esc_html__('Apply Label','rsvp-pro-plugin'),
			'text' => __( 'Apply', 'rsvp-pro-plugin' ),
		),
		'event_list_label'                                 => array(
			'name' => esc_html__('Event List Label','rsvp-pro-plugin'),
			'text' => __( 'Event List', 'rsvp-pro-plugin' ),
		),
		'attendee_event_list_label'                        => array(
			'name' => esc_html__('Attendee Event List Label','rsvp-pro-plugin'),
			'text' => __( 'Attendee Event List', 'rsvp-pro-plugin' ),
		),
		'rsvp_date_label'                                  => array(
			'name' => esc_html__('RSVP Date Label','rsvp-pro-plugin'),
			'text' => __( 'RSVP Date', 'rsvp-pro-plugin' ),
		),
		'attendee_label'                                   => array(
			'name' => esc_html__('Attendee Label','rsvp-pro-plugin'),
			'text' => __( 'Attendee', 'rsvp-pro-plugin' ),
		),
		'changes_header_label'                             => array(
			'name' => esc_html__('Changes header label','rsvp-pro-plugin'),
			'text' => __( 'Changes', 'rsvp-pro-plugin' ),
		),
		'change_date_header_label'                         => array(
			'name' => esc_html__('Change date header label','rsvp-pro-plugin'),
			'text' => __( 'Change Date', 'rsvp-pro-plugin' ),
		),
		'checked_in_label'                                 => array(
			'name' => esc_html__('Checked-In Label','rsvp-pro-plugin'),
			'text' => __( 'Checked In', 'rsvp-pro-plugin' ),
		),
		'additional_attendee_label'                        => array(
			'name' => esc_html__('Additional Attendee Label','rsvp-pro-plugin'),
			'text' => __( 'Additional Attendee', 'rsvp-pro-plugin' ),
		),
		'total_imported_label'                             => array(
			'name' => esc_html__('Total Records Imported Label','rsvp-pro-plugin'),
			'text' => __( 'total records were imported', 'rsvp-pro-plugin' ),
		),
		'continue_to_rsvp_label'                           => array(
			'name' => esc_html__('Continue to RSVP label','rsvp-pro-plugin'),
			'text' => __( 'Continue to the RSVP', 'rsvp-pro-plugin' ),
		),
		'list_label'                                       => array(
			'name' => esc_html__('List Label','rsvp-pro-plugin'),
			'text' => __( 'list', 'rsvp-pro-plugin' ),
		),
		'attendee_import_excel_message'                    => array(
			'name' => esc_html__('Attendee Import File Message','rsvp-pro-plugin'),
			'text' => __(
				'<p>This area allows you to import attendees in for your event. There are two steps with this process. Below you select the file you want to import and choose if you want to delete attendees associated with the event (this will happen on the final step and not when you click next).</p>
			 	<p>Any CSV or Excel file can be used to import attendees. The file must meet the following requirements:</p>
			 	<ol>
			 		<li>A first OR last name column</li>
			 		<li>The first row must be a header row with column names</li>
			 	</ol>
				<p>In the second step you specify which columns go to which attendee fields.</p>',
				'rsvp-pro-plugin'
			),
		),
		'attendee_import_title_step_1'                     => array(
			'name' => esc_html__('Attendee Import Step 1 Title','rsvp-pro-plugin'),
			'text' => __( 'Import (Step 1 of 2)', 'rsvp-pro-plugin' ),
		),
		'attendee_import_title_step_2'                     => array(
			'name' => esc_html__('Attendee Import Step 2 Title','rsvp-pro-plugin'),
			'text' => __( 'Import (Step 2 of 2)', 'rsvp-pro-plugin' ),
		),
		'attendee_import_column_selection_message'         => array(
			'name' => esc_html__('Attendee Import Column Selection Description','rsvp-pro-plugin'),
			'text' => __(
				'<p>We are almost there! This is the final step where you specify which column in your file goes to what attendee field.</p>

				<p>Once you specify the columns just hit &quot;Import Attendees&quot; and your attendees will be loaded for your event.</p>

				<p>Only the first OR last name needs to be selected for the import process to work.</p>',
				'rsvp-pro-plugin'
			),
		),
		'custom_message_label'                             => array(
			'name' => esc_html__('Custom Message Label','rsvp-pro-plugin'),
			'text' => __( 'Custom Message', 'rsvp-pro-plugin' ),
		),
		'number_guests_allowed_label'                      => array(
			'name' => esc_html__('Number of Guests Allowed Label','rsvp-pro-plugin'),
			'text' => __( 'Number of guests allowed for attendee', 'rsvp-pro-plugin' ),
		),
		'primary_attendee_label'                           => array(
			'name' => esc_html__('Primary Attendee Label','rsvp-pro-plugin'),
			'text' => __( 'Primary Attendee', 'rsvp-pro-plugin' ),
		),
		'group_id_label'                                   => array(
			'name' => esc_html__('Group ID Label','rsvp-pro-plugin'),
			'text' => __( 'GroupID', 'rsvp-pro-plugin' ),
		),
		'private_question_association_label'               => array(
			'name' => esc_html__('Select People Custom Question Association Label','rsvp-pro-plugin'),
			'text' => __( '&quot;Select People&quot; Custom Question Association', 'rsvp-pro-plugin' ),
		),
		'custom_question_value_label'                      => array(
			'name' => esc_html__('Custom Question Value Label','rsvp-pro-plugin'),
			'text' => __( 'Custom Question Values', 'rsvp-pro-plugin' ),
		),
		'sub_event_association_label'                      => array(
			'name' => esc_html__('Sub-Event Association Label','rsvp-pro-plugin'),
			'text' => __( 'Sub-Event Association', 'rsvp-pro-plugin' ),
		),
		'delete_attendees_import_label'                    => array(
			'name' => esc_html__('Delete Attendees on Import Label','rsvp-pro-plugin'),
			'text' => __( 'Delete existing attendees on import', 'rsvp-pro-plugin' ),
		),
		'emailed_label'                                    => array(
			'name' => esc_html__('Emailed Label','rsvp-pro-plugin'),
			'text' => __( 'emailed', 'rsvp-pro-plugin' ),
		),
		'send_message_for_label'                           => array(
			'name' => esc_html__('Send A Message For Event Label','rsvp-pro-plugin'),
			'text' => __( 'Send a message for', 'rsvp-pro-plugin' ),
		),
		'attendees_being_emailed_label'                    => array(
			'name' => esc_html__('Attendees Currently Emailing Label','rsvp-pro-plugin'),
			'text' => __( 'Attendees currently emailing', 'rsvp-pro-plugin' ),
		),
		'email_not_set_label'                              => array(
			'name' => esc_html__('Email Not Set Label','rsvp-pro-plugin'),
			'text' => __( 'Email Not Set', 'rsvp-pro-plugin' ),
		),
		'from_email_label'                                 => array(
			'name' => esc_html__('From Email Address Label','rsvp-pro-plugin'),
			'text' => __( 'From Email Address', 'rsvp-pro-plugin' ),
		),
		'from_email_name_label'                            => array(
			'name' => esc_html__('From Name Label','rsvp-pro-plugin'),
			'text' => __( 'From Name', 'rsvp-pro-plugin' ),
		),
		'limit_rsvp_status_label'                          => array(
			'name' => esc_html__('Limit to RSVP Status Label','rsvp-pro-plugin'),
			'text' => __( 'Limit to RSVP Status', 'rsvp-pro-plugin' ),
		),
		'read_receipt_label'                               => array(
			'name' => esc_html__('Request Read Receipt Label','rsvp-pro-plugin'),
			'text' => __( 'Request a Read Receipt', 'rsvp-pro-plugin' ),
		),
		'from_address_required_label'                      => array(
			'name' => esc_html__('From Address Field Must be Filled Out Label','rsvp-pro-plugin'),
			'text' => __( 'The &quot;From Address&quot; field must be filled out', 'rsvp-pro-plugin' ),
		),
		'message_subject_label'                            => array(
			'name' => esc_html__('Message Subject Label','rsvp-pro-plugin'),
			'text' => __( 'Subject', 'rsvp-pro-plugin' ),
		),
		'message_email_label'                              => array(
			'name' => esc_html__('Message Label','rsvp-pro-plugin'),
			'text' => __( 'Message', 'rsvp-pro-plugin' ),
		),
		'message_attachments_label'                        => array(
			'name' => esc_html__('Attachment Label','rsvp-pro-plugin'),
			'text' => __( 'Attachments', 'rsvp-pro-plugin' ),
		),
		'available_placeholders_label'                     => array(
			'name' => esc_html__('Available Placeholders Label','rsvp-pro-plugin'),
			'text' => __( 'Available Attendee Data Placeholders For Subject &amp; Message', 'rsvp-pro-plugin' ),
		),
		'individual_tags_label'                            => array(
			'name' => esc_html__('Individual Nested Tags Label','rsvp-pro-plugin'),
			'text' => __( 'This tag needs to have an open and close tag, individual tags can be nested inside.', 'rsvp-pro-plugin' ),
		),
		'copy_text'                                        => array(
			'name' => esc_html__('Copy Text','rsvp-pro-plugin'),
			'text' => __( 'Copy', 'rsvp-pro-plugin' ),
		),
		'event_copy_to_message'                            => array(
			'name' => esc_html__('Event Copied Message','rsvp-pro-plugin'),
			'text' => __( 'Event copied to', 'rsvp-pro-plugin' ),
		),
		'copy_settings_and_questions_label'                => array(
			'name' => esc_html__('Copy All Settings and Custom Questions From Event Label','rsvp-pro-plugin'),
			'text' => __( 'Copy all settings and custom questions from ', 'rsvp-pro-plugin' ),
		),
		'to_new_event_label'                               => array(
			'name' => esc_html__('To New Event Label','rsvp-pro-plugin'),
			'text' => __( 'to a new event?', 'rsvp-pro-plugin' ),
		),
		'copy_attendees_question_label'                    => array(
			'name' => esc_html__('Copy Attendees Question Label','rsvp-pro-plugin'),
			'text' => __( 'Copy attendees as well?', 'rsvp-pro-plugin' ),
		),
		'reset_attendees_caution_label'                    => array(
			'name' => esc_html__('Reset All Attendees Question Label','rsvp-pro-plugin'),
			'text' => __( 'Are you sure you want to reset all attendees for event ', 'rsvp-pro-plugin' ),
		),
		'reset_rsvp_status_label'                          => array(
			'name' => esc_html__('Reset RSVP Responses Label','rsvp-pro-plugin'),
			'text' => __( 'This will set RSVP responses to &quot;No Response&quot; and remove all answers for custom questions.', 'rsvp-pro-plugin' ),
		),
		'reset_label'                                      => array(
			'name' => esc_html__('Reset Label','rsvp-pro-plugin'),
			'text' => __( 'Reset', 'rsvp-pro-plugin' ),
		),
		'attendee_successfully_saved_message'              => array(
			'name' => esc_html__('Attendee Successfully Saved','rsvp-pro-plugin'),
			'text' => __( 'has been successfully saved', 'rsvp-pro-plugin' ),
		),
		'continue_attendee_list_label'                     => array(
			'name' => esc_html__('Continue To Attendee List Label','rsvp-pro-plugin'),
			'text' => __( 'Continue to Attendee List', 'rsvp-pro-plugin' ),
		),
		'edit_label'                                       => array(
			'name' => esc_html__('Edit Label','rsvp-pro-plugin'),
			'text' => __( 'Edit ', 'rsvp-pro-plugin' ),
		),
		'again_label'                                      => array(
			'name' => esc_html__('Again Label','rsvp-pro-plugin'),
			'text' => __( 'again', 'rsvp-pro-plugin' ),
		),
		'back_attendee_list_label'                         => array(
			'name' => esc_html__('Back to Attendee List Label','rsvp-pro-plugin'),
			'text' => __( 'Back to attendee list', 'rsvp-pro-plugin' ),
		),
		'rsvpd_label'                                      => array(
			'name' => esc_html__('RSVP\'d On Label','rsvp-pro-plugin'),
			'text' => __( 'RSVP\'d on', 'rsvp-pro-plugin' ),
		),
		'alt_first_name_label'                             => array(
			'name' => esc_html__('Alternative First Name Label','rsvp-pro-plugin'),
			'text' => __( 'Alternative First Names', 'rsvp-pro-plugin' ),
		),
		'primary_attendee_description_message'             => array(
			'name' => esc_html__('Primary Attendee Description Message','rsvp-pro-plugin'),
			'text' => __( 'Primary attendees will be shown first when associated guests try to RSVP', 'rsvp-pro-plugin' ),
		),
		'non_associated_attendees_label'                   => array(
			'name' => esc_html__('Non-Associated Attendees Label','rsvp-pro-plugin'),
			'text' => __( 'Non-Associated Attendees', 'rsvp-pro-plugin' ),
		),
		'email_attendee_label'                             => array(
			'name' => esc_html__('Email Attendee Label','rsvp-pro-plugin'),
			'text' => __( 'Email Attendee', 'rsvp-pro-plugin' ),
		),
		'reset_attendee_label'                             => array(
			'name' => esc_html__('Reset Attendee Label','rsvp-pro-plugin'),
			'text' => __( 'Reset Attendee Information', 'rsvp-pro-plugin' ),
		),
		'save_sort_order_label'                            => array(
			'name' => esc_html__('Save Sort Order Label','rsvp-pro-plugin'),
			'text' => __( 'Save Sort Order', 'rsvp-pro-plugin' ),
		),
		'id_label'                                         => array(
			'name' => esc_html__('ID Label','rsvp-pro-plugin'),
			'text' => __( 'ID', 'rsvp-pro-plugin' ),
		),
		'question_label'                                   => array(
			'name' => esc_html__('Question Label','rsvp-pro-plugin'),
			'text' => __( 'Question', 'rsvp-pro-plugin' ),
		),
		'custom_question_saved_label'                      => array(
			'name' => esc_html__('Custom Question Saved Label','rsvp-pro-plugin'),
			'text' => __( 'Custom Question saved', 'rsvp-pro-plugin' ),
		),
		'continue_question_list_label'                     => array(
			'name' => esc_html__('Continue to Question List Label','rsvp-pro-plugin'),
			'text' => __( 'Continue to Question List', 'rsvp-pro-plugin' ),
		),
		'another_question_label'                           => array(
			'name' => esc_html__('Add Another Question Label','rsvp-pro-plugin'),
			'text' => __( 'Add another Question', 'rsvp-pro-plugin' ),
		),
		'answer_label'                                     => array(
			'name' => esc_html__('Answer Label','rsvp-pro-plugin'),
			'text' => __( 'Answer', 'rsvp-pro-plugin' ),
		),
		'default_answer_label'                             => array(
			'name' => esc_html__('Default Answer Label','rsvp-pro-plugin'),
			'text' => __( 'Default Answer', 'rsvp-pro-plugin' ),
		),
		'save_label'                                       => array(
			'name' => esc_html__('Save Label','rsvp-pro-plugin'),
			'text' => __( 'Save', 'rsvp-pro-plugin' ),
		),
		'back_custom_question_label'                       => array(
			'name' => esc_html__('Back to Custom Question List','rsvp-pro-plugin'),
			'text' => __( 'Back to custom question list', 'rsvp-pro-plugin' ),
		),
		'question_grouping_label'                          => array(
			'name' => esc_html__('Question Grouping Label','rsvp-pro-plugin'),
			'text' => __( 'Question Grouping', 'rsvp-pro-plugin' ),
		),
		'question_asked_everyone_label'                    => array(
			'name' => esc_html__('Question Asked to Everyone Label','rsvp-pro-plugin'),
			'text' => __( 'Question asked to everyone', 'rsvp-pro-plugin' ),
		),
		'question_asked_per_associated_label'              => array(
			'name' => esc_html__('Question Asked Once Per Associated Attendee Label','rsvp-pro-plugin'),
			'text' => __( 'Question asked once per associated attendees', 'rsvp-pro-plugin' ),
		),
		'question_type_label'                              => array(
			'name' => esc_html__('Question Type Label','rsvp-pro-plugin'),
			'text' => __( 'Question Type', 'rsvp-pro-plugin' ),
		),
		'is_required_label'                                => array(
			'name' => esc_html__('Is Required? Label','rsvp-pro-plugin'),
			'text' => __( 'Is Required?', 'rsvp-pro-plugin' ),
		),
		'required_text_label'                              => array(
			'name' => esc_html__('Required Message Label','rsvp-pro-plugin'),
			'text' => __( 'Required Message', 'rsvp-pro-plugin' ),
		),
		'only_ask_associated_new_label'                    => array(
			'name' => esc_html__('Only Ask Question to Associated and New Attendees','rsvp-pro-plugin'),
			'text' => __( 'Only ask question to associated and new guests?', 'rsvp-pro-plugin' ),
		),
		'question_permission_label'                        => array(
			'name' => esc_html__('Question Permission Label','rsvp-pro-plugin'),
			'text' => __( 'Question Permission Level', 'rsvp-pro-plugin' ),
		),
		'everyone_label'                                   => array(
			'name' => esc_html__('Everyone Label','rsvp-pro-plugin'),
			'text' => __( 'Everyone', 'rsvp-pro-plugin' ),
		),
		'select_people_label'                              => array(
			'name' => esc_html__('Select People Label','rsvp-pro-plugin'),
			'text' => __( 'Select People', 'rsvp-pro-plugin' ),
		),
		'attendees_allowed_to_answer_label'                => array(
			'name' => esc_html__('Attendees Allowed to Answer Label','rsvp-pro-plugin'),
			'text' => __( 'Attendees allowed to answer this question', 'rsvp-pro-plugin' ),
		),
		'show_question_rsvp_status_label'                  => array(
			'name' => esc_html__('Only Show Question for RSVP Status Label','rsvp-pro-plugin'),
			'text' => __( 'Only Show Question for RSVP Status', 'rsvp-pro-plugin' ),
		),
		'answers_label'                                    => array(
			'name' => esc_html__('Answers Label','rsvp-pro-plugin'),
			'text' => __( 'Answers', 'rsvp-pro-plugin' ),
		),
		'add_answer_label'                                 => array(
			'name' => esc_html__('Add New Answer Label','rsvp-pro-plugin'),
			'text' => __( 'Add new Answer', 'rsvp-pro-plugin' ),
		),
		'import_complete_label'                            => array(
			'name' => esc_html__('Import Complete Label','rsvp-pro-plugin'),
			'text' => __( 'Import complete', 'rsvp-pro-plugin' ),
		),
		'import_label'                                     => array(
			'name' => esc_html__('Import Label','rsvp-pro-plugin'),
			'text' => __( 'Import!', 'rsvp-pro-plugin' ),
		),
		'rsvp_general_settings_label'                      => array(
			'name' => esc_html__('RSVP Pro General Settings Label','rsvp-pro-plugin'),
			'text' => __( 'RSVP Pro General Settings', 'rsvp-pro-plugin' ),
		),
		'delete_data_uninstall_label'                      => array(
			'name' => esc_html__('Delete Data on Uninstall Label','rsvp-pro-plugin'),
			'text' => __( 'Delete all data on uninstall:', 'rsvp-pro-plugin' ),
		),
		'post_type_select_settings_label'                  => array(
			'name' => esc_html__('Select Post Type to Auto-Create Event Pages Label','rsvp-pro-plugin'),
			'text' => __( 'Select the post type to auto create events &quot;pages&quot; for', 'rsvp-pro-plugin' ),
		),
		'auto_create_post_type_label'                      => array(
			'name' => esc_html__('Automatically Create Post-Type Settings Label','rsvp-pro-plugin'),
			'text' => __( 'Automatically create post_type entry for main event:', 'rsvp-pro-plugin' ),
		),
		'page_found_or_not_description_label'              => array(
			'name' => esc_html__('If Page Found With Shortcode One Won\'t Be Created Label','rsvp-pro-plugin'),
			'text' => __( 'If a &quot;page&quot; is found with the rsvp short code than a &quot;page&quot; will not be created.', 'rsvp-pro-plugin' ),
		),
		'add_attendee_list_to_auto_page_label'             => array(
			'name' => esc_html__('Add Attendee List to Auto-Created Page Label','rsvp-pro-plugin'),
			'text' => __( 'Add attendee list shortcode to automatically created page:', 'rsvp-pro-plugin' ),
		),
		'attendee_list_auto_page_description'              => array(
			'name' => esc_html__('Add Attendee List to Auto-Created Description Label','rsvp-pro-plugin'),
			'text' => __( 'This will automatically add the public attendee list shortcode to the automatic created page.', 'rsvp-pro-plugin' ),
		),
		'custom_styling_label'                             => array(
			'name' => esc_html__('Custom Styling Label','rsvp-pro-plugin'),
			'text' => __( 'Custom Styling:', 'rsvp-pro-plugin' ),
		),
		'events_imported_label'                            => array(
			'name' => esc_html__('Events Imported Label','rsvp-pro-plugin'),
			'text' => __( 'Events imported', 'rsvp-pro-plugin' ),
		),
		'rsvp_pro_import_events_label'                     => array(
			'name' => esc_html__('RSVP Pro Import Events Label','rsvp-pro-plugin'),
			'text' => __( 'RSVP Pro Import Events', 'rsvp-pro-plugin' ),
		),
		'select_file_import_label'                         => array(
			'name' => esc_html__('Select File Import Label','rsvp-pro-plugin'),
			'text' => __( 'Select file to import', 'rsvp-pro-plugin' ),
		),
		'import_events_label'                              => array(
			'name' => esc_html__('Import Events Label','rsvp-pro-plugin'),
			'text' => __( 'Import Events', 'rsvp-pro-plugin' ),
		),
		'export_events_header'                             => array(
			'name' => esc_html__('RSVP Pro Export Events Header','rsvp-pro-plugin'),
			'text' => __( 'RSVP Pro Export Events', 'rsvp-pro-plugin' ),
		),
		'select_events_exported_label'                     => array(
			'name' => esc_html__('Select Events to be Exported Label','rsvp-pro-plugin'),
			'text' => __( 'Select the Events To Be Exported', 'rsvp-pro-plugin' ),
		),
		'export_parent_is_label'                           => array(
			'name' => esc_html__('Export Parent Event Label','rsvp-pro-plugin'),
			'text' => __( ' - Parent Event is ', 'rsvp-pro-plugin' ),
		),
		'export_information_warning_label'                 => array(
			'name' => esc_html__('Export Information Warning Label','rsvp-pro-plugin'),
			'text' => __( 'Currently only event information and <b>NOT</b> attendee information is exported', 'rsvp-pro-plugin' ),
		),
		'export_events_label'                              => array(
			'name' => esc_html__('Export Events Label','rsvp-pro-plugin'),
			'text' => __( 'Export Events', 'rsvp-pro-plugin' ),
		),
		'event_management_label'                           => array(
			'name' => esc_html__('Event Management Label','rsvp-pro-plugin'),
			'text' => __( 'Event Management', 'rsvp-pro-plugin' ),
		),
		'general_settings_label'                           => array(
			'name' => esc_html__('General Settings Label','rsvp-pro-plugin'),
			'text' => __( 'General settings', 'rsvp-pro-plugin' ),
		),
		'rsvp_pro_plugin_license_label'                    => array(
			'name' => esc_html__('RSVP Pro Plugin License Label','rsvp-pro-plugin'),
			'text' => __( 'License', 'rsvp-pro-plugin' ),
		),
		'enter_license_key_label'                          => array(
			'name' => esc_html__('Enter License Key Label','rsvp-pro-plugin'),
			'text' => __( 'Enter your license key', 'rsvp-pro-plugin' ),
		),
		'active_label'                                     => array(
			'name' => esc_html__('Active Label','rsvp-pro-plugin'),
			'text' => __( 'active', 'rsvp-pro-plugin' ),
		),
		'deactivate_license_label'                         => array(
			'name' => esc_html__('Deactivate License Label','rsvp-pro-plugin'),
			'text' => __( 'Deactivate License', 'rsvp-pro-plugin' ),
		),
		'activate_license_label'                           => array(
			'name' => esc_html__('Activate License Label','rsvp-pro-plugin'),
			'text' => __( 'Activate License', 'rsvp-pro-plugin' ),
		),
		'attendee_list_for_label'                          => array(
			'name' => esc_html__('Attendee List For Notification Subject Label','rsvp-pro-plugin'),
			'text' => __( 'Attendee list for ', 'rsvp-pro-plugin' ),
		),
		'documentation_label'                              => array(
			'name' => esc_html__('Documentation Label','rsvp-pro-plugin'),
			'text' => __( 'Documentation', 'rsvp-pro-plugin' ),
		),
		'event_added_message'                              => array(
			'name' => esc_html__('Event Added Message','rsvp-pro-plugin'),
			'text' => __( 'Event added successfully', 'rsvp-pro-plugin' ),
		),
		'event_updated_message'                            => array(
			'name' => esc_html__('Event Updated Message','rsvp-pro-plugin'),
			'text' => __( 'Event updated successfully', 'rsvp-pro-plugin' ),
		),
		'settings_general_tab_text'                        => array(
			'name' => esc_html__('Settings General Tab Label','rsvp-pro-plugin'),
			'text' => __( 'General', 'rsvp-pro-plugin' ),
		),
		'settings_frontend_tab_text'                       => array(
			'name' => esc_html__('Settings Front-End Tab Label','rsvp-pro-plugin'),
			'text' => __( 'Front-End', 'rsvp-pro-plugin' ),
		),
		'settings_frontend_text_tab_text'                  => array(
			'name' => esc_html__('Settings Front-End Text Tab Label','rsvp-pro-plugin'),
			'text' => __( 'Front-End Text', 'rsvp-pro-plugin' ),
		),
		'settings_public_attendee_tab_text'                => array(
			'name' => esc_html__('Settings Public Attendee List Label','rsvp-pro-plugin'),
			'text' => __( 'Public Attendee List', 'rsvp-pro-plugin' ),
		),
		'settings_notifications_tab_text'                  => array(
			'name' => esc_html__('Settings Notifications Tab Label','rsvp-pro-plugin'),
			'text' => __( 'Notifications', 'rsvp-pro-plugin' ),
		),
		'settings_payment_tab_text'                        => array(
			'name' => esc_html__('Settings Payment Tab Label','rsvp-pro-plugin'),
			'text' => __( 'Payments', 'rsvp-pro-plugin' ),
		),
		'settings_admin_options_tab_text'                  => array(
			'name' => esc_html__('Admin Options Tab Label','rsvp-pro-plugin'),
			'text' => __( 'Admin Area Options', 'rsvp-pro-plugin' ),
		),
		'update_event_button_label'                        => array(
			'name' => esc_html__('Update Event Button Label','rsvp-pro-plugin'),
			'text' => __( 'Update Event', 'rsvp-pro-plugin' ),
		),
		'settings_notify_when_rsvp_label'                  => array(
			'name' => esc_html__('Notify When Guest RSVPs Label','rsvp-pro-plugin'),
			'text' => __( 'Notify When Guest RSVPs:', 'rsvp-pro-plugin' ),
		),
		'settings_admin_notification_email_label'          => array(
			'name' => esc_html__('Admin Notification Email Label','rsvp-pro-plugin'),
			'text' => __( 'Admin notification email:', 'rsvp-pro-plugin' ),
		),
		'settings_email_guest_when_rsvp_label'             => array(
			'name' => esc_html__('Email Guest when RSVP is Complete Label','rsvp-pro-plugin'),
			'text' => __( 'Email guests when RSVP is completed:', 'rsvp-pro-plugin' ),
		),
		'settings_guest_eamil_text_label'                  => array(
			'name' => esc_html__('Guest Email Header Text Label','rsvp-pro-plugin'),
			'text' => __( 'Email Text: <br />Sent to guests in confirmation, at top of email', 'rsvp-pro-plugin' ),
		),
		'settings_email_from_label'                        => array(
			'name' => esc_html__('Email Address Notifications From label','rsvp-pro-plugin'),
			'text' => __( 'Email address notifications could come from?', 'rsvp-pro-plugin' ),
		),
		'settings_email_from_description'                  => array(
			'name' => esc_html__('Email Address Notification From Description','rsvp-pro-plugin'),
			'text' => __(
				'Note: depending on your web host they might block emails with this setting turned on.<br />
                   Examples of expected data: test@test.com or &quot;Test Bob&quot; &lt;test@test.com&gt;',
				'rsvp-pro-plugin'
			),
		),
		'settings_cc_associated_label'                     => array(
			'name' => esc_html__('CC Associated Label','rsvp-pro-plugin'),
			'text' => __( 'CC associated attendees', 'rsvp-pro-plugin' ),
		),
		'settings_email_associated_separately_label'       => array(
			'name' => esc_html__('Email Associated Separately Label','rsvp-pro-plugin'),
			'text' => __( 'Email associated attendees separately', 'rsvp-pro-plugin' ),
		),
		'settings_include_ics_label'                       => array(
			'name' => esc_html__('Include ICS Label','rsvp-pro-plugin'),
			'text' => __( 'Include an ICS file as an attachment', 'rsvp-pro-plugin' ),
		),
		'settings_include_ics_description'                 => array(
			'name' => esc_html__('Include ICS Description','rsvp-pro-plugin'),
			'text' => __( 'An ICS file will only be attached if the &quot;General Event Information&quot; area is filled out.', 'rsvp-pro-plugin' ),
		),
		'settings_email_to_bcc_label'                      => array(
			'name' => esc_html__('Email Address to BCC for Attendee RSVPs Label','rsvp-pro-plugin'),
			'text' => __( 'Email addresses to BCC when attendee RSVPs', 'rsvp-pro-plugin' ),
		),
		'settings_email_to_bcc_description'                => array(
			'name' => esc_html__('Email Address to BCC For Attendee RSVPs Description','rsvp-pro-plugin'),
			'text' => __( 'Separate each email address with a semicolon (;)', 'rsvp-pro-plugin' ),
		),
		'settings_email_attendee_subject_label'            => array(
			'name' => esc_html__('Email Attendee Subject Label','rsvp-pro-plugin'),
			'text' => __( 'Email subject for the attendee email', 'rsvp-pro-plugin' ),
		),
		'settings_email_attendee_subject_description'      => array(
			'name' => esc_html__('Email Attendee Subject Description','rsvp-pro-plugin'),
			'text' => __( 'Default is: &quot;RSVP Confirmation&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_email_admin_subject_label'               => array(
			'name' => esc_html__('Email Admin Subject Label','rsvp-pro-plugin'),
			'text' => __( 'Email subject for the admin notification email', 'rsvp-pro-plugin' ),
		),
		'settings_email_admin_subject_description'         => array(
			'name' => esc_html__('Email Admin Subject Description','rsvp-pro-plugin'),
			'text' => __( 'Default is: &quot;New RSVP Submission&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_available_email_fields_description'      => array(
			'name' => esc_html__('Available Email Fields Description','rsvp-pro-plugin'),
			'text' => __( 'Fields that can be used in the email body', 'rsvp-pro-plugin' ),
		),
		'settings_email_attendee_body_label'               => array(
			'name' => esc_html__('Email Attendee Body Label','rsvp-pro-plugin'),
			'text' => __( 'Email body for the attendee email:', 'rsvp-pro-plugin' ),
		),
		'settings_email_attendee_body_description'         => array(
			'name' => esc_html__('Email Attendee Body Description','rsvp-pro-plugin'),
			'text' => __( 'This will replace the email message that is sent when an attendee RSVPs.', 'rsvp-pro-plugin' ),
		),
		'settings_email_attendee_body_no_label'            => array(
			'name' => esc_html__('Email Attendee "No" Body Label','rsvp-pro-plugin'),
			'text' => __( 'Email body for attendee email when they RSVP with &quot;No&quot;:', 'rsvp-pro-plugin' ),
		),
		'settings_email_attendee_body_no_description'      => array(
			'name' => esc_html__('Email Attendee "No" Body Description','rsvp-pro-plugin'),
			'text' => __( 'This will be sent when an attendee RSVPs with a &quot;No&quot;. The same fields can be used as the email body field above.', 'rsvp-pro-plugin' ),
		),
		'settings_email_attendee_body_maybe_label'         => array(
			'name' => esc_html__('Email Attendee "Maybe" Body Label','rsvp-pro-plugin'),
			'text' => __( 'Email body for attendee email when they RSVP with &quot;Maybe&quot;:', 'rsvp-pro-plugin' ),
		),
		'settings_email_attendee_body_maybe_description'      => array(
			'name' => esc_html__('Email Attendee "Maybe" Body Description','rsvp-pro-plugin'),
			'text' => __( 'This will be sent when an attendee RSVPs with a &quot;Maybe&quot;. The same fields can be used as the email body field above.', 'rsvp-pro-plugin' ),
		),
		'settings_email_attendee_body_waitlist_label'      => array(
			'name' => esc_html__('Email Attendee "Waitlist" Body Label','rsvp-pro-plugin'),
			'text' => __( 'Email body for attendee email when they RSVP with &quot;Waitlist&quot;:', 'rsvp-pro-plugin' ),
		),
		'settings_email_attendee_body_waitlist_description' => array(
			'name' => esc_html__('Email Attendee "Waitlist" Body Description','rsvp-pro-plugin'),
			'text' => __( 'This will be sent when an attendee RSVPs with a &quot;No&quot;. The same fields can be used as the email body field above.', 'rsvp-pro-plugin' ),
		),
		'settings_send_attendee_list_label'                => array(
			'name' => esc_html__('Send Attendee List Label','rsvp-pro-plugin'),
			'text' => __( 'Send attendee list once RSVP closes', 'rsvp-pro-plugin' ),
		),
		'settings_send_attendee_list_description'          => array(
			'name' => esc_html__('Send Attendee List Description','rsvp-pro-plugin'),
			'text' => __( 'Automatically send a list of attendees that are going to the event, once the event passes the RSVP close date.', 'rsvp-pro-plugin' ),
		),
		'settings_send_attendee_list_button'               => array(
			'name' => esc_html__('Send Attendee List Button Label','rsvp-pro-plugin'),
			'text' => __( 'Manually Send Attendee List Now', 'rsvp-pro-plugin' ),
		),
		'settings_email_attendee_list_to_label'            => array(
			'name' => esc_html__('Send Attendee List Email To Label','rsvp-pro-plugin'),
			'text' => __( 'Email attendee list to', 'rsvp-pro-plugin' ),
		),
		'settings_email_attendee_list_to_description'      => array(
			'name' => esc_html__('Send Attendee List Email To Description','rsvp-pro-plugin'),
			'text' => __( 'Each address should be separated by a comma.', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_message_label'             => array(
			'name' => esc_html__('Send Attendee List Message Label','rsvp-pro-plugin'),
			'text' => __( 'Attendee list message', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_message_description'       => array(
			'name' => esc_html__('Send Attendee List Message Description','rsvp-pro-plugin'),
			'text' => __( 'The text that goes at the top of the attendee list.', 'rsvp-pro-plugin' ),
		),
		'settings_data_fields_label'                       => array(
			'name' => esc_html__('Data Fields Label','rsvp-pro-plugin'),
			'text' => __( 'Data fields that can be used below', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_format_label'              => array(
			'name' => esc_html__('Attendee List Format Label','rsvp-pro-plugin'),
			'text' => __( 'Attendee list row format', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_format_description'        => array(
			'name' => esc_html__('Attendee List Format Description','rsvp-pro-plugin'),
			'text' => __( 'Email sent to attendees when they are automatically changed from "waitlist" to "yes":', 'rsvp-pro-plugin' ),
		),
		'general_form_settings_label'                      => array(
			'name' => esc_html__('General Form Settings Label','rsvp-pro-plugin'),
			'text' => __( 'General Form Settings', 'rsvp-pro-plugin' ),
		),
		'settings_frontend_one_step_label'                 => array(
			'name' => esc_html__('Frontend Has One Step Per Event Label','rsvp-pro-plugin'),
			'text' => __( 'Frontend has one step per event:', 'rsvp-pro-plugin' ),
		),
		'settings_frontend_enable_ajax_label'              => array(
			'name' => esc_html__('Enable No Refresh Form Submit Label','rsvp-pro-plugin'),
			'text' => __( 'Enable no refresh form submit:', 'rsvp-pro-plugin' ),
		),
		'settings_frontend_enable_ajax_description'        => array(
			'name' => esc_html__('Enable No Refresh Form Submit Label','rsvp-pro-plugin'),
			'text' => __( 'This requires JavaScript to be enabled on your site.', 'rsvp-pro-plugin' ),
		),
		'settings_remove_scrolling_label'                  => array(
			'name' => esc_html__('Remove Scrolling To Top Label','rsvp-pro-plugin'),
			'text' => __( 'Disable scrolling to the RSVP form on form submission.', 'rsvp-pro-plugin' ),
		),
		'settings_disable_fuzzy_label'                     => array(
			'name' => esc_html__('Disable Fuzzy User Search Label','rsvp-pro-plugin'),
			'text' => __( 'Disable fuzzy user search:', 'rsvp-pro-plugin' ),
		),
		'settings_event_guest_capacity'                    => array(
			'name' => esc_html__('Event Guest Capacity Label','rsvp-pro-plugin'),
			'text' => __( 'Event guest capacity:', 'rsvp-pro-plugin' ),
		),
		'settings_event_guest_capacity_description'        => array(
			'name' => esc_html__('Event Guest Capacity Description','rsvp-pro-plugin'),
			'text' => __( 'By default capacity is unlimited', 'rsvp-pro-plugin' ),
		),
		'settings_waitlist_label'                          => array(
			'name' => esc_html__('Enable Waitlist Label','rsvp-pro-plugin'),
			'text' => __( 'Enable wait list:', 'rsvp-pro-plugin' ),
		),
		'settings_waitlist_description'                    => array(
			'name' => esc_html__('Enable Waitlist Description','rsvp-pro-plugin'),
			'text' => __( 'Only applies when there is an event capacity set', 'rsvp-pro-plugin' ),
		),
		'settings_partial_match_label'                     => array(
			'name' => esc_html__('Do Partial Match on First and Last Name Label','rsvp-pro-plugin'),
			'text' => __( "Do partial match on attendee's first and last name:", 'rsvp-pro-plugin' ),
		),
		'settings_auto_change_waitlist_label'              => array(
			'name' => esc_html__('Automatically Change Waitlist to Yes Label','rsvp-pro-plugin'),
			'text' => __( 'Automatically change "waitlist" status to "yes" when a spot opens up:', 'rsvp-pro-plugin' ),
		),
		'settings_auto_change_waitlist_description'        => array(
			'name' => esc_html__('Automatically Change Waitlist to Yes Description','rsvp-pro-plugin'),
			'text' => __( 'Will select attendees based on who has the oldest RSVP date', 'rsvp-pro-plugin' ),
		),
		'settings_yes_no_longer_label'                     => array(
			'name' => esc_html__('Once "Waitlist" is Triggered "Yes" Will No Longer be Available Label','rsvp-pro-plugin'),
			'text' => __( 'Once "waitlist" is triggered, "yes" will no longer be available:', 'rsvp-pro-plugin' ),
		),
		'settings_yes_no_longer_description'               => array(
			'name' => esc_html__('Once "Waitlist" is Triggered "Yes" Will No Longer be Available Description','rsvp-pro-plugin'),
			'text' => __( 'With this option once a waitlist situation occurs it will never go back to open registration', 'rsvp-pro-plugin' ),
		),
		'settings_yes_unavailable_label'                   => array(
			'name' => esc_html__('Is "Yes" Unavailable Label','rsvp-pro-plugin'),
			'text' => __( 'Is the "yes" option unavailable to be selected?:', 'rsvp-pro-plugin' ),
		),
		'settings_yes_unavailable_description'             => array(
			'name' => esc_html__('Is "Yes" Unavailable Description','rsvp-pro-plugin'),
			'text' => __( 'This will set the flag for if the "yes" option should be available when waitlists are enabled', 'rsvp-pro-plugin' ),
		),
		'settings_maybe_label'                             => array(
			'name' => esc_html__('Allow Maybe Label','rsvp-pro-plugin'),
			'text' => __( 'Allow for a maybe response:', 'rsvp-pro-plugin' ),
		),
		'settings_num_guests_label'                        => array(
			'name' => esc_html__('Number of Additional Guests Label','rsvp-pro-plugin'),
			'text' => __( 'Number of Additional Guests:', 'rsvp-pro-plugin' ),
		),
		'settings_num_guests_description'                  => array(
			'name' => esc_html__('Number of Additional Guests Description','rsvp-pro-plugin'),
			'text' => __( 'Default is 3 guests, it is also possible to set different limits for individual attendees', 'rsvp-pro-plugin' ),
		),
		'settings_no_additional_guests_label'              => array(
			'name' => esc_html__('No Additional Guests Label','rsvp-pro-plugin'),
			'text' => __( 'No additional guests:', 'rsvp-pro-plugin' ),
		),
		'settings_allow_open_label'                        => array(
			'name' => esc_html__('Allow Open Registration Label','rsvp-pro-plugin'),
			'text' => __( 'Allow Open Registration:', 'rsvp-pro-plugin' ),
		),
		'settings_allow_open_description'                  => array(
			'name' => esc_html__('Allow Open Registration Description','rsvp-pro-plugin'),
			'text' => __( 'This will force passcodes for attendees', 'rsvp-pro-plugin' ),
		),
		'settings_cant_edit_label'                         => array(
			'name' => esc_html__('Attendees Can\'t Edit Registration Label','rsvp-pro-plugin'),
			'text' => __( "Attendees can't edit their RSVP:", 'rsvp-pro-plugin' ),
		),
		'settings_cant_edit_description'                   => array(
			'name' => esc_html__('Attendees Can\'t Edit Registration Description','rsvp-pro-plugin'),
			'text' => __( 'This only works with open registrations', 'rsvp-pro-plugin' ),
		),
		'settings_no_edit_prompt_label'                    => array(
			'name' => esc_html__('No Edit Prompt for Attendees Label','rsvp-pro-plugin'),
			'text' => __( 'No Edit Prompt for Attendees:', 'rsvp-pro-plugin' ),
		),
		'settings_no_edit_prompt_description'              => array(
			'name' => esc_html__('No Edit Prompt for Attendees Description','rsvp-pro-plugin'),
			'text' => __( 'This removes the edit prompt for returning attendees', 'rsvp-pro-plugin' ),
		),
		'settings_rsvp_once_label'                         => array(
			'name' => esc_html__('Attendees Can RSVP Once Label','rsvp-pro-plugin'),
			'text' => __( 'Attendees can only RSVP once:', 'rsvp-pro-plugin' ),
		),
		'settings_rsvp_once_description'                   => array(
			'name' => esc_html__('Attendees Can RSVP Once Description','rsvp-pro-plugin'),
			'text' => __( 'This will allow attendees to RSVP only once.', 'rsvp-pro-plugin' ),
		),
		'settings_open_prompt_label'                       => array(
			'name' => esc_html__('Open Registrations Prompt to Add Label','rsvp-pro-plugin'),
			'text' => __( 'For open registrations prompt to add a user if not found in user search:', 'rsvp-pro-plugin' ),
		),
		'settings_open_prompt_description'                 => array(
			'name' => esc_html__('Open Regsitrations Prompt to Add Description','rsvp-pro-plugin'),
			'text' => __( 'This will initially hide the open registration button and will display it if a user is not found', 'rsvp-pro-plugin' ),
		),
		'settings_auto_auth_label'                         => array(
			'name' => esc_html__('Automatically Authenticate WP-Users Label','rsvp-pro-plugin'),
			'text' => __( 'Automatically authenticate logged in WP-Users:', 'rsvp-pro-plugin' ),
		),
		'settings_auto_auth_description'                   => array(
			'name' => esc_html__('Automatically Authenticate WP-Users Description','rsvp-pro-plugin'),
			'text' => __( 'Checking this option will automatically skip the user lookup form if they are logged in and the user and attendee emails match, if it is an open event they will automatically go to create an attendee if there is no match.', 'rsvp-pro-plugin' ),
		),
		'settings_auto_enroll_wp_role_label'               => array(
			'name' => esc_html__('Auto-Enroll WordPress Roles Label','rsvp-pro-plugin'),
			'text' => __( 'Auto enroll the following WordPress roles:', 'rsvp-pro-plugin' ),
		),
		'settings_available_roles'                         => array(
			'name' => esc_html__('Available Roles Label','rsvp-pro-plugin'),
			'text' => __( 'Available roles', 'rsvp-pro-plugin' ),
		),
		'settings_auto_enabled_roles_label'                => array(
			'name' => esc_html__('Auto Enroll Enabled Roles Label','rsvp-pro-plugin'),
			'text' => __( 'Auto enroll enabled roles', 'rsvp-pro-plugin' ),
		),
		'settings_auto_enroll_wp_role_description'         => array(
			'name' => esc_html__('Auto-Enroll WordPress Roles Description','rsvp-pro-plugin'),
			'text' => __( 'This will allow for a set attendee list to pull from WordPress roles for attendees, &quot;automatically authenticate logged in WP-Users&quot; must be checked.', 'rsvp-pro-plugin' ),
		),
		'settings_email_lookup_label'                      => array(
			'name' => esc_html__('Use Email for Look-up Label','rsvp-pro-plugin'),
			'text' => __( 'Use email address instead of first and last name for lookup:', 'rsvp-pro-plugin' ),
		),
		'settings_email_lookup_description'                => array(
			'name' => esc_html__('Use Email for Look-up Description','rsvp-pro-plugin'),
			'text' => __( 'Checking this option will use the email address instead of the first and last name of the attendee when trying to find the user.', 'rsvp-pro-plugin' ),
		),
		'settings_do_not_require_last_name_label'          => array(
			'name' => esc_html__('Do Not Require Last Name for Attendees Label','rsvp-pro-plugin'),
			'text' => __( 'Do not require the last name for attendees:', 'rsvp-pro-plugin' ),
		),
		'settings_do_not_require_last_name_description'    => array(
			'name' => esc_html__('Do Not Require Last Name for Attendees Description','rsvp-pro-plugin'),
			'text' => __( 'Checking this option will allow attendees to look-up themselves with just their first name and also allow people to not enter in their last name if they do not want.', 'rsvp-pro-plugin' ),
		),
		'settings_show_cal_link_label'                     => array(
			'name' => esc_html__('Show Calendar Link on Confirmation Page Label','rsvp-pro-plugin'),
			'text' => __( 'Show calendar invite link on confirmation page:', 'rsvp-pro-plugin' ),
		),
		'settings_show_cal_link_description'               => array(
			'name' => esc_html__('Show Calendar Link on Confirmation Page Description','rsvp-pro-plugin'),
			'text' => __( 'Displays a link to download a calendar ICS file on the "Yes" confirmation page.', 'rsvp-pro-plugin' ),
		),
		'settings_display_event_description_label'         => array(
			'name' => esc_html__('Display Event Description on Front-End Label','rsvp-pro-plugin'),
			'text' => __( 'Display &quot;Event Description&quot; on the front-end:', 'rsvp-pro-plugin' ),
		),
		'settings_display_event_description_description'   => array(
			'name' => esc_html__('Display Event Description on Front-End Description','rsvp-pro-plugin'),
			'text' => __( 'Displays the event description specified in the &quot;General Event Information&quot; section on the front-page.', 'rsvp-pro-plugin' ),
		),
		'form_fields_settings_label'                       => array(
			'name' => esc_html__('Form Field Settings Label','rsvp-pro-plugin'),
			'text' => __( 'Form Field Settings', 'rsvp-pro-plugin' ),
		),
		'settings_first_last_editable_label'               => array(
			'name' => esc_html__('Allow First and Last Name to be Editable Label','rsvp-pro-plugin'),
			'text' => __( 'Allow for the First and Last Name to Editable:', 'rsvp-pro-plugin' ),
		),
		'settings_first_last_editable_description'         => array(
			'name' => esc_html__('Allow First and Last Name to be Editable Description','rsvp-pro-plugin'),
			'text' => __( 'Makes it so the first and last name can always be edited by attendees when they RSVP', 'rsvp-pro-plugin' ),
		),
		'settings_show_salutation_label'                   => array(
			'name' => esc_html__('Show Salutation Label','rsvp-pro-plugin'),
			'text' => __( 'Show Salutations:', 'rsvp-pro-plugin' ),
		),
		'settings_possible_salutations_label'              => array(
			'name' => esc_html__('Possible Salutations Label','rsvp-pro-plugin'),
			'text' => __( 'Possible Salutations:', 'rsvp-pro-plugin' ),
		),
		'settings_possible_salutations_description'        => array(
			'name' => esc_html__('Possible Salutations Description','rsvp-pro-plugin'),
			'text' => __( 'One salutation per-line', 'rsvp-pro-plugin' ),
		),
		'settings_show_suffix_label'                       => array(
			'name' => esc_html__('Show Suffix Label','rsvp-pro-plugin'),
			'text' => __( 'Show Suffix:', 'rsvp-pro-plugin' ),
		),
		'settings_show_no_response_label'                  => array(
			'name' => esc_html__('Show "No Response" for Associated Attendees Label','rsvp-pro-plugin'),
			'text' => __( 'Show &quot;No Response&quot; for Associated Attendees:', 'rsvp-pro-plugin' ),
		),
		'settings_hide_note_label'                         => array(
			'name' => esc_html__('Hide Note Field Label','rsvp-pro-plugin'),
			'text' => __( 'Hide Note Field:', 'rsvp-pro-plugin' ),
		),
		'settings_hide_email_field_label'                  => array(
			'name' => esc_html__('Hide Email Field Label','rsvp-pro-plugin'),
			'text' => __( 'Hide email field on rsvp form:', 'rsvp-pro-plugin' ),
		),
		'settings_unique_email_validation_label'           => array(
			'name' => esc_html__('Unique Email Validation Label','rsvp-pro-plugin'),
			'text' => __( 'Unique email validation on rsvp form', 'rsvp-pro-plugin' ),
		),
		'settings_unique_email_validation_description'     => array(
			'name' => esc_html__('Unique Email Validation Description','rsvp-pro-plugin'),
			'text' => __( 'This requires a unique email addresses when an attendee RSVPs', 'rsvp-pro-plugin' ),
		),
		'settings_require_email_label'                     => array(
			'name' => esc_html__('Require Email Label','rsvp-pro-plugin'),
			'text' => __( 'Require email question:', 'rsvp-pro-plugin' ),
		),
		'settings_require_rsvp_label'                      => array(
			'name' => esc_html__('Require RSVP Question Label','rsvp-pro-plugin'),
			'text' => __( 'Require RSVP question:', 'rsvp-pro-plugin' ),
		),
		'settings_hide_rsvp_question_label'                => array(
			'name' => esc_html__('Hide RSVP Question Label','rsvp-pro-plugin'),
			'text' => __( 'Hide RSVP question', 'rsvp-pro-plugin' ),
		),
		'settings_hide_rsvp_question_description'          => array(
			'name' => esc_html__('Hide RSVP Question Description','rsvp-pro-plugin'),
			'text' => __( 'Will default to "No Response" if a default is not specified', 'rsvp-pro-plugin' ),
		),
		'settings_default_rsvp_label'                      => array(
			'name' => esc_html__('Default RSVP Response Label','rsvp-pro-plugin'),
			'text' => __( 'Default RSVP response', 'rsvp-pro-plugin' ),
		),
		'passcode_settings_label'                          => array(
			'name' => esc_html__('Passcode Settings Label','rsvp-pro-plugin'),
			'text' => __( 'Passcode Settings', 'rsvp-pro-plugin' ),
		),
		'settings_require_passcode_label'                  => array(
			'name' => esc_html__('Require a Passcode to RSVP Label','rsvp-pro-plugin'),
			'text' => __( 'Require a Passcode to RSVP:', 'rsvp-pro-plugin' ),
		),
		'settings_passcode_length_label'                   => array(
			'name' => esc_html__('Passcode Length Label','rsvp-pro-plugin'),
			'text' => __( 'Passcode length:', 'rsvp-pro-plugin' ),
		),
		'settings_passcode_length_description'             => array(
			'name' => esc_html__('Passcode Length Description','rsvp-pro-plugin'),
			'text' => __( 'Valid values 1 to 50', 'rsvp-pro-plugin' ),
		),
		'settings_passcode_modification_label'             => array(
			'name' => esc_html__('Allow Passcode Modification Label','rsvp-pro-plugin'),
			'text' => __( 'Allow passcodes to be modified by attendees:', 'rsvp-pro-plugin' ),
		),
		'settings_just_passcode_label'                     => array(
			'name' => esc_html__('Just a Passcode to RSVP Label','rsvp-pro-plugin'),
			'text' => __( 'Just a Passcode to RSVP:', 'rsvp-pro-plugin' ),
		),
		'settings_just_passcode_description'               => array(
			'name' => esc_html__('Just a Passcode to RSVP Description','rsvp-pro-plugin'),
			'text' => __( 'Requires that passcodes are unique', 'rsvp-pro-plugin' ),
		),
		'settings_no_passcode_open_label'                  => array(
			'name' => esc_html__('No Passcode on Open Registration Label','rsvp-pro-plugin'),
			'text' => __( 'No passcode required on open registration:', 'rsvp-pro-plugin' ),
		),
		'settings_no_passcode_open_description'            => array(
			'name' => esc_html__('No Passcode on Open Registration Description','rsvp-pro-plugin'),
			'text' => __( 'This will override the requirement of having a passcode for open registration', 'rsvp-pro-plugin' ),
		),
		'settings_first_name_label'                        => array(
			'name' => esc_html__('First Name Label','rsvp-pro-plugin'),
			'text' => __( '&quot;First Name&quot; label:', 'rsvp-pro-plugin' ),
		),
		'settings_last_name_label'                         => array(
			'name' => esc_html__('Last Name Label','rsvp-pro-plugin'),
			'text' => __( '&quot;Last Name&quot; label:', 'rsvp-pro-plugin' ),
		),
		'settings_yes_text_label'                          => array(
			'name' => esc_html__('Yes Text Label','rsvp-pro-plugin'),
			'text' => __( '&quot;Yes&quot; text:', 'rsvp-pro-plugin' ),
		),
		'settings_no_text_label'                           => array(
			'name' => esc_html__('No Text Label','rsvp-pro-plugin'),
			'text' => __( '&quot;No&quot; text:', 'rsvp-pro-plugin' ),
		),
		'settings_mabye_text_label'                        => array(
			'name' => esc_html__('Maybe Text Label','rsvp-pro-plugin'),
			'text' => __( '&quot;Maybe&quot; text:', 'rsvp-pro-plugin' ),
		),
		'settings_waitlist_friendly_text_label'            => array(
			'name' => esc_html__('Waitlist Text Label','rsvp-pro-plugin'),
			'text' => __( '&quot;Waitlist&quot; text:', 'rsvp-pro-plugin' ),
		),
		'settings_plus_one_generic_text_label'             => array(
			'name' => esc_html__('Yes, Plus One Text Label','rsvp-pro-plugin'),
			'text' => __( '&quot;Yes, Plus One&quot; text:', 'rsvp-pro-plugin' ),
		),
		'settings_hi_text_label'                           => array(
			'name' => esc_html__('Hi Text Label','rsvp-pro-plugin'),
			'text' => __( '&quot;Hi&quot; text:', 'rsvp-pro-plugin' ),
		),
		'settings_no_response_text_label'                  => array(
			'name' => esc_html__('No Response Text Label','rsvp-pro-plugin'),
			'text' => __( '&quot;No Response&quot; text:', 'rsvp-pro-plugin' ),
		),
		'greetings_page_label'                             => array(
			'name' => esc_html__('Greetings Page Header','rsvp-pro-plugin'),
			'text' => __( 'Greeting Page', 'rsvp-pro-plugin' ),
		),
		'settings_open_message_label'                      => array(
			'name' => esc_html__('Before Open Message Label','rsvp-pro-plugin'),
			'text' => __( "Message displayed before the event is open for RSVP'ing", 'rsvp-pro-plugin' ),
		),
		'settings_open_message_description'                => array(
			'name' => esc_html__('Before Open Message Description','rsvp-pro-plugin'),
			'text' => __( "Default is: &quot;I am sorry but the ability to RSVP for our event won't open till &lt;strong&gt;%s&lt;/strong&gt;&quot;", 'rsvp-pro-plugin' ),
		),
		'settings_closed_message_label'                    => array(
			'name' => esc_html__('Closed Message Label','rsvp-pro-plugin'),
			'text' => __( "Message displayed once the event is closed for RSVP'ing", 'rsvp-pro-plugin' ),
		),
		'settings_closed_message_description'              => array(
			'name' => esc_html__('Closed Message Description','rsvp-pro-plugin'),
			'text' => __( 'Default is: &quot;The deadline to RSVP for this event has passed.&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_custom_greeting_label'                   => array(
			'name' => esc_html__('Custom Greeting Label','rsvp-pro-plugin'),
			'text' => __( 'Custom greeting:', 'rsvp-pro-plugin' ),
		),
		'settings_custom_greeting_description'             => array(
			'name' => esc_html__('Custom Greeting Description','rsvp-pro-plugin'),
			'text' => __( 'Default is: &quot;Please enter your first and last name to RSVP.&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_modify_attendee_label'                   => array(
			'name' => esc_html__('Modify Attendee Label','rsvp-pro-plugin'),
			'text' => __( '&quot;Modify Attendee&quot; message:', 'rsvp-pro-plugin' ),
		),
		'settings_modify_attendee_description'             => array(
			'name' => esc_html__('Modify Attendee Description','rsvp-pro-plugin'),
			'text' => __( 'Default text is: &quot;Need to modify your registration? Start with the below form.&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_passcode_label'                          => array(
			'name' => esc_html__('Passcode Label','rsvp-pro-plugin'),
			'text' => __( '&quot;Passcode&quot; label:', 'rsvp-pro-plugin' ),
		),
		'settings_new_attendee_button_label'               => array(
			'name' => esc_html__('New Attendee Button label','rsvp-pro-plugin'),
			'text' => __( '&quot;New Attendee&quot; button:', 'rsvp-pro-plugin' ),
		),
		'settings_new_attendee_button_description'         => array(
			'name' => esc_html__('New Attendee Button Description','rsvp-pro-plugin'),
			'text' => __( 'Default text is: &quot;New Attendee Registration&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_find_me_button_label'                    => array(
			'name' => esc_html__('Find Me Button label','rsvp-pro-plugin'),
			'text' => __( '&quot;Find me&quot; button:', 'rsvp-pro-plugin' ),
		),
		'settings_find_me_button_description'              => array(
			'name' => esc_html__('Find Me Button Description','rsvp-pro-plugin'),
			'text' => __( 'Default text is: &quot;Find me!&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_unable_find_label'                       => array(
			'name' => esc_html__('Unable to Find Label','rsvp-pro-plugin'),
			'text' => __( 'Unable to find:', 'rsvp-pro-plugin' ),
		),
		'settings_unable_find_description'                 => array(
			'name' => esc_html__('Unable to Find Description','rsvp-pro-plugin'),
			'text' => __( 'Default text is: &quot;We were unable to find anyone with a name of...&quot;', 'rsvp-pro-plugin' ),
		),
		'edit_confirmation_page_label'                     => array(
			'name' => esc_html__('Edit Confirmation Label','rsvp-pro-plugin'),
			'text' => __( 'Edit Confirmation Page', 'rsvp-pro-plugin' ),
		),
		'settings_edit_prompt_label'                       => array(
			'name' => esc_html__('Edit Prompt Label','rsvp-pro-plugin'),
			'text' => __( 'Edit prompt:', 'rsvp-pro-plugin' ),
		),
		'settings_edit_prompt_description'                 => array(
			'name' => esc_html__('Edit Prompt Description','rsvp-pro-plugin'),
			'text' => __( "Default text is: &quot;Hi %1\$s %2\$s it looks like you have already RSVP'd. Would you like to edit your reservation?&quot;", 'rsvp-pro-plugin' ),
		),
		'settings_rsvp_once_message_header'                => array(
			'name' => esc_html__('Only RSVP Once Message Header','rsvp-pro-plugin'),
			'text' => __( 'Only RSVP Once Message Screen', 'rsvp-pro-plugin' ),
		),
		'settings_user_already_rsvpd_label'                => array(
			'name' => esc_html__('Message Displayed When User Has Already RSVP\'d Label','rsvp-pro-plugin'),
			'text' => __( 'Message displayed when a user has already RSVP\'d:', 'rsvp-pro-plugin' ),
		),
		'settings_user_already_rsvpd_description'          => array(
			'name' => esc_html__('Message Displayed When User Has Already RSVP\'d Description','rsvp-pro-plugin'),
			'text' => __( "Default text is: &quot;You have already RSVP'd for this event. Please contact us if you need to modify your registration.&quot;", 'rsvp-pro-plugin' ),
		),
		'settings_not_found_screen_header'                 => array(
			'name' => esc_html__('Not Found Screen Header','rsvp-pro-plugin'),
			'text' => __( 'Not found screen', 'rsvp-pro-plugin' ),
		),
		'settings_fuzzy_match_text_label'                  => array(
			'name' => esc_html__('Fuzzy Match Results Text Label','rsvp-pro-plugin'),
			'text' => __( 'Fuzzy match results text:', 'rsvp-pro-plugin' ),
		),
		'settings_fuzzy_match_text_description'            => array(
			'name' => esc_html__('Fuzzy Match Results Text Description','rsvp-pro-plugin'),
			'text' => __( 'Default text is: &quot;We could not find an exact match but could any of the below entries be you?&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_multiple_match_text_label'               => array(
			'name' => esc_html__('Multiple Match Results Text Label','rsvp-pro-plugin'),
			'text' => __( 'Multiple match results text:', 'rsvp-pro-plugin' ),
		),
		'settings_multiple_match_text_description'         => array(
			'name' => esc_html__('Multiple Match Results Text Description','rsvp-pro-plugin'),
			'text' => __( 'Default text is: &quot;we found multiple people with that name, please select your record&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_multiple_attendee_match_text_label'      => array(
			'name' => esc_html__('Multiple Attendee Match Text Label','rsvp-pro-plugin'),
			'text' => __( 'Multiple match attendee text:', 'rsvp-pro-plugin' ),
		),
		'settings_multiple_attendee_match_text_description' => array(
			'name' => esc_html__('Multiple Attendee Match Text Description','rsvp-pro-plugin'),
			'text' => __( 'Default text is: &quot;[Salutation] [FirstName] [LastName] [Suffix] - [Email]&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_open_add_user_prompt_label'              => array(
			'name' => esc_html__('Open Registration Add User Prompt Label','rsvp-pro-plugin'),
			'text' => __( 'Open registration add user prompt:', 'rsvp-pro-plugin' ),
		),
		'settings_open_add_user_prompt_description'        => array(
			'name' => esc_html__('Open Registration Add User Prompt Description','rsvp-pro-plugin'),
			'text' => __( 'Default text is: &quot;Maybe you aren\'t on the invitee list yet. Add yourself now.&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_main_rsvp_header'                        => array(
			'name' => esc_html__('Main RSVP Page Header','rsvp-pro-plugin'),
			'text' => __( 'Main RSVP Page', 'rsvp-pro-plugin' ),
		),
		'settings_custom_welcome_text_label'               => array(
			'name' => esc_html__('Custom Welcome Label','rsvp-pro-plugin'),
			'text' => __( 'Custom welcome:', 'rsvp-pro-plugin' ),
		),
		'settings_custom_welcome_text_description'         => array(
			'name' => esc_html__('Custom Welcome Description','rsvp-pro-plugin'),
			'text' => __( 'Default is: &quot;There are a few more questions we need to ask you if you could please fill them out below to finish up the RSVP process.&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_welcome_text_label'                      => array(
			'name' => esc_html__('Welcome Label','rsvp-pro-plugin'),
			'text' => __( 'Welcome:', 'rsvp-pro-plugin' ),
		),
		'settings_welcome_text_description'                => array(
			'name' => esc_html__('Welcome Description','rsvp-pro-plugin'),
			'text' => __( 'Default is: &quot;Welcome %1$s %2$s!&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_rsvp_question_label'                     => array(
			'name' => esc_html__('RSVP Question Verbiage Label','rsvp-pro-plugin'),
			'text' => __( 'RSVP question verbiage:', 'rsvp-pro-plugin' ),
		),
		'settings_rsvp_question_description'               => array(
			'name' => esc_html__('RSVP Question Verbiage Description','rsvp-pro-plugin'),
			'text' => __( 'Default is: &quot;So, how about it?&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_rsvp_yes_text_label'                     => array(
			'name' => esc_html__('RSVP Yes Label','rsvp-pro-plugin'),
			'text' => __( 'RSVP yes:', 'rsvp-pro-plugin' ),
		),
		'settings_rsvp_yes_text_description'               => array(
			'name' => esc_html__('RSVP Yes Description','rsvp-pro-plugin'),
			'text' => __( 'Default is: &quot;Yes, I will attend.&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_rsvp_no_text_label'                      => array(
			'name' => esc_html__('RSVP No Label','rsvp-pro-plugin'),
			'text' => __( 'RSVP no:', 'rsvp-pro-plugin' ),
		),
		'settings_rsvp_no_text_description'                => array(
			'name' => esc_html__('RSVP No Description','rsvp-pro-plugin'),
			'text' => __( 'Default is: &quot;No, I will not be able to attend.&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_rsvp_waitlist_text_label'                => array(
			'name' => esc_html__('RSVP Waitlist Label','rsvp-pro-plugin'),
			'text' => __( 'RSVP waitlist:', 'rsvp-pro-plugin' ),
		),
		'settings_rsvp_waitlist_text_description'          => array(
			'name' => esc_html__('RSVP Waitlist Description','rsvp-pro-plugin'),
			'text' => __( 'Default is: &quot;The event is full but we can add you to the waitlist.&quot;', 'rsvp-pro-plugin' ),
		),
		'settigns_rsvp_maybe_text_label'                   => array(
			'name' => esc_html__('RSVP Maybe Label','rsvp-pro-plugin'),
			'text' => __( 'RSVP maybe:', 'rsvp-pro-plugin' ),
		),
		'settings_rsvp_maybe_text_description'             => array(
			'name' => esc_html__('RSVP Maybe Description','rsvp-pro-plugin'),
			'text' => __( 'Default is: &quot;I might attend.&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_salutation_text_label'                   => array(
			'name' => esc_html__('Salutation Label','rsvp-pro-plugin'),
			'text' => __( '&quot;Salutation&quot; label:', 'rsvp-pro-plugin' ),
		),
		'settings_salutation_text_description'             => array(
			'name' => esc_html__('Salutation Description','rsvp-pro-plugin'),
			'text' => __( 'Default is: &quot;Salutation&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_suffix_text_label'                       => array(
			'name' => esc_html__('Suffix Label','rsvp-pro-plugin'),
			'text' => __( '&quot;Suffix&quot; label:', 'rsvp-pro-plugin' ),
		),
		'settings_suffix_text_description'                 => array(
			'name' => esc_html__('Suffix Description','rsvp-pro-plugin'),
			'text' => __( 'Default is: &quot;Suffix&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_email_text_label'                        => array(
			'name' => esc_html__('Email Label','rsvp-pro-plugin'),
			'text' => __( '&quot;Email&quot; label:', 'rsvp-pro-plugin' ),
		),
		'settings_email_text_description'                  => array(
			'name' => esc_html__('Email Description','rsvp-pro-plugin'),
			'text' => __( 'Default is: &quot;Email address&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_passcode_edit_text_label'                => array(
			'name' => esc_html__('Passcode Edit Label','rsvp-pro-plugin'),
			'text' => __( '&quot;Passcode Edit&quot; label:', 'rsvp-pro-plugin' ),
		),
		'settings_passcode_edit_text_description'          => array(
			'name' => esc_html__('Passcode Edit Description','rsvp-pro-plugin'),
			'text' => __( 'Default is: &quot;Attendee Passcode&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_text_under_rsvp_label'                   => array(
			'name' => esc_html__('Text Under RSVP Label','rsvp-pro-plugin'),
			'text' => __( 'Text Under RSVP', 'rsvp-pro-plugin' ),
		),
		'settings_text_under_rsvp_description'             => array(
			'name' => esc_html__('Text Under RSVP Description','rsvp-pro-plugin'),
			'text' => __( 'Option to show some text right underneath the RSVP main question.', 'rsvp-pro-plugin' ),
		),
		'settings_note_question_text_label'                => array(
			'name' => esc_html__('Note Question Label','rsvp-pro-plugin'),
			'text' => __( 'Note question:', 'rsvp-pro-plugin' ),
		),
		'settings_note_question_text_description'          => array(
			'name' => esc_html__('Note Question Description','rsvp-pro-plugin'),
			'text' => __( "Default is: &quot;If you have any <strong style=\"color:red;\">food allergies</strong>, please indicate what they are in the 'notes' section below.  Or, if you just want to send us a note, please feel free. If you have any questions, please send us an email.&quot;", 'rsvp-pro-plugin' ),
		),
		'settings_rsvp_button_label'                       => array(
			'name' => esc_html__('RSVP Button Label','rsvp-pro-plugin'),
			'text' => __( '&quot;RSVP&quot; button:', 'rsvp-pro-plugin' ),
		),
		'settings_rsvp_button_description'                 => array(
			'name' => esc_html__('RSVP Button Description','rsvp-pro-plugin'),
			'text' => __( 'Default text is: &quot;RSVP&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_next_button_label'                       => array(
			'name' => esc_html__('Next Button Label','rsvp-pro-plugin'),
			'text' => __( '&quot;Next&quot; button:', 'rsvp-pro-plugin' ),
		),
		'settings_next_button_description'                 => array(
			'name' => esc_html__('Next Button Description','rsvp-pro-plugin'),
			'text' => __( 'Default text is: &quot;Next&quot; (this only applies to when the multiple step option is enabled)', 'rsvp-pro-plugin' ),
		),
		'settings_add_additional_label'                    => array(
			'name' => esc_html__('Add Additional Label','rsvp-pro-plugin'),
			'text' => __( 'Add additional:', 'rsvp-pro-plugin' ),
		),
		'settings_add_additional_description'              => array(
			'name' => esc_html__('Add Additional Description','rsvp-pro-plugin'),
			'text' => __( 'Default is: &quot;You currently can invite &lt;span id="numAvailableToAdd"&gt;%d&lt;/span&gt; more people.&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_associated_attendee_greeting_label'      => array(
			'name' => esc_html__('Associated Attendee Greeting Label','rsvp-pro-plugin'),
			'text' => __( 'Associated attendee greeting:', 'rsvp-pro-plugin' ),
		),
		'settings_associated_attendee_greeting_description' => array(
			'name' => esc_html__('Associated Attendee Greeting Description','rsvp-pro-plugin'),
			'text' => __( 'Default is: &quot;Will %s be attending?&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_new_attendee_button_text_label'          => array(
			'name' => esc_html__('New Attendee Button Label','rsvp-pro-plugin'),
			'text' => __( 'New attendee button:', 'rsvp-pro-plugin' ),
		),
		'settings_new_attendee_button_text_description'    => array(
			'name' => esc_html__('New Attendee Button Description','rsvp-pro-plugin'),
			'text' => __( 'Default is: &quot;Add Additional Guests&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_remove_attendee_button_text_label'       => array(
			'name' => esc_html__('Remove Attendee Button Label','rsvp-pro-plugin'),
			'text' => __( 'Remove attendee button:', 'rsvp-pro-plugin' ),
		),
		'settings_remove_attendee_button_text_description' => array(
			'name' => esc_html__('Remove Attendee Button Description','rsvp-pro-plugin'),
			'text' => __( 'Default is: &quot;Remove Guest&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_message_event_capacity_text_label'       => array(
			'name' => esc_html__('Message Event Capacity is Reached Label','rsvp-pro-plugin'),
			'text' => __( 'Message when event capacity is reached:', 'rsvp-pro-plugin' ),
		),
		'settings_message_event_capacity_text_description' => array(
			'name' => esc_html__('Message Event Capacity is Reached Description','rsvp-pro-plugin'),
			'text' => __( 'Default is: &quot;The maximum limit of %1$d has been reached for this event.&quot; <br />The %2$d is a placeholder that will autofill the capacity number set on the front-end settings tab.', 'rsvp-pro-plugin' ),
		),
		'settings_waitlist_text_label'                     => array(
			'name' => esc_html__('Waitlist Text Label','rsvp-pro-plugin'),
			'text' => __( 'Waitlist text:', 'rsvp-pro-plugin' ),
		),
		'settings_waitlist_text_description'               => array(
			'name' => esc_html__('Waitlist Text Description','rsvp-pro-plugin'),
			'text' => __( 'Default is: &quot;This event has a waitlist available.&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_associated_rsvp_text_label'              => array(
			'name' => esc_html__('Associated RSVP Message Label','rsvp-pro-plugin'),
			'text' => __( 'Associated RSVP message:', 'rsvp-pro-plugin' ),
		),
		'settings_associated_rsvp_text_description'        => array(
			'name' => esc_html__('Associated RSVP Message Description','rsvp-pro-plugin'),
			'text' => __( 'Default is: &quot;The following people are associated with you.  At this time you can RSVP for them as well.&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_additional_attendee_greeting_text_label' => array(
			'name' => esc_html__('Additional Attendee Greeting Label','rsvp-pro-plugin'),
			'text' => __( 'Additional attendee greeting:', 'rsvp-pro-plugin' ),
		),
		'settings_additional_attendee_greeting_text_description' => array(
			'name' => esc_html__('Additional Attendee Greeting Description','rsvp-pro-plugin'),
			'text' => __( 'Default is: &quot;Will this person be attending?&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_javascript_validation_header'            => array(
			'name' => esc_html__('JavaScript Validation Messages','rsvp-pro-plugin'),
			'text' => __( 'JavaScript Validation Messages', 'rsvp-pro-plugin' ),
		),
		'settings_first_name_required_label'               => array(
			'name' => esc_html__('First Name Required Label','rsvp-pro-plugin'),
			'text' => __( 'First name required message:', 'rsvp-pro-plugin' ),
		),
		'settings_first_name_required_description'         => array(
			'name' => esc_html__('First Name Required Description','rsvp-pro-plugin'),
			'text' => __( 'Default is: &quot;Please enter a first name&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_last_name_required_label'                => array(
			'name' => esc_html__('Last Name Required Label','rsvp-pro-plugin'),
			'text' => __( 'Last name required message:', 'rsvp-pro-plugin' ),
		),
		'settings_last_name_required_description'          => array(
			'name' => esc_html__('Last Name Required Description','rsvp-pro-plugin'),
			'text' => __( 'Default is: &quot;Please enter a last name&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_custom_note_required_label'              => array(
			'name' => esc_html__('Custom Note Required Label','rsvp-pro-plugin'),
			'text' => __( 'Custom note required message:', 'rsvp-pro-plugin' ),
		),
		'settings_custom_note_required_description'        => array(
			'name' => esc_html__('Custom Note Required Description','rsvp-pro-plugin'),
			'text' => __( 'Default is: &quot;If you are adding additional RSVPs please enter your email address in case we have questions&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_email_required_label'                    => array(
			'name' => esc_html__('Email Required Label','rsvp-pro-plugin'),
			'text' => __( 'Email required message:', 'rsvp-pro-plugin' ),
		),
		'settings_email_required_description'              => array(
			'name' => esc_html__('Email Required Description','rsvp-pro-plugin'),
			'text' => __( 'Default is: &quot;Please enter an email address&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_gdpr_required_label'                     => array(
			'name' => esc_html__('GDPR Required Label','rsvp-pro-plugin'),
			'text' => __( 'GDPR required message:', 'rsvp-pro-plugin' ),
		),
		'settings_gdpr_required_description'               => array(
			'name' => esc_html__('GDPR Required Description','rsvp-pro-plugin'),
			'text' => __( 'Default is: &quot;This field is required&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_one_step_event_header'                   => array(
			'name' => esc_html__('One Step Per-Event Messages','rsvp-pro-plugin'),
			'text' => __( 'One Step Per Event', 'rsvp-pro-plugin' ),
		),
		'settings_event_title_text_label'                  => array(
			'name' => esc_html__('Event Title Text Label','rsvp-pro-plugin'),
			'text' => __( 'Event title text:', 'rsvp-pro-plugin' ),
		),
		'settings_event_title_text_description'            => array(
			'name' => esc_html__('Event Title Text Description','rsvp-pro-plugin'),
			'text' => __( 'Default is: &quot;RSVP for %s&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_option_text_label'                       => array(
			'name' => esc_html__('Option Text Label','rsvp-pro-plugin'),
			'text' => __( '&quot;Option&quot; text:', 'rsvp-pro-plugin' ),
		),
		'settings_confirmation_page_header'                => array(
			'name' => esc_html__('Confirmtion Page Header','rsvp-pro-plugin'),
			'text' => __( 'Confirmation Page', 'rsvp-pro-plugin' ),
		),
		'settings_modify_instructions_text_label'          => array(
			'name' => esc_html__('Modify Instructions for New Attendees Label','rsvp-pro-plugin'),
			'text' => __( 'Modify instructions for new attendees:', 'rsvp-pro-plugin' ),
		),
		'settings_modify_instructions_text_description'    => array(
			'name' => esc_html__('Modify Instructions for New Attendees Description','rsvp-pro-plugin'),
			'text' => __( 'Default is: &quot;To modify your RSVP just come back to this page and enter in your first and last name.&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_password_new_attendees_text_label'       => array(
			'name' => esc_html__('Password for New Attendees Text Label','rsvp-pro-plugin'),
			'text' => __( 'Password for new attendees:', 'rsvp-pro-plugin' ),
		),
		'settings_password_new_attendees_text_description' => array(
			'name' => esc_html__('Password for New Attendees Text Description','rsvp-pro-plugin'),
			'text' => __( 'Default is: &quot;You will also need to know your password which is <strong>%s</strong>&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_associated_text_new_attendees_label'     => array(
			'name' => esc_html__('Associated Text for New Attendees Label','rsvp-pro-plugin'),
			'text' => __( 'Associated text for new attendees:', 'rsvp-pro-plugin' ),
		),
		'settings_associated_text_new_attendees_description' => array(
			'name' => esc_html__('Associated Text for New Attendees Description','rsvp-pro-plugin'),
			'text' => __( 'Default is: &quot;You have also RSVPed for - &quot;', 'rsvp-pro-plugin' ),
		),
		'settings_custom_thankyou_text_label'              => array(
			'name' => esc_html__('Custom Thank You Label','rsvp-pro-plugin'),
			'text' => __( 'Custom thank you:', 'rsvp-pro-plugin' ),
		),
		'settings_custom_thankyou_text_description'        => array(
			'name' => esc_html__('Custom Thank You Description','rsvp-pro-plugin'),
			'text' => __( 'Default is: &quot;Thank you for RSVPing&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_thank_you_when_no_label'                 => array(
			'name' => esc_html__('Thank You When an Attendee Says "No"','rsvp-pro-plugin'),
			'text' => __( 'Thank You when an attendee RSVPs with &quot;no&quot;:', 'rsvp-pro-plugin' ),
		),
		'settings_calendar_link_text_label'                => array(
			'name' => esc_html__('Calendar Download Link Text Label','rsvp-pro-plugin'),
			'text' => __( 'Calendar download link text:', 'rsvp-pro-plugin' ),
		),
		'settings_calendar_link_text_description'          => array(
			'name' => esc_html__('Calendar Download Link Text Description','rsvp-pro-plugin'),
			'text' => __( 'Default is: &quot;Add to your calendar&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_google_calendar_link_text_label'         => array(
			'name' => esc_html__('Add to Google Calendar Link Text Label','rsvp-pro-plugin'),
			'text' => __( 'Add to Google Calendar link text:', 'rsvp-pro-plugin' ),
		),
		'settings_google_calendar_link_text_description'   => array(
			'name' => esc_html__('Add to Google Calendar Link Text Description','rsvp-pro-plugin'),
			'text' => __( 'Default is: &quot;Add to your Google calendar&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_rsvp_open_date_label'                    => array(
			'name' => esc_html__('RSVP Open Date Label','rsvp-pro-plugin'),
			'text' => __( 'RSVP Open Date', 'rsvp-pro-plugin' ),
		),
		'settings_rsvp_close_date_label'                   => array(
			'name' => esc_html__('RSVP Close Date Label','rsvp-pro-plugin'),
			'text' => __( 'RSVP Close Date', 'rsvp-pro-plugin' ),
		),
		'settings_parent_event_label'                      => array(
			'name' => esc_html__('Parent Event Label','rsvp-pro-plugin'),
			'text' => __( 'Parent Event', 'rsvp-pro-plugin' ),
		),
		'settings_parent_event_description'                => array(
			'name' => esc_html__('Parent Event Description','rsvp-pro-plugin'),
			'text' => __( 'Setting a parent event will allow you to share attendee lists and RSVP for all the events on one page.', 'rsvp-pro-plugin' ),
		),
		'settings_specify_roles_with_access_label'         => array(
			'name' => esc_html__('Specify Roles That Can Access Configuration Label','rsvp-pro-plugin'),
			'text' => __( 'Specify roles that can access configuration functionality:', 'rsvp-pro-plugin' ),
		),
		'settings_specify_roles_access_description'        => array(
			'name' => esc_html__('Specify Roles That Can Access Configuration Description','rsvp-pro-plugin'),
			'text' => __( 'If no one is selected then everyone can access the configuration functionality. Administrators can not be locked out of settings.', 'rsvp-pro-plugin' ),
		),
		'settings_roles_have_access_label'                 => array(
			'name' => esc_html__('Roles That Have Access Label','rsvp-pro-plugin'),
			'text' => __( 'Roles That Have Access', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_access_label'                   => array(
			'name' => esc_html__('Attendee Access to Event Label','rsvp-pro-plugin'),
			'text' => __( 'Attendee Access to Event:', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_access_list_label'              => array(
			'name' => esc_html__('Attendee Access List Label','rsvp-pro-plugin'),
			'text' => __( 'Attendee Access List:', 'rsvp-pro-plugin' ),
		),
		'settings_available_attendees_label'               => array(
			'name' => esc_html__('Available Attendees Label','rsvp-pro-plugin'),
			'text' => __( 'Available Attendees', 'rsvp-pro-plugin' ),
		),
		'settings_attendees_who_have_access_label'         => array(
			'name' => esc_html__('Attendees Who Have Access Label','rsvp-pro-plugin'),
			'text' => __( 'Attendees Who Have Access', 'rsvp-pro-plugin' ),
		),
		'settings_allow_attendee_checkin_label'            => array(
			'name' => esc_html__('Allow Attendee Check-Ins Label','rsvp-pro-plugin'),
			'text' => __( 'Allow Attendee Check-ins:', 'rsvp-pro-plugin' ),
		),
		'settings_allow_attendee_checkin_description'      => array(
			'name' => esc_html__('Allow Attendee Check-Ins Description','rsvp-pro-plugin'),
			'text' => __( 'This surfaces the ability for admins to check attendees into events, confirming attendance, etc.. for this event', 'rsvp-pro-plugin' ),
		),
		'general_event_information_header'                 => array(
			'name' => esc_html__('General Event Information Header','rsvp-pro-plugin'),
			'text' => __( 'General Event Information', 'rsvp-pro-plugin' ),
		),
		'settings_event_start_date_label'                  => array(
			'name' => esc_html__('Event Start Date Label','rsvp-pro-plugin'),
			'text' => __( 'Event Start Date', 'rsvp-pro-plugin' ),
		),
		'settings_date_format_example'                     => array(
			'name' => esc_html__('Settings Date Format Example','rsvp-pro-plugin'),
			'text' => __( 'yyyy-mm-dd h:m:s AM/PM(i.e. 2017-05-31 10:30:00 AM)', 'rsvp-pro-plugin' ),
		),
		'settings_event_end_date_label'                    => array(
			'name' => esc_html__('Event End Date Label','rsvp-pro-plugin'),
			'text' => __( 'Event End Date', 'rsvp-pro-plugin' ),
		),
		'settings_event_description_label'                 => array(
			'name' => esc_html__('Event Description Label','rsvp-pro-plugin'),
			'text' => __( 'Event Description', 'rsvp-pro-plugin' ),
		),
		'settings_recurring_event_information_header'      => array(
			'name' => esc_html__('Recurring Event Information Header','rsvp-pro-plugin'),
			'text' => __( 'Recurring Event Information', 'rsvp-pro-plugin' ),
		),
		'settings_recurring_event_header_description'      => array(
			'name' => esc_html__('Recurring Event Header Description','rsvp-pro-plugin'),
			'text' => __( 'Information used for making an event repeat', 'rsvp-pro-plugin' ),
		),
		'settings_repeating_start_date_label'              => array(
			'name' => esc_html__('Repeating Start Date Label','rsvp-pro-plugin'),
			'text' => __( 'Repeating start date:', 'rsvp-pro-plugin' ),
		),
		'settings_repeating_start_date_description'        => array(
			'name' => esc_html__('Repeating Start Date Description','rsvp-pro-plugin'),
			'text' => __( 'The date to which the recurring event starts', 'rsvp-pro-plugin' ),
		),
		'settings_repeating_end_date_label'                => array(
			'name' => esc_html__('Repeating End Date Label','rsvp-pro-plugin'),
			'text' => __( 'Repeating end date', 'rsvp-pro-plugin' ),
		),
		'settings_repeating_end_date_description'          => array(
			'name' => esc_html__('Repeating End Date Description','rsvp-pro-plugin'),
			'text' => __( 'The date to which the recurring event ends', 'rsvp-pro-plugin' ),
		),
		'settings_repeating_frequency_label'               => array(
			'name' => esc_html__('Repeating Frequency Label','rsvp-pro-plugin'),
			'text' => __( 'Repeating frequency:', 'rsvp-pro-plugin' ),
		),
		'settings_repeating_frequency_description'         => array(
			'name' => esc_html__('Repeating Frequency Description','rsvp-pro-plugin'),
			'text' => __( 'How often does it repeat (i.e. 1 week, 2 months), any whole number greater than zero is allowed.', 'rsvp-pro-plugin' ),
		),
		'settings_repeating_frequency_type'                => array(
			'name' => esc_html__('Repeating Frequency Type Label','rsvp-pro-plugin'),
			'text' => __( 'Repeating frequency type:', 'rsvp-pro-plugin' ),
		),
		'settings_day_label'                               => array(
			'name' => esc_html__('Day Label','rsvp-pro-plugin'),
			'text' => __( 'Day', 'rsvp-pro-plugin' ),
		),
		'settings_week_label'                              => array(
			'name' => esc_html__('Week Label','rsvp-pro-plugin'),
			'text' => __( 'Week', 'rsvp-pro-plugin' ),
		),
		'settings_month_label'                             => array(
			'name' => esc_html__('Month Label','rsvp-pro-plugin'),
			'text' => __( 'Month', 'rsvp-pro-plugin' ),
		),
		'settings_year_label'                              => array(
			'name' => esc_html__('Year Label','rsvp-pro-plugin'),
			'text' => __( 'Year', 'rsvp-pro-plugin' ),
		),
		'settings_repeating_frequency_type_description'    => array(
			'name' => esc_html__('Frequency Type Description','rsvp-pro-plugin'),
			'text' => __( 'The frequency at which the event repeats (i.e. every week, a month, etc..)', 'rsvp-pro-plugin' ),
		),
		'settings_event_length_label'                      => array(
			'name' => esc_html__('Event Length Label','rsvp-pro-plugin'),
			'text' => __( 'Length of each event', 'rsvp-pro-plugin' ),
		),
		'settings_event_length_description'                => array(
			'name' => esc_html__('Event Length Description','rsvp-pro-plugin'),
			'text' => __( 'How long each instance of the event goes for, any whole number greater than zero is allowed.', 'rsvp-pro-plugin' ),
		),
		'settings_length_type_label'                       => array(
			'name' => esc_html__('Length Type Label','rsvp-pro-plugin'),
			'text' => __( 'Length type of each event', 'rsvp-pro-plugin' ),
		),
		'settings_length_type_description'                 => array(
			'name' => esc_html__('Length Type Description','rsvp-pro-plugin'),
			'text' => __( 'The length type of each instance (i.e. day, month, etc...).', 'rsvp-pro-plugin' ),
		),
		'settings_dont_keep_recurring_history'             => array(
			'name' => esc_html__('Do Not Keep a History of Repeated Events Label','rsvp-pro-plugin'),
			'text' => __( 'Do not keep a history of repeated events', 'rsvp-pro-plugin' ),
		),
		'settings_dont_keep_recurring_history_description' => array(
			'name' => esc_html__('Do Not Keep a History of Repeated Events Description','rsvp-pro-plugin'),
			'text' => __( 'By default whenever an event repeats we will keep a copy of the previous date of event.', 'rsvp-pro-plugin' ),
		),
		'settings_public_attendee_list_only_status_label'  => array(
			'name' => esc_html__('Only Show a Specific RSVP Status on Public Attendee List','rsvp-pro-plugin'),
			'text' => __( 'Only show a specific rsvp status on public attendee list:', 'rsvp-pro-plugin' ),
		),
		'settings_allow_status_change_on_attendee_list_label' => array(
			'name' => esc_html__('Allow Status Change on Public Attendee List Label','rsvp-pro-plugin'),
			'text' => __( 'Allow attendees to modify their status via the list:', 'rsvp-pro-plugin' ),
		),
		'settings_show_search_attendee_list_label'         => array(
			'name' => esc_html__('Show Search on Public Attendee List Label','rsvp-pro-plugin'),
			'text' => __( 'Show attendee search on the attendee list:', 'rsvp-pro-plugin' ),
		),
		'settings_show_export_button_attendee_list_label'  => array(
			'name' => esc_html__('Show Export Button on Public Attendee List Label','rsvp-pro-plugin'),
			'text' => __( 'Show export attendee button on the attendee list:', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_search_text_label'         => array(
			'name' => esc_html__('Public Attendee List Search Text Label','rsvp-pro-plugin'),
			'text' => __( 'Specify search text:', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_search_text_description'   => array(
			'name' => esc_html__('Public Attendee List Search Text Description','rsvp-pro-plugin'),
			'text' => __( 'Default is "Search Attendee List"', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_allow_checkin_label'       => array(
			'name' => esc_html__('Public Attendee List Allow Check-In Label','rsvp-pro-plugin'),
			'text' => __( 'Allow attendees to check-in:', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_allow_checkin_description' => array(
			'name' => esc_html__('Public Attendee List Allow Check-In Description','rsvp-pro-plugin'),
			'text' => __( 'Allows attendees to check-in for the event to show they have attended.', 'rsvp-pro-plugin' ),
		),

		'settings_attendee_list_checkin_text_label'        => array(
			'name' => esc_html__('Public Attendee List Check-In Button Text Label','rsvp-pro-plugin'),
			'text' => __( 'Specify Check-In Button Text:', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_checkin_text_description'  => array(
			'name' => esc_html__('Public Attendee List Check-In Button Text Description','rsvp-pro-plugin'),
			'text' => __( 'Default is "Check In"', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_checkin_message_label'     => array(
			'name' => esc_html__('Public Attendee List Checked-In Message Label','rsvp-pro-plugin'),
			'text' => __( 'Message if User is Checked-In:', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_checkin_message_description' => array(
			'name' => esc_html__('Public Attendee List Checked-In Message Description','rsvp-pro-plugin'),
			'text' => __( 'Default is "Already checked in"', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_sort_order_label'          => array(
			'name' => esc_html__('Public Attendee List Sort Order Label','rsvp-pro-plugin'),
			'text' => __( 'Attendee list sort order:', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_sort_order_description'    => array(
			'name' => esc_html__('Public Attendee List Sort Order Description','rsvp-pro-plugin'),
			'text' => __( 'Default sort order is: First Name', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_show_email_label'          => array(
			'name' => esc_html__('Public Attendee List Show Email Label','rsvp-pro-plugin'),
			'text' => __( 'Show email address on attendee list', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_show_note_label'           => array(
			'name' => esc_html__('Public Attendee List Show Note Label','rsvp-pro-plugin'),
			'text' => __( 'Show note on attendee list', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_show_associated_label'     => array(
			'name' => esc_html__('Public Attendee List Show Associated Attendees Label','rsvp-pro-plugin'),
			'text' => __( 'Show associated attendees on attendee list', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_show_rsvp_count_label'     => array(
			'name' => esc_html__('Public Attendee List Show RSVP Count Label','rsvp-pro-plugin'),
			'text' => __( 'Show total RSVP yes/no count at the top and bottom of the attendee list', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_hide_rsvp_status_label'    => array(
			'name' => esc_html__('Public Attendee List Hide RSVP Status Label','rsvp-pro-plugin'),
			'text' => __( 'Hide RSVP status from list:', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_show_custom_questions_label' => array(
			'name' => esc_html__('Public Attendee List Show Custom Questions Label','rsvp-pro-plugin'),
			'text' => __( 'Show custom questions in list:', 'rsvp-pro-plugin' ),
		),
		'settings_available_custom_questions_label'        => array(
			'name' => esc_html__('Available Custom Questions Label','rsvp-pro-plugin'),
			'text' => __( 'Available custom questions', 'rsvp-pro-plugin' ),
		),
		'settings_custom_questions_displayed_label'        => array(
			'name' => esc_html__('Custom Questions Displayed Label','rsvp-pro-plugin'),
			'text' => __( 'Custom questions displayed', 'rsvp-pro-plugin' ),
		),
		'add_rsvp_pro_form_label'                          => array(
			'name' => esc_html__('Add RSVP Pro Form Label','rsvp-pro-plugin'),
			'text' => __( 'Add RSVP Pro Form', 'rsvp-pro-plugin' ),
		),
		'insert_rsvp_pro_form_label'                       => array(
			'name' => esc_html__('Insert RSVP Pro Form Label','rsvp-pro-plugin'),
			'text' => __( 'Insert A RSVP Pro Form', 'rsvp-pro-plugin' ),
		),
		'select_information_to_display_label'              => array(
			'name' => esc_html__('Select Informtion to Display Label','rsvp-pro-plugin'),
			'text' => __( 'Select information you want to display', 'rsvp-pro-plugin' ),
		),
		'rsvp_form_label'                                  => array(
			'name' => esc_html__('RSVP Form Label','rsvp-pro-plugin'),
			'text' => __( 'RSVP Form', 'rsvp-pro-plugin' ),
		),
		'attendee_list_label'                              => array(
			'name' => esc_html__('Attendee List Label','rsvp-pro-plugin'),
			'text' => __( 'Attendee List', 'rsvp-pro-plugin' ),
		),
		'event_list_label'                                 => array(
			'name' => esc_html__('Event List Label','rsvp-pro-plugin'),
			'text' => __( 'Event List', 'rsvp-pro-plugin' ),
		),
		'select_event_label'                               => array(
			'name' => esc_html__('Select Event Label','rsvp-pro-plugin'),
			'text' => __( 'Select event', 'rsvp-pro-plugin' ),
		),
		'insert_event_label'                               => array(
			'name' => esc_html__('Inert Event Label','rsvp-pro-plugin'),
			'text' => __( 'Insert Event', 'rsvp-pro-plugin' ),
		),
		'cancel_label'                                     => array(
			'name' => esc_html__('Cancel Label','rsvp-pro-plugin'),
			'text' => __( 'Cancel', 'rsvp-pro-plugin' ),
		),
		'reminders_for_label'                              => array(
			'name' => esc_html__('Reminders For Label','rsvp-pro-plugin'),
			'text' => __( 'Reminders for', 'rsvp-pro-plugin' ),
		),
		'add_new_label'                                    => array(
			'name' => esc_html__('Add New Label','rsvp-pro-plugin'),
			'text' => __( 'Add New', 'rsvp-pro-plugin' ),
		),
		'the_date_label'                                   => array(
			'name' => esc_html__('The Date Label','rsvp-pro-plugin'),
			'text' => __( 'The date', 'rsvp-pro-plugin' ),
		),
		'used_for_reminder_calculation_label'              => array(
			'name' => esc_html__('Will Be Used For Reminders Calculation Label','rsvp-pro-plugin'),
			'text' => __( 'will be used to calculate when the reminders are sent out.', 'rsvp-pro-plugin' ),
		),
		'date_retrieved_from_label'                        => array(
			'name' => esc_html__('Date Retrieved From Label','rsvp-pro-plugin'),
			'text' => __( 'This date was retrieved from the ', 'rsvp-pro-plugin' ),
		),
		'field_label'                                      => array(
			'name' => esc_html__('Field Label','rsvp-pro-plugin'),
			'text' => __( 'field.', 'rsvp-pro-plugin' ),
		),
		'add_reminder_label'                               => array(
			'name' => esc_html__('Add Reminder Label','rsvp-pro-plugin'),
			'text' => __( 'Add Reminder', 'rsvp-pro-plugin' ),
		),
		'edit_reminder_label'                              => array(
			'name' => esc_html__('Edit Reminder Label','rsvp-pro-plugin'),
			'text' => __( 'Edit Reminder', 'rsvp-pro-plugin' ),
		),
		'go_back_label'                                    => array(
			'name' => esc_html__('Go Back Label','rsvp-pro-plugin'),
			'text' => __( 'Go Back', 'rsvp-pro-plugin' ),
		),
		'reminder_name_label'                              => array(
			'name' => esc_html__('Reminder Name Label','rsvp-pro-plugin'),
			'text' => __( 'Reminder Name', 'rsvp-pro-plugin' ),
		),
		'reminder_name_description'                        => array(
			'name' => esc_html__('Reminder Name Description','rsvp-pro-plugin'),
			'text' => __( 'A friendly name for the reminder that is only viewable from the admin area', 'rsvp-pro-plugin' ),
		),
		'reminder_time_label'                              => array(
			'name' => esc_html__('Reminder Time Label','rsvp-pro-plugin'),
			'text' => __( 'Reminder Time', 'rsvp-pro-plugin' ),
		),
		'send_reminder_label'                              => array(
			'name' => esc_html__('Send Reminder Label','rsvp-pro-plugin'),
			'text' => __( 'Send reminder', 'rsvp-pro-plugin' ),
		),
		'before_label'                                     => array(
			'name' => esc_html__('Before Label','rsvp-pro-plugin'),
			'text' => __( 'before', 'rsvp-pro-plugin' ),
		),
		'send_reminder_on_label'                           => array(
			'name' => esc_html__('Send Reminder On Label','rsvp-pro-plugin'),
			'text' => __( 'Send Reminder On', 'rsvp-pro-plugin' ),
		),
		'reminders_only_rsvp_status_label'                 => array(
			'name' => esc_html__('Only Send Reminders to Selected Statuses Label','rsvp-pro-plugin'),
			'text' => __( 'Only Send Reminders to Selected Statuses', 'rsvp-pro-plugin' ),
		),
		'possible_statuses_to_send_label'                  => array(
			'name' => esc_html__('Possible Statuses to Send Label','rsvp-pro-plugin'),
			'text' => __( 'Possible Statuses To Send', 'rsvp-pro-plugin' ),
		),
		'reminders_sent_to_statuses_label'                 => array(
			'name' => esc_html__('Reminders Sent to Statuses Label','rsvp-pro-plugin'),
			'text' => __( 'Statuses Reminders Will Be Sent To', 'rsvp-pro-plugin' ),
		),
		'reminder_subject_label'                           => array(
			'name' => esc_html__('Reminder Subject Label','rsvp-pro-plugin'),
			'text' => __( 'Reminder Subject', 'rsvp-pro-plugin' ),
		),
		'reminder_message_label'                           => array(
			'name' => esc_html__('Reminder Message Label','rsvp-pro-plugin'),
			'text' => __( 'Reminder Message', 'rsvp-pro-plugin' ),
		),
		'save_reminder_label'                              => array(
			'name' => esc_html__('Save Reminder Label','rsvp-pro-plugin'),
			'text' => __( 'Save Reminder', 'rsvp-pro-plugin' ),
		),
		'reminder_label'                                   => array(
			'name' => esc_html__('Reminder Label','rsvp-pro-plugin'),
			'text' => __( 'Reminder', 'rsvp-pro-plugin' ),
		),
		'time_qualifier_label'                             => array(
			'name' => esc_html__('Time Qualifier Label','rsvp-pro-plugin'),
			'text' => __( 'Time Qualifier', 'rsvp-pro-plugin' ),
		),
		'time_period_label'                                => array(
			'name' => esc_html__('Time Period Label','rsvp-pro-plugin'),
			'text' => __( 'Time Period', 'rsvp-pro-plugin' ),
		),
		'send_reminder_specific_date_label'                => array(
			'name' => esc_html__('Send Reminder On Specific Date Label','rsvp-pro-plugin'),
			'text' => __( 'Send On Specific Date', 'rsvp-pro-plugin' ),
		),
		'relevant_rsvp_label'                              => array(
			'name' => esc_html__('Relevant RSVP Label','rsvp-pro-plugin'),
			'text' => __( 'Relevant RSVP', 'rsvp-pro-plugin' ),
		),
		'rsvp_pro_event_responses_label'                   => array(
			'name' => esc_html__('RSVP Pro Event Responses Label','rsvp-pro-plugin'),
			'text' => __( 'RSVP Pro Event Responses', 'rsvp-pro-plugin' ),
		),
		'settings_hide_search_form_label'                  => array(
			'name' => esc_html__('Use A Button to Display Search Form Label','rsvp-pro-plugin'),
			'text' => __( 'Use A Button to Display Attendee Search Form', 'rsvp-pro-plugin' ),
		),
		'settings_hide_search_form_description'            => array(
			'name' => esc_html__('Use A Button to Display Search Form Description','rsvp-pro-plugin'),
			'text' => __( 'This will surface a button for a user to click on before the attendee search form is displayed.', 'rsvp-pro-plugin' ),
		),
		'settings_find_attendees_label'                    => array(
			'name' => esc_html__('"Find Attendees" Button Label','rsvp-pro-plugin'),
			'text' => __( '"Find Attendees" Button', 'rsvp-pro-plugin' ),
		),
		'settings_find_attendees_description'              => array(
			'name' => esc_html__('"Find Attendees" Button Description','rsvp-pro-plugin'),
			'text' => __( 'Default text is: "Find Attendees"', 'rsvp-pro-plugin' ),
		),
		'auto_create_attendee_list_label'                  => array(
			'name' => esc_html__('Automatically Create Attendee List Label','rsvp-pro-plugin'),
			'text' => __( 'Automatically create post_type entry for main event attendee list', 'rsvp-pro-plugin' ),
		),
		'auto_create_attendee_list_description'            => array(
			'name' => esc_html__('Automatically Create Attendee List Description','rsvp-pro-plugin'),
			'text' => __( 'If a "page" is found with the attendee list short code than a "page" will not be created.', 'rsvp-pro-plugin' ),
		),
		'attendee_list_text'                               => array(
			'name' => esc_html__('Attendee List Text','rsvp-pro-plugin'),
			'text' => __( 'Attendee List', 'rsvp-pro-plugin' ),
		),
		'disable_comments_label'                           => array(
			'name' => esc_html__('Disable Comments Label','rsvp-pro-plugin'),
			'text' => __( 'Disable Comments on Automatically Created Items', 'rsvp-pro-plugin' ),
		),
		'disable_comments_description'                     => array(
			'name' => esc_html__('Disable Comments Description','rsvp-pro-plugin'),
			'text' => __( 'This will turn off commenting on items automatically created for events', 'rsvp-pro-plugin' ),
		),
		'global_attendee_list'                             => array(
			'name' => esc_html__('Global Attendee List Label','rsvp-pro-plugin'),
			'text' => __( 'Global Attendee List', 'rsvp-pro-plugin' ),
		),
		'enable_global_attendee_list_label'                => array(
			'name' => esc_html__('Enable Global Attendee List Label','rsvp-pro-plugin'),
			'text' => __( 'Enable Global Attendee List', 'rsvp-pro-plugin' ),
		),
		'enable_global_attendee_list_description'          => array(
			'name' => esc_html__('Global Attendee List Setting Description','rsvp-pro-plugin'),
			'text' => __( 'This enables a global attendee list that will be shared with ALL events.', 'rsvp-pro-plugin' ),
		),
		'enable_global_attendee_changelog_label'           => array(
			'name' => esc_html__('Enable Attendee Changelog Label','rsvp-pro-plugin'),
			'text' => __( 'Enable Attendee Changelogs', 'rsvp-pro-plugin' ),
		),
		'enable_global_attendee_changelog_description'     => array(
			'name' => esc_html__('Attendee Changelog Setting Description','rsvp-pro-plugin'),
			'text' => __( 'This enables a feature which saves any changes an  attendee makes from the front-end.', 'rsvp-pro-plugin' ),
		),
		'change_heading'                                   => array(
			'name' => esc_html__('Changes Table Header Label','rsvp-pro-plugin'),
			'text' => __( 'Changes', 'rsvp-pro-plugin' ),
		),
		'change_heading_date'                              => array(
			'name' => esc_html__('Changes Date Table Header Label','rsvp-pro-plugin'),
			'text' => __( 'Change Date', 'rsvp-pro-plugin' ),
		),
		'changed_to_label'                                 => array(
			'name' => esc_html__('Changed To Label','rsvp-pro-plugin'),
			'text' => __( 'changed to', 'rsvp-pro-plugin' ),
		),
		'export_select_columns_text'                       => array(
			'name' => esc_html__('Select columns text','rsvp-pro-plugin'),
			'text' => __( 'Check the below columns that you want in the exported file.', 'rsvp-pro-plugin' ),
		),
		'prefill_url_label'                                => array(
			'name' => esc_html__('Pre-fill URL label','rsvp-pro-plugin'),
			'text' => __( 'Pre-fill URL', 'rsvp-pro-plugin' ),
		),
		'settings_enable_plus_one_label'                   => array(
			'name' => esc_html__('Allow Yes, Plus One Settings Label','rsvp-pro-plugin'),
			'text' => __( 'Allow for a &quot;Yes, plus one&quot; response', 'rsvp-pro-plugin' ),
		),
		'settings_enable_plus_one_description'             => array(
			'name' => esc_html__('Enable +1 Settings Description','rsvp-pro-plugin'),
			'text' => __( 'This surfaces an additional RSVP response for attendees to add a +1 for an additional attendee without any information.', 'rsvp-pro-plugin' ),
		),
		'settings_plus_one_text_label'                     => array(
			'name' => esc_html__('Yes, Plus One Settings Label','rsvp-pro-plugin'),
			'text' => __( 'RSVP yes, plus one', 'rsvp-pro-plugin' ),
		),
		'settings_plus_one_text_description'               => array(
			'name' => esc_html__('+1 Text Settings Description','rsvp-pro-plugin'),
			'text' => __( 'Default is: &quot;Yes, +1 additional attendee&quot;', 'rsvp-pro-plugin' ),
		),
		'save_message_label'                               => array(
			'name' => esc_html__('Save Message Label','rsvp-pro-plugin'),
			'text' => __( 'Save Message to Log', 'rsvp-pro-plugin' ),
		),
		'message_log_table_label'                          => array(
			'name' => esc_html__('Message Log Table Label','rsvp-pro-plugin'),
			'text' => __( 'Message Log', 'rsvp-pro-plugin' ),
		),
		'message_logs_table_label'                         => array(
			'name' => esc_html__('Message Logs Table Label','rsvp-pro-plugin'),
			'text' => __( 'Message Logs', 'rsvp-pro-plugin' ),
		),
		'message_log_sent_on_label'                        => array(
			'name' => esc_html__('Message Log Sent On Label','rsvp-pro-plugin'),
			'text' => __( 'Sent On', 'rsvp-pro-plugin' ),
		),
		'message_log_copy_table_label'                     => array(
			'name' => esc_html__('Message Log Table Copy Header Label','rsvp-pro-plugin'),
			'text' => __( 'Copy Message', 'rsvp-pro-plugin' ),
		),
		'message_log_resend_label'                         => array(
			'name' => esc_html__('Resend Message Label','rsvp-pro-plugin'),
			'text' => __( 'Resend Message', 'rsvp-pro-plugin' ),
		),
		'message_attendees_emailed_label'                  => array(
			'name' => esc_html__('Attendees Emailed in this Message Label','rsvp-pro-plugin'),
			'text' => __( 'Attendees Emailed in this Message', 'rsvp-pro-plugin' ),
		),
		'select_all_label'                                 => array(
			'name' => esc_html__('Select All Label','rsvp-pro-plugin'),
			'text' => __( 'Select All', 'rsvp-pro-plugin' ),
		),
		'deselect_all_label'                               => array(
			'name' => esc_html__('Deselect All Label','rsvp-pro-plugin'),
			'text' => __( 'Deselect All', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_columns_label'             => array(
			'name' => esc_html__('Attendee List Columns Label','rsvp-pro-plugin'),
			'text' => __( 'Attendee List Columns', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_columns_description'       => array(
			'name' => esc_html__('Attendee List Columns Description','rsvp-pro-plugin'),
			'text' => __( 'This allows you to select which columns are displayed for this event\'s attendee list in the admin area.', 'rsvp-pro-plugin' ),
		),
		'attendee_name_column_option'                      => array(
			'name' => esc_html__('Attendee Name Column Option Label','rsvp-pro-plugin'),
			'text' => __( 'Attendee Name', 'rsvp-pro-plugin' ),
		),
		'rsvp_status_column_option'                        => array(
			'name' => esc_html__('RSVP Status Column Option Label','rsvp-pro-plugin'),
			'text' => __( 'RSVP Status', 'rsvp-pro-plugin' ),
		),
		'rsvp_date_column_option'                          => array(
			'name' => esc_html__('RSVP Date Column Option Label','rsvp-pro-plugin'),
			'text' => __( 'RSVP Date', 'rsvp-pro-plugin' ),
		),
		'additional_attendee_column_option'                => array(
			'name' => esc_html__('Additional Attendee Column Option Label','rsvp-pro-plugin'),
			'text' => __( 'Additional Attendee', 'rsvp-pro-plugin' ),
		),
		'note_column_option'                               => array(
			'name' => esc_html__('Note Column Option Label','rsvp-pro-plugin'),
			'text' => __( 'Note', 'rsvp-pro-plugin' ),
		),
		'associated_attendees_column_option'               => array(
			'name' => esc_html__('Associated Attendees Column Option Label','rsvp-pro-plugin'),
			'text' => __( 'Associated Attendees', 'rsvp-pro-plugin' ),
		),
		'email_column_option'                              => array(
			'name' => esc_html__('Email Column Option Label','rsvp-pro-plugin'),
			'text' => __( 'Email', 'rsvp-pro-plugin' ),
		),
		'checked_in_column_option'                         => array(
			'name' => esc_html__('Checked In Column Option Label','rsvp-pro-plugin'),
			'text' => __( 'Checked In', 'rsvp-pro-plugin' ),
		),
		'passcode_column_option'                           => array(
			'name' => esc_html__('Passcode Column Option Label','rsvp-pro-plugin'),
			'text' => __( 'Passcode', 'rsvp-pro-plugin' ),
		),
		'data_eraser_successful'                           => array(
			'name' => esc_html__('Data Eraser Success Message','rsvp-pro-plugin'),
			'text' => __( 'All RSVP Pro data erased for email submitted', 'rsvp-pro-plugin' ),
		),
		'rsvp_pro_friendly_name'                           => array(
			'name' => esc_html__('RSVP Pro Friendly Label','rsvp-pro-plugin'),
			'text' => __( 'RSVP Pro Plugin', 'rsvp-pro-plugin' ),
		),
		'settings_thankyou_redirect_label'                 => array(
			'name' => esc_html__('Thank You Redirect Label','rsvp-pro-plugin'),
			'text' => __( 'Thank you redirect', 'rsvp-pro-plugin' ),
		),
		'settings_thankyou_redirect_description'           => array(
			'name' => esc_html__('Thank You Redirect Description','rsvp-pro-plugin'),
			'text' => __( 'Specifies a URL to redirect to for the thank you instead of showing the thank you text', 'rsvp-pro-plugin' ),
		),
		'settings_notcoming_redirect_label'                => array(
			'name' => esc_html__('Thank You Attendee Says &quot;No&quot; Redirect Label','rsvp-pro-plugin'),
			'text' => __( 'No thank you redirect', 'rsvp-pro-plugin' ),
		),
		'settings_notcoming_redirect_description'          => array(
			'name' => esc_html__('No Thank You Redirect Description','rsvp-pro-plugin'),
			'text' => __( 'Specifies a URL to redirect to for the thank you when an attendee says &quot;No&quot; instead of showing the thank you text', 'rsvp-pro-plugin' ),
		),
		'settings_show_gpdr_label'                         => array(
			'name' => esc_html__('Show GDPR Question Label','rsvp-pro-plugin'),
			'text' => __( 'Show GDPR Agreement Question', 'rsvp-pro-plugin' ),
		),
		'settings_show_gdpr_description'                   => array(
			'name' =>esc_html__( 'Show GDPR Question Description','rsvp-pro-plugin'),
			'text' => __( 'Displays a required GDPR agreement question when people RSVP', 'rsvp-pro-plugin' ),
		),
		'settings_gdpr_question_text_label'                => array(
			'name' => esc_html__('Custom GDPR Question Label','rsvp-pro-plugin'),
			'text' => __( 'Custom GDPR Question', 'rsvp-pro-plugin' ),
		),
		'settings_gdpr_question_text_description'          => array(
			'name' => esc_html__('Custom GDPR Question Description','rsvp-pro-plugin'),
			'text' => __( 'Default is: &quot;I agree to having this website store my submitted event related information.&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_hide_main_rsvp_question_label'           => array(
			'name' => esc_html__('Hide Main RSVP Question Label','rsvp-pro-plugin'),
			'text' => __( 'Hide the main RSVP question prompt', 'rsvp-pro-plugin' ),
		),
		'settings_hide_main_rsvp_question_description'     => array(
			'name' => esc_html__('Hide Main RSVP Question Description','rsvp-pro-plugin'),
			'text' => __( 'Hides the main RSVP question prompt, the default question is &quot;So, how about it?&quot;.', 'rsvp-pro-plugin' ),
		),
		'settings_hide_welcome_text_label'                 => array(
			'name' => esc_html__('Hide Welcome Text Label','rsvp-pro-plugin'),
			'text' => __( 'Hide welcome text', 'rsvp-pro-plugin' ),
		),
		'settings_hide_welcome_text_description'           => array(
			'name' => esc_html__('Hide Welcome Text Description','rsvp-pro-plugin'),
			'text' => __( 'Hides the custom welcome text the defaults start with &quot;There are a few more questions...&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_unique_passcode_label'                   => array(
			'name' => esc_html__('Require Unique Passcodes Label','rsvp-pro-plugin'),
			'text' => __( 'Require Unique Passcodes', 'rsvp-pro-plugin' ),
		),
		'settings_unique_passcode_description'             => array(
			'name' => esc_html__('Requie Unique Passcodes Description','rsvp-pro-plugin'),
			'text' => __( 'This will require a unique passcode per-attendee when adding or editing an attendee from the admin-side and front-end. This will not enforce unique passcodes during import.', 'rsvp-pro-plugin' ),
		),
		'settings_unique_passcode_js_label'                => array(
			'name' => esc_html__('Unique Passcode Javascript Message Label','rsvp-pro-plugin'),
			'text' => __( 'Unique passcode validation message', 'rsvp-pro-plugin' ),
		),
		'settings_unique_passcode_js_description'          => array(
			'name' => esc_html__('Unique Passcode JavaScript Message Description','rsvp-pro-plugin'),
			'text' => __( 'Default is: &quot;Passcode is already in use&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_unique_email_js_label'                   => array(
			'name' => esc_html__('Unique Email Javascript Message Label','rsvp-pro-plugin'),
			'text' => __( 'Unique email validation message', 'rsvp-pro-plugin' ),
		),
		'settings_unique_email_js_description'             => array(
			'name' => esc_html__('Unique Email JavaScript Message Description','rsvp-pro-plugin'),
			'text' => __( 'Default is: &quot;Email is already in use&quot;', 'rsvp-pro-plugin' ),
		),
		'captcha_settings_label'                           => array(
			'name' => esc_html__('reCAPTCHA Settings Header','rsvp-pro-plugin'),
			'text' => __( 'reCAPTCHA Settings', 'rsvp-pro-plugin' ),
		),
		'settings_enable_recaptcha_label'                  => array(
			'name' => esc_html__('Enable reCAPTCHA Settings Label','rsvp-pro-plugin'),
			'text' => __( 'Enable reCAPTCHA', 'rsvp-pro-plugin' ),
		),
		'settings_enable_recaptcha_description'            => array(
			'name' => esc_html__('Enable reCAPTCHA Settings Description','rsvp-pro-plugin'),
			'text' => __( 'This will enable reCAPTCHA on the RSVP form for both new and existing attendees', 'rsvp-pro-plugin' ),
		),
		'settings_recaptcha_site_key_label'                => array(
			'name' => esc_html__('reCAPTCHA Site Key Settings Label','rsvp-pro-plugin'),
			'text' => __( 'reCAPTCHA Site Key', 'rsvp-pro-plugin' ),
		),
		'settings_recaptcha_site_key_description'          => array(
			'name' => esc_html__('reCAPTCHA Site Key Settings Description','rsvp-pro-plugin'),
			'text' => __( 'Enter in the reCAPTCHA Site Key Here', 'rsvp-pro-plugin' ),
		),
		'settings_recaptcha_secret_key_label'              => array(
			'name' => esc_html__('reCAPTCHA Secret Key Settings Label','rsvp-pro-plugin'),
			'text' => __( 'reCAPTCHA Secret Key', 'rsvp-pro-plugin' ),
		),
		'settings_recaptcha_secret_key_description'        => array(
			'name' => esc_html__('reCAPTCHA Secret Key Settings Description','rsvp-pro-plugin'),
			'text' => __( 'Enter in the reCAPTCHA Secret Key Here', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_page_size_label'           => array(
			'name' => esc_html__('Attendee List Page Size Settings Label','rsvp-pro-plugin'),
			'text' => __( 'Number of Attendees Per-Page', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_page_size_description'     => array(
			'name' => esc_html__('Attendee List Page Size Settings Description','rsvp-pro-plugin'),
			'text' => __( 'The default is &quot;100&quot; attendees per-page', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_page_size_50'              => array(
			'name' => esc_html__('Attendee List Page Size 50 Per-Page','rsvp-pro-plugin'),
			'text' => __( '50', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_page_size_100'             => array(
			'name' => esc_html__('Attendee List Page Size 100 Per-Page','rsvp-pro-plugin'),
			'text' => __( '100', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_page_size_250'             => array(
			'name' => esc_html__('Attendee List Page Size 250 Per-Page','rsvp-pro-plugin'),
			'text' => __( '250', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_page_size_500'             => array(
			'name' => esc_html__('Attendee List Page Size 500 Per-Page','rsvp-pro-plugin'),
			'text' => __( '500', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_page_size_1000'            => array(
			'name' => esc_html__('Attendee List Page Size 1000 Per-Page','rsvp-pro-plugin'),
			'text' => __( '1000', 'rsvp-pro-plugin' ),
		),
		'qr_code_label'                                    => array(
			'name' => esc_html__('QR Code Message Generation Placeholder','rsvp-pro-plugin'),
			'text' => __( 'This places a QR code for the current event attendee combination to allow for them to be checked in via a QR scanner.', 'rsvp-pro-plugin' ),
		),
		'attendee_field_label'                             => array(
			'name' => esc_html__('Attendee Field Import Label','rsvp-pro-plugin'),
			'text' => __( 'Attendee Field', 'rsvp-pro-plugin' ),
		),
		'excel_column_label'                               => array(
			'name' => esc_html__('Excel Column Import Label','rsvp-pro-plugin'),
			'text' => __( 'Excel Column', 'rsvp-pro-plugin' ),
		),
		'custom_questions_answer_import_label'             => array(
			'name' => esc_html__('Import Custom Question Answers Label','rsvp-pro-plugin'),
			'text' => __( 'If you have a lot of answers to add, put them below. One answer per-line.', 'rsvp-pro-plugin' ),
		),
		'settings_display_new_attendee_form_label'         => array(
			'name' => esc_html__('Display New Attendee Form First Label','rsvp-pro-plugin'),
			'text' => __( 'Show New Attendee Form First', 'rsvp-pro-plugin' ),
		),
		'settings_display_new_attendee_form_description'   => array(
			'name' => esc_html__('Display New Attendee Form First Description','rsvp-pro-plugin'),
			'text' => __( 'When this is enabled the new attendee form will be displayed first and a link at the bottom will be displayed for returning attendees to edit their registration.', 'rsvp-pro-plugin' ),
		),
		'settings_find_attendee_link_text_label'           => array(
			'name' => esc_html__('Find Attendee Link Text Settings Label','rsvp-pro-plugin'),
			'text' => __( 'Find Attendees Link Text', 'rsvp-pro-plugin' ),
		),
		'settings_find_attendee_link_text_description'     => array(
			'name' => esc_html__('Find Attendee Link Text Settings Description','rsvp-pro-plugin'),
			'text' => __( 'The text shown for the find attendee link when the new attendee form is shown first, default is &quot;Modify Your Registration Here&quot;.', 'rsvp-pro-plugin' ),
		),
		'settings_admin_email_body_label'                  => array(
			'name' => esc_html__('Admin Email Notification Body Label','rsvp-pro-plugin'),
			'text' => __( 'Email body for the admin notification email', 'rsvp-pro-plugin' ),
		),
		'settings_admin_email_body_description'            => array(
			'name' => esc_html__('Admin Email Notification Body Description','rsvp-pro-plugin'),
			'text' => __( 'Replaces the message that gets sent to &quot;admins&quot; when someone RSVPs', 'rsvp-pro-plugin' ),
		),
		'settings_rsvp_form_label'                         => array(
			'name' => esc_html__('Custom RSVP Form URL Label','rsvp-pro-plugin'),
			'text' => __( 'Custom RSVP Form URL', 'rsvp-pro-plugin' ),
		),
		'settings_rsvp_form_description'                   => array(
			'name' => esc_html__('Custom RSVP Form URL Description','rsvp-pro-plugin'),
			'text' => __( 'When specifying a custom RSVP form URL it is assumed that the corresponding page has the correct RSVP Pro shortcode in place to handle the form submission.', 'rsvp-pro-plugin' ),
		),
		'admin_attendee_view_file'                         => array(
			'name' => esc_html__('Text for viewing a custom question file upload','rsvp-pro-plugin'),
			'text' => __( 'View File', 'rsvp-pro-plugin' ),
		),
		'admin_attendee_delete_file'                       => array(
			'name' => esc_html__('Text for deleting a file related to a custom question file upload','rsvp-pro-plugin'),
			'text' => __( 'Delete File', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_show_profile_pic_label'    => array(
			'name' => esc_html__('Show profile picture on attendee list setting label','rsvp-pro-plugin'),
			'text' => __( 'Show Profile Picture on Attendee List', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_show_profile_pic_description' => array(
			'name' => esc_html__('Show profile picture on attendee list setting description','rsvp-pro-plugin'),
			'text' => __( 'This will try to retrieve the WordPress profile picture for the attendee using the attendee\'s email address.', 'rsvp-pro-plugin' ),
		),
		'settings_form_show_profile_pic_label'             => array(
			'name' => esc_html__('Show profile picture on RSVP form setting label','rsvp-pro-plugin'),
			'text' => __( 'Show Profile Picture on RSVP form', 'rsvp-pro-plugin' ),
		),
		'settings_form_show_profile_pic_description'       => array(
			'name' => esc_html__('Show profile picture on RVSP form setting description','rsvp-pro-plugin'),
			'text' => __( 'Displays the attendee\'s WordPress profile picture next to the &quot;welcome&quot; message of the RSVP form. This is based off the attendee\'s email address.', 'rsvp-pro-plugin' ),
		),
		'admin_attendees_per_page_setting_label'           => array(
			'name' => esc_html__('Number of attendees per-page on admin attendee list label','rsvp-pro-plugin'),
			'text' => __( 'Number of attendees per-page on attendee list', 'rsvp-pro-plugin' ),
		),
		'settings_available_people_to_send_label'          => array(
			'name' => esc_html__('Settings label for people to send to','rsvp-pro-plugin'),
			'text' => __( 'Available Attendees', 'rsvp-pro-plugin' ),
		),
		'settings_people_being_sent_to_label'              => array(
			'name' => esc_html__('Settings label for attendees being sent messages','rsvp-pro-plugin'),
			'text' => __( 'Attendees Receiving Message', 'rsvp-pro-plugin' ),
		),
		'settings_always_show_additional_label'            => array(
			'name' => esc_html__('Settings label for always show add additional attendees ','rsvp-pro-plugin'),
			'text' => __( 'Always Show Add Additional Attendees', 'rsvp-pro-plugin' ),
		),
		'settings_always_show_additional_description'      => array(
			'name' => esc_html__('Settings description for always show add additional attendees','rsvp-pro-plugin'),
			'text' => __( 'This will always show the add additional button no matter what RSVP response the main attendee has.', 'rsvp-pro-plugin' ),
		),
		'settings_enable_payments_label'                   => array(
			'name' => esc_html__('Enable Payments Label','rsvp-pro-plugin'),
			'text' => __( 'Enable Payments', 'rsvp-pro-plugin' ),
		),
		'settings_enable_payments_description'             => array(
			'name' => esc_html__('Enable Payments Description','rsvp-pro-plugin'),
			'text' => __( 'Allows an event and sub-events to receive payments.', 'rsvp-pro-plugin' ),
		),
		'settings_ticket_price_label'                      => array(
			'name' => esc_html__('Ticket Price Label','rsvp-pro-plugin'),
			'text' => __( 'Ticket Price', 'rsvp-pro-plugin' ),
		),
		'settings_ticket_price_description'                => array(
			'name' => esc_html__('Ticket Price Description','rsvp-pro-plugin'),
			'text' => __( 'Ticket price for the event', 'rsvp-pro-plugin' ),
		),
		'stripe_form_settings_label'                       => array(
			'name' => esc_html__('Stripe Settings Title','rsvp-pro-plugin'),
			'text' => __( 'Stripe Settings', 'rsvp-pro-plugin' ),
		),
		'paypal_form_settings_label'                       => array(
			'name' => esc_html__('PayPal Settings Title','rsvp-pro-plugin'),
			'text' => __( 'PayPal Settings', 'rsvp-pro-plugin' ),
		),
		'paypal_email_settings_label'                      => array(
			'name' => esc_html__('PayPal Email Settings Label','rsvp-pro-plugin'),
			'text' => __( 'PayPal Email' , 'rsvp-pro-plugin' ),
		),
		'paypal_email_settings_description'                => array(
			'name' => esc_html__('PayPal Email Settings Description','rsvp-pro-plugin'),
			'text' => __( 'Enter in Your PayPal Account\'s Email Address', 'rsvp-pro-plugin' ),
		),
		'paypal_api_credentials_header'                    => array(
			'name' => esc_html__('PayPal API Credentials Header','rsvp-pro-plugin'),
			'text' => __( 'PayPal API Credentials', 'rsvp-pro-plugin' ),
		),
		'paypal_live_client_id_settings_label'             => array(
			'name' => esc_html__('Live Client ID Label','rsvp-pro-plugin'),
			'text' => __( 'Live Client ID', 'rsvp-pro-plugin' ),
		),
		'paypal_live_client_id_settings_description'       => array(
			'name' => esc_html__('Live Client ID Description','rsvp-pro-plugin'),
			'text' => __( 'The live client ID.', 'rsvp-pro-plugin' ),
		),
		'paypal_live_client_secret_settings_label'         => array(
			'name' => esc_html__('Live Client Secret Label','rsvp-pro-plugin'),
			'text' => __( 'Live Client Secret', 'rsvp-pro-plugin' ),
		),
		'paypal_live_client_secret_settings_description'   => array(
			'name' => esc_html__('Live Client Secret Description','rsvp-pro-plugin'),
			'text' => __( 'The live client secret.', 'rsvp-pro-plugin' ),
		),
		'paypal_sandbox_client_id_settings_label'          => array(
			'name' => esc_html__('Sandbox Client ID Label','rsvp-pro-plugin'),
			'text' => __( 'Sandbox Client ID', 'rsvp-pro-plugin' ),
		),
		'paypal_sandbox_client_id_settings_description'    => array(
			'name' => esc_html__('Sandbox Client ID Description','rsvp-pro-plugin'),
			'text' => __( 'The sandbox client ID .', 'rsvp-pro-plugin' ),
		),
		'paypal_sandbox_client_secret_settings_label'      => array(
			'name' => esc_html__('Sandbox Client Secret Label','rsvp-pro-plugin'),
			'text' => __( 'Sandbox Client Secret', 'rsvp-pro-plugin' ),
		),
		'paypal_sandbox_client_secret_settings_description' => array(
			'name' => esc_html__('Sandbox Client Secret Description','rsvp-pro-plugin'),
			'text' => __( 'The sandbox client secret.', 'rsvp-pro-plugin' ),
		),
		'paypal_test_api_signature_settings_label'         => array(
			'name' => esc_html__('Test API Signature Label','rsvp-pro-plugin'),
			'text' => __( 'Test API Signature', 'rsvp-pro-plugin' ),
		),
		'paypal_test_api_signature_settings_description'   => array(
			'name' => esc_html__('Test API Signature Description','rsvp-pro-plugin'),
			'text' => __( 'The test API signature.', 'rsvp-pro-plugin' ),
		),
		'settings_payments_testing_label'                  => array(
			'name' => esc_html__('Test Mode Label','rsvp-pro-plugin'),
			'text' => __( 'Test Mode', 'rsvp-pro-plugin' ),
		),
		'settings_payments_testing_description'            => array(
			'name' => esc_html__('Test Mode Description','rsvp-pro-plugin'),
			'text' => __( 'While in test mode no live transactions are processed. Test accounts needs to be specified for your payment gateway', 'rsvp-pro-plugin' ),
		),
		'attendee_event_list_settings_title'               => array(
			'name' => esc_html__('Attendee Event List Settings Title','rsvp-pro-plugin'),
			'text' => __( 'Attendee Event List Settings', 'rsvp-pro-plugin' ),
		),
		'attendee_list_greeting_label'                     => array(
			'name' => esc_html__('Attendee Event List Greeting Label','rsvp-pro-plugin'),
			'text' => __( 'Attendee Event List Greeting', 'rsvp-pro-plugin' ),
		),
		'attendee_list_greeting_description'               => array(
			'name' => esc_html__('Attendee Event List Greeting Description','rsvp-pro-plugin'),
			'text' => __( 'Defaults to &quot;Enter in your email address to see all events you can RSVP for.&quot;.', 'rsvp-pro-plugin' ),
		),
		'attendee_list_rsvp_for_label'                     => array(
			'name' => esc_html__('Attendee Event List Link Text Label','rsvp-pro-plugin'),
			'text' => __( 'Link Text', 'rsvp-pro-plugin' ),
		),
		'attendee_list_rsvp_for_description'               => array(
			'name' => esc_html__('Attendee Event List Link Text Description','rsvp-pro-plugin'),
			'text' => __( 'Defaults to &quot;RSVP for - %s&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_currency_label'                          => array(
			'name' => esc_html__('Currency Settings Label','rsvp-pro-plugin'),
			'text' => __( 'Currency', 'rsvp-pro-plugin' ),
		),
		'settings_currency_description'                    => array(
			'name' => esc_html__('Currency Settings Description','rsvp-pro-plugin'),
			'text' => __( 'The currency for the tickets', 'rsvp-pro-plugin' ),
		),
		'settings_currency_position_label'                 => array(
			'name' => esc_html__('Currency position settings label','rsvp-pro-plugin'),
			'text' => __( 'Currency Position', 'rsvp-pro-plugin' ),
		),
		'settings_currency_position_description'           => array(
			'name' => esc_html__('Currency position settings description','rsvp-pro-plugin'),
			'text' => __( 'The location of the currency sign', 'rsvp-pro-plugin' ),
		),
		'settings_thousands_separator_label'               => array(
			'name' => esc_html__('Thousands separator settings label','rsvp-pro-plugin'),
			'text' => __( 'Thousands Separator', 'rsvp-pro-plugin' ),
		),
		'settings_thousands_separator_description'         => array(
			'name' => esc_html__('Thousands separator settings description','rsvp-pro-plugin'),
			'text' => __( 'The character used for the thousands separator, default is &quot;,&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_decimal_separator_label'                 => array(
			'name' => esc_html__('Decimal separator settings label','rsvp-pro-plugin'),
			'text' => __( 'Decimal Separator', 'rsvp-pro-plugin' ),
		),
		'settings_decimal_separator_description'           => array(
			'name' => esc_html__('Decimal separator settings description','rsvp-pro-plugin'),
			'text' => __( 'The character used for the decimal separator, default is &quot;.&quot;', 'rsvp-pro-plugin' ),
		),
		'settings_currency_position_after'                 => array(
			'name' => esc_html__('Currency position after label','rsvp-pro-plugin'),
			'text' => __( 'After - 1$', 'rsvp-pro-plugin' ),
		),
		'settings_currency_position_before'                => array(
			'name' => esc_html__('Currency position before label','rsvp-pro-plugin'),
			'text' => __( 'Before - $1', 'rsvp-pro-plugin' ),
		),
		'settings_payment_message_label'                   => array(
			'name' => esc_html__('Settings Payment Message Label','rsvp-pro-plugin'),
			'text' => __( 'Payment Message', 'rsvp-pro-plugin' ),
		),
		'settings_payment_message_description'             => array(
			'name' => esc_html__('Settings Payment Message Description','rsvp-pro-plugin'),
			'text' => __( 'Defaults to &quot;To finish RSVP\'ing please pay %s.&quot;', 'rsvp-pro-plugin' ),
		),
		'select_all_link_text'                             => array(
			'name' => esc_html__('Select all link text','rsvp-pro-plugin'),
			'text' => __( 'Select All', 'rsvp-pro-plugin' ),
		),
		'deselect_all_link_text'                           => array(
			'name' => esc_html__('Deselect all link text','rsvp-pro-plugin'),
			'text' => __( 'Deselect All', 'rsvp-pro-plugin' ),
		),
		'settings_payment_success_url_label'               => array(
			'name' => esc_html__('Setting Payment Success URL Label','rsvp-pro-plugin'),
			'text' => __( 'Payment Success Page', 'rsvp-pro-plugin' ),
		),
		'settings_payment_success_url_description'         => array(
			'name' => esc_html__('Setting Payment Success URL Description','rsvp-pro-plugin'),
			'text' => __( 'The full-URL for the page/post that should be used when a payment is successful. The shortcode [rsvp-pro-payment-success] must be on this page.', 'rsvp-pro-plugin' ),
		),
		'settings_payment_failure_url_label'               => array(
			'name' => esc_html__('Setting Payment Failure URL Label','rsvp-pro-plugin'),
			'text' => __( 'Payment Failure Page', 'rsvp-pro-plugin' ),
		),
		'settings_payment_failure_url_description'         => array(
			'name' => esc_html__('Setting Payment Failure URL Description','rsvp-pro-plugin'),
			'text' => __( 'The full-URL for the page/post that should be used when a payment is unsuccessful. The shortcode [rsvp-pro-payment-failure] must be on this page.', 'rsvp-pro-plugin' ),
		),
		'transaction_description'                          => array(
			'name' => esc_html__('Transaction Description','rsvp-pro-plugin'),
			'text' => __( 'Tickets for %s.', 'rsvp-pro-plugin' ),
		),
		'settings_payment_description_label'               => array(
			'name' => esc_html__('Setting Payment Description Label','rsvp-pro-plugin'),
			'text' => __( 'Payment Description', 'rsvp-pro-plugin' ),
		),
		'settings_payment_description'                     => array(
			'name' => esc_html__('Setting Payment Description','rsvp-pro-plugin'),
			'text' => __( 'This is sent to the payment processor the default is &quot;Tickets for %s&quot; where %s is the Event\'s name.', 'rsvp-pro-plugin' ),
		),
		'settings_full_name_search_label'                  => array(
			'name' => esc_html__('Setting Full Name Search','rsvp-pro-plugin'),
			'text' => __( 'Use full name for lookup', 'rsvp-pro-plugin' ),
		),
		'settings_full_name_search_description'            => array(
			'name' => esc_html__('Setting Full Name Search Description','rsvp-pro-plugin'),
			'text' => __( 'This will place a full name search input box on the attendee look-up page. During lookup it will search for the first and last name together.', 'rsvp-pro-plugin' ),
		),
		'settings_name_label'                              => array(
			'name' => esc_html__('Settings Name Text Label','rsvp-pro-plugin'),
			'text' => __( '&quot;Name&quot; label:', 'rsvp-pro-plugin' ),
		),
		'settings_name_description'                        => array(
			'name' => esc_html__('Settings Name Text Description','rsvp-pro-plugin'),
			'text' => __( 'This text is used for the full name lookup front-end form input field. The default is &quot;Name.&quot;', 'rsvp-pro-plugin' ),
		),
		'alternate_passcode_label'                         => array(
			'name' => esc_html__('Alternate Passcode Setting Label','rsvp-pro-plugin'),
			'text' => __( 'Alternate Passcode', 'rsvp-pro-plugin' ),
		),
		'total_amount_label'                               => array(
			'name' => esc_html__('Total Amount Label','rsvp-pro-plugin'),
			'text' => __( 'Total Amount', 'rsvp-pro-plugin' ),
		),
		'qr_prefill_code_label'                            => array(
			'name' => esc_html__('QR Prefill Code Email Variable Label','rsvp-pro-plugin'),
			'text' => __( 'QR code to automatically lookup an attendee.', 'rsvp-pro-plugin' ),
		),
		'settings_attendee_list_show_qr_prefill_label'     => array(
			'name' => esc_html__('Show attendee list qr prefill code on public attendee list setting label.','rsvp-pro-plugin'),
			'text' => __( 'Show QR code to auto-lookup attendee', 'rsvp-pro-plugin' ),
		),
		'export_event_attendee_label'                      => array(
			'name' => esc_html__('The label shown on the event export form for people to select if they should include attendee information.','rsvp-pro-plugin'),
			'text' => __( 'Include attendee information when exporting events.', 'rsvp-pro-plugin' ),
		),
		'attendee_payment_transactions_header'             => array(
			'name' => esc_html__('Admin attendee edit form payment transactions header','rsvp-pro-plugin'),
			'text' => __( 'Payment Transactions', 'rsvp-pro-plugin' ),
		),
		'other_question_display_setting_label'             => array(
			'name' => esc_html__('Custom question display other question setting label','rsvp-pro-plugin'),
			'text' => __( 'Display &quot;other&quot; as last option for this question?', 'rsvp-pro-plugin' ),
		),
		'other_question_text_setting_label'                => array(
			'name' => esc_html__('Custom question other question text setting label','rsvp-pro-plugin'),
			'text' => __( '&quot;Other&quot; text', 'rsvp-pro-plugin' ),
		),
		'other_question_text_setting_description'          => array(
			'name' => esc_html__('Other question text setting description','rsvp-pro-plugin'),
			'text' => __( 'Defaults to &quot;Other:&quot;', 'rsvp-pro-plugin' ),
		),
		'turnstile_settings_label'                           => array(
			'name' => esc_html__('Turnstile Settings Header','rsvp-pro-plugin'),
			'text' => __( 'Turnstile Settings', 'rsvp-pro-plugin' ),
		),
		'settings_enable_turnstile_label'                  => array(
			'name' => esc_html__('Enable Turnstile Settings Label','rsvp-pro-plugin'),
			'text' => __( 'Enable Turnstile', 'rsvp-pro-plugin' ),
		),
		'settings_enable_turnstile_description'            => array(
			'name' => esc_html__('Enable Turnstile Settings Description','rsvp-pro-plugin'),
			'text' => __( 'This will enable Turnstile on the RSVP form for both new and existing attendees', 'rsvp-pro-plugin' ),
		),
		'settings_turnstile_site_key_label'                => array(
			'name' => esc_html__('Turnstile Site Key Settings Label','rsvp-pro-plugin'),
			'text' => __( 'Turnstile Site Key', 'rsvp-pro-plugin' ),
		),
		'settings_turnstile_site_key_description'          => array(
			'name' => esc_html__('Turnstile Site Key Settings Description','rsvp-pro-plugin'),
			'text' => __( 'Enter in the Turnstile Site Key Here', 'rsvp-pro-plugin' ),
		),
		'settings_turnstile_secret_key_label'              => array(
			'name' => esc_html__('Turnstile Secret Key Settings Label','rsvp-pro-plugin'),
			'text' => __( 'Turnstile Secret Key', 'rsvp-pro-plugin' ),
		),
		'settings_turnstile_secret_key_description'        => array(
			'name' => esc_html__('Turnstile Secret Key Settings Description','rsvp-pro-plugin'),
			'text' => __( 'Enter in the Turnstile Secret Key Here', 'rsvp-pro-plugin' ),
		),

	);

	return $admin_strings;
}
