<?php
/**
 * Class file that allows for integration with WP HTML Mail plugin.
 *
 * @since 4.2.5
 * @package rsvp-pro-plugin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class to integrate with the WP HTML Mail plugin
 *
 * @link https://wordpress.org/plugins/wp-html-mail/
 */
class RSVP_Pro_WP_HTML_Sender_Plugin_RSVP_Pro extends Haet_Sender_Plugin {

	/**
	 * The constructor for the class.
	 *
	 * @param array $mail Holds the mail associative array.
	 */
	public function __construct( $mail ) {
		if ( empty( $mail['message'] ) ) {
			echo 'The mail should have a message';
			return;
		}
	}

	/**
	 * Returns the default options for this plugin.
	 *
	 * @return array The default options for this specific HTML Mail Plugin
	 */
	public static function get_plugin_default_options() {
		return array(
			'template'    => true,
			'sender'      => true,
			'hide_header' => false,
			'hide_footer' => false,
		);
	}

	/**
	 * Modify the email content before applying the template.
	 *
	 * @param string $content The content before the template gets applied.
	 * @return string The content ready for the template to be applied.
	 */
	public function modify_content( $content ) {
		$content = wpautop( $content );
		return $content;
	}
}
