<?php
/**
 * Displays all of the public events for an install
 *
 * @return HTML output
 */
function rsvp_pro_eventlist_frontend_handler() {
	global $wpdb;

	ob_start(); ?>
	<div id="rsvppro_eventlist_container">
		<table>
		<?php do_action( 'rsvppro_eventlist_begin_list' ); ?>
			<tr>
				<th class="rsvppro_eventlist_event_date"><?php echo rsvp_pro_get_frontend_string( 'event_date_label' ); ?></th>
				<th class="rsvppro_eventlist_event_name"><?php echo rsvp_pro_get_frontend_string( 'event_name_label' ); ?></th>
				<th class="rsvppro_eventlist_event_num_attendees"><?php echo rsvp_pro_get_frontend_string( 'rsvp_count_label' ); ?></th>
				<th class="rsvppro_eventlist_event_location"><?php echo rsvp_pro_get_frontend_string( 'event_location_label' ); ?></th>
				<th class="rsvppro_eventlist_event_link"></th>
			</tr>
	<?php
	$sql    = 'SELECT id, eventName, open_date, close_date, close_date_time, event_access, eventStartDate, eventLocation, eventEndDate, eventStartDateTimezone, eventEndDateTimezone, 
			 (SELECT COUNT(*) FROM ' . PRO_ATTENDEES_TABLE . " WHERE rsvpEventID = e.id AND rsvpStatus = 'Yes') AS yesCount,
			 (SELECT COUNT(*) FROM " . PRO_ATTENDEES_TABLE . " WHERE rsvpEventID = e.id AND rsvpStatus = 'No') AS noCount,
			 (SELECT COUNT(*) FROM " . PRO_ATTENDEES_TABLE . " WHERE rsvpEventID = e.id AND rsvpStatus = 'NoResponse') AS noResponseCount
		FROM " . PRO_EVENT_TABLE . " e
		WHERE (parentEventID IS NULL OR parentEventID = 0) AND event_access != 'select'
        AND id != " . RSVP_PRO_GLOBAL_ATTENDEE_EVENT_ID . '
		ORDER BY close_date, eventStartDate ';
	$events = $wpdb->get_results( $sql );

	// Will be used when displaying the time information in the event list
	$time_zone = new DateTimeZone( rsvp_pro_wp_get_timezone_string() );

	foreach ( $events as $e ) {
		if ( ! rsvp_pro_is_event_closed( $e->id ) ) {
			$yes_text         = rsvp_pro_get_frontend_string( 'yes_text' );
			$no_text          = rsvp_pro_get_frontend_string( 'no_text' );
			$no_response_text = rsvp_pro_get_frontend_string( 'noresponse_text' );

			if ( rsvp_pro_get_event_option( $e->id, RSVP_PRO_OPTION_YES_TEXT ) !== '' ) {
				$yes_text = rsvp_pro_get_event_option( $e->id, RSVP_PRO_OPTION_YES_TEXT );
			}

			if ( rsvp_pro_get_event_option( $e->id, RSVP_PRO_OPTION_NO_TEXT ) !== '' ) {
				$no_text = rsvp_pro_get_event_option( $e->id, RSVP_PRO_OPTION_NO_TEXT );
			}

			if ( rsvp_pro_get_event_option( $e->id, RSVP_PRO_OPTION_NO_RESPONSE_TEXT ) !== '' ) {
				$no_response_text = rsvp_pro_get_event_option( $e->id, RSVP_PRO_OPTION_NO_RESPONSE_TEXT );
			}

			// Get the page that is linked....
			$queryString = array(
				's'        => '[rsvppro id="' . $e->id . '"]',
				'sentence' => 1,
			);
			$query       = new WP_Query( $queryString );
			$url         = '';
			if ( $query->have_posts() ) {
				$query->the_post();
				$url = get_permalink();
			}
			wp_reset_postdata();
			?>
			<tr class="rsvppro_eventlist_event">
				<?php do_action( 'rsvppro_eventlist_before_eventdate' ); ?>
				<td class="rsvppro_eventlist_event_date">
				<?php
				if ( ( strtotime( $e->eventStartDate ) !== true ) && ( $e->eventStartDate != '0000-00-00 00:00:00' ) ) {
					$tmp_date = new DateTime( $e->eventStartDate, new DateTimeZone( 'UTC' ) );
					$tmp_date->setTimeZone( $time_zone );
					if ( ! empty( $e->eventStartDateTimezone ) ) {
						$tmp_date->setTimeZone( new DateTimeZone( $e->eventStartDateTimezone ) );
					}
					echo $tmp_date->format( get_option( 'date_format' ) . ' ' . get_option( 'time_format' ) );

					if ( ( strtotime( $e->eventEndDate ) !== true ) && ( $e->eventEndDate != '0000-00-00 00:00:00' ) ) {
						$tmp_end_date = new DateTime( $e->eventEndDate, new DateTimeZone( 'UTC' ) );
						$tmp_end_date->setTimeZone( $time_zone );
						if ( ! empty( $e->eventEndDateTimezone ) ) {
							$tmp_end_date->setTimeZone( new DateTimeZone( $e->eventEndDateTimezone ) );
						}

						if ( $tmp_date->format( get_option( 'date_format' ) ) == $tmp_end_date->format( get_option( 'date_format' ) ) ) {
							echo ' - ' . $tmp_end_date->format( get_option( 'time_format' ) );
						} else {
							echo ' - ' . $tmp_end_date->format( get_option( 'date_format' ) . ' ' . get_option( 'time_format' ) );
						}
					}
				} else {
					$tmp_date_string = '';

					if ( ( strtotime( $e->close_date ) !== false ) && ( $e->close_date != '0000-00-00' ) ) {
						$tmp_date_string = $e->close_date;
						$format_string   = get_option( 'date_format' );

						if ( ! empty( $e->close_date_time ) ) {
							$tmp_date_string .= ' ' . $e->close_date_time;
							$format_string   .= ' ' . get_option( 'time_format' );
						}
					}

					if ( $tmp_date_string != '' ) {
						$tmp_date = new DateTime( $tmp_date_string, $time_zone );
						echo $tmp_date->format( $format_string );
					}
				}
				?>
				</td>
				<?php do_action( 'rsvppro_eventlist_before_eventname' ); ?>
				<td class="rsvppro_eventlist_event_name"><?php echo esc_html( $e->eventName ); ?></td>
				<?php do_action( 'rsvppro_eventlist_before_num_attendees' ); ?>
				<td class="rsvppro_eventlist_event_num_attendees">
				<?php
					echo $yes_text . ': ' . $e->yesCount . '<br />';
				echo $no_text . ': ' . $e->noCount . '<br />';
				echo $no_response_text . ': ' . $e->noResponseCount . '<br />';
				?>
			</td>
				<?php do_action( 'rsvppro_eventlist_before_location' ); ?>
				<td class="rsvppro_eventlist_event_location">
					<?php echo esc_html( rsvp_pro_get_dynamic_translated_string( rsvp_pro_get_event_name( $e->id ) . ' - ' . rsvp_pro_get_admin_string( 'settings_event_description_label' ), stripslashes( $e->eventLocation ), $e->id ) ); ?>
				</td>
				<?php do_action( 'rsvppro_eventlist_before_link' ); ?>
				<td class="rsvppro_eventlist_event_link"><?php if ( ! empty( $url ) ) : ?>
					<a href="<?php echo $url; ?>" target="_blank"><?php echo rsvp_pro_get_frontend_string( 'rsvp_now_label' ); ?></a>
				<?php endif; ?></td>
				<?php do_action( 'rsvppro_eventlist_end_event_entry' ); ?>
			</tr>
			<?php
		}
	}
	do_action( 'rsvppro_eventlist_end_list' );
	?>
		</table>
	</div> <!-- <div id="rsvppro_eventlist_container.. -->
	<?php
	$output = ob_get_clean();

	return $output;
}
