<?php
/**
 * Class file that handles Stripe payment processing and settings.
 *
 * @since 4.1.5
 * @package rsvp-pro-plugin
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) :
	exit;
endif;

/**
 * Class for handling Stripe payment handling.
 *
 * @since 4.1.5
 */
class Rsvp_Pro_Stripe_Payment_Gateway {

	/**
	 * Creates the RSVP Pro Stripe Payment Gateway object.
	 */
	public function __construct() {
		add_action( 'rsvp_pro_event_payment_settings_tab', array( $this, 'display_stripe_payment_settings' ) );
	}

	/**
	 * Displays the form elements for getting stripe payments integrated with the RSVP form.
	 *
	 * @param  array $options The options associated with the stripe payments.
	 */
	public function display_stripe_payment_settings( $options ) {
		?>
		<tr class="subEventHide">
			<th scope="row">
				<h3><?php echo rsvp_pro_get_admin_string( 'stripe_form_settings_label' ); ?></h3>
			</th>
		</tr>
		<tr class="subEventHide">
			<th scope="row">
				<label for="<?php echo "test"; ?>">
					<?php echo rsvp_pro_get_admin_string( 'settings_frontend_enable_ajax_label' ); ?>
				</label>
			</th>
			<td>
				<input type="checkbox" />
			</td>
		</tr>
		<?php
	}
}
